/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapred.gridmix.GenerateData;
import org.apache.hadoop.mapred.gridmix.RandomTextDataGenerator;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompressionEmulationUtil {
    static final Logger LOG = LoggerFactory.getLogger(CompressionEmulationUtil.class);
    private static final String COMPRESSION_EMULATION_ENABLE = "gridmix.compression-emulation.enable";
    private static final String INPUT_DECOMPRESSION_EMULATION_ENABLE = "gridmix.compression-emulation.input-decompression.enable";
    private static final String GRIDMIX_MAP_INPUT_COMPRESSION_RATIO = "gridmix.compression-emulation.map-input.decompression-ratio";
    private static final String GRIDMIX_MAP_OUTPUT_COMPRESSION_RATIO = "gridmix.compression-emulation.map-output.compression-ratio";
    private static final String GRIDMIX_JOB_OUTPUT_COMPRESSION_RATIO = "gridmix.compression-emulation.job-output.compression-ratio";
    static final float DEFAULT_COMPRESSION_RATIO = 0.5f;
    private static final CompressionRatioLookupTable COMPRESSION_LOOKUP_TABLE = new CompressionRatioLookupTable();
    private static final Charset charsetUTF8 = Charset.forName("UTF-8");

    CompressionEmulationUtil() {
    }

    static void configure(Job job) throws IOException, InterruptedException, ClassNotFoundException {
        job.setMapperClass(RandomTextDataMapper.class);
        job.setNumReduceTasks(0);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setInputFormatClass(GenerateData.GenDataFormat.class);
        job.setJarByClass(GenerateData.class);
        org.apache.hadoop.mapreduce.lib.output.FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
        try {
            org.apache.hadoop.mapreduce.lib.input.FileInputFormat.addInputPath((Job)job, (Path)new Path("ignored"));
        }
        catch (IOException e) {
            LOG.error("Error while adding input path ", (Throwable)e);
        }
    }

    static void setupDataGeneratorConfig(Configuration conf) {
        boolean compress = CompressionEmulationUtil.isCompressionEmulationEnabled(conf);
        if (compress) {
            float ratio = CompressionEmulationUtil.getMapInputCompressionEmulationRatio(conf);
            LOG.info("GridMix is configured to generate compressed input data with  a compression ratio of " + ratio);
            int wordSize = COMPRESSION_LOOKUP_TABLE.getWordSizeForRatio(ratio);
            RandomTextDataGenerator.setRandomTextDataGeneratorWordSize(conf, wordSize);
            RandomTextDataGenerator.setRandomTextDataGeneratorListSize(conf, 200);
        }
    }

    static RandomTextDataGenerator getRandomTextDataGenerator(float ratio, long seed) {
        int wordSize = COMPRESSION_LOOKUP_TABLE.getWordSizeForRatio(ratio);
        RandomTextDataGenerator rtg = new RandomTextDataGenerator(200, seed, wordSize);
        return rtg;
    }

    static GenerateData.DataStatistics publishCompressedDataStatistics(Path inputDir, Configuration conf, long uncompressedDataSize) throws IOException {
        FileStatus[] outFileStatuses;
        FileSystem fs = inputDir.getFileSystem(conf);
        CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(conf);
        long compressedDataSize = 0L;
        int numCompressedFiles = 0;
        for (FileStatus status : outFileStatuses = fs.listStatus(inputDir, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter())) {
            CompressionCodec codec;
            if (compressionCodecs == null || (codec = compressionCodecs.getCodec(status.getPath())) == null) continue;
            ++numCompressedFiles;
            compressedDataSize += status.getLen();
        }
        LOG.info("Gridmix is configured to use compressed input data.");
        LOG.info("Total size of compressed input data : " + StringUtils.humanReadableInt((long)compressedDataSize));
        LOG.info("Total number of compressed input data files : " + numCompressedFiles);
        if (numCompressedFiles == 0) {
            throw new RuntimeException("No compressed file found in the input directory : " + inputDir.toString() + ". To enable compression emulation, run Gridmix either with  an input directory containing compressed input file(s) or use the -generate option to (re)generate it. If compression emulation is not desired, disable it by setting 'gridmix.compression-emulation.enable' to 'false'.");
        }
        if (uncompressedDataSize > 0L) {
            double ratio = (double)compressedDataSize / (double)uncompressedDataSize;
            LOG.info("Input Data Compression Ratio : " + ratio);
        }
        return new GenerateData.DataStatistics(compressedDataSize, numCompressedFiles, true);
    }

    static void setCompressionEmulationEnabled(Configuration conf, boolean val) {
        conf.setBoolean(COMPRESSION_EMULATION_ENABLE, val);
    }

    static boolean isCompressionEmulationEnabled(Configuration conf) {
        return conf.getBoolean(COMPRESSION_EMULATION_ENABLE, true);
    }

    static void setInputCompressionEmulationEnabled(Configuration conf, boolean val) {
        conf.setBoolean(INPUT_DECOMPRESSION_EMULATION_ENABLE, val);
    }

    static boolean isInputCompressionEmulationEnabled(Configuration conf) {
        return conf.getBoolean(INPUT_DECOMPRESSION_EMULATION_ENABLE, false);
    }

    static void setMapInputCompressionEmulationRatio(Configuration conf, float ratio) {
        conf.setFloat(GRIDMIX_MAP_INPUT_COMPRESSION_RATIO, ratio);
    }

    static float getMapInputCompressionEmulationRatio(Configuration conf) {
        return conf.getFloat(GRIDMIX_MAP_INPUT_COMPRESSION_RATIO, 0.5f);
    }

    static void setMapOutputCompressionEmulationRatio(Configuration conf, float ratio) {
        conf.setFloat(GRIDMIX_MAP_OUTPUT_COMPRESSION_RATIO, ratio);
    }

    static float getMapOutputCompressionEmulationRatio(Configuration conf) {
        return conf.getFloat(GRIDMIX_MAP_OUTPUT_COMPRESSION_RATIO, 0.5f);
    }

    static void setJobOutputCompressionEmulationRatio(Configuration conf, float ratio) {
        conf.setFloat(GRIDMIX_JOB_OUTPUT_COMPRESSION_RATIO, ratio);
    }

    static float getJobOutputCompressionEmulationRatio(Configuration conf) {
        return conf.getFloat(GRIDMIX_JOB_OUTPUT_COMPRESSION_RATIO, 0.5f);
    }

    static float standardizeCompressionRatio(float ratio) {
        int significant = Math.round(ratio * 100.0f);
        return (float)significant / 100.0f;
    }

    static InputStream getPossiblyDecompressedInputStream(Path file, Configuration conf, long offset) throws IOException {
        Decompressor decompressor;
        CompressionCodecFactory compressionCodecs;
        CompressionCodec codec;
        FileSystem fs = file.getFileSystem(conf);
        if (CompressionEmulationUtil.isCompressionEmulationEnabled(conf) && CompressionEmulationUtil.isInputCompressionEmulationEnabled(conf) && (codec = (compressionCodecs = new CompressionCodecFactory(conf)).getCodec(file)) != null && (decompressor = CodecPool.getDecompressor((CompressionCodec)codec)) != null) {
            CompressionInputStream in = codec.createInputStream((InputStream)fs.open(file), decompressor);
            return in;
        }
        FSDataInputStream in = fs.open(file);
        in.seek(offset);
        return in;
    }

    static OutputStream getPossiblyCompressedOutputStream(Path file, Configuration conf) throws IOException {
        FileSystem fs = file.getFileSystem(conf);
        JobConf jConf = new JobConf(conf);
        if (FileOutputFormat.getCompressOutput((JobConf)jConf)) {
            Class codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jConf, GzipCodec.class);
            CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
            file = file.suffix(codec.getDefaultExtension());
            if (CompressionEmulationUtil.isCompressionEmulationEnabled(conf)) {
                FSDataOutputStream fileOut = fs.create(file, false);
                return new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fileOut));
            }
        }
        return fs.create(file, false);
    }

    static void configureCompressionEmulation(Configuration source, Configuration target) {
        String jobOutputCompressionType;
        target.setBoolean("mapreduce.output.fileoutputformat.compress", source.getBoolean("mapreduce.output.fileoutputformat.compress", false));
        String jobOutputCompressionCodec = source.get("mapreduce.output.fileoutputformat.compress.codec");
        if (jobOutputCompressionCodec != null) {
            target.set("mapreduce.output.fileoutputformat.compress.codec", jobOutputCompressionCodec);
        }
        if ((jobOutputCompressionType = source.get("mapreduce.output.fileoutputformat.compress.type")) != null) {
            target.set("mapreduce.output.fileoutputformat.compress.type", jobOutputCompressionType);
        }
        target.setBoolean("mapreduce.map.output.compress", source.getBoolean("mapreduce.map.output.compress", false));
        String mapOutputCompressionCodec = source.get("mapreduce.map.output.compress.codec");
        if (mapOutputCompressionCodec != null) {
            target.set("mapreduce.map.output.compress.codec", mapOutputCompressionCodec);
        }
        Path[] inputs = FileInputFormat.getInputPaths((JobConf)new JobConf(source));
        boolean needsCompressedInput = false;
        CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(source);
        for (Path input : inputs) {
            CompressionCodec codec = compressionCodecs.getCodec(input);
            if (codec == null) continue;
            needsCompressedInput = true;
        }
        CompressionEmulationUtil.setInputCompressionEmulationEnabled(target, needsCompressedInput);
    }

    static long getUncompressedInputBytes(long possiblyCompressedInputBytes, Configuration conf) {
        long uncompressedInputBytes = possiblyCompressedInputBytes;
        if (CompressionEmulationUtil.isInputCompressionEmulationEnabled(conf)) {
            float inputCompressionRatio = CompressionEmulationUtil.getMapInputCompressionEmulationRatio(conf);
            uncompressedInputBytes = (long)((float)uncompressedInputBytes / inputCompressionRatio);
        }
        return uncompressedInputBytes;
    }

    private static class CompressionRatioLookupTable {
        private static Map<Float, Integer> map = new HashMap<Float, Integer>(60);
        private static final float MIN_RATIO = 0.07f;
        private static final float MAX_RATIO = 0.68f;

        CompressionRatioLookupTable() {
            map.put(Float.valueOf(0.07f), 30);
            map.put(Float.valueOf(0.08f), 25);
            map.put(Float.valueOf(0.09f), 60);
            map.put(Float.valueOf(0.1f), 20);
            map.put(Float.valueOf(0.11f), 70);
            map.put(Float.valueOf(0.12f), 15);
            map.put(Float.valueOf(0.13f), 80);
            map.put(Float.valueOf(0.14f), 85);
            map.put(Float.valueOf(0.15f), 90);
            map.put(Float.valueOf(0.16f), 95);
            map.put(Float.valueOf(0.17f), 100);
            map.put(Float.valueOf(0.18f), 105);
            map.put(Float.valueOf(0.19f), 110);
            map.put(Float.valueOf(0.2f), 115);
            map.put(Float.valueOf(0.21f), 120);
            map.put(Float.valueOf(0.22f), 125);
            map.put(Float.valueOf(0.23f), 130);
            map.put(Float.valueOf(0.24f), 140);
            map.put(Float.valueOf(0.25f), 145);
            map.put(Float.valueOf(0.26f), 150);
            map.put(Float.valueOf(0.27f), 155);
            map.put(Float.valueOf(0.28f), 160);
            map.put(Float.valueOf(0.29f), 170);
            map.put(Float.valueOf(0.3f), 175);
            map.put(Float.valueOf(0.31f), 180);
            map.put(Float.valueOf(0.32f), 190);
            map.put(Float.valueOf(0.33f), 195);
            map.put(Float.valueOf(0.34f), 205);
            map.put(Float.valueOf(0.35f), 215);
            map.put(Float.valueOf(0.36f), 225);
            map.put(Float.valueOf(0.37f), 230);
            map.put(Float.valueOf(0.38f), 240);
            map.put(Float.valueOf(0.39f), 250);
            map.put(Float.valueOf(0.4f), 260);
            map.put(Float.valueOf(0.41f), 270);
            map.put(Float.valueOf(0.42f), 280);
            map.put(Float.valueOf(0.43f), 295);
            map.put(Float.valueOf(0.44f), 310);
            map.put(Float.valueOf(0.45f), 325);
            map.put(Float.valueOf(0.46f), 335);
            map.put(Float.valueOf(0.47f), 355);
            map.put(Float.valueOf(0.48f), 375);
            map.put(Float.valueOf(0.49f), 395);
            map.put(Float.valueOf(0.5f), 420);
            map.put(Float.valueOf(0.51f), 440);
            map.put(Float.valueOf(0.52f), 465);
            map.put(Float.valueOf(0.53f), 500);
            map.put(Float.valueOf(0.54f), 525);
            map.put(Float.valueOf(0.55f), 550);
            map.put(Float.valueOf(0.56f), 600);
            map.put(Float.valueOf(0.57f), 640);
            map.put(Float.valueOf(0.58f), 680);
            map.put(Float.valueOf(0.59f), 734);
            map.put(Float.valueOf(0.6f), 813);
            map.put(Float.valueOf(0.61f), 905);
            map.put(Float.valueOf(0.62f), 1000);
            map.put(Float.valueOf(0.63f), 1055);
            map.put(Float.valueOf(0.64f), 1160);
            map.put(Float.valueOf(0.65f), 1355);
            map.put(Float.valueOf(0.66f), 1510);
            map.put(Float.valueOf(0.67f), 1805);
            map.put(Float.valueOf(0.68f), 2170);
        }

        int getWordSizeForRatio(float ratio) {
            if ((ratio = CompressionEmulationUtil.standardizeCompressionRatio(ratio)) >= 0.07f && ratio <= 0.68f) {
                return map.get(Float.valueOf(ratio));
            }
            throw new RuntimeException("Compression ratio should be in the range [0.07,0.68]. Configured compression ratio is " + ratio + ".");
        }
    }

    public static class RandomTextDataMapper
    extends Mapper<NullWritable, LongWritable, Text, Text> {
        private RandomTextDataGenerator rtg;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            int listSize = RandomTextDataGenerator.getRandomTextDataGeneratorListSize(conf);
            int wordSize = RandomTextDataGenerator.getRandomTextDataGeneratorWordSize(conf);
            this.rtg = new RandomTextDataGenerator(listSize, wordSize);
        }

        public void map(NullWritable key, LongWritable value, Mapper.Context context) throws IOException, InterruptedException {
            String randomKey;
            String randomValue;
            for (long bytes = value.get(); bytes > 0L; bytes -= (long)(randomValue.getBytes(charsetUTF8).length + randomKey.getBytes(charsetUTF8).length)) {
                randomKey = this.rtg.getRandomWord();
                randomValue = this.rtg.getRandomWord();
                context.write((Object)new Text(randomKey), (Object)new Text(randomValue));
            }
        }
    }
}

