/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.fedbalance;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.tools.fedbalance.FedBalanceConfigs;
import org.apache.hadoop.tools.fedbalance.FedBalanceContext;
import org.apache.hadoop.tools.fedbalance.procedure.BalanceProcedure;

public class TrashProcedure
extends BalanceProcedure {
    private DistributedFileSystem srcFs;
    private FedBalanceContext context;
    private Configuration conf;

    public TrashProcedure() {
    }

    public TrashProcedure(String name, String nextProcedure, long delayDuration, FedBalanceContext context) throws IOException {
        super(name, nextProcedure, delayDuration);
        this.context = context;
        this.conf = context.getConf();
        this.srcFs = (DistributedFileSystem)context.getSrc().getFileSystem(this.conf);
    }

    @Override
    public boolean execute() throws IOException {
        this.moveToTrash();
        return true;
    }

    void moveToTrash() throws IOException {
        Path src = this.context.getSrc();
        if (this.srcFs.exists(src)) {
            FedBalanceConfigs.TrashOption trashOption = this.context.getTrashOpt();
            switch (trashOption) {
                case TRASH: {
                    this.conf.setFloat("fs.trash.interval", 60.0f);
                    if (Trash.moveToAppropriateTrash((FileSystem)this.srcFs, (Path)src, (Configuration)this.conf)) break;
                    throw new IOException("Failed move " + src + " to trash.");
                }
                case DELETE: {
                    if (!this.srcFs.delete(src, true)) {
                        throw new IOException("Failed delete " + src);
                    }
                    LOG.info("{} is deleted.", (Object)src);
                    break;
                }
                case SKIP: {
                    break;
                }
                default: {
                    throw new IOException("Unexpected trash option=" + (Object)((Object)trashOption));
                }
            }
        }
    }

    public FedBalanceContext getContext() {
        return this.context;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.context.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.context = new FedBalanceContext();
        this.context.readFields(in);
        this.conf = this.context.getConf();
        this.srcFs = (DistributedFileSystem)this.context.getSrc().getFileSystem(this.conf);
    }
}

