/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

final class AMOptions {
    public static final String NAMENODE_MEMORY_MB_ARG = "namenode_memory_mb";
    public static final String NAMENODE_MEMORY_MB_DEFAULT = "2048";
    public static final String NAMENODE_VCORES_ARG = "namenode_vcores";
    public static final String NAMENODE_VCORES_DEFAULT = "1";
    public static final String NAMENODE_NODELABEL_ARG = "namenode_nodelabel";
    public static final String NAMENODE_ARGS_ARG = "namenode_args";
    public static final String DATANODE_MEMORY_MB_ARG = "datanode_memory_mb";
    public static final String DATANODE_MEMORY_MB_DEFAULT = "2048";
    public static final String DATANODE_VCORES_ARG = "datanode_vcores";
    public static final String DATANODE_VCORES_DEFAULT = "1";
    public static final String DATANODE_NODELABEL_ARG = "datanode_nodelabel";
    public static final String DATANODE_ARGS_ARG = "datanode_args";
    public static final String NAMENODE_METRICS_PERIOD_ARG = "namenode_metrics_period";
    public static final String NAMENODE_METRICS_PERIOD_DEFAULT = "60";
    public static final String SHELL_ENV_ARG = "shell_env";
    public static final String DATANODES_PER_CLUSTER_ARG = "datanodes_per_cluster";
    public static final String DATANODES_PER_CLUSTER_DEFAULT = "1";
    public static final String DATANODE_LAUNCH_DELAY_ARG = "datanode_launch_delay";
    public static final String DATANODE_LAUNCH_DELAY_DEFAULT = "0s";
    public static final String NAMENODE_NAME_DIR_ARG = "namenode_name_dir";
    public static final String NAMENODE_EDITS_DIR_ARG = "namenode_edits_dir";
    private final int datanodeMemoryMB;
    private final int datanodeVirtualCores;
    private final String datanodeArgs;
    private final String datanodeNodeLabelExpression;
    private final int datanodesPerCluster;
    private final String datanodeLaunchDelay;
    private final int namenodeMemoryMB;
    private final int namenodeVirtualCores;
    private final String namenodeArgs;
    private final String namenodeNodeLabelExpression;
    private final int namenodeMetricsPeriod;
    private final String namenodeNameDir;
    private final String namenodeEditsDir;
    private final Map<String, String> originalShellEnv;
    private final Map<String, String> shellEnv;

    private AMOptions(int datanodeMemoryMB, int datanodeVirtualCores, String datanodeArgs, String datanodeNodeLabelExpression, int datanodesPerCluster, String datanodeLaunchDelay, int namenodeMemoryMB, int namenodeVirtualCores, String namenodeArgs, String namenodeNodeLabelExpression, int namenodeMetricsPeriod, String namenodeNameDir, String namenodeEditsDir, Map<String, String> shellEnv) {
        this.datanodeMemoryMB = datanodeMemoryMB;
        this.datanodeVirtualCores = datanodeVirtualCores;
        this.datanodeArgs = datanodeArgs;
        this.datanodeNodeLabelExpression = datanodeNodeLabelExpression;
        this.datanodesPerCluster = datanodesPerCluster;
        this.datanodeLaunchDelay = datanodeLaunchDelay;
        this.namenodeMemoryMB = namenodeMemoryMB;
        this.namenodeVirtualCores = namenodeVirtualCores;
        this.namenodeArgs = namenodeArgs;
        this.namenodeNodeLabelExpression = namenodeNodeLabelExpression;
        this.namenodeMetricsPeriod = namenodeMetricsPeriod;
        this.namenodeNameDir = namenodeNameDir;
        this.namenodeEditsDir = namenodeEditsDir;
        this.originalShellEnv = shellEnv;
        this.shellEnv = new HashMap<String, String>(this.originalShellEnv);
        this.shellEnv.put("NN_ADDITIONAL_ARGS", this.namenodeArgs);
        this.shellEnv.put("DN_ADDITIONAL_ARGS", this.datanodeArgs);
        this.shellEnv.put("NN_FILE_METRIC_PERIOD", String.valueOf(this.namenodeMetricsPeriod));
        this.shellEnv.put("NN_NAME_DIR", this.namenodeNameDir);
        this.shellEnv.put("NN_EDITS_DIR", this.namenodeEditsDir);
    }

    void verify(long maxMemory, int maxVcores) throws IllegalArgumentException {
        Preconditions.checkArgument((this.datanodeMemoryMB > 0 && (long)this.datanodeMemoryMB <= maxMemory ? 1 : 0) != 0, (String)"datanodeMemoryMB (%s) must be between 0 and %s", (int)this.datanodeMemoryMB, (long)maxMemory);
        Preconditions.checkArgument((this.datanodeVirtualCores > 0 && this.datanodeVirtualCores <= maxVcores ? 1 : 0) != 0, (String)"datanodeVirtualCores (%s) must be between 0 and %s", (int)this.datanodeVirtualCores, (int)maxVcores);
        Preconditions.checkArgument((this.namenodeMemoryMB > 0 && (long)this.namenodeMemoryMB <= maxMemory ? 1 : 0) != 0, (String)"namenodeMemoryMB (%s) must be between 0 and %s", (int)this.namenodeMemoryMB, (long)maxMemory);
        Preconditions.checkArgument((this.namenodeVirtualCores > 0 && this.namenodeVirtualCores <= maxVcores ? 1 : 0) != 0, (String)"namenodeVirtualCores (%s) must be between 0 and %s", (int)this.namenodeVirtualCores, (int)maxVcores);
        Preconditions.checkArgument((this.datanodesPerCluster > 0 ? 1 : 0) != 0, (String)"datanodesPerCluster (%s) must be > 0", (int)this.datanodesPerCluster);
    }

    void verify() throws IllegalArgumentException {
        this.verify(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    void addToVargs(List<String> vargs) {
        vargs.add("--datanode_memory_mb " + this.datanodeMemoryMB);
        vargs.add("--datanode_vcores " + this.datanodeVirtualCores);
        this.addStringValToVargs(vargs, DATANODE_ARGS_ARG, this.datanodeArgs);
        this.addStringValToVargs(vargs, DATANODE_NODELABEL_ARG, this.datanodeNodeLabelExpression);
        vargs.add("--datanodes_per_cluster " + this.datanodesPerCluster);
        vargs.add("--datanode_launch_delay " + this.datanodeLaunchDelay);
        vargs.add("--namenode_memory_mb " + this.namenodeMemoryMB);
        vargs.add("--namenode_vcores " + this.namenodeVirtualCores);
        this.addStringValToVargs(vargs, NAMENODE_ARGS_ARG, this.namenodeArgs);
        this.addStringValToVargs(vargs, NAMENODE_NODELABEL_ARG, this.namenodeNodeLabelExpression);
        vargs.add("--namenode_metrics_period " + this.namenodeMetricsPeriod);
        this.addStringValToVargs(vargs, NAMENODE_NAME_DIR_ARG, this.namenodeNameDir);
        this.addStringValToVargs(vargs, NAMENODE_EDITS_DIR_ARG, this.namenodeEditsDir);
        for (Map.Entry<String, String> entry : this.originalShellEnv.entrySet()) {
            vargs.add("--shell_env " + entry.getKey() + "=" + entry.getValue());
        }
    }

    private void addStringValToVargs(List<String> vargs, String optionName, String val) {
        if (!val.isEmpty()) {
            vargs.add("--" + optionName + " \\\"" + val + "\\\"");
        }
    }

    int getDataNodeMemoryMB() {
        return this.datanodeMemoryMB;
    }

    int getDataNodeVirtualCores() {
        return this.datanodeVirtualCores;
    }

    String getDataNodeNodeLabelExpression() {
        return this.datanodeNodeLabelExpression;
    }

    int getDataNodesPerCluster() {
        return this.datanodesPerCluster;
    }

    long getDataNodeLaunchDelaySec() {
        String tmpConfKey = "___temp_config_property___";
        Configuration tmpConf = new Configuration();
        tmpConf.set(tmpConfKey, this.datanodeLaunchDelay);
        return tmpConf.getTimeDuration(tmpConfKey, 0L, TimeUnit.SECONDS);
    }

    int getNameNodeMemoryMB() {
        return this.namenodeMemoryMB;
    }

    int getNameNodeVirtualCores() {
        return this.namenodeVirtualCores;
    }

    String getNameNodeNodeLabelExpression() {
        return this.namenodeNodeLabelExpression;
    }

    Map<String, String> getShellEnv() {
        return this.shellEnv;
    }

    static void setOptions(Options opts) {
        opts.addOption(SHELL_ENV_ARG, true, "Environment for shell script. Specified as env_key=env_val pairs");
        opts.addOption(NAMENODE_MEMORY_MB_ARG, true, "Amount of memory in MB to be requested to run the NN (default 2048). Ignored unless the NameNode is run within YARN.");
        opts.addOption(NAMENODE_VCORES_ARG, true, "Amount of virtual cores to be requested to run the NN (default 1). Ignored unless the NameNode is run within YARN.");
        opts.addOption(NAMENODE_ARGS_ARG, true, "Additional arguments to add when starting the NameNode. Ignored unless the NameNode is run within YARN.");
        opts.addOption(NAMENODE_NODELABEL_ARG, true, "The node label to specify for the container to use to run the NameNode.");
        opts.addOption(NAMENODE_METRICS_PERIOD_ARG, true, "The period in seconds for the NameNode's metrics to be emitted to file; if <=0, disables this functionality. Otherwise, a metrics file will be stored in the container logs for the NameNode (default 60).");
        opts.addOption(NAMENODE_NAME_DIR_ARG, true, "The directory to use for the NameNode's name data directory. If not specified, a location  within the container's working directory will be used.");
        opts.addOption(NAMENODE_EDITS_DIR_ARG, true, "The directory to use for the NameNode's edits directory. If not specified, a location  within the container's working directory will be used.");
        opts.addOption(DATANODE_MEMORY_MB_ARG, true, "Amount of memory in MB to be requested to run the DNs (default 2048)");
        opts.addOption(DATANODE_VCORES_ARG, true, "Amount of virtual cores to be requested to run the DNs (default 1)");
        opts.addOption(DATANODE_ARGS_ARG, true, "Additional arguments to add when starting the DataNodes.");
        opts.addOption(DATANODE_NODELABEL_ARG, true, "The node label to specify for the container to use to run the DataNode.");
        opts.addOption(DATANODES_PER_CLUSTER_ARG, true, "How many simulated DataNodes to run within each YARN container (default 1)");
        opts.addOption(DATANODE_LAUNCH_DELAY_ARG, true, "The period over which to launch the DataNodes; this will be used as the maximum delay and each DataNode container will be launched with some random delay less than  this value. Accepts human-readable time durations (e.g. 10s, 1m) (default 0s)");
        opts.addOption("help", false, "Print usage");
    }

    static AMOptions initFromParser(CommandLine cliParser) {
        HashMap<String, String> originalShellEnv = new HashMap<String, String>();
        if (cliParser.hasOption(SHELL_ENV_ARG)) {
            for (String env : cliParser.getOptionValues(SHELL_ENV_ARG)) {
                String trimmed = env.trim();
                int index = trimmed.indexOf(61);
                if (index == -1) {
                    originalShellEnv.put(trimmed, "");
                    continue;
                }
                String key = trimmed.substring(0, index);
                String val = "";
                if (index < trimmed.length() - 1) {
                    val = trimmed.substring(index + 1);
                }
                originalShellEnv.put(key, val);
            }
        }
        return new AMOptions(Integer.parseInt(cliParser.getOptionValue(DATANODE_MEMORY_MB_ARG, "2048")), Integer.parseInt(cliParser.getOptionValue(DATANODE_VCORES_ARG, "1")), cliParser.getOptionValue(DATANODE_ARGS_ARG, ""), cliParser.getOptionValue(DATANODE_NODELABEL_ARG, ""), Integer.parseInt(cliParser.getOptionValue(DATANODES_PER_CLUSTER_ARG, "1")), cliParser.getOptionValue(DATANODE_LAUNCH_DELAY_ARG, DATANODE_LAUNCH_DELAY_DEFAULT), Integer.parseInt(cliParser.getOptionValue(NAMENODE_MEMORY_MB_ARG, "2048")), Integer.parseInt(cliParser.getOptionValue(NAMENODE_VCORES_ARG, "1")), cliParser.getOptionValue(NAMENODE_ARGS_ARG, ""), cliParser.getOptionValue(NAMENODE_NODELABEL_ARG, ""), Integer.parseInt(cliParser.getOptionValue(NAMENODE_METRICS_PERIOD_ARG, NAMENODE_METRICS_PERIOD_DEFAULT)), cliParser.getOptionValue(NAMENODE_NAME_DIR_ARG, ""), cliParser.getOptionValue(NAMENODE_EDITS_DIR_ARG, ""), originalShellEnv);
    }
}

