/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class SimulatedDataNodes
extends Configured
implements Tool {
    private static final long STORAGE_CAPACITY = 0xC80000000000L;
    private static final String USAGE = "Usage: org.apache.hadoop.tools.dynamometer.SimulatedDataNodes bpid blockListFile1 [ blockListFileN ... ]\n   bpid should be the ID of the block pool to which these DataNodes belong.\n   Each blockListFile specified should contain a list of blocks to be served by one DataNode.\n   See the Javadoc of this class for more detail.";

    static void printUsageExit(String err) {
        System.out.println(err);
        System.out.println(USAGE);
        throw new RuntimeException(err);
    }

    public static void main(String[] args) throws Exception {
        SimulatedDataNodes datanodes = new SimulatedDataNodes();
        ToolRunner.run((Configuration)new HdfsConfiguration(), (Tool)datanodes, (String[])args);
    }

    public int run(String[] args) throws Exception {
        String nameNodeAdr;
        if (args.length < 2) {
            SimulatedDataNodes.printUsageExit("Not enough arguments");
        }
        String bpid = args[0];
        ArrayList<Path> blockListFiles = new ArrayList<Path>();
        for (int i = 1; i < args.length; ++i) {
            blockListFiles.add(new Path(args[i]));
        }
        URI defaultFS = FileSystem.getDefaultUri((Configuration)this.getConf());
        if (!"hdfs".equals(defaultFS.getScheme())) {
            SimulatedDataNodes.printUsageExit("Must specify an HDFS-based default FS! Got <" + defaultFS + ">");
        }
        if ((nameNodeAdr = defaultFS.getAuthority()) == null) {
            SimulatedDataNodes.printUsageExit("No NameNode address and port in config");
        }
        System.out.println("DataNodes will connect to NameNode at " + nameNodeAdr);
        String loc = ((StorageLocation)DataNode.getStorageLocations((Configuration)this.getConf()).get(0)).toString();
        loc = loc.substring(loc.indexOf("]") + 1);
        String path = new URI(loc).getPath();
        System.setProperty("test.build.data", path);
        SimulatedFSDataset.setFactory((Configuration)this.getConf());
        this.getConf().setLong("dfs.datanode.simulateddatastorage.capacity", 0xC80000000000L);
        UserGroupInformation.setConfiguration((Configuration)this.getConf());
        MiniDFSCluster mc = new MiniDFSCluster();
        try {
            mc.formatDataNodeDirs();
        }
        catch (IOException e) {
            System.out.println("Error formatting DataNode dirs: " + e);
            throw new RuntimeException("Error formatting DataNode dirs", e);
        }
        try {
            System.out.println("Found " + blockListFiles.size() + " block listing files; launching DataNodes accordingly.");
            mc.startDataNodes(this.getConf(), blockListFiles.size(), null, false, HdfsServerConstants.StartupOption.REGULAR, null, null, null, null, false, true, true, null);
            long startTime = Time.monotonicNow();
            System.out.println("Waiting for DataNodes to connect to NameNode and init storage directories.");
            HashSet<DataNode> datanodesWithoutFSDataset = new HashSet<DataNode>(mc.getDataNodes());
            while (!datanodesWithoutFSDataset.isEmpty()) {
                datanodesWithoutFSDataset.removeIf(dn -> DataNodeTestUtils.getFSDataset((DataNode)dn) != null);
                Thread.sleep(100L);
            }
            System.out.println("Waited " + (Time.monotonicNow() - startTime) + " ms for DataNode FSDatasets to be ready");
            for (int dnIndex = 0; dnIndex < blockListFiles.size(); ++dnIndex) {
                Path blockListFile = (Path)blockListFiles.get(dnIndex);
                try (FSDataInputStream fsdis = blockListFile.getFileSystem(this.getConf()).open(blockListFile);
                     BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fsdis, StandardCharsets.UTF_8));){
                    ArrayList<Block> blockList = new ArrayList<Block>();
                    int cnt = 0;
                    String line = reader.readLine();
                    while (line != null) {
                        String[] blockInfo = line.split(",");
                        blockList.add(new Block(Long.parseLong(blockInfo[0]), Long.parseLong(blockInfo[2]), Long.parseLong(blockInfo[1])));
                        ++cnt;
                        line = reader.readLine();
                    }
                    try {
                        mc.injectBlocks(dnIndex, blockList, bpid);
                    }
                    catch (IOException ioe) {
                        System.out.printf("Error injecting blocks into DataNode %d for block pool %s: %s%n", dnIndex, bpid, ExceptionUtils.getStackTrace((Throwable)ioe));
                    }
                    System.out.printf("Injected %d blocks into DataNode %d for block pool %s%n", cnt, dnIndex, bpid);
                    continue;
                }
            }
        }
        catch (IOException e) {
            System.out.println("Error creating DataNodes: " + ExceptionUtils.getStackTrace((Throwable)e));
            return 1;
        }
        return 0;
    }
}

