/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.IOException;
import java.security.Permission;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.util.TestDistCpUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExternalCall {
    private static final Logger LOG = LoggerFactory.getLogger(TestExternalCall.class);
    private static FileSystem fs;
    private static String root;
    private SecurityManager securityManager;

    private static Configuration getConf() {
        Configuration conf = new Configuration();
        conf.set("fs.default.name", "file:///");
        conf.set("mapred.job.tracker", "local");
        return conf;
    }

    @Before
    public void setup() {
        this.securityManager = System.getSecurityManager();
        System.setSecurityManager(new NoExitSecurityManager());
        try {
            fs = FileSystem.get((Configuration)TestExternalCall.getConf());
            root = new Path("target/tmp").makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString();
            TestDistCpUtils.delete(fs, root);
        }
        catch (IOException e) {
            LOG.error("Exception encountered ", (Throwable)e);
        }
    }

    @After
    public void tearDown() {
        System.setSecurityManager(this.securityManager);
    }

    @Test
    public void testCleanup() throws Exception {
        Configuration conf = TestExternalCall.getConf();
        Path stagingDir = JobSubmissionFiles.getStagingDir((Cluster)new Cluster(conf), (Configuration)conf);
        stagingDir.getFileSystem(conf).mkdirs(stagingDir);
        Path soure = this.createFile("tmp.txt");
        Path target = this.createFile("target.txt");
        DistCp distcp = new DistCp(conf, null);
        String[] arg = new String[]{soure.toString(), target.toString()};
        distcp.run(arg);
        Assert.assertTrue((boolean)fs.exists(target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path createFile(String fname) throws IOException {
        Path result = new Path(root + "/" + fname);
        try (FSDataOutputStream out = fs.create(result);){
            out.write((root + "/" + fname).getBytes());
            out.write("\n".getBytes());
        }
        return result;
    }

    public void testCleanupTestViaToolRunner() throws IOException, InterruptedException {
        Configuration conf = TestExternalCall.getConf();
        Path stagingDir = JobSubmissionFiles.getStagingDir((Cluster)new Cluster(conf), (Configuration)conf);
        stagingDir.getFileSystem(conf).mkdirs(stagingDir);
        Path soure = this.createFile("tmp.txt");
        Path target = this.createFile("target.txt");
        try {
            String[] arg = new String[]{target.toString(), soure.toString()};
            DistCp.main((String[])arg);
            Assert.fail();
        }
        catch (ExitException t) {
            Assert.assertTrue((boolean)fs.exists(target));
            Assert.assertEquals((long)t.status, (long)0L);
            Assert.assertEquals((long)stagingDir.getFileSystem(conf).listStatus(stagingDir).length, (long)0L);
        }
    }

    @Test
    public void testCleanupOfJob() throws Exception {
        Configuration conf = TestExternalCall.getConf();
        Path stagingDir = JobSubmissionFiles.getStagingDir((Cluster)new Cluster(conf), (Configuration)conf);
        stagingDir.getFileSystem(conf).mkdirs(stagingDir);
        Path soure = this.createFile("tmp.txt");
        Path target = this.createFile("target.txt");
        DistCp distcp = (DistCp)Mockito.mock(DistCp.class);
        Job job = (Job)Mockito.spy(Job.class);
        Mockito.when((Object)distcp.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)distcp.execute()).thenReturn((Object)job);
        Mockito.when((Object)distcp.run((String[])Mockito.any())).thenCallRealMethod();
        String[] arg = new String[]{soure.toString(), target.toString()};
        distcp.run(arg);
        ((Job)Mockito.verify((Object)job, (VerificationMode)Mockito.times((int)1))).close();
    }

    private static class NoExitSecurityManager
    extends SecurityManager {
        private NoExitSecurityManager() {
        }

        @Override
        public void checkPermission(Permission perm) {
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
        }

        @Override
        public void checkExit(int status) {
            super.checkExit(status);
            throw new ExitException(status);
        }
    }

    protected static class ExitException
    extends SecurityException {
        private static final long serialVersionUID = -1982617086752946683L;
        public final int status;

        public ExitException(int status) {
            super("There is no escape!");
            this.status = status;
        }
    }
}

