/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.util.DistCpTestUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDistCpSystem {
    private static final Logger LOG = LoggerFactory.getLogger(TestDistCpSystem.class);
    private static final String SRCDAT = "srcdat";
    private static final String DSTDAT = "dstdat";
    private static final long BLOCK_SIZE = 1024L;
    private static MiniDFSCluster cluster;
    private static Configuration conf;

    @BeforeClass
    public static void beforeClass() throws IOException {
        conf = new Configuration();
        conf.setLong("dfs.namenode.fs-limits.min-block-size", 1024L);
        conf.setLong("dfs.blocksize", 1024L);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        cluster.waitActive();
    }

    @AfterClass
    public static void afterClass() throws IOException {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    static String execCmd(FsShell shell, String ... args) throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baout, true);
        PrintStream old = System.out;
        System.setOut(out);
        shell.run(args);
        out.close();
        System.setOut(old);
        return baout.toString();
    }

    private void createFiles(DistributedFileSystem fs, String topdir, FileEntry[] entries, long chunkSize) throws IOException {
        long seed = System.currentTimeMillis();
        Random rand = new Random(seed);
        short replicationFactor = 2;
        for (FileEntry entry : entries) {
            Path newPath = new Path(topdir + "/" + entry.getPath());
            if (entry.isDirectory()) {
                fs.mkdirs(newPath);
            } else {
                long fileSize = 102400L;
                int bufSize = 128;
                if (chunkSize == -1L) {
                    DFSTestUtil.createFile((FileSystem)fs, (Path)newPath, (int)bufSize, (long)fileSize, (long)1024L, (short)replicationFactor, (long)seed);
                } else {
                    long seg1 = chunkSize * 1024L - 512L;
                    long seg2 = fileSize - seg1;
                    DFSTestUtil.createFile((FileSystem)fs, (Path)newPath, (int)bufSize, (long)seg1, (long)1024L, (short)replicationFactor, (long)seed);
                    DFSTestUtil.appendFileNewBlock((DistributedFileSystem)fs, (Path)newPath, (int)((int)seg2));
                }
            }
            seed = System.currentTimeMillis() + rand.nextLong();
        }
    }

    private void createFiles(DistributedFileSystem fs, String topdir, FileEntry[] entries) throws IOException {
        this.createFiles(fs, topdir, entries, -1L);
    }

    private static FileStatus[] getFileStatus(FileSystem fs, String topdir, FileEntry[] files) throws IOException {
        Path root = new Path(topdir);
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        for (int idx = 0; idx < files.length; ++idx) {
            Path newpath = new Path(root, files[idx].getPath());
            statuses.add(fs.getFileStatus(newpath));
        }
        return statuses.toArray(new FileStatus[statuses.size()]);
    }

    private static void deldir(FileSystem fs, String topdir) throws IOException {
        fs.delete(new Path(topdir), true);
    }

    private void testPreserveUserHelper(String testRoot, FileEntry[] srcEntries, FileEntry[] dstEntries, boolean createSrcDir, boolean createTgtDir, boolean update) throws Exception {
        String[] stringArray;
        String testSrcRel = SRCDAT;
        String testSrc = testRoot + "/" + SRCDAT;
        String testDstRel = DSTDAT;
        String testDst = testRoot + "/" + DSTDAT;
        String nnUri = FileSystem.getDefaultUri((Configuration)conf).toString();
        DistributedFileSystem fs = (DistributedFileSystem)FileSystem.get((URI)URI.create(nnUri), (Configuration)conf);
        fs.mkdirs(new Path(testRoot));
        if (createSrcDir) {
            fs.mkdirs(new Path(testSrc));
        }
        if (createTgtDir) {
            fs.mkdirs(new Path(testDst));
        }
        this.createFiles(fs, testRoot, srcEntries);
        FileStatus[] srcstats = TestDistCpSystem.getFileStatus((FileSystem)fs, testRoot, srcEntries);
        for (int i = 0; i < srcEntries.length; ++i) {
            fs.setOwner(srcstats[i].getPath(), "u" + i, null);
        }
        if (update) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "-pub";
            stringArray2[1] = "-update";
            stringArray2[2] = nnUri + testSrc;
            stringArray = stringArray2;
            stringArray2[3] = nnUri + testDst;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "-pub";
            stringArray3[1] = nnUri + testSrc;
            stringArray = stringArray3;
            stringArray3[2] = nnUri + testDst;
        }
        String[] args = stringArray;
        ToolRunner.run((Configuration)conf, (Tool)new DistCp(), (String[])args);
        String realTgtPath = testDst;
        if (!createTgtDir) {
            realTgtPath = testRoot;
        }
        FileStatus[] dststat = TestDistCpSystem.getFileStatus((FileSystem)fs, realTgtPath, dstEntries);
        for (int i = 0; i < dststat.length; ++i) {
            Assert.assertEquals((String)("i=" + i), (Object)("u" + i), (Object)dststat[i].getOwner());
        }
        TestDistCpSystem.deldir((FileSystem)fs, testRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareFiles(FileSystem fs, FileStatus srcStat, FileStatus dstStat) throws Exception {
        LOG.info("Comparing " + srcStat + " and " + dstStat);
        Assert.assertEquals((Object)srcStat.isDirectory(), (Object)dstStat.isDirectory());
        Assert.assertEquals((long)srcStat.getReplication(), (long)dstStat.getReplication());
        Assert.assertEquals((String)"File POSIX permission should match", (Object)srcStat.getPermission(), (Object)dstStat.getPermission());
        Assert.assertEquals((String)"File user ownership should match", (Object)srcStat.getOwner(), (Object)dstStat.getOwner());
        Assert.assertEquals((String)"File group ownership should match", (Object)srcStat.getGroup(), (Object)dstStat.getGroup());
        if (srcStat.isDirectory()) {
            return;
        }
        Assert.assertEquals((String)("File length should match (" + srcStat.getPath() + ")"), (long)srcStat.getLen(), (long)dstStat.getLen());
        FSDataInputStream srcIn = fs.open(srcStat.getPath());
        FSDataInputStream dstIn = fs.open(dstStat.getPath());
        try {
            byte[] readSrc = new byte[0x8000000];
            byte[] readDst = new byte[0x8000000];
            int srcBytesRead = 0;
            int tgtBytesRead = 0;
            int srcIdx = 0;
            int tgtIdx = 0;
            long totalComparedBytes = 0L;
            while (true) {
                if (srcBytesRead == 0) {
                    srcBytesRead = srcIn.read(readSrc);
                    srcIdx = 0;
                }
                if (tgtBytesRead == 0) {
                    tgtBytesRead = dstIn.read(readDst);
                    tgtIdx = 0;
                }
                if (srcBytesRead == 0 || tgtBytesRead == 0) {
                    LOG.info("______ compared src and dst files for " + totalComparedBytes + " bytes, content match.");
                    if (srcBytesRead != tgtBytesRead) {
                        Assert.fail((String)("Read mismatching size, compared " + totalComparedBytes + " bytes between src and dst file " + srcStat + " and " + dstStat));
                    }
                    if (totalComparedBytes == srcStat.getLen()) break;
                    Assert.fail((String)("Only read/compared " + totalComparedBytes + " bytes between src and dst file " + srcStat + " and " + dstStat));
                }
                while (srcIdx < srcBytesRead && tgtIdx < tgtBytesRead) {
                    if (readSrc[srcIdx] != readDst[tgtIdx]) {
                        Assert.fail((String)("src and dst file does not match at " + totalComparedBytes + " between " + srcStat + " and " + dstStat));
                    }
                    ++totalComparedBytes;
                    ++srcIdx;
                    ++tgtIdx;
                }
                LOG.info("______ compared src and dst files for " + totalComparedBytes + " bytes, content match. FileLength: " + srcStat.getLen());
                if (totalComparedBytes == srcStat.getLen()) {
                    LOG.info("______ Final:" + srcIdx + " " + srcBytesRead + " " + tgtIdx + " " + tgtBytesRead);
                    break;
                }
                if (srcIdx == srcBytesRead) {
                    srcBytesRead = 0;
                }
                if (tgtIdx != tgtBytesRead) continue;
                tgtBytesRead = 0;
            }
        }
        finally {
            if (srcIn != null) {
                srcIn.close();
            }
            if (dstIn != null) {
                dstIn.close();
            }
        }
    }

    private void createDestDir(FileSystem fs, String testDst, FileStatus[] srcStats, FileEntry[] srcFiles) throws IOException {
        fs.mkdirs(new Path(testDst));
        for (int i = 0; i < srcStats.length; ++i) {
            FileStatus srcStat = srcStats[i];
            if (!srcStat.isDirectory()) continue;
            Path dstPath = new Path(testDst, srcFiles[i].getPath());
            fs.mkdirs(dstPath);
            fs.setOwner(dstPath, srcStat.getOwner(), srcStat.getGroup());
        }
    }

    private void copyAndVerify(DistributedFileSystem fs, FileEntry[] srcFiles, FileStatus[] srcStats, String testDst, String[] args) throws Exception {
        String testRoot = "/testdir";
        FsShell shell = new FsShell(fs.getConf());
        LOG.info("ls before distcp");
        LOG.info(TestDistCpSystem.execCmd(shell, "-lsr", "/testdir"));
        LOG.info("_____ running distcp: " + args[0] + " " + args[1]);
        ToolRunner.run((Configuration)conf, (Tool)new DistCp(), (String[])args);
        LOG.info("ls after distcp");
        LOG.info(TestDistCpSystem.execCmd(shell, "-lsr", "/testdir"));
        FileStatus[] dstStat = TestDistCpSystem.getFileStatus((FileSystem)fs, testDst, srcFiles);
        for (int i = 0; i < dstStat.length; ++i) {
            this.compareFiles((FileSystem)fs, srcStats[i], dstStat[i]);
        }
    }

    private void chunkCopy(FileEntry[] srcFiles) throws Exception {
        String testRoot = "/testdir";
        String testSrcRel = SRCDAT;
        String testSrc = "/testdir/srcdat";
        String testDstRel = DSTDAT;
        String testDst = "/testdir/dstdat";
        long chunkSize = 8L;
        String nnUri = FileSystem.getDefaultUri((Configuration)conf).toString();
        DistributedFileSystem fs = (DistributedFileSystem)FileSystem.get((URI)URI.create(nnUri), (Configuration)conf);
        this.createFiles(fs, "/testdir", srcFiles, chunkSize);
        FileStatus[] srcStats = TestDistCpSystem.getFileStatus((FileSystem)fs, "/testdir", srcFiles);
        for (int i = 0; i < srcFiles.length; ++i) {
            fs.setOwner(srcStats[i].getPath(), "u" + i, "g" + i);
        }
        srcStats = TestDistCpSystem.getFileStatus((FileSystem)fs, "/testdir", srcFiles);
        this.createDestDir((FileSystem)fs, "/testdir/dstdat", srcStats, srcFiles);
        String[] args = new String[]{"-pugp", "-blocksperchunk", String.valueOf(chunkSize), nnUri + "/testdir/srcdat", nnUri + "/testdir/dstdat"};
        this.copyAndVerify(fs, srcFiles, srcStats, "/testdir/dstdat", args);
        this.copyAndVerify(fs, srcFiles, srcStats, "/testdir/dstdat", args);
        LOG.info("Modify a file and copy again");
        for (int i = srcFiles.length - 1; i >= 0; --i) {
            if (srcFiles[i].isDirectory()) continue;
            LOG.info("Modifying " + srcStats[i].getPath());
            DFSTestUtil.appendFileNewBlock((DistributedFileSystem)fs, (Path)srcStats[i].getPath(), (int)3072);
            break;
        }
        srcStats = TestDistCpSystem.getFileStatus((FileSystem)fs, "/testdir", srcFiles);
        args = new String[]{"-pugp", "-update", "-blocksperchunk", String.valueOf(chunkSize), nnUri + "/testdir/srcdat", nnUri + "/testdir/dstdat" + "/" + SRCDAT};
        this.copyAndVerify(fs, srcFiles, srcStats, "/testdir/dstdat", args);
        TestDistCpSystem.deldir((FileSystem)fs, "/testdir");
    }

    public void testRecursiveChunkCopy() throws Exception {
        FileEntry[] srcFiles = new FileEntry[]{new FileEntry(SRCDAT, true), new FileEntry("srcdat/file0", false), new FileEntry("srcdat/dir1", true), new FileEntry("srcdat/dir2", true), new FileEntry("srcdat/dir1/file1", false)};
        this.chunkCopy(srcFiles);
    }

    public void testChunkCopyOneFile() throws Exception {
        FileEntry[] srcFiles = new FileEntry[]{new FileEntry(SRCDAT, true), new FileEntry("srcdat/file0", false)};
        this.chunkCopy(srcFiles);
    }

    public void testDistcpLargeFile() throws Exception {
        FileEntry[] srcfiles = new FileEntry[]{new FileEntry(SRCDAT, true), new FileEntry("srcdat/file", false)};
        String testRoot = "/testdir";
        String testSrcRel = SRCDAT;
        String testSrc = "/testdir/srcdat";
        String testDstRel = DSTDAT;
        String testDst = "/testdir/dstdat";
        String nnUri = FileSystem.getDefaultUri((Configuration)conf).toString();
        DistributedFileSystem fs = (DistributedFileSystem)FileSystem.get((URI)URI.create(nnUri), (Configuration)conf);
        fs.mkdirs(new Path("/testdir"));
        fs.mkdirs(new Path("/testdir/srcdat"));
        fs.mkdirs(new Path("/testdir/dstdat"));
        long chunkSize = 6L;
        this.createFiles(fs, "/testdir", srcfiles, chunkSize);
        String srcFileName = "/testdir/" + srcfiles[1].getPath();
        Path srcfile = new Path(srcFileName);
        if (!cluster.getFileSystem().exists(srcfile)) {
            throw new Exception("src not exist");
        }
        long srcLen = fs.getFileStatus(srcfile).getLen();
        FileStatus[] srcstats = TestDistCpSystem.getFileStatus((FileSystem)fs, "/testdir", srcfiles);
        for (int i = 0; i < srcfiles.length; ++i) {
            fs.setOwner(srcstats[i].getPath(), "u" + i, null);
        }
        String[] args = new String[]{"-blocksperchunk", String.valueOf(chunkSize), nnUri + "/testdir/srcdat", nnUri + "/testdir/dstdat"};
        LOG.info("_____ running distcp: " + args[0] + " " + args[1]);
        ToolRunner.run((Configuration)conf, (Tool)new DistCp(), (String[])args);
        String realTgtPath = "/testdir/dstdat";
        FileStatus[] dststat = TestDistCpSystem.getFileStatus((FileSystem)fs, realTgtPath, srcfiles);
        Assert.assertEquals((String)"File length should match", (long)srcLen, (long)dststat[dststat.length - 1].getLen());
        this.compareFiles((FileSystem)fs, srcstats[srcstats.length - 1], dststat[dststat.length - 1]);
        TestDistCpSystem.deldir((FileSystem)fs, "/testdir");
    }

    @Test
    public void testPreserveUseNonEmptyDir() throws Exception {
        String testRoot = "/testdir." + GenericTestUtils.getMethodName();
        FileEntry[] srcfiles = new FileEntry[]{new FileEntry(SRCDAT, true), new FileEntry("srcdat/a", false), new FileEntry("srcdat/b", true), new FileEntry("srcdat/b/c", false)};
        FileEntry[] dstfiles = new FileEntry[]{new FileEntry(DSTDAT, true), new FileEntry("dstdat/a", false), new FileEntry("dstdat/b", true), new FileEntry("dstdat/b/c", false)};
        this.testPreserveUserHelper(testRoot, srcfiles, srcfiles, false, true, false);
        this.testPreserveUserHelper(testRoot, srcfiles, dstfiles, false, false, false);
    }

    @Test
    public void testPreserveUserEmptyDir() throws Exception {
        String testRoot = "/testdir." + GenericTestUtils.getMethodName();
        FileEntry[] srcfiles = new FileEntry[]{new FileEntry(SRCDAT, true)};
        FileEntry[] dstfiles = new FileEntry[]{new FileEntry(DSTDAT, true)};
        this.testPreserveUserHelper(testRoot, srcfiles, srcfiles, false, true, false);
        this.testPreserveUserHelper(testRoot, srcfiles, dstfiles, false, false, false);
    }

    public void testPreserveUserSingleFile() throws Exception {
        String testRoot = "/testdir." + GenericTestUtils.getMethodName();
        FileEntry[] srcfiles = new FileEntry[]{new FileEntry(SRCDAT, false)};
        FileEntry[] dstfiles = new FileEntry[]{new FileEntry(DSTDAT, false)};
        this.testPreserveUserHelper(testRoot, srcfiles, srcfiles, false, true, false);
        this.testPreserveUserHelper(testRoot, srcfiles, dstfiles, false, false, false);
    }

    @Test
    public void testPreserveUserNonEmptyDirWithUpdate() throws Exception {
        String testRoot = "/testdir." + GenericTestUtils.getMethodName();
        FileEntry[] srcfiles = new FileEntry[]{new FileEntry("srcdat/a", false), new FileEntry("srcdat/b", true), new FileEntry("srcdat/b/c", false)};
        FileEntry[] dstfiles = new FileEntry[]{new FileEntry("a", false), new FileEntry("b", true), new FileEntry("b/c", false)};
        this.testPreserveUserHelper(testRoot, srcfiles, dstfiles, true, true, true);
    }

    @Test
    public void testSourceRoot() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        String rootStr = fs.makeQualified(new Path("/")).toString();
        String testRoot = "/testdir." + GenericTestUtils.getMethodName();
        Path tgtPath = new Path(testRoot + "/nodir");
        String tgtStr = fs.makeQualified(tgtPath).toString();
        String[] args = new String[]{rootStr, tgtStr};
        Assert.assertThat((Object)ToolRunner.run((Configuration)conf, (Tool)new DistCp(), (String[])args), (Matcher)Is.is((Object)0));
        Path tgtPath2 = new Path(testRoot + "/dir");
        Assert.assertTrue((boolean)fs.mkdirs(tgtPath2));
        String tgtStr2 = fs.makeQualified(tgtPath2).toString();
        String[] args2 = new String[]{rootStr, tgtStr2};
        Assert.assertThat((Object)ToolRunner.run((Configuration)conf, (Tool)new DistCp(), (String[])args2), (Matcher)Is.is((Object)0));
    }

    @Test
    public void testUpdateRoot() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        Path source = new Path("/src");
        Path dest1 = new Path("/dest1");
        Path dest2 = new Path("/dest2");
        fs.delete(source, true);
        fs.delete(dest1, true);
        fs.delete(dest2, true);
        fs.mkdirs(source);
        fs.setOwner(source, "userA", "groupA");
        fs.setTimes(source, new Random().nextLong(), new Random().nextLong());
        GenericTestUtils.createFiles((FileSystem)fs, (Path)source, (int)3, (int)5, (int)5);
        DistCpTestUtils.assertRunDistCp(0, source.toString(), dest1.toString(), "-p -update", conf);
        FileStatus srcStatus = fs.getFileStatus(source);
        FileStatus destStatus1 = fs.getFileStatus(dest1);
        Assert.assertNotEquals((Object)srcStatus.getOwner(), (Object)destStatus1.getOwner());
        Assert.assertNotEquals((long)srcStatus.getModificationTime(), (long)destStatus1.getModificationTime());
        DistCpTestUtils.assertRunDistCp(0, source.toString(), dest2.toString(), "-p -update -updateRoot", conf);
        FileStatus destStatus2 = fs.getFileStatus(dest2);
        Assert.assertEquals((Object)srcStatus.getOwner(), (Object)destStatus2.getOwner());
        Assert.assertEquals((long)srcStatus.getModificationTime(), (long)destStatus2.getModificationTime());
    }

    private class FileEntry {
        String path;
        boolean isDir;

        public FileEntry(String path, boolean isDir) {
            this.path = path;
            this.isDir = isDir;
        }

        String getPath() {
            return this.path;
        }

        boolean isDirectory() {
            return this.isDir;
        }
    }
}

