/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyFilter;
import org.apache.hadoop.tools.CopyListing;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.FileListingEntry;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.tools.util.ProducerConsumer;
import org.apache.hadoop.tools.util.WorkReport;
import org.apache.hadoop.tools.util.WorkRequest;
import org.apache.hadoop.tools.util.WorkRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCopyListing
extends CopyListing {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleCopyListing.class);
    private long totalPaths = 0L;
    private long totalDirs = 0L;
    private long totalBytesToCopy = 0L;
    private int numListstatusThreads = 1;
    private final int maxRetries = 3;
    private CopyFilter copyFilter;
    public static Map<String, Set<String>> loopLocator = new HashMap<String, Set<String>>();

    protected SimpleCopyListing(Configuration configuration, Credentials credentials) {
        super(configuration, credentials);
        this.numListstatusThreads = this.getConf().getInt("distcp.liststatus.threads", 1);
        this.copyFilter = CopyFilter.getCopyFilter(this.getConf());
        this.copyFilter.initialize();
    }

    @VisibleForTesting
    protected SimpleCopyListing(Configuration configuration, Credentials credentials, int numListstatusThreads) {
        super(configuration, credentials);
        this.numListstatusThreads = numListstatusThreads;
    }

    @Override
    protected void validatePaths(DistCpOptions options) throws IOException, CopyListing.InvalidInputException {
        Credentials credentials;
        Path targetPath = options.getTargetPath();
        FileSystem targetFS = targetPath.getFileSystem(this.getConf());
        boolean targetIsFile = targetFS.isFile(targetPath);
        targetPath = targetFS.makeQualified(targetPath);
        boolean targetIsReservedRaw = Path.getPathWithoutSchemeAndAuthority((Path)targetPath).toString().startsWith("/.reserved/raw");
        if (targetIsFile) {
            if (options.getSourcePaths().size() > 1) {
                throw new CopyListing.InvalidInputException("Multiple source being copied to a file: " + targetPath);
            }
            Path srcPath = options.getSourcePaths().get(0);
            FileSystem sourceFS = srcPath.getFileSystem(this.getConf());
            if (!sourceFS.isFile(srcPath)) {
                throw new CopyListing.InvalidInputException("Cannot copy " + srcPath + ", which is not a file to " + targetPath);
            }
        }
        if (options.shouldAtomicCommit() && targetFS.exists(targetPath)) {
            throw new CopyListing.InvalidInputException("Target path for atomic-commit already exists: " + targetPath + ". Cannot atomic-commit to pre-existing target-path.");
        }
        for (Path path : options.getSourcePaths()) {
            FileSystem fs = path.getFileSystem(this.getConf());
            if (!fs.exists(path)) {
                throw new CopyListing.InvalidInputException(path + " doesn't exist");
            }
            if (Path.getPathWithoutSchemeAndAuthority((Path)path).toString().startsWith("/.reserved/raw")) {
                if (targetIsReservedRaw) continue;
                String msg = "The source path '" + path + "' starts with /.reserved/raw but the target path '" + targetPath + "' does not. Either all or none of the paths must have this prefix.";
                throw new CopyListing.InvalidInputException(msg);
            }
            if (!targetIsReservedRaw) continue;
            String msg = "The target path '" + targetPath + "' starts with /.reserved/raw but the source path '" + path + "' does not. Either all or none of the paths must have this prefix.";
            throw new CopyListing.InvalidInputException(msg);
        }
        if (targetIsReservedRaw) {
            options.preserveRawXattrs();
            this.getConf().setBoolean("distcp.preserve.rawxattrs", true);
        }
        if ((credentials = this.getCredentials()) != null) {
            Path[] inputPaths = options.getSourcePaths().toArray(new Path[1]);
            TokenCache.obtainTokensForNamenodes((Credentials)credentials, (Path[])inputPaths, (Configuration)this.getConf());
        }
    }

    @Override
    public void doBuildListing(Path pathToListingFile, DistCpOptions options) throws IOException {
        this.doBuildListing(this.getWriter(pathToListingFile), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void doBuildListing(SequenceFile.Writer fileListWriter, DistCpOptions options) throws IOException {
        if (options.getNumListstatusThreads() > 0) {
            this.numListstatusThreads = options.getNumListstatusThreads();
        }
        try {
            for (Path path : options.getSourcePaths()) {
                boolean explore;
                FileSystem sourceFS = path.getFileSystem(this.getConf());
                boolean preserveAcls = options.shouldPreserve(DistCpOptions.FileAttribute.ACL);
                boolean preserveXAttrs = options.shouldPreserve(DistCpOptions.FileAttribute.XATTR);
                boolean preserveRawXAttrs = options.shouldPreserveRawXattrs();
                boolean keepLinks = options.shouldKeepLinks();
                path = this.makeQualified(path);
                FileStatus rootStatus = sourceFS.getFileStatus(path);
                FileListingEntry listingEntryRoot = DistCpUtils.getOriginalFileStatus(rootStatus, this.getConf(), keepLinks, loopLocator);
                FileStatus[] sourceFiles = sourceFS.listStatus(listingEntryRoot.getSourceRealPath().getPath());
                Path sourcePathRoot = this.computeSourceRootPath(listingEntryRoot.getSourceRealPath(), options);
                String relativePathPrefix = listingEntryRoot.getSourceRealPath().getPath().equals((Object)sourcePathRoot) ? "" : "/" + listingEntryRoot.getSourceRealPath().getPath().getName();
                boolean bl = explore = sourceFiles != null && sourceFiles.length > 0;
                if (!explore || rootStatus.isDirectory() || rootStatus.isSymlink() && listingEntryRoot.getSourceRealPath().isDirectory() || rootStatus.isSymlink() && keepLinks) {
                    DistCpUtils.toCopyListingFileStatus(sourceFS, listingEntryRoot, preserveAcls, preserveXAttrs, preserveRawXAttrs, options.getBlocksPerChunk());
                    this.writeToFileListingRoot(fileListWriter, listingEntryRoot, sourcePathRoot, options, relativePathPrefix);
                }
                if (!explore || keepLinks && rootStatus.isSymlink()) continue;
                ArrayList<FileListingEntry> sourceDirs = new ArrayList<FileListingEntry>();
                for (FileStatus sourceStatus : sourceFiles) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Recording source-path: " + sourceStatus.getPath() + " for copy.");
                    }
                    FileListingEntry listingEntry = DistCpUtils.getOriginalFileStatus(sourceStatus, this.getConf(), keepLinks, loopLocator);
                    DistCpUtils.toCopyListingFileStatus(sourceFS, listingEntry, preserveAcls && listingEntry.getSourceRealPath().isDirectory(), preserveXAttrs && listingEntry.getSourceRealPath().isDirectory(), preserveRawXAttrs && listingEntry.getSourceRealPath().isDirectory(), options.getBlocksPerChunk());
                    this.writeToFileListing(fileListWriter, listingEntry, relativePathPrefix + DistCpUtils.getRelativePath(listingEntry));
                    if (!listingEntry.getSourceRealPath().isDirectory()) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding source dir for traverse: " + listingEntry.getSourceRealPath().getPath());
                    }
                    sourceDirs.add(listingEntry);
                }
                this.traverseDirectory(fileListWriter, sourceFS, sourceDirs, relativePathPrefix, options);
            }
            fileListWriter.close();
            this.printStats();
            LOG.info("Build file listing completed.");
            fileListWriter = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fileListWriter});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fileListWriter});
    }

    private Path computeSourceRootPath(FileStatus sourceStatus, DistCpOptions options) throws IOException {
        boolean simpleFile;
        boolean solitaryFile;
        Path target = options.getTargetPath();
        FileSystem targetFS = target.getFileSystem(this.getConf());
        boolean targetPathExists = options.getTargetPathExists();
        boolean bl = solitaryFile = options.getSourcePaths().size() == 1 && !sourceStatus.isDirectory() && (!sourceStatus.isSymlink() || !DistCpUtils.getOriginalFileStatus(sourceStatus, this.getConf(), options.shouldKeepLinks(), loopLocator).getSourceRealPath().isDirectory());
        if (solitaryFile) {
            return sourceStatus.getPath();
        }
        boolean specialHandling = options.getSourcePaths().size() == 1 && !targetPathExists || options.shouldSyncFolder() || options.shouldOverwrite();
        boolean bl2 = simpleFile = !sourceStatus.isDirectory() && (!sourceStatus.isSymlink() || !DistCpUtils.getOriginalFileStatus(sourceStatus, this.getConf(), options.shouldKeepLinks(), loopLocator).getSourceRealPath().isDirectory());
        if (specialHandling && (sourceStatus.isDirectory() || !simpleFile) || simpleFile) {
            return sourceStatus.getPath();
        }
        return sourceStatus.getPath().getParent();
    }

    protected boolean shouldCopy(Path path) {
        return this.copyFilter.shouldCopy(path);
    }

    @Override
    protected long getBytesToCopy() {
        return this.totalBytesToCopy;
    }

    @Override
    protected long getNumberOfPaths() {
        return this.totalPaths;
    }

    private Path makeQualified(Path path) throws IOException {
        FileSystem fs = path.getFileSystem(this.getConf());
        return path.makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    private SequenceFile.Writer getWriter(Path pathToListFile) throws IOException {
        FileSystem fs = pathToListFile.getFileSystem(this.getConf());
        if (fs.exists(pathToListFile)) {
            fs.delete(pathToListFile, false);
        }
        return SequenceFile.createWriter((Configuration)this.getConf(), (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)pathToListFile), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(CopyListingFileStatus.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE)});
    }

    private void printStats() {
        LOG.info("Paths (files+dirs) cnt = " + this.totalPaths + "; dirCnt = " + this.totalDirs);
    }

    private void maybePrintStats() {
        if (this.totalPaths % 100000L == 0L) {
            this.printStats();
        }
    }

    private void traverseDirectory(SequenceFile.Writer fileListWriter, FileSystem sourceFS, ArrayList<FileListingEntry> sourceDirs, String relativePathPrefix, DistCpOptions options) throws IOException {
        boolean preserveAcls = options.shouldPreserve(DistCpOptions.FileAttribute.ACL);
        boolean preserveXAttrs = options.shouldPreserve(DistCpOptions.FileAttribute.XATTR);
        boolean preserveRawXattrs = options.shouldPreserveRawXattrs();
        assert (this.numListstatusThreads > 0);
        LOG.debug("Starting thread pool of " + this.numListstatusThreads + " listStatus workers.");
        ProducerConsumer<FileListingEntry, List<FileListingEntry>> workers = new ProducerConsumer<FileListingEntry, List<FileListingEntry>>(this.numListstatusThreads);
        for (int i = 0; i < this.numListstatusThreads; ++i) {
            workers.addWorker(new FileStatusProcessor(sourceFS));
        }
        for (FileListingEntry entry : sourceDirs) {
            workers.put(new WorkRequest<FileListingEntry>(entry, 0));
            this.maybePrintStats();
        }
        while (workers.hasWork()) {
            try {
                WorkReport workResult = workers.take();
                int retry = workResult.getRetry();
                List childs = (List)workResult.getItem();
                for (FileListingEntry child : childs) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Recording source-path: " + child.getSourceRealPath().getPath() + " for copy.");
                    }
                    if (retry == 0) {
                        DistCpUtils.toCopyListingFileStatus(sourceFS, child, preserveAcls && child.getSourceRealPath().isDirectory(), preserveXAttrs && child.getSourceRealPath().isDirectory(), preserveRawXattrs && child.getSourceRealPath().isDirectory(), options.getBlocksPerChunk());
                        this.writeToFileListing(fileListWriter, child, relativePathPrefix + DistCpUtils.getRelativePath(child));
                    }
                    if (retry < 3) {
                        if (!child.getSourceRealPath().isDirectory()) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Traversing into source dir: " + child.getSourceRealPath().getPath());
                        }
                        workers.put(new WorkRequest<FileListingEntry>(child, retry));
                        this.maybePrintStats();
                        continue;
                    }
                    LOG.error("Giving up on " + child.getSourceRealPath().getPath() + " after " + retry + " retries.");
                }
            }
            catch (InterruptedException ie) {
                LOG.error("Could not get item from childQueue. Retrying...");
            }
        }
        workers.shutdown();
    }

    private void writeToFileListingRoot(SequenceFile.Writer fileListWriter, FileListingEntry listingEntry, Path sourcePathRoot, DistCpOptions options, String relativePathPrefix) throws IOException {
        boolean syncOrOverwrite;
        boolean bl = syncOrOverwrite = options.shouldSyncFolder() || options.shouldOverwrite();
        if (listingEntry.getSourceRealPath().getPath().equals((Object)sourcePathRoot) && listingEntry.getSourceRealPath().isDirectory() && syncOrOverwrite) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skip " + listingEntry.getSourceRealPath().getPath());
            }
            return;
        }
        this.writeToFileListing(fileListWriter, listingEntry, relativePathPrefix);
    }

    private void writeToFileListing(SequenceFile.Writer fileListWriter, FileListingEntry listingEntry, String relativePath) throws IOException {
        for (CopyListingFileStatus fileStatus : listingEntry.getCopyListingFileStatus()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("RELATIVE TARGET PATH: " + relativePath + ", REAL FILE PATH: " + fileStatus.getPath());
            }
            if (!this.shouldCopy(fileStatus.getPath())) {
                return;
            }
            fileListWriter.append((Writable)new Text(relativePath), (Writable)fileStatus);
            fileListWriter.sync();
            if (!fileStatus.isDirectory()) {
                this.totalBytesToCopy += fileStatus.getSizeToCopy();
            } else {
                ++this.totalDirs;
            }
            ++this.totalPaths;
        }
    }

    private static class FileStatusProcessor
    implements WorkRequestProcessor<FileListingEntry, List<FileListingEntry>> {
        private FileSystem fileSystem;

        public FileStatusProcessor(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
        }

        @Override
        public WorkReport<List<FileListingEntry>> processItem(WorkRequest<FileListingEntry> workRequest) {
            FileListingEntry parent = workRequest.getItem();
            int retry = workRequest.getRetry();
            WorkReport<List<FileListingEntry>> result = null;
            try {
                if (retry > 0) {
                    int sleepSeconds = 2;
                    for (int i = 1; i < retry; ++i) {
                        sleepSeconds *= 2;
                    }
                    try {
                        Thread.sleep(1000 * sleepSeconds);
                    }
                    catch (InterruptedException ie) {
                        LOG.debug("Interrupted while sleeping in exponential backoff.");
                    }
                }
                FileStatus[] childFileStatusList = this.fileSystem.listStatus(parent.getSourceRealPath().getPath());
                ArrayList<FileListingEntry> childEntryList = new ArrayList<FileListingEntry>();
                for (FileStatus status : childFileStatusList) {
                    FileListingEntry childListingEntry = DistCpUtils.getOriginalFileStatus(status, new Configuration(), parent.isKeepLink(), loopLocator);
                    childListingEntry.setParent(parent);
                    childEntryList.add(childListingEntry);
                }
                result = new WorkReport(childEntryList, 0, true);
            }
            catch (FileNotFoundException fnf) {
                LOG.error("FileNotFoundException exception in listStatus: " + fnf.getMessage());
                result = new WorkReport<List<FileListingEntry>>(new ArrayList(), 0, true, fnf);
            }
            catch (Exception e) {
                LOG.error("Exception in listStatus. Will send for retry.");
                ArrayList<FileListingEntry> childEntryList = new ArrayList<FileListingEntry>();
                childEntryList.add(parent);
                result = new WorkReport(childEntryList, retry + 1, false, e);
            }
            return result;
        }
    }
}

