/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.bouncycastle.tls.crypto.impl.AEADNonceGenerator;
import org.bouncycastle.tls.crypto.impl.AEADNonceGeneratorFactory;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipher;
import org.bouncycastle.tls.crypto.impl.jcajce.BCFipsAEADNonceGenerator;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class GCMFipsUtil {
    private static final Class fipsNonceGeneratorClass = GCMFipsUtil.lookup("org.bouncycastle.crypto.fips.FipsNonceGenerator");

    GCMFipsUtil() {
    }

    static AEADNonceGeneratorFactory getDefaultFipsGCMNonceGeneratorFactory() {
        return GCMFipsUtil.getBcFipsNonceGeneratorFactory();
    }

    private static AEADNonceGeneratorFactory getBcFipsNonceGeneratorFactory() {
        if (fipsNonceGeneratorClass != null) {
            return new AEADNonceGeneratorFactory(){

                @Override
                public AEADNonceGenerator create(byte[] baseNonce, int counterSizeInBits) {
                    return new BCFipsAEADNonceGenerator(baseNonce, counterSizeInBits);
                }
            };
        }
        return null;
    }

    static Class lookup(final String className) {
        if (null == className) {
            return null;
        }
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    ClassLoader classLoader = TlsAEADCipher.class.getClassLoader();
                    Class<?> clazz = null == classLoader ? Class.forName(className) : classLoader.loadClass(className);
                    return clazz;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }
}

