/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.CommitResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ContainerUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ContainerUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLocalizationStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLocalizationStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReInitializeContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReInitializeContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceLocalizationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceLocalizationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RestartContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RollbackResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.SignalContainerResponsePBImpl;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.LocalizationStatus;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.SerializedException;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.LogAggregationContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.InvalidAuxServiceException;
import org.apache.hadoop.yarn.exceptions.InvalidContainerException;
import org.apache.hadoop.yarn.exceptions.NMNotYetReadyException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.metrics.EventTypeMetrics;
import org.apache.hadoop.yarn.metrics.GenericEventTypeMetrics;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.security.NMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.AuxiliaryLocalPathHandler;
import org.apache.hadoop.yarn.server.api.ContainerInitializationContext;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.apache.hadoop.yarn.server.api.records.ContainerQueuingLimit;
import org.apache.hadoop.yarn.server.api.records.OpportunisticContainersStatus;
import org.apache.hadoop.yarn.server.nodemanager.CMgrCompletedAppsEvent;
import org.apache.hadoop.yarn.server.nodemanager.CMgrCompletedContainersEvent;
import org.apache.hadoop.yarn.server.nodemanager.CMgrSignalContainersEvent;
import org.apache.hadoop.yarn.server.nodemanager.CMgrUpdateContainersEvent;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEvent;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEventType;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.GenericEventTypeMetricsManager;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.NMAuditLogger;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AMRMProxyService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServices;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManager;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationFinishEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerKillEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerReInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.UpdateContainerTokenEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.AbstractContainersLauncher;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncher;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.SignalContainersLauncherEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourceRequest;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ResourceLocalizationService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ResourceSet;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ContainerLocalizationRequestEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.sharedcache.SharedCacheUploadEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.sharedcache.SharedCacheUploadService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.logaggregation.LogAggregationService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.LogHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.NonAggregatingLogHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerTokenUpdatedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler.ContainerScheduler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler.ContainerSchedulerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler.ContainerSchedulerEventType;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.recovery.RecoveryIterator;
import org.apache.hadoop.yarn.server.nodemanager.security.authorize.NMPolicyProvider;
import org.apache.hadoop.yarn.server.nodemanager.timelineservice.NMTimelinePublisher;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.utils.YarnServerSecurityUtils;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerManagerImpl
extends CompositeService
implements ContainerManager {
    private static final int SHUTDOWN_CLEANUP_SLOP_MS = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(ContainerManagerImpl.class);
    public static final String INVALID_NMTOKEN_MSG = "Invalid NMToken";
    static final String INVALID_CONTAINERTOKEN_MSG = "Invalid ContainerToken";
    protected final Context context;
    private final ContainersMonitor containersMonitor;
    private Server server;
    private final ResourceLocalizationService rsrcLocalizationSrvc;
    private final AbstractContainersLauncher containersLauncher;
    private final AuxServices auxiliaryServices;
    @VisibleForTesting
    final NodeManagerMetrics metrics;
    protected final NodeStatusUpdater nodeStatusUpdater;
    protected LocalDirsHandlerService dirsHandler;
    private AsyncDispatcher dispatcher;
    private final DeletionService deletionService;
    private LogHandler logHandler;
    private boolean serviceStopped = false;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private AMRMProxyService amrmProxyService;
    protected boolean amrmProxyEnabled = false;
    private final ContainerScheduler containerScheduler;
    private long waitForContainersOnShutdownMillis;
    private NMTimelinePublisher nmMetricsPublisher;
    private boolean timelineServiceV2Enabled;
    private boolean nmDispatherMetricEnabled;

    public ContainerManagerImpl(Context context, ContainerExecutor exec, DeletionService deletionContext, NodeStatusUpdater nodeStatusUpdater, NodeManagerMetrics metrics, LocalDirsHandlerService dirsHandler) {
        super(ContainerManagerImpl.class.getName());
        this.context = context;
        this.dirsHandler = dirsHandler;
        this.dispatcher = this.createContainerManagerDispatcher();
        this.deletionService = deletionContext;
        this.metrics = metrics;
        this.rsrcLocalizationSrvc = this.createResourceLocalizationService(exec, deletionContext, context, metrics);
        this.addService((Service)this.rsrcLocalizationSrvc);
        this.containersLauncher = this.createContainersLauncher(context, exec);
        this.addService(this.containersLauncher);
        this.nodeStatusUpdater = nodeStatusUpdater;
        this.containerScheduler = this.createContainerScheduler(context);
        this.addService((Service)this.containerScheduler);
        AuxiliaryLocalPathHandlerImpl auxiliaryLocalPathHandler = new AuxiliaryLocalPathHandlerImpl(dirsHandler);
        this.auxiliaryServices = new AuxServices(auxiliaryLocalPathHandler, this.context, this.deletionService);
        this.auxiliaryServices.registerServiceListener(this);
        context.setAuxServices(this.auxiliaryServices);
        this.addService((Service)this.auxiliaryServices);
        Configuration conf = context.getConf();
        if (YarnConfiguration.timelineServiceV2Enabled((Configuration)conf)) {
            if (YarnConfiguration.systemMetricsPublisherEnabled((Configuration)conf)) {
                LOG.info("YARN system metrics publishing service is enabled");
                this.nmMetricsPublisher = this.createNMTimelinePublisher(context);
                context.setNMTimelinePublisher(this.nmMetricsPublisher);
            }
            this.timelineServiceV2Enabled = true;
        }
        this.containersMonitor = this.createContainersMonitor(exec);
        this.addService(this.containersMonitor);
        this.dispatcher.register(ContainerEventType.class, (EventHandler)new ContainerEventDispatcher());
        this.dispatcher.register(ApplicationEventType.class, this.createApplicationEventDispatcher());
        this.dispatcher.register(LocalizationEventType.class, (EventHandler)new LocalizationEventHandlerWrapper(this.rsrcLocalizationSrvc, this.nmMetricsPublisher));
        this.dispatcher.register(AuxServicesEventType.class, (EventHandler)this.auxiliaryServices);
        this.dispatcher.register(ContainersMonitorEventType.class, (EventHandler)this.containersMonitor);
        this.dispatcher.register(ContainersLauncherEventType.class, (EventHandler)this.containersLauncher);
        this.dispatcher.register(ContainerSchedulerEventType.class, (EventHandler)this.containerScheduler);
        this.addService((Service)this.dispatcher);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.logHandler = this.createLogHandler(conf, this.context, this.deletionService);
        this.addIfService(this.logHandler);
        this.dispatcher.register(LogHandlerEventType.class, (EventHandler)this.logHandler);
        SharedCacheUploadService sharedCacheUploader = this.createSharedCacheUploaderService();
        this.addService((Service)sharedCacheUploader);
        this.dispatcher.register(SharedCacheUploadEventType.class, (EventHandler)sharedCacheUploader);
        this.createAMRMProxyService(conf);
        this.waitForContainersOnShutdownMillis = conf.getLong("yarn.nodemanager.sleep-delay-before-sigkill.ms", 250L) + conf.getLong("yarn.nodemanager.process-kill-wait.ms", 5000L) + 1000L;
        this.nmDispatherMetricEnabled = conf.getBoolean("yarn.nodemanager.dispatcher.metric.enable", false);
        super.serviceInit(conf);
        this.recover();
    }

    protected AsyncDispatcher createContainerManagerDispatcher() {
        this.dispatcher = new AsyncDispatcher("NM ContainerManager dispatcher");
        if (!this.nmDispatherMetricEnabled) {
            return this.dispatcher;
        }
        GenericEventTypeMetrics containerEventTypeMetrics = GenericEventTypeMetricsManager.create(this.dispatcher.getName(), ContainerEventType.class);
        this.dispatcher.addMetrics((EventTypeMetrics)containerEventTypeMetrics, containerEventTypeMetrics.getEnumClass());
        GenericEventTypeMetrics localizationEventTypeMetrics = GenericEventTypeMetricsManager.create(this.dispatcher.getName(), LocalizationEventType.class);
        this.dispatcher.addMetrics((EventTypeMetrics)localizationEventTypeMetrics, localizationEventTypeMetrics.getEnumClass());
        GenericEventTypeMetrics applicationEventTypeMetrics = GenericEventTypeMetricsManager.create(this.dispatcher.getName(), ApplicationEventType.class);
        this.dispatcher.addMetrics((EventTypeMetrics)applicationEventTypeMetrics, applicationEventTypeMetrics.getEnumClass());
        GenericEventTypeMetrics containersLauncherEventTypeMetrics = GenericEventTypeMetricsManager.create(this.dispatcher.getName(), ContainersLauncherEventType.class);
        this.dispatcher.addMetrics((EventTypeMetrics)containersLauncherEventTypeMetrics, containersLauncherEventTypeMetrics.getEnumClass());
        GenericEventTypeMetrics containerSchedulerEventTypeMetrics = GenericEventTypeMetricsManager.create(this.dispatcher.getName(), ContainerSchedulerEventType.class);
        this.dispatcher.addMetrics((EventTypeMetrics)containerSchedulerEventTypeMetrics, containerSchedulerEventTypeMetrics.getEnumClass());
        GenericEventTypeMetrics containersMonitorEventTypeMetrics = GenericEventTypeMetricsManager.create(this.dispatcher.getName(), ContainersMonitorEventType.class);
        this.dispatcher.addMetrics((EventTypeMetrics)containersMonitorEventTypeMetrics, containersMonitorEventTypeMetrics.getEnumClass());
        GenericEventTypeMetrics auxServicesEventTypeTypeMetrics = GenericEventTypeMetricsManager.create(this.dispatcher.getName(), AuxServicesEventType.class);
        this.dispatcher.addMetrics((EventTypeMetrics)auxServicesEventTypeTypeMetrics, auxServicesEventTypeTypeMetrics.getEnumClass());
        GenericEventTypeMetrics localizerEventTypeMetrics = GenericEventTypeMetricsManager.create(this.dispatcher.getName(), LocalizerEventType.class);
        this.dispatcher.addMetrics((EventTypeMetrics)localizerEventTypeMetrics, localizerEventTypeMetrics.getEnumClass());
        LOG.info("NM ContainerManager dispatcher Metric Initialization Completed.");
        return this.dispatcher;
    }

    protected void createAMRMProxyService(Configuration conf) {
        boolean bl = this.amrmProxyEnabled = conf.getBoolean("yarn.nodemanager.amrmproxy.enabled", false) || conf.getBoolean("yarn.nodemanager.distributed-scheduling.enabled", false);
        if (this.amrmProxyEnabled) {
            LOG.info("AMRMProxyService is enabled. All the AM->RM requests will be intercepted by the proxy");
            this.setAMRMProxyService(new AMRMProxyService(this.context, this.dispatcher));
            this.addService((Service)this.getAMRMProxyService());
        } else {
            LOG.info("AMRMProxyService is disabled");
        }
    }

    @VisibleForTesting
    protected ContainerScheduler createContainerScheduler(Context cntxt) {
        return new ContainerScheduler(cntxt, this.dispatcher, this.metrics);
    }

    protected ContainersMonitor createContainersMonitor(ContainerExecutor exec) {
        return new ContainersMonitorImpl(exec, this.dispatcher, this.context);
    }

    private void recover() throws IOException, URISyntaxException {
        NMStateStoreService stateStore = this.context.getNMStateStore();
        if (stateStore.canRecover()) {
            this.rsrcLocalizationSrvc.recoverLocalizedResources(stateStore.loadLocalizationState());
            NMStateStoreService.RecoveredApplicationsState appsState = stateStore.loadApplicationsState();
            try (RecoveryIterator<YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto> rasIterator = appsState.getIterator();){
                while (rasIterator.hasNext()) {
                    YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto proto = rasIterator.next();
                    LOG.debug("Recovering application with state: {}", (Object)proto);
                    this.recoverApplication(proto);
                }
            }
            try (RecoveryIterator<NMStateStoreService.RecoveredContainerState> rcsIterator = stateStore.getContainerStateIterator();){
                while (rcsIterator.hasNext()) {
                    NMStateStoreService.RecoveredContainerState rcs = rcsIterator.next();
                    LOG.debug("Recovering container with state: {}", (Object)rcs);
                    this.recoverContainer(rcs);
                }
            }
            if (this.amrmProxyEnabled) {
                this.getAMRMProxyService().recover();
            }
            this.dispatcher.getEventHandler().handle((Event)new ContainerSchedulerEvent(null, ContainerSchedulerEventType.RECOVERY_COMPLETED));
        } else {
            LOG.info("Not a recoverable state store. Nothing to recover.");
        }
    }

    private void recoverApplication(YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto p) throws IOException {
        ApplicationIdPBImpl appId = new ApplicationIdPBImpl(p.getId());
        Credentials creds = new Credentials();
        creds.readTokenStorageStream(new DataInputStream(p.getCredentials().newInput()));
        List<YarnProtos.ApplicationACLMapProto> aclProtoList = p.getAclsList();
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>(aclProtoList.size());
        for (YarnProtos.ApplicationACLMapProto aclProto : aclProtoList) {
            acls.put(ProtoUtils.convertFromProtoFormat((YarnProtos.ApplicationAccessTypeProto)aclProto.getAccessType()), aclProto.getAcl());
        }
        LogAggregationContextPBImpl logAggregationContext = null;
        if (p.getLogAggregationContext() != null) {
            logAggregationContext = new LogAggregationContextPBImpl(p.getLogAggregationContext());
        }
        ApplicationImpl.FlowContext fc = null;
        if (p.getFlowContext() != null) {
            YarnServerNodemanagerRecoveryProtos.FlowContextProto fcp = p.getFlowContext();
            fc = new ApplicationImpl.FlowContext(fcp.getFlowName(), fcp.getFlowVersion(), fcp.getFlowRunId());
            LOG.debug("Recovering Flow context: {} for an application {}", (Object)fc, (Object)appId);
        } else {
            fc = new ApplicationImpl.FlowContext(TimelineUtils.generateDefaultFlowName(null, (ApplicationId)appId), "1", appId.getClusterTimestamp());
            LOG.debug("No prior existing flow context found. Using default Flow context: {} for an application {}", (Object)fc, (Object)appId);
        }
        LOG.info("Recovering application " + appId);
        ApplicationImpl app = new ApplicationImpl((Dispatcher)this.dispatcher, p.getUser(), fc, (ApplicationId)appId, creds, this.context, p.getAppLogAggregationInitedTime());
        this.context.getApplications().put((ApplicationId)appId, app);
        this.metrics.runningApplication();
        app.handle(new ApplicationInitEvent((ApplicationId)appId, acls, (LogAggregationContext)logAggregationContext));
    }

    private void recoverContainer(NMStateStoreService.RecoveredContainerState rcs) throws IOException {
        ContainerTokenIdentifier token;
        StartContainerRequest req = rcs.getStartRequest();
        ContainerLaunchContext launchContext = req.getContainerLaunchContext();
        if (rcs.getCapability() != null) {
            ContainerTokenIdentifier originalToken = BuilderUtils.newContainerTokenIdentifier(req.getContainerToken());
            token = new ContainerTokenIdentifier(originalToken.getContainerID(), originalToken.getVersion(), originalToken.getNmHostAddress(), originalToken.getApplicationSubmitter(), rcs.getCapability(), originalToken.getExpiryTimeStamp(), originalToken.getMasterKeyId(), originalToken.getRMIdentifier(), originalToken.getPriority(), originalToken.getCreationTime(), originalToken.getLogAggregationContext(), originalToken.getNodeLabelExpression(), originalToken.getContainerType(), originalToken.getExecutionType(), originalToken.getAllocationRequestId(), originalToken.getAllcationTags());
        } else {
            token = BuilderUtils.newContainerTokenIdentifier(req.getContainerToken());
        }
        ContainerId containerId = token.getContainerID();
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        LOG.info("Recovering " + containerId + " in state " + (Object)((Object)rcs.getStatus()) + " with exit code " + rcs.getExitCode());
        Application app = (Application)this.context.getApplications().get(appId);
        if (app != null) {
            this.recoverActiveContainer(app, launchContext, token, rcs);
            if (rcs.getRecoveryType() == NMStateStoreService.RecoveredContainerType.KILL) {
                this.dispatcher.getEventHandler().handle((Event)new ContainerKillEvent(containerId, -100, "Due to invalid StateStore info container was killed during recovery"));
            }
        } else {
            if (rcs.getStatus() != NMStateStoreService.RecoveredContainerStatus.COMPLETED) {
                LOG.warn(containerId + " has no corresponding application!");
            }
            LOG.info("Adding " + containerId + " to recently stopped containers");
            this.nodeStatusUpdater.addCompletedContainer(containerId);
        }
    }

    protected void recoverActiveContainer(Application app, ContainerLaunchContext launchContext, ContainerTokenIdentifier token, NMStateStoreService.RecoveredContainerState rcs) throws IOException {
        Credentials credentials = YarnServerSecurityUtils.parseCredentials(launchContext);
        ContainerImpl container = new ContainerImpl(this.getConfig(), (Dispatcher)this.dispatcher, launchContext, credentials, this.metrics, token, this.context, rcs);
        this.context.getContainers().put(token.getContainerID(), container);
        this.containerScheduler.recoverActiveContainer(container, rcs);
        app.handle((Event)new ApplicationContainerInitEvent(container));
    }

    private void waitForRecoveredContainers() throws InterruptedException {
        int sleepMsec = 100;
        int waitIterations = 100;
        ArrayList<ContainerId> newContainers = new ArrayList<ContainerId>();
        while (--waitIterations >= 0) {
            newContainers.clear();
            for (Container container : this.context.getContainers().values()) {
                if (container.getContainerState() != ContainerState.NEW) continue;
                newContainers.add(container.getContainerId());
            }
            if (newContainers.isEmpty()) break;
            LOG.info("Waiting for containers: " + newContainers);
            Thread.sleep(100L);
        }
        if (waitIterations < 0) {
            LOG.warn("Timeout waiting for recovered containers");
        }
    }

    protected LogHandler createLogHandler(Configuration conf, Context context, DeletionService deletionService) {
        if (conf.getBoolean("yarn.log-aggregation-enable", false) || YarnConfiguration.isNodeLocalAggregationEnabled((Configuration)conf)) {
            return new LogAggregationService((Dispatcher)this.dispatcher, context, deletionService, this.dirsHandler);
        }
        return new NonAggregatingLogHandler((Dispatcher)this.dispatcher, deletionService, this.dirsHandler, context.getNMStateStore());
    }

    @Override
    public ContainersMonitor getContainersMonitor() {
        return this.containersMonitor;
    }

    protected ResourceLocalizationService createResourceLocalizationService(ContainerExecutor exec, DeletionService deletionContext, Context nmContext, NodeManagerMetrics nmMetrics) {
        return new ResourceLocalizationService((Dispatcher)this.dispatcher, exec, deletionContext, this.dirsHandler, nmContext, nmMetrics);
    }

    protected SharedCacheUploadService createSharedCacheUploaderService() {
        return new SharedCacheUploadService();
    }

    @VisibleForTesting
    protected NMTimelinePublisher createNMTimelinePublisher(Context ctxt) {
        NMTimelinePublisher nmTimelinePublisherLocal = new NMTimelinePublisher(ctxt);
        this.addIfService((Object)nmTimelinePublisherLocal);
        return nmTimelinePublisherLocal;
    }

    protected AbstractContainersLauncher createContainersLauncher(Context ctxt, ContainerExecutor exec) {
        AbstractContainersLauncher launcher;
        Class containersLauncherClass = ctxt.getConf().getClass("yarn.nodemanager.containers-launcher.class", ContainersLauncher.class, AbstractContainersLauncher.class);
        try {
            launcher = (AbstractContainersLauncher)ReflectionUtils.newInstance((Class)containersLauncherClass, (Configuration)ctxt.getConf());
            launcher.init(ctxt, (Dispatcher)this.dispatcher, exec, this.dirsHandler, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return launcher;
    }

    protected EventHandler<ApplicationEvent> createApplicationEventDispatcher() {
        return new ApplicationEventDispatcher();
    }

    protected void serviceStart() throws Exception {
        InetSocketAddress connectAddress;
        boolean usingEphemeralPort;
        Configuration conf = this.getConfig();
        InetSocketAddress initialAddress = conf.getSocketAddr("yarn.nodemanager.bind-host", "yarn.nodemanager.address", "0.0.0.0:8099", 8099);
        boolean bl = usingEphemeralPort = initialAddress.getPort() == 0;
        if (this.context.getNMStateStore().canRecover() && usingEphemeralPort) {
            throw new IllegalArgumentException("Cannot support recovery with an ephemeral server port. Check the setting of yarn.nodemanager.address");
        }
        boolean delayedRpcServerStart = this.context.getNMStateStore().canRecover();
        Configuration serverConf = new Configuration(conf);
        serverConf.set("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.TOKEN.toString());
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = rpc.getServer(ContainerManagementProtocol.class, (Object)this, initialAddress, serverConf, (SecretManager)this.context.getNMTokenSecretManager(), conf.getInt("yarn.nodemanager.container-manager.thread-count", 20));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, NMPolicyProvider.getInstance());
        }
        String bindHost = conf.get("yarn.nodemanager.bind-host");
        String nmAddress = conf.getTrimmed("yarn.nodemanager.address");
        String hostOverride = null;
        if (bindHost != null && !bindHost.isEmpty() && nmAddress != null && !nmAddress.isEmpty()) {
            hostOverride = nmAddress.split(":")[0];
        }
        if (delayedRpcServerStart) {
            connectAddress = NetUtils.getConnectAddress((InetSocketAddress)initialAddress);
        } else {
            this.server.start();
            connectAddress = NetUtils.getConnectAddress((Server)this.server);
        }
        NodeId nodeId = this.buildNodeId(connectAddress, hostOverride);
        ((NodeManager.NMContext)this.context).setNodeId(nodeId);
        this.context.getNMTokenSecretManager().setNodeId(nodeId);
        this.context.getContainerTokenSecretManager().setNodeId(nodeId);
        super.serviceStart();
        if (delayedRpcServerStart) {
            this.waitForRecoveredContainers();
            this.server.start();
            connectAddress = NetUtils.getConnectAddress((Server)this.server);
            NodeId serverNode = this.buildNodeId(connectAddress, hostOverride);
            if (!serverNode.equals((Object)nodeId)) {
                throw new IOException("Node mismatch after server started, expected '" + nodeId + "' but found '" + serverNode + "'");
            }
        }
        LOG.info("ContainerManager started at " + connectAddress);
        LOG.info("ContainerManager bound to " + initialAddress);
    }

    private NodeId buildNodeId(InetSocketAddress connectAddress, String hostOverride) {
        if (hostOverride != null) {
            connectAddress = NetUtils.getConnectAddress((InetSocketAddress)new InetSocketAddress(hostOverride, connectAddress.getPort()));
        }
        return NodeId.newInstance((String)connectAddress.getAddress().getCanonicalHostName(), (int)connectAddress.getPort());
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    public void serviceStop() throws Exception {
        this.writeLock.lock();
        try {
            this.serviceStopped = true;
            if (this.context != null) {
                this.cleanUpApplicationsOnNMShutDown();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.auxiliaryServices.getServiceState() == Service.STATE.STARTED) {
            this.auxiliaryServices.unregisterServiceListener(this);
        }
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    public void cleanUpApplicationsOnNMShutDown() {
        ConcurrentMap<ApplicationId, Application> applications = this.context.getApplications();
        if (applications.isEmpty()) {
            return;
        }
        LOG.info("Applications still running : " + applications.keySet());
        if (this.context.getNMStateStore().canRecover() && !this.context.getDecommissioned() && this.getConfig().getBoolean("yarn.nodemanager.recovery.supervised", false)) {
            return;
        }
        ArrayList<ApplicationId> appIds = new ArrayList<ApplicationId>(applications.keySet());
        this.handle(new CMgrCompletedAppsEvent(appIds, CMgrCompletedAppsEvent.Reason.ON_SHUTDOWN));
        LOG.info("Waiting for Applications to be Finished");
        long waitStartTime = System.currentTimeMillis();
        while (!applications.isEmpty() && System.currentTimeMillis() - waitStartTime < this.waitForContainersOnShutdownMillis) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                LOG.warn("Interrupted while sleeping on applications finish on shutdown", (Throwable)ex);
            }
        }
        if (applications.isEmpty()) {
            LOG.info("All applications in FINISHED state");
        } else {
            LOG.info("Done waiting for Applications to be Finished. Still alive: " + applications.keySet());
        }
    }

    public void cleanupContainersOnNMResync() {
        ConcurrentMap<ContainerId, Container> containers = this.context.getContainers();
        if (containers.isEmpty()) {
            return;
        }
        LOG.info("Containers still running on " + (Object)((Object)CMgrCompletedContainersEvent.Reason.ON_NODEMANAGER_RESYNC) + " : " + containers.keySet());
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>(containers.keySet());
        LOG.info("Waiting for containers to be killed");
        this.handle(new CMgrCompletedContainersEvent(containerIds, CMgrCompletedContainersEvent.Reason.ON_NODEMANAGER_RESYNC));
        boolean allContainersCompleted = false;
        block2: while (!containers.isEmpty() && !allContainersCompleted) {
            allContainersCompleted = true;
            for (Map.Entry container : containers.entrySet()) {
                if (((ContainerImpl)container.getValue()).getCurrentState() == org.apache.hadoop.yarn.api.records.ContainerState.COMPLETE) continue;
                allContainersCompleted = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    LOG.warn("Interrupted while sleeping on container kill on resync", (Throwable)ex);
                }
                continue block2;
            }
        }
        if (allContainersCompleted) {
            LOG.info("All containers in DONE state");
        } else {
            LOG.info("Done waiting for containers to be killed. Still alive: " + containers.keySet());
        }
    }

    protected UserGroupInformation getRemoteUgi() throws YarnException {
        UserGroupInformation remoteUgi;
        try {
            remoteUgi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            String msg = "Cannot obtain the user-name. Got exception: " + StringUtils.stringifyException((Throwable)e);
            LOG.warn(msg);
            throw RPCUtil.getRemoteException((String)msg);
        }
        return remoteUgi;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected NMTokenIdentifier selectNMTokenIdentifier(UserGroupInformation remoteUgi) {
        Set tokenIdentifiers = remoteUgi.getTokenIdentifiers();
        NMTokenIdentifier resultId = null;
        for (TokenIdentifier id : tokenIdentifiers) {
            if (!(id instanceof NMTokenIdentifier)) continue;
            resultId = (NMTokenIdentifier)id;
            break;
        }
        return resultId;
    }

    protected void authorizeUser(UserGroupInformation remoteUgi, NMTokenIdentifier nmTokenIdentifier) throws YarnException {
        if (nmTokenIdentifier == null) {
            throw RPCUtil.getRemoteException((String)INVALID_NMTOKEN_MSG);
        }
        if (!remoteUgi.getUserName().equals(nmTokenIdentifier.getApplicationAttemptId().toString())) {
            throw RPCUtil.getRemoteException((String)("Expected applicationAttemptId: " + remoteUgi.getUserName() + "Found: " + nmTokenIdentifier.getApplicationAttemptId()));
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void authorizeStartAndResourceIncreaseRequest(NMTokenIdentifier nmTokenIdentifier, ContainerTokenIdentifier containerTokenIdentifier, boolean startRequest) throws YarnException {
        if (nmTokenIdentifier == null) {
            throw RPCUtil.getRemoteException((String)INVALID_NMTOKEN_MSG);
        }
        if (containerTokenIdentifier == null) {
            throw RPCUtil.getRemoteException((String)INVALID_CONTAINERTOKEN_MSG);
        }
        ContainerId containerId = containerTokenIdentifier.getContainerID();
        String containerIDStr = containerId.toString();
        boolean unauthorized = false;
        StringBuilder messageBuilder = new StringBuilder("Unauthorized request to " + (startRequest ? "start container." : "increase container resource."));
        if (!nmTokenIdentifier.getApplicationAttemptId().getApplicationId().equals((Object)containerId.getApplicationAttemptId().getApplicationId())) {
            unauthorized = true;
            messageBuilder.append("\nNMToken for application attempt : ").append(nmTokenIdentifier.getApplicationAttemptId()).append(" was used for " + (startRequest ? "starting " : "increasing resource of ") + "container with container token").append(" issued for application attempt : ").append(containerId.getApplicationAttemptId());
        } else if (startRequest && !this.context.getContainerTokenSecretManager().isValidStartContainerRequest(containerTokenIdentifier)) {
            unauthorized = true;
            messageBuilder.append("\n Attempt to relaunch the same ").append("container with id ").append(containerIDStr).append(".");
        } else if (containerTokenIdentifier.getExpiryTimeStamp() < System.currentTimeMillis()) {
            unauthorized = true;
            messageBuilder.append("\nThis token is expired. current time is ").append(System.currentTimeMillis()).append(" found ").append(containerTokenIdentifier.getExpiryTimeStamp());
            messageBuilder.append("\nNote: System times on machines may be out of sync.").append(" Check system time and time zones.");
        }
        if (unauthorized) {
            String msg = messageBuilder.toString();
            LOG.error(msg);
            throw RPCUtil.getRemoteException((String)msg);
        }
        if (containerTokenIdentifier.getRMIdentifier() != this.nodeStatusUpdater.getRMIdentifier()) {
            StringBuilder sb = new StringBuilder("\nContainer ");
            sb.append(containerTokenIdentifier.getContainerID().toString()).append(" rejected as it is allocated by a previous RM");
            throw new InvalidContainerException(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StartContainersResponse startContainers(StartContainersRequest requests) throws YarnException, IOException {
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        String remoteUser = remoteUgi.getUserName();
        NMTokenIdentifier nmTokenIdentifier = this.selectNMTokenIdentifier(remoteUgi);
        this.authorizeUser(remoteUgi, nmTokenIdentifier);
        ArrayList<ContainerId> succeededContainers = new ArrayList<ContainerId>();
        HashMap<ContainerId, SerializedException> failedContainers = new HashMap<ContainerId, SerializedException>();
        Context context = this.context;
        synchronized (context) {
            ContainerId anyContainerid = null;
            for (StartContainerRequest request : requests.getStartContainerRequests()) {
                ContainerId containerId = null;
                try {
                    if (request.getContainerToken() == null || request.getContainerToken().getIdentifier() == null) {
                        throw new IOException(INVALID_CONTAINERTOKEN_MSG);
                    }
                    ContainerTokenIdentifier containerTokenIdentifier = BuilderUtils.newContainerTokenIdentifier(request.getContainerToken());
                    this.verifyAndGetContainerTokenIdentifier(request.getContainerToken(), containerTokenIdentifier);
                    anyContainerid = containerId = containerTokenIdentifier.getContainerID();
                    if (this.amrmProxyEnabled && containerTokenIdentifier.getContainerType().equals((Object)ContainerType.APPLICATION_MASTER)) {
                        this.getAMRMProxyService().processApplicationStartRequest(request);
                    }
                    this.performContainerPreStartChecks(nmTokenIdentifier, request, containerTokenIdentifier);
                    this.startContainerInternal(containerTokenIdentifier, request, remoteUser);
                    succeededContainers.add(containerId);
                }
                catch (YarnException e) {
                    failedContainers.put(containerId, SerializedException.newInstance((Throwable)e));
                }
                catch (SecretManager.InvalidToken ie) {
                    failedContainers.put(containerId, SerializedException.newInstance((Throwable)ie));
                    throw ie;
                }
                catch (IOException e) {
                    throw RPCUtil.getRemoteException((Throwable)e);
                }
            }
            return StartContainersResponse.newInstance(this.getAuxServiceMetaData(anyContainerid), succeededContainers, failedContainers);
        }
    }

    private void performContainerPreStartChecks(NMTokenIdentifier nmTokenIdentifier, StartContainerRequest request, ContainerTokenIdentifier containerTokenIdentifier) throws YarnException, SecretManager.InvalidToken {
        this.authorizeStartAndResourceIncreaseRequest(nmTokenIdentifier, containerTokenIdentifier, true);
        this.updateNMTokenIdentifier(nmTokenIdentifier);
        ContainerLaunchContext launchContext = request.getContainerLaunchContext();
        Map<String, ByteBuffer> serviceData = this.getAuxServiceMetaData();
        if (launchContext.getServiceData() != null && !launchContext.getServiceData().isEmpty()) {
            for (Map.Entry meta : launchContext.getServiceData().entrySet()) {
                if (null != serviceData.get(meta.getKey())) continue;
                throw new InvalidAuxServiceException("The auxService:" + (String)meta.getKey() + " does not exist");
            }
        }
    }

    private YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto buildAppProto(ApplicationId appId, String user, Credentials credentials, Map<ApplicationAccessType, String> appAcls, LogAggregationContext logAggregationContext, ApplicationImpl.FlowContext flowContext) {
        YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto.Builder builder = YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto.newBuilder();
        builder.setId(((ApplicationIdPBImpl)appId).getProto());
        builder.setUser(user);
        if (logAggregationContext != null) {
            builder.setLogAggregationContext(((LogAggregationContextPBImpl)logAggregationContext).getProto());
        }
        builder.clearCredentials();
        if (credentials != null) {
            DataOutputBuffer dob = new DataOutputBuffer();
            try {
                credentials.writeTokenStorageToStream((DataOutputStream)dob);
                builder.setCredentials(ByteString.copyFrom((byte[])dob.getData()));
            }
            catch (IOException iOException) {
                LOG.error("Cannot serialize credentials", (Throwable)iOException);
            }
        }
        builder.clearAcls();
        if (appAcls != null) {
            for (Map.Entry entry : appAcls.entrySet()) {
                YarnProtos.ApplicationACLMapProto p = YarnProtos.ApplicationACLMapProto.newBuilder().setAccessType(ProtoUtils.convertToProtoFormat((ApplicationAccessType)((ApplicationAccessType)entry.getKey()))).setAcl((String)entry.getValue()).build();
                builder.addAcls(p);
            }
        }
        builder.clearFlowContext();
        if (flowContext != null && flowContext.getFlowName() != null && flowContext.getFlowVersion() != null) {
            YarnServerNodemanagerRecoveryProtos.FlowContextProto fcp = YarnServerNodemanagerRecoveryProtos.FlowContextProto.newBuilder().setFlowName(flowContext.getFlowName()).setFlowVersion(flowContext.getFlowVersion()).setFlowRunId(flowContext.getFlowRunId()).build();
            builder.setFlowContext(fcp);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startContainerInternal(ContainerTokenIdentifier containerTokenIdentifier, StartContainerRequest request, String remoteUser) throws YarnException, IOException {
        block14: {
            ContainerId containerId = containerTokenIdentifier.getContainerID();
            String containerIdStr = containerId.toString();
            String user = containerTokenIdentifier.getApplicationSubmitter();
            Resource containerResource = containerTokenIdentifier.getResource();
            LOG.info("Start request for " + containerIdStr + " by user " + remoteUser + " with resource " + containerResource);
            ContainerLaunchContext launchContext = request.getContainerLaunchContext();
            for (Map.Entry rsrc : launchContext.getLocalResources().entrySet()) {
                if (rsrc.getValue() == null || ((LocalResource)rsrc.getValue()).getResource() == null) {
                    throw new YarnException("Null resource URL for local resource " + (String)rsrc.getKey() + " : " + rsrc.getValue());
                }
                if (((LocalResource)rsrc.getValue()).getType() == null) {
                    throw new YarnException("Null resource type for local resource " + (String)rsrc.getKey() + " : " + rsrc.getValue());
                }
                if (((LocalResource)rsrc.getValue()).getVisibility() != null) continue;
                throw new YarnException("Null resource visibility for local resource " + (String)rsrc.getKey() + " : " + rsrc.getValue());
            }
            Credentials credentials = YarnServerSecurityUtils.parseCredentials(launchContext);
            long containerStartTime = SystemClock.getInstance().getTime();
            ContainerImpl container = new ContainerImpl(this.getConfig(), (Dispatcher)this.dispatcher, launchContext, credentials, this.metrics, containerTokenIdentifier, this.context, containerStartTime);
            ApplicationId applicationID = containerId.getApplicationAttemptId().getApplicationId();
            if (this.context.getContainers().putIfAbsent(containerId, container) != null) {
                NMAuditLogger.logFailure(remoteUser, "Start Container Request", "ContainerManagerImpl", "Container already running on this node!", applicationID, containerId);
                throw RPCUtil.getRemoteException((String)("Container " + containerIdStr + " already is running on this node!!"));
            }
            this.readLock.lock();
            try {
                if (!this.isServiceStopped()) {
                    if (!this.context.getApplications().containsKey(applicationID)) {
                        ApplicationImpl.FlowContext flowContext = this.getFlowContext(launchContext, applicationID);
                        ApplicationImpl application = new ApplicationImpl((Dispatcher)this.dispatcher, user, flowContext, applicationID, credentials, this.context);
                        if (this.context.getApplications().putIfAbsent(applicationID, application) == null) {
                            this.metrics.runningApplication();
                            LOG.info("Creating a new application reference for app " + applicationID);
                            LogAggregationContext logAggregationContext = containerTokenIdentifier.getLogAggregationContext();
                            Map appAcls = container.getLaunchContext().getApplicationACLs();
                            this.context.getNMStateStore().storeApplication(applicationID, this.buildAppProto(applicationID, user, credentials, appAcls, logAggregationContext, flowContext));
                            this.dispatcher.getEventHandler().handle((Event)new ApplicationInitEvent(applicationID, appAcls, logAggregationContext));
                        }
                    } else if (containerTokenIdentifier.getContainerType() == ContainerType.APPLICATION_MASTER) {
                        ApplicationImpl.FlowContext flowContext = this.getFlowContext(launchContext, applicationID);
                        if (flowContext != null) {
                            ApplicationImpl application = (ApplicationImpl)this.context.getApplications().get(applicationID);
                            application.setFlowContext(flowContext);
                            this.context.getNMStateStore().storeApplication(applicationID, this.buildAppProto(applicationID, user, credentials, container.getLaunchContext().getApplicationACLs(), containerTokenIdentifier.getLogAggregationContext(), flowContext));
                            LOG.info("Updated application reference with flowContext " + flowContext + " for app " + applicationID);
                        } else {
                            LOG.info("TimelineService V2.0 is not enabled. Skipping updating flowContext for application " + applicationID);
                        }
                    }
                    this.context.getNMStateStore().storeContainer(containerId, containerTokenIdentifier.getVersion(), containerStartTime, request);
                    this.dispatcher.getEventHandler().handle((Event)new ApplicationContainerInitEvent(container));
                    this.context.getContainerTokenSecretManager().startContainerSuccessful(containerTokenIdentifier);
                    NMAuditLogger.logSuccess(remoteUser, "Start Container Request", "ContainerManageImpl", applicationID, containerId);
                    this.metrics.launchedContainer();
                    this.metrics.allocateContainer(containerTokenIdentifier.getResource());
                    break block14;
                }
                throw new YarnException("Container start failed as the NodeManager is in the process of shutting down");
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    private ApplicationImpl.FlowContext getFlowContext(ContainerLaunchContext launchContext, ApplicationId applicationID) {
        ApplicationImpl.FlowContext flowContext = null;
        if (this.timelineServiceV2Enabled) {
            String flowName = (String)launchContext.getEnvironment().get("TIMELINE_FLOW_NAME_TAG");
            String flowVersion = (String)launchContext.getEnvironment().get("TIMELINE_FLOW_VERSION_TAG");
            String flowRunIdStr = (String)launchContext.getEnvironment().get("TIMELINE_FLOW_RUN_ID_TAG");
            long flowRunId = 0L;
            if (flowRunIdStr != null && !flowRunIdStr.isEmpty()) {
                flowRunId = Long.parseLong(flowRunIdStr);
            }
            flowContext = new ApplicationImpl.FlowContext(flowName, flowVersion, flowRunId);
            LOG.debug("Flow context: {} created for an application {}", (Object)flowContext, (Object)applicationID);
        }
        return flowContext;
    }

    protected ContainerTokenIdentifier verifyAndGetContainerTokenIdentifier(Token token, ContainerTokenIdentifier containerTokenIdentifier) throws YarnException, SecretManager.InvalidToken {
        byte[] password = this.context.getContainerTokenSecretManager().retrievePassword(containerTokenIdentifier);
        byte[] tokenPass = token.getPassword().array();
        if (password == null || tokenPass == null || !MessageDigest.isEqual(password, tokenPass)) {
            throw new SecretManager.InvalidToken("Invalid container token used for starting container on : " + this.context.getNodeId().toString());
        }
        return containerTokenIdentifier;
    }

    @Deprecated
    public IncreaseContainersResourceResponse increaseContainersResource(IncreaseContainersResourceRequest requests) throws YarnException, IOException {
        ContainerUpdateResponse resp = this.updateContainer(ContainerUpdateRequest.newInstance((List)requests.getContainersToIncrease()));
        return IncreaseContainersResourceResponse.newInstance((List)resp.getSuccessfullyUpdatedContainers(), (Map)resp.getFailedRequests());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerUpdateResponse updateContainer(ContainerUpdateRequest request) throws YarnException, IOException {
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        NMTokenIdentifier nmTokenIdentifier = this.selectNMTokenIdentifier(remoteUgi);
        this.authorizeUser(remoteUgi, nmTokenIdentifier);
        ArrayList<ContainerId> successfullyUpdatedContainers = new ArrayList<ContainerId>();
        HashMap<ContainerId, SerializedException> failedContainers = new HashMap<ContainerId, SerializedException>();
        Context context = this.context;
        synchronized (context) {
            for (Token token : request.getContainersToUpdate()) {
                ContainerId containerId = null;
                try {
                    if (token.getIdentifier() == null) {
                        throw new IOException(INVALID_CONTAINERTOKEN_MSG);
                    }
                    ContainerTokenIdentifier containerTokenIdentifier = BuilderUtils.newContainerTokenIdentifier(token);
                    this.verifyAndGetContainerTokenIdentifier(token, containerTokenIdentifier);
                    this.authorizeStartAndResourceIncreaseRequest(nmTokenIdentifier, containerTokenIdentifier, false);
                    containerId = containerTokenIdentifier.getContainerID();
                    this.updateNMTokenIdentifier(nmTokenIdentifier);
                    this.updateContainerInternal(containerId, containerTokenIdentifier);
                    successfullyUpdatedContainers.add(containerId);
                }
                catch (SecretManager.InvalidToken | YarnException e) {
                    failedContainers.put(containerId, SerializedException.newInstance((Throwable)e));
                }
                catch (IOException e) {
                    throw RPCUtil.getRemoteException((Throwable)e);
                }
            }
        }
        return ContainerUpdateResponse.newInstance(successfullyUpdatedContainers, failedContainers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateContainerInternal(ContainerId containerId, ContainerTokenIdentifier containerTokenIdentifier) throws YarnException, IOException {
        block13: {
            Container container = (Container)this.context.getContainers().get(containerId);
            if (container == null) {
                if (this.nodeStatusUpdater.isContainerRecentlyStopped(containerId)) {
                    throw RPCUtil.getRemoteException((String)("Container " + containerId.toString() + " was recently stopped on node manager."));
                }
                throw RPCUtil.getRemoteException((String)("Container " + containerId.toString() + " is not handled by this NodeManager"));
            }
            int currentVersion = container.getContainerTokenIdentifier().getVersion();
            if (containerTokenIdentifier.getVersion() <= currentVersion) {
                throw RPCUtil.getRemoteException((String)("Container " + containerId.toString() + " has update version [" + currentVersion + "] >= requested version [" + containerTokenIdentifier.getVersion() + "]"));
            }
            Resource currentResource = container.getResource();
            ExecutionType currentExecType = container.getContainerTokenIdentifier().getExecutionType();
            boolean isResourceChange = false;
            boolean isExecTypeUpdate = false;
            Resource targetResource = containerTokenIdentifier.getResource();
            ExecutionType targetExecType = containerTokenIdentifier.getExecutionType();
            boolean isIncrease = false;
            if (!currentResource.equals((Object)targetResource)) {
                isResourceChange = true;
                isIncrease = Resources.fitsIn((Resource)currentResource, (Resource)targetResource) && !Resources.fitsIn((Resource)targetResource, (Resource)currentResource);
            } else if (!currentExecType.equals((Object)targetExecType)) {
                isExecTypeUpdate = true;
                boolean bl = isIncrease = currentExecType == ExecutionType.OPPORTUNISTIC && targetExecType == ExecutionType.GUARANTEED;
            }
            if (isIncrease) {
                org.apache.hadoop.yarn.api.records.Container increasedContainer = null;
                if (isResourceChange) {
                    increasedContainer = org.apache.hadoop.yarn.api.records.Container.newInstance((ContainerId)containerId, null, null, (Resource)targetResource, null, null, (ExecutionType)currentExecType);
                    if (this.context.getIncreasedContainers().putIfAbsent(containerId, increasedContainer) != null) {
                        throw RPCUtil.getRemoteException((String)("Container " + containerId.toString() + " resource is being increased -or- is undergoing ExecutionType promoted."));
                    }
                }
            }
            this.readLock.lock();
            try {
                if (!this.serviceStopped) {
                    this.dispatcher.getEventHandler().handle((Event)new UpdateContainerTokenEvent(container.getContainerId(), containerTokenIdentifier, isResourceChange, isExecTypeUpdate, isIncrease));
                    break block13;
                }
                throw new YarnException("Unable to change container resource as the NodeManager is in the process of shutting down");
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void updateNMTokenIdentifier(NMTokenIdentifier nmTokenIdentifier) throws SecretManager.InvalidToken {
        this.context.getNMTokenSecretManager().appAttemptStartContainer(nmTokenIdentifier);
    }

    public StopContainersResponse stopContainers(StopContainersRequest requests) throws YarnException, IOException {
        ArrayList<ContainerId> succeededRequests = new ArrayList<ContainerId>();
        HashMap<ContainerId, SerializedException> failedRequests = new HashMap<ContainerId, SerializedException>();
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        NMTokenIdentifier identifier = this.selectNMTokenIdentifier(remoteUgi);
        if (identifier == null) {
            throw RPCUtil.getRemoteException((String)INVALID_NMTOKEN_MSG);
        }
        String remoteUser = remoteUgi.getUserName();
        for (ContainerId id : requests.getContainerIds()) {
            try {
                Container container = (Container)this.context.getContainers().get(id);
                this.authorizeGetAndStopContainerRequest(id, container, true, identifier, remoteUser);
                this.stopContainerInternal(id, remoteUser);
                succeededRequests.add(id);
            }
            catch (YarnException e) {
                failedRequests.put(id, SerializedException.newInstance((Throwable)e));
            }
        }
        return StopContainersResponse.newInstance(succeededRequests, failedRequests);
    }

    protected void stopContainerInternal(ContainerId containerID, String remoteUser) throws YarnException, IOException {
        String containerIDStr = containerID.toString();
        Container container = (Container)this.context.getContainers().get(containerID);
        LOG.info("Stopping container with container Id: " + containerIDStr);
        if (container == null) {
            if (!this.nodeStatusUpdater.isContainerRecentlyStopped(containerID)) {
                throw RPCUtil.getRemoteException((String)("Container " + containerIDStr + " is not handled by this NodeManager"));
            }
        } else {
            if (container.isRecovering()) {
                throw new NMNotYetReadyException("Container " + containerIDStr + " is recovering, try later");
            }
            this.context.getNMStateStore().storeContainerKilled(containerID);
            container.sendKillEvent(-105, "Container killed by the ApplicationMaster.");
            NMAuditLogger.logSuccess(remoteUser, "Stop Container Request", "ContainerManageImpl", containerID.getApplicationAttemptId().getApplicationId(), containerID);
        }
    }

    public GetContainerStatusesResponse getContainerStatuses(GetContainerStatusesRequest request) throws YarnException, IOException {
        ArrayList<ContainerStatus> succeededRequests = new ArrayList<ContainerStatus>();
        HashMap<ContainerId, SerializedException> failedRequests = new HashMap<ContainerId, SerializedException>();
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        NMTokenIdentifier identifier = this.selectNMTokenIdentifier(remoteUgi);
        if (identifier == null) {
            throw RPCUtil.getRemoteException((String)INVALID_NMTOKEN_MSG);
        }
        String remoteUser = remoteUgi.getUserName();
        for (ContainerId id : request.getContainerIds()) {
            try {
                ContainerStatus status = this.getContainerStatusInternal(id, identifier, remoteUser);
                succeededRequests.add(status);
            }
            catch (YarnException e) {
                failedRequests.put(id, SerializedException.newInstance((Throwable)e));
            }
        }
        return GetContainerStatusesResponse.newInstance(succeededRequests, failedRequests);
    }

    protected ContainerStatus getContainerStatusInternal(ContainerId containerID, NMTokenIdentifier nmTokenIdentifier, String remoteUser) throws YarnException {
        String containerIDStr = containerID.toString();
        Container container = (Container)this.context.getContainers().get(containerID);
        LOG.info("Getting container-status for " + containerIDStr);
        this.authorizeGetAndStopContainerRequest(containerID, container, false, nmTokenIdentifier, remoteUser);
        if (container == null) {
            if (this.nodeStatusUpdater.isContainerRecentlyStopped(containerID)) {
                throw RPCUtil.getRemoteException((String)("Container " + containerIDStr + " was recently stopped on node manager."));
            }
            throw RPCUtil.getRemoteException((String)("Container " + containerIDStr + " is not handled by this NodeManager"));
        }
        ContainerStatus containerStatus = container.cloneAndGetContainerStatus();
        this.logContainerStatus("Returning ", containerStatus);
        return containerStatus;
    }

    private void logContainerStatus(String prefix, ContainerStatus status) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append("ContainerStatus: [");
        sb.append("ContainerId: ");
        sb.append(status.getContainerId()).append(", ");
        sb.append("ExecutionType: ");
        sb.append(status.getExecutionType()).append(", ");
        sb.append("State: ");
        sb.append(status.getState()).append(", ");
        sb.append("Capability: ");
        sb.append(status.getCapability()).append(", ");
        sb.append("Diagnostics: ");
        sb.append(LOG.isDebugEnabled() ? status.getDiagnostics() : "...");
        sb.append(", ");
        sb.append("ExitStatus: ");
        sb.append(status.getExitStatus()).append(", ");
        sb.append("IP: ");
        sb.append(status.getIPs()).append(", ");
        sb.append("Host: ");
        sb.append(status.getHost()).append(", ");
        sb.append("ExposedPorts: ");
        sb.append(status.getExposedPorts()).append(", ");
        sb.append("ContainerSubState: ");
        sb.append(status.getContainerSubState());
        sb.append("]");
        LOG.info(sb.toString());
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void authorizeGetAndStopContainerRequest(ContainerId containerId, Container container, boolean stopRequest, NMTokenIdentifier identifier, String remoteUser) throws YarnException {
        if (identifier == null) {
            throw RPCUtil.getRemoteException((String)INVALID_NMTOKEN_MSG);
        }
        ApplicationId nmTokenAppId = identifier.getApplicationAttemptId().getApplicationId();
        if (!nmTokenAppId.equals((Object)containerId.getApplicationAttemptId().getApplicationId()) || container != null && !nmTokenAppId.equals((Object)container.getContainerId().getApplicationAttemptId().getApplicationId())) {
            String msg;
            if (stopRequest) {
                msg = identifier.getApplicationAttemptId() + " attempted to stop non-application container : " + containerId;
                NMAuditLogger.logFailure(remoteUser, "Stop Container Request", "ContainerManagerImpl", "Trying to stop unknown container!", nmTokenAppId, containerId);
            } else {
                msg = identifier.getApplicationAttemptId() + " attempted to get status for non-application container : " + containerId;
            }
            LOG.warn(msg);
            throw RPCUtil.getRemoteException((String)msg);
        }
    }

    public void handle(ContainerManagerEvent event) {
        switch ((ContainerManagerEventType)event.getType()) {
            case FINISH_APPS: {
                CMgrCompletedAppsEvent appsFinishedEvent = (CMgrCompletedAppsEvent)event;
                for (ApplicationId appID : appsFinishedEvent.getAppsToCleanup()) {
                    Application app = (Application)this.context.getApplications().get(appID);
                    if (app == null) {
                        LOG.info("couldn't find application " + appID + " while processing FINISH_APPS event. The ResourceManager allocated resources for this application to the NodeManager but no active containers were found to process.");
                        continue;
                    }
                    boolean shouldDropEvent = false;
                    for (Container container : app.getContainers().values()) {
                        if (!container.isRecovering()) continue;
                        LOG.info("drop FINISH_APPS event to " + appID + " because container " + container.getContainerId() + " is recovering");
                        shouldDropEvent = true;
                        break;
                    }
                    if (shouldDropEvent) continue;
                    String diagnostic = "";
                    if (appsFinishedEvent.getReason() == CMgrCompletedAppsEvent.Reason.ON_SHUTDOWN) {
                        diagnostic = "Application killed on shutdown";
                    } else if (appsFinishedEvent.getReason() == CMgrCompletedAppsEvent.Reason.BY_RESOURCEMANAGER) {
                        diagnostic = "Application killed by ResourceManager";
                    }
                    this.dispatcher.getEventHandler().handle((Event)new ApplicationFinishEvent(appID, diagnostic));
                }
                break;
            }
            case FINISH_CONTAINERS: {
                CMgrCompletedContainersEvent containersFinishedEvent = (CMgrCompletedContainersEvent)event;
                for (ContainerId containerId : containersFinishedEvent.getContainersToCleanup()) {
                    ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
                    Application app = (Application)this.context.getApplications().get(appId);
                    if (app == null) {
                        LOG.warn("couldn't find app " + appId + " while processing FINISH_CONTAINERS event");
                        continue;
                    }
                    Container container = app.getContainers().get(containerId);
                    if (container == null) {
                        LOG.warn("couldn't find container " + containerId + " while processing FINISH_CONTAINERS event");
                        continue;
                    }
                    if (container.isRecovering()) {
                        LOG.info("drop FINISH_CONTAINERS event to " + containerId + " because container is recovering");
                        continue;
                    }
                    this.dispatcher.getEventHandler().handle((Event)new ContainerKillEvent(containerId, -106, "Container Killed by ResourceManager"));
                }
                break;
            }
            case UPDATE_CONTAINERS: {
                CMgrUpdateContainersEvent containersDecreasedEvent = (CMgrUpdateContainersEvent)event;
                for (org.apache.hadoop.yarn.api.records.Container container : containersDecreasedEvent.getContainersToUpdate()) {
                    try {
                        ContainerTokenIdentifier containerTokenIdentifier = BuilderUtils.newContainerTokenIdentifier(container.getContainerToken());
                        this.updateContainerInternal(container.getId(), containerTokenIdentifier);
                    }
                    catch (YarnException e) {
                        LOG.error("Unable to decrease container resource", (Throwable)e);
                    }
                    catch (IOException e) {
                        LOG.error("Unable to update container resource in store", (Throwable)e);
                    }
                }
                break;
            }
            case SIGNAL_CONTAINERS: {
                CMgrSignalContainersEvent containersSignalEvent = (CMgrSignalContainersEvent)event;
                for (SignalContainerRequest request : containersSignalEvent.getContainersToSignal()) {
                    this.internalSignalToContainer(request, "ResourceManager");
                }
                break;
            }
            default: {
                throw new YarnRuntimeException("Got an unknown ContainerManagerEvent type: " + event.getType());
            }
        }
    }

    public void stateChanged(Service service) {
    }

    public Context getContext() {
        return this.context;
    }

    public Map<String, ByteBuffer> getAuxServiceMetaData() {
        return this.auxiliaryServices.getMetaData();
    }

    @InterfaceAudience.Private
    public AMRMProxyService getAMRMProxyService() {
        return this.amrmProxyService;
    }

    public Map<String, ByteBuffer> getAuxServiceMetaData(ContainerId cId) {
        return this.auxiliaryServices.getMetaData(new ContainerInitializationContext(null, cId, null));
    }

    @InterfaceAudience.Private
    protected void setAMRMProxyService(AMRMProxyService amrmProxyService) {
        this.amrmProxyService = amrmProxyService;
    }

    protected boolean isServiceStopped() {
        return this.serviceStopped;
    }

    @Override
    public OpportunisticContainersStatus getOpportunisticContainersStatus() {
        return this.containerScheduler.getOpportunisticContainersStatus();
    }

    @Override
    public void updateQueuingLimit(ContainerQueuingLimit queuingLimit) {
        this.containerScheduler.updateQueuingLimit(queuingLimit);
    }

    public SignalContainerResponse signalToContainer(SignalContainerRequest request) throws YarnException, IOException {
        this.internalSignalToContainer(request, "Application Master");
        return new SignalContainerResponsePBImpl();
    }

    public ResourceLocalizationResponse localize(ResourceLocalizationRequest request) throws YarnException, IOException {
        ContainerId containerId = request.getContainerId();
        Container container = this.preReInitializeOrLocalizeCheck(containerId, ReInitOp.LOCALIZE);
        try {
            Map<LocalResourceVisibility, Collection<LocalResourceRequest>> req = container.getResourceSet().addResources(request.getLocalResources());
            if (req != null && !req.isEmpty()) {
                this.dispatcher.getEventHandler().handle((Event)new ContainerLocalizationRequestEvent(container, req));
            }
        }
        catch (URISyntaxException e) {
            LOG.info("Error when parsing local resource URI for " + containerId, (Throwable)e);
            throw new YarnException((Throwable)e);
        }
        return ResourceLocalizationResponse.newInstance();
    }

    public ReInitializeContainerResponse reInitializeContainer(ReInitializeContainerRequest request) throws YarnException, IOException {
        this.reInitializeContainer(request.getContainerId(), request.getContainerLaunchContext(), request.getAutoCommit());
        return ReInitializeContainerResponse.newInstance();
    }

    public RestartContainerResponse restartContainer(ContainerId containerId) throws YarnException, IOException {
        this.reInitializeContainer(containerId, null, true);
        return RestartContainerResponse.newInstance();
    }

    public void reInitializeContainer(ContainerId containerId, ContainerLaunchContext reInitLaunchContext, boolean autoCommit) throws YarnException {
        LOG.debug("{} requested reinit", (Object)containerId);
        Container container = this.preReInitializeOrLocalizeCheck(containerId, ReInitOp.RE_INIT);
        ResourceSet resourceSet = new ResourceSet();
        try {
            if (reInitLaunchContext != null) {
                resourceSet.addResources(reInitLaunchContext.getLocalResources());
            }
            this.dispatcher.getEventHandler().handle((Event)new ContainerReInitEvent(containerId, reInitLaunchContext, resourceSet, autoCommit));
            container.setIsReInitializing(true);
        }
        catch (URISyntaxException e) {
            LOG.info("Error when parsing local resource URI for upgrade ofContainer [" + containerId + "]", (Throwable)e);
            throw new YarnException((Throwable)e);
        }
    }

    public RollbackResponse rollbackLastReInitialization(ContainerId containerId) throws YarnException {
        Container container = this.preReInitializeOrLocalizeCheck(containerId, ReInitOp.ROLLBACK);
        if (!container.canRollback()) {
            throw new YarnException("Nothing to rollback to !!");
        }
        this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(containerId, ContainerEventType.ROLLBACK_REINIT));
        container.setIsReInitializing(true);
        return RollbackResponse.newInstance();
    }

    public CommitResponse commitLastReInitialization(ContainerId containerId) throws YarnException {
        Container container = this.preReInitializeOrLocalizeCheck(containerId, ReInitOp.COMMIT);
        if (!container.canRollback()) {
            throw new YarnException("Nothing to Commit !!");
        }
        container.commitUpgrade();
        return CommitResponse.newInstance();
    }

    private Container preReInitializeOrLocalizeCheck(ContainerId containerId, ReInitOp op) throws YarnException {
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        NMTokenIdentifier nmTokenIdentifier = this.selectNMTokenIdentifier(remoteUgi);
        this.authorizeUser(remoteUgi, nmTokenIdentifier);
        if (!nmTokenIdentifier.getApplicationAttemptId().getApplicationId().equals((Object)containerId.getApplicationAttemptId().getApplicationId())) {
            throw new YarnException("ApplicationMaster not authorized to perform [" + (Object)((Object)op) + "] on Container [" + containerId + "]!!");
        }
        Container container = (Container)this.context.getContainers().get(containerId);
        if (container == null) {
            throw new YarnException("Specified " + containerId + " does not exist!");
        }
        if (!container.isRunning() || container.isReInitializing() || container.getContainerTokenIdentifier().getExecutionType() == ExecutionType.OPPORTUNISTIC) {
            throw new YarnException("Cannot perform " + (Object)((Object)op) + " on [" + containerId + "]. Current state is [" + (Object)((Object)container.getContainerState()) + ", isReInitializing=" + container.isReInitializing() + "]. Container Execution Type is [" + container.getContainerTokenIdentifier().getExecutionType() + "].");
        }
        return container;
    }

    private void internalSignalToContainer(SignalContainerRequest request, String sentBy) {
        ContainerId containerId = request.getContainerId();
        Container container = (Container)this.context.getContainers().get(containerId);
        if (container != null) {
            LOG.info(containerId + " signal request " + request.getCommand() + " by " + sentBy);
            this.dispatcher.getEventHandler().handle((Event)new SignalContainersLauncherEvent(container, request.getCommand()));
        } else {
            LOG.info("Container " + containerId + " no longer exists");
        }
    }

    @Override
    public ContainerScheduler getContainerScheduler() {
        return this.containerScheduler;
    }

    @Override
    public void handleCredentialUpdate() {
        Set<ApplicationId> invalidApps = this.logHandler.getInvalidTokenApps();
        if (!invalidApps.isEmpty()) {
            this.dispatcher.getEventHandler().handle((Event)new LogHandlerTokenUpdatedEvent());
        }
    }

    public GetLocalizationStatusesResponse getLocalizationStatuses(GetLocalizationStatusesRequest request) throws YarnException, IOException {
        HashMap<ContainerId, List<LocalizationStatus>> allStatuses = new HashMap<ContainerId, List<LocalizationStatus>>();
        HashMap<ContainerId, SerializedException> failedRequests = new HashMap<ContainerId, SerializedException>();
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        NMTokenIdentifier identifier = this.selectNMTokenIdentifier(remoteUgi);
        if (identifier == null) {
            throw RPCUtil.getRemoteException((String)INVALID_NMTOKEN_MSG);
        }
        String remoteUser = remoteUgi.getUserName();
        for (ContainerId id : request.getContainerIds()) {
            try {
                List<LocalizationStatus> statuses = this.getLocalizationStatusesInternal(id, identifier, remoteUser);
                allStatuses.put(id, statuses);
            }
            catch (YarnException e) {
                failedRequests.put(id, SerializedException.newInstance((Throwable)e));
            }
        }
        return GetLocalizationStatusesResponse.newInstance(allStatuses, failedRequests);
    }

    private List<LocalizationStatus> getLocalizationStatusesInternal(ContainerId containerID, NMTokenIdentifier nmTokenIdentifier, String remoteUser) throws YarnException {
        Container container = (Container)this.context.getContainers().get(containerID);
        LOG.info("Getting localization status for {}", (Object)containerID);
        this.authorizeGetAndStopContainerRequest(containerID, container, false, nmTokenIdentifier, remoteUser);
        String containerIDStr = containerID.toString();
        if (container == null) {
            if (this.nodeStatusUpdater.isContainerRecentlyStopped(containerID)) {
                throw RPCUtil.getRemoteException((String)("Container " + containerIDStr + " was recently stopped on node manager."));
            }
            throw RPCUtil.getRemoteException((String)("Container " + containerIDStr + " is not handled by this NodeManager"));
        }
        return container.getLocalizationStatuses();
    }

    @Override
    public ResourceLocalizationService getResourceLocalizationService() {
        return this.rsrcLocalizationSrvc;
    }

    public AsyncDispatcher getDispatcher() {
        return this.dispatcher;
    }

    static class AuxiliaryLocalPathHandlerImpl
    implements AuxiliaryLocalPathHandler {
        private LocalDirsHandlerService dirhandlerService;

        AuxiliaryLocalPathHandlerImpl(LocalDirsHandlerService dirhandlerService) {
            this.dirhandlerService = dirhandlerService;
        }

        public Path getLocalPathForRead(String path) throws IOException {
            return this.dirhandlerService.getLocalPathForRead(path);
        }

        public Path getLocalPathForWrite(String path) throws IOException {
            return this.dirhandlerService.getLocalPathForWrite(path);
        }

        public Path getLocalPathForWrite(String path, long size) throws IOException {
            return this.dirhandlerService.getLocalPathForWrite(path, size, false);
        }

        public Iterable<Path> getAllLocalPathsForRead(String path) throws IOException {
            return this.dirhandlerService.getAllLocalPathsForRead(path);
        }
    }

    private static final class LocalizationEventHandlerWrapper
    implements EventHandler<LocalizationEvent> {
        private EventHandler<LocalizationEvent> origLocalizationEventHandler;
        private NMTimelinePublisher timelinePublisher;

        LocalizationEventHandlerWrapper(EventHandler<LocalizationEvent> handler, NMTimelinePublisher publisher) {
            this.origLocalizationEventHandler = handler;
            this.timelinePublisher = publisher;
        }

        public void handle(LocalizationEvent event) {
            this.origLocalizationEventHandler.handle((Event)event);
            if (this.timelinePublisher != null) {
                this.timelinePublisher.publishLocalizationEvent(event);
            }
        }
    }

    class ApplicationEventDispatcher
    implements EventHandler<ApplicationEvent> {
        ApplicationEventDispatcher() {
        }

        public void handle(ApplicationEvent event) {
            Application app = (Application)ContainerManagerImpl.this.context.getApplications().get(event.getApplicationID());
            if (app != null) {
                app.handle((Event)event);
                if (ContainerManagerImpl.this.nmMetricsPublisher != null) {
                    ContainerManagerImpl.this.nmMetricsPublisher.publishApplicationEvent(event);
                }
            } else {
                LOG.warn("Event " + (Object)((Object)event) + " sent to absent application " + event.getApplicationID());
            }
        }
    }

    class ContainerEventDispatcher
    implements EventHandler<ContainerEvent> {
        ContainerEventDispatcher() {
        }

        public void handle(ContainerEvent event) {
            ConcurrentMap<ContainerId, Container> containers = ContainerManagerImpl.this.context.getContainers();
            Container c = (Container)containers.get(event.getContainerID());
            if (c != null) {
                c.handle((Event)event);
                if (ContainerManagerImpl.this.nmMetricsPublisher != null) {
                    ContainerManagerImpl.this.nmMetricsPublisher.publishContainerEvent(event);
                }
            } else {
                LOG.warn("Event " + (Object)((Object)event) + " sent to absent container " + event.getContainerID());
            }
        }
    }

    private static enum ReInitOp {
        RE_INIT,
        COMMIT,
        ROLLBACK,
        LOCALIZE;

    }
}

