/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.http.server.util;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.server.Request;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.server.Response;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ssl.SSLFilter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ssl.SSLSupportImpl;

public class RequestUtils {
    private static final Logger LOGGER = Grizzly.logger(RequestUtils.class);

    public static Object populateCertificateAttribute(Request request) {
        Object[] certificates = null;
        if (request.getRequest().isSecure()) {
            SSLFilter.CertificateEvent event = new SSLFilter.CertificateEvent(true);
            request.getContext().notifyDownstream(event);
            certificates = event.getCertificates();
            request.setAttribute("org.apache.hadoop.shaded.javax.servlet.request.X509Certificate", certificates);
        }
        return certificates;
    }

    public static void populateSSLAttributes(Request request) {
        block9: {
            if (request.isSecure()) {
                try {
                    SSLSupportImpl sslSupport = new SSLSupportImpl(request.getContext().getConnection());
                    Object sslO = sslSupport.getCipherSuite();
                    if (sslO != null) {
                        request.setAttribute("org.apache.hadoop.shaded.javax.servlet.request.cipher_suite", sslO);
                    }
                    if ((sslO = sslSupport.getPeerCertificateChain(false)) != null) {
                        request.setAttribute("org.apache.hadoop.shaded.javax.servlet.request.X509Certificate", sslO);
                    }
                    if ((sslO = sslSupport.getKeySize()) != null) {
                        request.setAttribute("org.apache.hadoop.shaded.javax.servlet.request.key_size", sslO);
                    }
                    if ((sslO = sslSupport.getSessionId()) != null) {
                        request.setAttribute("org.apache.hadoop.shaded.javax.servlet.request.ssl_session_id", sslO);
                    }
                    break block9;
                }
                catch (Exception ioe) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "Unable to populate SSL attributes", ioe);
                    }
                    break block9;
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to populate SSL attributes on plain HTTP request");
            }
        }
    }

    public static void handleSendFile(Request request) {
        block7: {
            Object f = request.getAttribute("org.apache.hadoop.shaded.org.glassfish.grizzly.http.SEND_FILE");
            if (f != null) {
                Response response = request.getResponse();
                if (response.isCommitted()) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "SendFile can't be performed,because response headers are committed");
                    }
                    return;
                }
                File file = (File)f;
                Long offset = (Long)request.getAttribute("org.apache.hadoop.shaded.org.glassfish.grizzly.http.FILE_START_OFFSET");
                Long len = (Long)request.getAttribute("org.apache.hadoop.shaded.org.glassfish.grizzly.http.FILE_WRITE_LEN");
                if (offset == null) {
                    offset = 0L;
                }
                if (len == null) {
                    len = file.length();
                }
                try {
                    response.getOutputBuffer().sendfile(file, offset, len, null);
                }
                catch (IOException ioe) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block7;
                    LOGGER.log(Level.SEVERE, "Failed to transfer file: " + ((File)f).getAbsolutePath(), ioe);
                }
            }
        }
    }
}

