/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.auth0.jwk;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.shaded.com.auth0.jwk.Jwk;
import org.apache.hadoop.shaded.com.auth0.jwk.JwkException;
import org.apache.hadoop.shaded.com.auth0.jwk.JwkProvider;
import org.apache.hadoop.shaded.com.auth0.jwk.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.cache.Cache;
import org.apache.hadoop.shaded.com.google.common.cache.CacheBuilder;

public class GuavaCachedJwkProvider
implements JwkProvider {
    private final Cache<String, Jwk> cache;
    private final JwkProvider provider;
    @VisibleForTesting
    static final String NULL_KID_KEY = "null-kid";

    public GuavaCachedJwkProvider(JwkProvider provider) {
        this(provider, 5L, Duration.ofMinutes(10L));
    }

    public GuavaCachedJwkProvider(JwkProvider provider, long size, long expiresIn, TimeUnit expiresUnit) {
        this.provider = provider;
        this.cache = CacheBuilder.newBuilder().maximumSize(size).expireAfterWrite(expiresIn, expiresUnit).build();
    }

    public GuavaCachedJwkProvider(JwkProvider provider, long size, Duration expiresIn) {
        this(provider, size, expiresIn.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public Jwk get(String keyId) throws JwkException {
        try {
            String cacheKey = keyId == null ? NULL_KID_KEY : keyId;
            return this.cache.get(cacheKey, () -> this.provider.get(keyId));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof JwkException) {
                throw (JwkException)e.getCause();
            }
            throw new JwkException("Unable to obtain key with kid " + keyId, e);
        }
    }

    @VisibleForTesting
    JwkProvider getBaseProvider() {
        return this.provider;
    }
}

