/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.Session;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ShellContainerCommand;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerExecContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce", "YARN"})
@InterfaceStability.Unstable
@WebSocket
public class ContainerShellWebSocket {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerShellWebSocket.class);
    private static Context nmContext;
    private final ContainerExecutor exec = nmContext.getContainerExecutor();
    private IOStreamPair pair;

    public static void init(Context nm) {
        nmContext = nm;
    }

    @OnWebSocketMessage
    public void onText(Session session, String message) throws IOException {
        try {
            byte[] buffer = new byte[4000];
            if (session.isOpen()) {
                byte[] payload;
                if (!message.equals("1{}") && (payload = message.getBytes(StandardCharsets.UTF_8)) != null) {
                    this.pair.out.write(payload);
                    this.pair.out.flush();
                }
                int no = this.pair.in.available();
                this.pair.in.read(buffer, 0, Math.min(no, buffer.length));
                String formatted = new String(buffer, StandardCharsets.UTF_8).replaceAll("\n", "\r\n");
                session.getRemote().sendString(formatted);
            }
        }
        catch (IOException e) {
            this.onClose(session, 1001, "Shutdown");
        }
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        try {
            Container container;
            URI containerURI = session.getUpgradeRequest().getRequestURI();
            String command = "bash";
            String[] containerPath = containerURI.getPath().split("/");
            String cId = containerPath[2];
            if (containerPath.length == 4) {
                for (ShellContainerCommand c : ShellContainerCommand.values()) {
                    if (!c.name().equalsIgnoreCase(containerPath[3])) continue;
                    command = containerPath[3].toLowerCase();
                }
            }
            if (!this.checkAuthorization(session, container = (Container)nmContext.getContainers().get(ContainerId.fromString((String)cId)))) {
                session.close(1008, "Forbidden");
                return;
            }
            if (this.checkInsecureSetup()) {
                session.close(1003, "Nonsecure mode is unsupported.");
                return;
            }
            LOG.info(session.getRemoteAddress().getHostString() + " connected!");
            LOG.info("Making interactive connection to running docker container with ID: " + cId);
            ContainerExecContext execContext = new ContainerExecContext.Builder().setContainer(container).setNMLocalPath(nmContext.getLocalDirsHandler()).setShell(command).build();
            this.pair = this.exec.execContainer(execContext);
        }
        catch (Exception e) {
            LOG.error("Failed to establish WebSocket connection with Client", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketClose
    public void onClose(Session session, int status, String reason) {
        try {
            LOG.info(session.getRemoteAddress().getHostString() + " closed!");
            String exit = "exit\r\n";
            this.pair.out.write(exit.getBytes(StandardCharsets.UTF_8));
            this.pair.out.flush();
            this.pair.in.close();
            this.pair.out.close();
        }
        catch (IOException iOException) {
        }
        finally {
            session.close();
        }
    }

    protected boolean checkAuthorization(Session session, Container container) throws IOException {
        String containerUser;
        boolean authorized = true;
        String user = "";
        if (UserGroupInformation.isSecurityEnabled()) {
            user = new HadoopKerberosName(session.getUpgradeRequest().getUserPrincipal().getName()).getShortName();
        } else {
            Map parameters = session.getUpgradeRequest().getParameterMap();
            if (parameters.containsKey("user.name")) {
                List users = (List)parameters.get("user.name");
                user = (String)users.get(0);
            }
        }
        boolean isAdmin = false;
        if (nmContext.getApplicationACLsManager().areACLsEnabled()) {
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
            isAdmin = nmContext.getApplicationACLsManager().isAdmin(ugi);
        }
        if (!user.equals(containerUser = container.getUser()) && !isAdmin) {
            authorized = false;
        }
        return authorized;
    }

    private boolean checkInsecureSetup() {
        boolean kerberos = UserGroupInformation.isSecurityEnabled();
        boolean limitUsers = nmContext.getConf().getBoolean("yarn.nodemanager.linux-container-executor.nonsecure-mode.limit-users", true);
        if (kerberos) {
            return false;
        }
        return limitUsers;
    }
}

