/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.event.multidispatcher;

import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.shaded.org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.event.multidispatcher.MultiDispatcherConfig;
import org.apache.hadoop.yarn.event.multidispatcher.MultiDispatcherExecutor;
import org.apache.hadoop.yarn.event.multidispatcher.MultiDispatcherLibrary;
import org.apache.hadoop.yarn.metrics.DispatcherEventMetrics;
import org.apache.hadoop.yarn.metrics.DispatcherEventMetricsImpl;
import org.apache.hadoop.yarn.metrics.DispatcherEventMetricsNoOps;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDispatcher
extends AbstractService
implements Dispatcher {
    private final Logger log;
    private final String dispatcherName;
    private final MultiDispatcherLibrary library;
    private final Clock clock = new MonotonicClock();
    private MultiDispatcherExecutor workerExecutor;
    private ScheduledThreadPoolExecutor monitorExecutor;
    private DispatcherEventMetrics metrics;

    public MultiDispatcher(String dispatcherName) {
        super("Dispatcher");
        this.dispatcherName = dispatcherName.replaceAll(" ", "-").toLowerCase();
        this.log = LoggerFactory.getLogger((String)(MultiDispatcher.class.getCanonicalName() + "." + this.dispatcherName));
        this.library = new MultiDispatcherLibrary();
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        MultiDispatcherConfig config = new MultiDispatcherConfig(this.getConfig(), this.dispatcherName);
        this.workerExecutor = new MultiDispatcherExecutor(this.log, config, this.dispatcherName);
        this.workerExecutor.start();
        this.createMonitorThread(config);
        if (config.getMetricsEnabled()) {
            this.metrics = new DispatcherEventMetricsImpl(this.dispatcherName);
            DefaultMetricsSystem.instance().register("Event metrics for " + this.dispatcherName, "Event metrics for " + this.dispatcherName, this.metrics);
        } else {
            this.metrics = new DispatcherEventMetricsNoOps(this.log);
        }
    }

    @Override
    protected void serviceStop() throws Exception {
        if (this.monitorExecutor != null) {
            this.monitorExecutor.shutdown();
        }
        this.workerExecutor.stop();
    }

    public EventHandler getEventHandler() {
        return event -> {
            if (this.isInState(Service.STATE.STOPPED)) {
                this.log.warn("Discard event {} because stopped state", (Object)event);
            } else {
                EventHandler handler = this.library.getEventHandler(event);
                Runnable runnable = this.createRunnable(event, handler);
                this.workerExecutor.execute(event, runnable);
                this.metrics.addEvent(event.getType());
            }
        };
    }

    @Override
    public void register(Class<? extends Enum> eventType, EventHandler handler) {
        this.library.register(eventType, handler);
        this.metrics.init(eventType);
    }

    private Runnable createRunnable(Event event, EventHandler handler) {
        return () -> {
            long start = this.clock.getTime();
            try {
                handler.handle(event);
            }
            finally {
                this.metrics.updateRate(event.getType(), this.clock.getTime() - start);
                this.metrics.removeEvent(event.getType());
            }
        };
    }

    private void createMonitorThread(MultiDispatcherConfig config) {
        int interval = config.getMonitorSeconds();
        if (interval < 1) {
            return;
        }
        this.monitorExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern(this.dispatcherName + "-monitor-%d").build());
        this.monitorExecutor.scheduleAtFixedRate(() -> {
            List notEmptyQueues = this.workerExecutor.getQueuesSize().entrySet().stream().filter(e -> 0L < (Long)e.getValue()).map(e -> String.format("%s has queue size %d", e.getKey(), e.getValue())).sorted().collect(Collectors.toList());
            if (!notEmptyQueues.isEmpty()) {
                this.log.info("Event queue sizes: {}", notEmptyQueues);
            }
            this.log.debug("Metrics: {}", (Object)this.metrics);
        }, 10L, interval, TimeUnit.SECONDS);
    }
}

