/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.scram;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.scram.CredentialCache;
import org.apache.hadoop.security.scram.ScramCredential;
import org.apache.hadoop.security.scram.ScramCredentialCallback;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.shaded.org.apache.commons.codec.binary.Base64;

public class ScramServerCallbackHandler
implements CallbackHandler {
    private final CredentialCache.Cache<ScramCredential> credentialCache;
    private SecretManager<TokenIdentifier> secretManager;
    private Server.Connection connection;

    public ScramServerCallbackHandler(CredentialCache.Cache<ScramCredential> credentialCache, SecretManager<TokenIdentifier> secretManager, Server.Connection connection) {
        this.credentialCache = credentialCache;
        this.secretManager = secretManager;
        this.connection = connection;
    }

    public static <T extends TokenIdentifier> T getIdentifier(String id, SecretManager<T> secretManager) throws SecretManager.InvalidToken {
        byte[] tokenId = ScramServerCallbackHandler.decodeIdentifier(id);
        T tokenIdentifier = secretManager.createIdentifier();
        try {
            tokenIdentifier.readFields(new DataInputStream(new ByteArrayInputStream(tokenId)));
        }
        catch (IOException e) {
            throw (SecretManager.InvalidToken)new SecretManager.InvalidToken("Can't de-serialize tokenIdentifier").initCause(e);
        }
        return tokenIdentifier;
    }

    public static byte[] decodeIdentifier(String identifier) {
        return Base64.decodeBase64((byte[])identifier.getBytes());
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        String username = null;
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                username = ((NameCallback)callback).getDefaultName();
                continue;
            }
            if (callback instanceof ScramCredentialCallback) {
                TokenIdentifier tokenIdentifier = ScramServerCallbackHandler.getIdentifier(username, this.secretManager);
                this.connection.attemptingUser = tokenIdentifier.getUser();
                ((ScramCredentialCallback)callback).scramCredential(this.credentialCache.get(UserGroupInformation.getLoginUser().getUserName()));
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

