/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.auth0.jwt.interfaces;

import java.time.Instant;
import java.util.Date;
import java.util.function.BiPredicate;
import org.apache.hadoop.shaded.com.auth0.jwt.JWTVerifier;
import org.apache.hadoop.shaded.com.auth0.jwt.interfaces.Claim;
import org.apache.hadoop.shaded.com.auth0.jwt.interfaces.DecodedJWT;

public interface Verification {
    default public Verification withIssuer(String issuer) {
        return this.withIssuer(new String[]{issuer});
    }

    public Verification withIssuer(String ... var1);

    public Verification withSubject(String var1);

    public Verification withAudience(String ... var1);

    public Verification withAnyOfAudience(String ... var1);

    public Verification acceptLeeway(long var1) throws IllegalArgumentException;

    public Verification acceptExpiresAt(long var1) throws IllegalArgumentException;

    public Verification acceptNotBefore(long var1) throws IllegalArgumentException;

    public Verification acceptIssuedAt(long var1) throws IllegalArgumentException;

    public Verification withJWTId(String var1);

    public Verification withClaimPresence(String var1) throws IllegalArgumentException;

    public Verification withNullClaim(String var1) throws IllegalArgumentException;

    public Verification withClaim(String var1, Boolean var2) throws IllegalArgumentException;

    public Verification withClaim(String var1, Integer var2) throws IllegalArgumentException;

    public Verification withClaim(String var1, Long var2) throws IllegalArgumentException;

    public Verification withClaim(String var1, Double var2) throws IllegalArgumentException;

    public Verification withClaim(String var1, String var2) throws IllegalArgumentException;

    public Verification withClaim(String var1, Date var2) throws IllegalArgumentException;

    default public Verification withClaim(String name, Instant value) throws IllegalArgumentException {
        return this.withClaim(name, value != null ? Date.from(value) : null);
    }

    public Verification withClaim(String var1, BiPredicate<Claim, DecodedJWT> var2) throws IllegalArgumentException;

    public Verification withArrayClaim(String var1, String ... var2) throws IllegalArgumentException;

    public Verification withArrayClaim(String var1, Integer ... var2) throws IllegalArgumentException;

    public Verification withArrayClaim(String var1, Long ... var2) throws IllegalArgumentException;

    public Verification ignoreIssuedAt();

    public JWTVerifier build();
}

