/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.sasl.SaslException;
import org.apache.hadoop.shaded.org.apache.jute.BinaryInputArchive;
import org.apache.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import org.apache.hadoop.shaded.org.apache.jute.Record;
import org.apache.hadoop.shaded.org.apache.zookeeper.Environment;
import org.apache.hadoop.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.shaded.org.apache.zookeeper.data.ACL;
import org.apache.hadoop.shaded.org.apache.zookeeper.data.Id;
import org.apache.hadoop.shaded.org.apache.zookeeper.data.StatPersisted;
import org.apache.hadoop.shaded.org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.hadoop.shaded.org.apache.zookeeper.proto.AuthPacket;
import org.apache.hadoop.shaded.org.apache.zookeeper.proto.ConnectRequest;
import org.apache.hadoop.shaded.org.apache.zookeeper.proto.ConnectResponse;
import org.apache.hadoop.shaded.org.apache.zookeeper.proto.GetSASLRequest;
import org.apache.hadoop.shaded.org.apache.zookeeper.proto.ReplyHeader;
import org.apache.hadoop.shaded.org.apache.zookeeper.proto.RequestHeader;
import org.apache.hadoop.shaded.org.apache.zookeeper.proto.SetSASLResponse;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.DataTree;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.DataTreeBean;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.Request;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.RequestProcessor;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ServerCnxn;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ServerStats;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.SessionTracker;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.SessionTrackerImpl;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.UnimplementedRequestProcessor;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperSaslServer;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServerBean;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServerConf;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServerListener;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServerListenerImpl;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServerShutdownHandler;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZooTrace;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.auth.AuthenticationProvider;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.auth.ProviderRegistry;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.ReadOnlyZooKeeperServer;
import org.apache.hadoop.shaded.org.apache.zookeeper.txn.CreateSessionTxn;
import org.apache.hadoop.shaded.org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServer
implements SessionTracker.SessionExpirer,
ServerStats.Provider {
    protected static final Logger LOG = LoggerFactory.getLogger(ZooKeeperServer.class);
    protected ZooKeeperServerBean jmxServerBean;
    protected DataTreeBean jmxDataTreeBean;
    public static final int DEFAULT_TICK_TIME = 3000;
    protected int tickTime = 3000;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;
    protected SessionTracker sessionTracker;
    private FileTxnSnapLog txnLogFactory = null;
    private ZKDatabase zkDb;
    private final AtomicLong hzxid = new AtomicLong(0L);
    public static final Exception ok;
    protected RequestProcessor firstProcessor;
    protected volatile State state = State.INITIAL;
    private static final long superSecret = 3007405056L;
    private final AtomicInteger requestsInProcess = new AtomicInteger(0);
    final Deque<ChangeRecord> outstandingChanges = new ArrayDeque<ChangeRecord>();
    final HashMap<String, ChangeRecord> outstandingChangesForPath = new HashMap();
    protected ServerCnxnFactory serverCnxnFactory;
    protected ServerCnxnFactory secureServerCnxnFactory;
    private final ServerStats serverStats = new ServerStats(this);
    private final ZooKeeperServerListener listener;
    private ZooKeeperServerShutdownHandler zkShutdownHandler;
    private volatile int createSessionTrackerServerId = 1;

    void removeCnxn(ServerCnxn cnxn) {
        this.zkDb.removeCnxn(cnxn);
    }

    public ZooKeeperServer() {
        this.listener = new ZooKeeperServerListenerImpl(this);
    }

    public ZooKeeperServer(FileTxnSnapLog txnLogFactory, int tickTime, int minSessionTimeout, int maxSessionTimeout, ZKDatabase zkDb) {
        this.txnLogFactory = txnLogFactory;
        this.txnLogFactory.setServerStats(this.serverStats);
        this.zkDb = zkDb;
        this.tickTime = tickTime;
        this.setMinSessionTimeout(minSessionTimeout);
        this.setMaxSessionTimeout(maxSessionTimeout);
        this.listener = new ZooKeeperServerListenerImpl(this);
        LOG.info("Created server with tickTime " + tickTime + " minSessionTimeout " + this.getMinSessionTimeout() + " maxSessionTimeout " + this.getMaxSessionTimeout() + " datadir " + txnLogFactory.getDataDir() + " snapdir " + txnLogFactory.getSnapDir());
    }

    public ZooKeeperServer(FileTxnSnapLog txnLogFactory, int tickTime) throws IOException {
        this(txnLogFactory, tickTime, -1, -1, new ZKDatabase(txnLogFactory));
    }

    public ServerStats serverStats() {
        return this.serverStats;
    }

    public void dumpConf(PrintWriter pwriter) {
        pwriter.print("clientPort=");
        pwriter.println(this.getClientPort());
        pwriter.print("secureClientPort=");
        pwriter.println(this.getSecureClientPort());
        pwriter.print("dataDir=");
        pwriter.println(this.zkDb.snapLog.getSnapDir().getAbsolutePath());
        pwriter.print("dataDirSize=");
        pwriter.println(this.getDataDirSize());
        pwriter.print("dataLogDir=");
        pwriter.println(this.zkDb.snapLog.getDataDir().getAbsolutePath());
        pwriter.print("dataLogSize=");
        pwriter.println(this.getLogDirSize());
        pwriter.print("tickTime=");
        pwriter.println(this.getTickTime());
        pwriter.print("maxClientCnxns=");
        pwriter.println(this.getMaxClientCnxnsPerHost());
        pwriter.print("minSessionTimeout=");
        pwriter.println(this.getMinSessionTimeout());
        pwriter.print("maxSessionTimeout=");
        pwriter.println(this.getMaxSessionTimeout());
        pwriter.print("serverId=");
        pwriter.println(this.getServerId());
    }

    public ZooKeeperServerConf getConf() {
        return new ZooKeeperServerConf(this.getClientPort(), this.zkDb.snapLog.getSnapDir().getAbsolutePath(), this.zkDb.snapLog.getDataDir().getAbsolutePath(), this.getTickTime(), this.serverCnxnFactory.getMaxClientCnxnsPerHost(), this.getMinSessionTimeout(), this.getMaxSessionTimeout(), this.getServerId());
    }

    public ZooKeeperServer(File snapDir, File logDir, int tickTime) throws IOException {
        this(new FileTxnSnapLog(snapDir, logDir), tickTime);
    }

    public ZooKeeperServer(FileTxnSnapLog txnLogFactory) throws IOException {
        this(txnLogFactory, 3000, -1, -1, new ZKDatabase(txnLogFactory));
    }

    public ZKDatabase getZKDatabase() {
        return this.zkDb;
    }

    public void setZKDatabase(ZKDatabase zkDb) {
        this.zkDb = zkDb;
    }

    public void loadData() throws IOException, InterruptedException {
        if (this.zkDb.isInitialized()) {
            this.setZxid(this.zkDb.getDataTreeLastProcessedZxid());
        } else {
            this.setZxid(this.zkDb.loadDataBase());
        }
        LinkedList<Long> deadSessions = new LinkedList<Long>();
        for (Long session : this.zkDb.getSessions()) {
            if (this.zkDb.getSessionWithTimeOuts().get(session) != null) continue;
            deadSessions.add(session);
        }
        for (long session : deadSessions) {
            this.killSession(session, this.zkDb.getDataTreeLastProcessedZxid());
        }
        this.takeSnapshot();
    }

    public void takeSnapshot() {
        try {
            this.txnLogFactory.save(this.zkDb.getDataTree(), this.zkDb.getSessionWithTimeOuts());
        }
        catch (IOException e) {
            LOG.error("Severe unrecoverable error, exiting", (Throwable)e);
            System.exit(10);
        }
    }

    @Override
    public long getDataDirSize() {
        if (this.zkDb == null) {
            return 0L;
        }
        File path = this.zkDb.snapLog.getDataDir();
        return this.getDirSize(path);
    }

    @Override
    public long getLogDirSize() {
        if (this.zkDb == null) {
            return 0L;
        }
        File path = this.zkDb.snapLog.getSnapDir();
        return this.getDirSize(path);
    }

    private long getDirSize(File file) {
        long size = 0L;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    size += this.getDirSize(f);
                }
            }
        } else {
            size = file.length();
        }
        return size;
    }

    public long getZxid() {
        return this.hzxid.get();
    }

    public SessionTracker getSessionTracker() {
        return this.sessionTracker;
    }

    long getNextZxid() {
        return this.hzxid.incrementAndGet();
    }

    public void setZxid(long zxid) {
        this.hzxid.set(zxid);
    }

    private void close(long sessionId) {
        Request si = new Request(null, sessionId, 0, -11, null, null);
        this.setLocalSessionFlag(si);
        this.submitRequest(si);
    }

    public void closeSession(long sessionId) {
        LOG.info("Closing session 0x" + Long.toHexString(sessionId));
        this.close(sessionId);
    }

    protected void killSession(long sessionId, long zxid) {
        this.zkDb.killSession(sessionId, zxid);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "ZooKeeperServer --- killSession: 0x" + Long.toHexString(sessionId));
        }
        if (this.sessionTracker != null) {
            this.sessionTracker.removeSession(sessionId);
        }
    }

    @Override
    public void expire(SessionTracker.Session session) {
        long sessionId = session.getSessionId();
        LOG.info("Expiring session 0x" + Long.toHexString(sessionId) + ", timeout of " + session.getTimeout() + "ms exceeded");
        this.close(sessionId);
    }

    void touch(ServerCnxn cnxn) throws MissingSessionException {
        int to;
        if (cnxn == null) {
            return;
        }
        long id = cnxn.getSessionId();
        if (!this.sessionTracker.touchSession(id, to = cnxn.getSessionTimeout())) {
            throw new MissingSessionException("No session with sessionid 0x" + Long.toHexString(id) + " exists, probably expired and removed");
        }
    }

    protected void registerJMX() {
        try {
            this.jmxServerBean = new ZooKeeperServerBean(this);
            MBeanRegistry.getInstance().register(this.jmxServerBean, null);
            try {
                this.jmxDataTreeBean = new DataTreeBean(this.zkDb.getDataTree());
                MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
            }
            catch (Exception e) {
                LOG.warn("Failed to register with JMX", (Throwable)e);
                this.jmxDataTreeBean = null;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.jmxServerBean = null;
        }
    }

    public void startdata() throws IOException, InterruptedException {
        if (this.zkDb == null) {
            this.zkDb = new ZKDatabase(this.txnLogFactory);
        }
        if (!this.zkDb.isInitialized()) {
            this.loadData();
        }
    }

    public synchronized void startup() {
        if (this.sessionTracker == null) {
            this.createSessionTracker();
        }
        this.startSessionTracker();
        this.setupRequestProcessors();
        this.registerJMX();
        this.setState(State.RUNNING);
        this.notifyAll();
    }

    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        SyncRequestProcessor syncProcessor = new SyncRequestProcessor(this, finalProcessor);
        syncProcessor.start();
        this.firstProcessor = new PrepRequestProcessor(this, syncProcessor);
        ((PrepRequestProcessor)this.firstProcessor).start();
    }

    public ZooKeeperServerListener getZooKeeperServerListener() {
        return this.listener;
    }

    public void setCreateSessionTrackerServerId(int newId) {
        this.createSessionTrackerServerId = newId;
    }

    protected void createSessionTracker() {
        this.sessionTracker = new SessionTrackerImpl(this, this.zkDb.getSessionWithTimeOuts(), this.tickTime, (long)this.createSessionTrackerServerId, this.getZooKeeperServerListener());
    }

    protected void startSessionTracker() {
        ((SessionTrackerImpl)this.sessionTracker).start();
    }

    protected void setState(State state) {
        this.state = state;
        if (this.zkShutdownHandler != null) {
            this.zkShutdownHandler.handle(state);
        } else {
            LOG.debug("ZKShutdownHandler is not registered, so ZooKeeper server won't take any action on ERROR or SHUTDOWN server state changes");
        }
    }

    protected boolean canShutdown() {
        return this.state == State.RUNNING || this.state == State.ERROR;
    }

    public boolean isRunning() {
        return this.state == State.RUNNING;
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public synchronized void shutdown(boolean fullyShutDown) {
        if (!this.canShutdown()) {
            LOG.debug("ZooKeeper server is not running, so not proceeding to shutdown!");
            return;
        }
        LOG.info("shutting down");
        this.setState(State.SHUTDOWN);
        if (this.sessionTracker != null) {
            this.sessionTracker.shutdown();
        }
        if (this.firstProcessor != null) {
            this.firstProcessor.shutdown();
        }
        if (this.zkDb != null) {
            if (fullyShutDown) {
                this.zkDb.clear();
            } else {
                try {
                    this.zkDb.fastForwardDataBase();
                }
                catch (IOException e) {
                    LOG.error("Error updating DB", (Throwable)e);
                    this.zkDb.clear();
                }
            }
        }
        this.unregisterJMX();
    }

    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxServerBean = null;
        this.jmxDataTreeBean = null;
    }

    public void incInProcess() {
        this.requestsInProcess.incrementAndGet();
    }

    public void decInProcess() {
        this.requestsInProcess.decrementAndGet();
    }

    public int getInProcess() {
        return this.requestsInProcess.get();
    }

    byte[] generatePasswd(long id) {
        Random r = new Random(id ^ 0xB3415C00L);
        byte[] p = new byte[16];
        r.nextBytes(p);
        return p;
    }

    protected boolean checkPasswd(long sessionId, byte[] passwd) {
        return sessionId != 0L && Arrays.equals(passwd, this.generatePasswd(sessionId));
    }

    long createSession(ServerCnxn cnxn, byte[] passwd, int timeout) {
        if (passwd == null) {
            passwd = new byte[]{};
        }
        long sessionId = this.sessionTracker.createSession(timeout);
        Random r = new Random(sessionId ^ 0xB3415C00L);
        r.nextBytes(passwd);
        ByteBuffer to = ByteBuffer.allocate(4);
        to.putInt(timeout);
        cnxn.setSessionId(sessionId);
        Request si = new Request(cnxn, sessionId, 0, -10, to, null);
        this.setLocalSessionFlag(si);
        this.submitRequest(si);
        return sessionId;
    }

    public void setOwner(long id, Object owner) throws KeeperException.SessionExpiredException {
        this.sessionTracker.setOwner(id, owner);
    }

    protected void revalidateSession(ServerCnxn cnxn, long sessionId, int sessionTimeout) throws IOException {
        boolean rc = this.sessionTracker.touchSession(sessionId, sessionTimeout);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "Session 0x" + Long.toHexString(sessionId) + " is valid: " + rc);
        }
        this.finishSessionInit(cnxn, rc);
    }

    public void reopenSession(ServerCnxn cnxn, long sessionId, byte[] passwd, int sessionTimeout) throws IOException {
        if (this.checkPasswd(sessionId, passwd)) {
            this.revalidateSession(cnxn, sessionId, sessionTimeout);
        } else {
            LOG.warn("Incorrect password from " + cnxn.getRemoteSocketAddress() + " for session 0x" + Long.toHexString(sessionId));
            this.finishSessionInit(cnxn, false);
        }
    }

    public void finishSessionInit(ServerCnxn cnxn, boolean valid) {
        try {
            if (valid) {
                if (this.serverCnxnFactory != null && this.serverCnxnFactory.cnxns.contains(cnxn)) {
                    this.serverCnxnFactory.registerConnection(cnxn);
                } else if (this.secureServerCnxnFactory != null && this.secureServerCnxnFactory.cnxns.contains(cnxn)) {
                    this.secureServerCnxnFactory.registerConnection(cnxn);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
        }
        try {
            ConnectResponse rsp = new ConnectResponse(0, valid ? cnxn.getSessionTimeout() : 0, valid ? cnxn.getSessionId() : 0L, valid ? this.generatePasswd(cnxn.getSessionId()) : new byte[16]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive bos = BinaryOutputArchive.getArchive(baos);
            bos.writeInt(-1, "len");
            rsp.serialize(bos, "connect");
            if (!cnxn.isOldClient) {
                bos.writeBool(this instanceof ReadOnlyZooKeeperServer, "readOnly");
            }
            baos.close();
            ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
            bb.putInt(bb.remaining() - 4).rewind();
            cnxn.sendBuffer(bb);
            if (valid) {
                LOG.debug("Established session 0x" + Long.toHexString(cnxn.getSessionId()) + " with negotiated timeout " + cnxn.getSessionTimeout() + " for client " + cnxn.getRemoteSocketAddress());
                cnxn.enableRecv();
            } else {
                LOG.info("Invalid session 0x" + Long.toHexString(cnxn.getSessionId()) + " for client " + cnxn.getRemoteSocketAddress() + ", probably expired");
                cnxn.sendBuffer(ServerCnxnFactory.closeConn);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while establishing session, closing", (Throwable)e);
            cnxn.close();
        }
    }

    public void closeSession(ServerCnxn cnxn, RequestHeader requestHeader) {
        this.closeSession(cnxn.getSessionId());
    }

    @Override
    public long getServerId() {
        return 0L;
    }

    protected void setLocalSessionFlag(Request si) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitRequest(Request si) {
        if (this.firstProcessor == null) {
            ZooKeeperServer zooKeeperServer = this;
            synchronized (zooKeeperServer) {
                try {
                    while (this.state == State.INITIAL) {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn("Unexpected interruption", (Throwable)e);
                }
                if (this.firstProcessor == null || this.state != State.RUNNING) {
                    throw new RuntimeException("Not started");
                }
            }
        }
        try {
            this.touch(si.cnxn);
            boolean validpacket = Request.isValid(si.type);
            if (validpacket) {
                this.firstProcessor.processRequest(si);
                if (si.cnxn != null) {
                    this.incInProcess();
                }
            } else {
                LOG.warn("Received packet at server of unknown type " + si.type);
                new UnimplementedRequestProcessor().processRequest(si);
            }
        }
        catch (MissingSessionException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dropping request: " + e.getMessage());
            }
        }
        catch (RequestProcessor.RequestProcessorException e) {
            LOG.error("Unable to process request:" + e.getMessage(), (Throwable)e);
        }
    }

    public static int getSnapCount() {
        String sc = System.getProperty("zookeeper.snapCount");
        try {
            int snapCount = Integer.parseInt(sc);
            if (snapCount < 2) {
                LOG.warn("SnapCount should be 2 or more. Now, snapCount is reset to 2");
                snapCount = 2;
            }
            return snapCount;
        }
        catch (Exception e) {
            return 100000;
        }
    }

    public int getGlobalOutstandingLimit() {
        int limit;
        String sc = System.getProperty("zookeeper.globalOutstandingLimit");
        try {
            limit = Integer.parseInt(sc);
        }
        catch (Exception e) {
            limit = 1000;
        }
        return limit;
    }

    public void setServerCnxnFactory(ServerCnxnFactory factory) {
        this.serverCnxnFactory = factory;
    }

    public ServerCnxnFactory getServerCnxnFactory() {
        return this.serverCnxnFactory;
    }

    public ServerCnxnFactory getSecureServerCnxnFactory() {
        return this.secureServerCnxnFactory;
    }

    public void setSecureServerCnxnFactory(ServerCnxnFactory factory) {
        this.secureServerCnxnFactory = factory;
    }

    @Override
    public long getLastProcessedZxid() {
        return this.zkDb.getDataTreeLastProcessedZxid();
    }

    @Override
    public long getOutstandingRequests() {
        return this.getInProcess();
    }

    @Override
    public int getNumAliveConnections() {
        int numAliveConnections = 0;
        if (this.serverCnxnFactory != null) {
            numAliveConnections += this.serverCnxnFactory.getNumAliveConnections();
        }
        if (this.secureServerCnxnFactory != null) {
            numAliveConnections += this.secureServerCnxnFactory.getNumAliveConnections();
        }
        return numAliveConnections;
    }

    public void truncateLog(long zxid) throws IOException {
        this.zkDb.truncateLog(zxid);
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public void setTickTime(int tickTime) {
        LOG.info("tickTime set to " + tickTime);
        this.tickTime = tickTime;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout;
    }

    public void setMinSessionTimeout(int min) {
        this.minSessionTimeout = min == -1 ? this.tickTime * 2 : min;
        LOG.info("minSessionTimeout set to {}", (Object)this.minSessionTimeout);
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout;
    }

    public void setMaxSessionTimeout(int max) {
        this.maxSessionTimeout = max == -1 ? this.tickTime * 20 : max;
        LOG.info("maxSessionTimeout set to {}", (Object)this.maxSessionTimeout);
    }

    public int getClientPort() {
        return this.serverCnxnFactory != null ? this.serverCnxnFactory.getLocalPort() : -1;
    }

    public int getSecureClientPort() {
        return this.secureServerCnxnFactory != null ? this.secureServerCnxnFactory.getLocalPort() : -1;
    }

    public int getMaxClientCnxnsPerHost() {
        if (this.serverCnxnFactory != null) {
            return this.serverCnxnFactory.getMaxClientCnxnsPerHost();
        }
        if (this.secureServerCnxnFactory != null) {
            return this.secureServerCnxnFactory.getMaxClientCnxnsPerHost();
        }
        return -1;
    }

    public void setTxnLogFactory(FileTxnSnapLog txnLog) {
        this.txnLogFactory = txnLog;
    }

    public FileTxnSnapLog getTxnLogFactory() {
        return this.txnLogFactory;
    }

    public long getTxnLogElapsedSyncTime() {
        return this.txnLogFactory.getTxnLogElapsedSyncTime();
    }

    @Override
    public String getState() {
        return "standalone";
    }

    public void dumpEphemerals(PrintWriter pwriter) {
        this.zkDb.dumpEphemerals(pwriter);
    }

    public Map<Long, Set<String>> getEphemerals() {
        return this.zkDb.getEphemerals();
    }

    public void processConnectRequest(ServerCnxn cnxn, ByteBuffer incomingBuffer) throws IOException {
        int maxSessionTimeout;
        BinaryInputArchive bia = BinaryInputArchive.getArchive(new ByteBufferInputStream(incomingBuffer));
        ConnectRequest connReq = new ConnectRequest();
        connReq.deserialize(bia, "connect");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session establishment request from client " + cnxn.getRemoteSocketAddress() + " client's lastZxid is 0x" + Long.toHexString(connReq.getLastZxidSeen()));
        }
        boolean readOnly = false;
        try {
            readOnly = bia.readBool("readOnly");
            cnxn.isOldClient = false;
        }
        catch (IOException e) {
            LOG.warn("Connection request from old client " + cnxn.getRemoteSocketAddress() + "; will be dropped if server is in r-o mode");
        }
        if (!readOnly && this instanceof ReadOnlyZooKeeperServer) {
            String msg = "Refusing session request for not-read-only client " + cnxn.getRemoteSocketAddress();
            LOG.info(msg);
            throw new ServerCnxn.CloseRequestException(msg);
        }
        if (connReq.getLastZxidSeen() > this.zkDb.dataTree.lastProcessedZxid) {
            String msg = "Refusing session request for client " + cnxn.getRemoteSocketAddress() + " as it has seen zxid 0x" + Long.toHexString(connReq.getLastZxidSeen()) + " our last zxid is 0x" + Long.toHexString(this.getZKDatabase().getDataTreeLastProcessedZxid()) + " client must try another server";
            LOG.info(msg);
            throw new ServerCnxn.CloseRequestException(msg);
        }
        int sessionTimeout = connReq.getTimeOut();
        byte[] passwd = connReq.getPasswd();
        int minSessionTimeout = this.getMinSessionTimeout();
        if (sessionTimeout < minSessionTimeout) {
            sessionTimeout = minSessionTimeout;
        }
        if (sessionTimeout > (maxSessionTimeout = this.getMaxSessionTimeout())) {
            sessionTimeout = maxSessionTimeout;
        }
        cnxn.setSessionTimeout(sessionTimeout);
        cnxn.disableRecv();
        long sessionId = connReq.getSessionId();
        if (sessionId == 0L) {
            long id = this.createSession(cnxn, passwd, sessionTimeout);
            LOG.debug("Client attempting to establish new session: session = 0x{}, zxid = 0x{}, timeout = {}, address = {}", new Object[]{Long.toHexString(id), Long.toHexString(connReq.getLastZxidSeen()), connReq.getTimeOut(), cnxn.getRemoteSocketAddress()});
        } else {
            long clientSessionId = connReq.getSessionId();
            LOG.debug("Client attempting to renew session: session = 0x{}, zxid = 0x{}, timeout = {}, address = {}", new Object[]{Long.toHexString(clientSessionId), Long.toHexString(connReq.getLastZxidSeen()), connReq.getTimeOut(), cnxn.getRemoteSocketAddress()});
            if (this.serverCnxnFactory != null) {
                this.serverCnxnFactory.closeSession(sessionId);
            }
            if (this.secureServerCnxnFactory != null) {
                this.secureServerCnxnFactory.closeSession(sessionId);
            }
            cnxn.setSessionId(sessionId);
            this.reopenSession(cnxn, sessionId, passwd, sessionTimeout);
        }
    }

    public boolean shouldThrottle(long outStandingCount) {
        if (this.getGlobalOutstandingLimit() < this.getInProcess()) {
            return outStandingCount > 0L;
        }
        return false;
    }

    private static boolean shouldRequireClientSaslAuth() {
        return QuorumPeerConfig.isQuorumEnableSasl() && QuorumPeerConfig.isSessionRequireClientSASLAuth();
    }

    private boolean hasCnxSASLAuthenticated(ServerCnxn cnxn) {
        for (Id id : cnxn.getAuthInfo()) {
            if (!id.getScheme().equals("sasl")) continue;
            return true;
        }
        return false;
    }

    public void processPacket(ServerCnxn cnxn, ByteBuffer incomingBuffer) throws IOException {
        ByteBufferInputStream bais = new ByteBufferInputStream(incomingBuffer);
        BinaryInputArchive bia = BinaryInputArchive.getArchive(bais);
        RequestHeader h = new RequestHeader();
        h.deserialize(bia, "header");
        incomingBuffer = incomingBuffer.slice();
        if (h.getType() == 100) {
            LOG.info("got auth packet " + cnxn.getRemoteSocketAddress());
            AuthPacket authPacket = new AuthPacket();
            ByteBufferInputStream.byteBuffer2Record(incomingBuffer, authPacket);
            String scheme = authPacket.getScheme();
            AuthenticationProvider ap = ProviderRegistry.getProvider(scheme);
            KeeperException.Code authReturn = KeeperException.Code.AUTHFAILED;
            if (ap != null) {
                try {
                    authReturn = ap.handleAuthentication(cnxn, authPacket.getAuth());
                }
                catch (RuntimeException e) {
                    LOG.warn("Caught runtime exception from AuthenticationProvider: " + scheme + " due to " + e);
                    authReturn = KeeperException.Code.AUTHFAILED;
                }
            }
            if (authReturn == KeeperException.Code.OK) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication succeeded for scheme: " + scheme);
                }
                LOG.info("auth success " + cnxn.getRemoteSocketAddress());
                ReplyHeader rh = new ReplyHeader(h.getXid(), 0L, KeeperException.Code.OK.intValue());
                cnxn.sendResponse(rh, null, null);
            } else {
                if (ap == null) {
                    LOG.warn("No authentication provider for scheme: " + scheme + " has " + ProviderRegistry.listProviders());
                } else {
                    LOG.warn("Authentication failed for scheme: " + scheme);
                }
                ReplyHeader rh = new ReplyHeader(h.getXid(), 0L, KeeperException.Code.AUTHFAILED.intValue());
                cnxn.sendResponse(rh, null, null);
                cnxn.sendBuffer(ServerCnxnFactory.closeConn);
                cnxn.disableRecv();
            }
            return;
        }
        if (h.getType() == 102) {
            this.processSasl(incomingBuffer, cnxn, h);
        } else if (ZooKeeperServer.shouldRequireClientSaslAuth() && !this.hasCnxSASLAuthenticated(cnxn)) {
            ReplyHeader replyHeader = new ReplyHeader(h.getXid(), 0L, KeeperException.Code.SESSIONCLOSEDREQUIRESASLAUTH.intValue());
            cnxn.sendResponse(replyHeader, null, "response");
            LOG.warn("Sent response, closing non-SASL authenticated connection from {}", (Object)cnxn.getRemoteSocketAddress());
            cnxn.sendCloseSession();
            cnxn.disableRecv();
        } else {
            Request si = new Request(cnxn, cnxn.getSessionId(), h.getXid(), h.getType(), incomingBuffer, cnxn.getAuthInfo());
            si.setOwner(ServerCnxn.me);
            this.setLocalSessionFlag(si);
            this.submitRequest(si);
        }
        cnxn.incrOutstandingRequests(h);
    }

    private void processSasl(ByteBuffer incomingBuffer, ServerCnxn cnxn, RequestHeader requestHeader) throws IOException {
        byte[] responseToken;
        block8: {
            LOG.debug("Responding to client SASL token.");
            GetSASLRequest clientTokenRecord = new GetSASLRequest();
            ByteBufferInputStream.byteBuffer2Record(incomingBuffer, clientTokenRecord);
            byte[] clientToken = clientTokenRecord.getToken();
            LOG.debug("Size of client SASL token: " + clientToken.length);
            responseToken = null;
            try {
                ZooKeeperSaslServer saslServer = cnxn.zooKeeperSaslServer;
                try {
                    responseToken = saslServer.evaluateResponse(clientToken);
                    if (saslServer.isComplete()) {
                        String authorizationID = saslServer.getAuthorizationID();
                        LOG.info("adding SASL authorization for authorizationID: " + authorizationID);
                        cnxn.addAuthInfo(new Id("sasl", authorizationID));
                        if (System.getProperty("zookeeper.superUser") != null && System.getProperty("zookeeper.allowSuperUser") != null && authorizationID.equals(System.getProperty("zookeeper.superUser"))) {
                            cnxn.addAuthInfo(new Id("super", ""));
                        }
                    }
                }
                catch (SaslException e) {
                    LOG.warn("Client {} failed to SASL authenticate: {}", (Object)cnxn.getRemoteSocketAddress(), (Object)e.getMessage());
                    if (!ZooKeeperServer.shouldRequireClientSaslAuth()) {
                        LOG.warn("Maintaining client connection despite SASL authentication failure.");
                        break block8;
                    }
                    int error = KeeperException.Code.SESSIONCLOSEDREQUIRESASLAUTH.intValue();
                    LOG.warn("Closing client connection due to server requires client SASL authentication, but client SASL authentication has failed, or client is not configured with SASL authentication.");
                    ReplyHeader replyHeader = new ReplyHeader(requestHeader.getXid(), 0L, error);
                    cnxn.sendResponse(replyHeader, new SetSASLResponse(null), "response");
                    cnxn.sendCloseSession();
                    cnxn.disableRecv();
                    return;
                }
            }
            catch (NullPointerException e) {
                LOG.error("cnxn.saslServer is null: cnxn object did not initialize its saslServer properly.");
            }
        }
        if (responseToken != null) {
            LOG.debug("Size of server SASL response: " + responseToken.length);
        }
        ReplyHeader replyHeader = new ReplyHeader(requestHeader.getXid(), 0L, KeeperException.Code.OK.intValue());
        SetSASLResponse record = new SetSASLResponse(responseToken);
        cnxn.sendResponse(replyHeader, record, "response");
    }

    public DataTree.ProcessTxnResult processTxn(TxnHeader hdr, Record txn) {
        return this.processTxn(null, hdr, txn);
    }

    public DataTree.ProcessTxnResult processTxn(Request request) {
        return this.processTxn(request, request.getHdr(), request.getTxn());
    }

    private DataTree.ProcessTxnResult processTxn(Request request, TxnHeader hdr, Record txn) {
        int opCode = request != null ? request.type : hdr.getType();
        long sessionId = request != null ? request.sessionId : hdr.getClientId();
        DataTree.ProcessTxnResult rc = hdr != null ? this.getZKDatabase().processTxn(hdr, txn) : new DataTree.ProcessTxnResult();
        if (opCode == -10) {
            if (hdr != null && txn instanceof CreateSessionTxn) {
                CreateSessionTxn cst = (CreateSessionTxn)txn;
                this.sessionTracker.addGlobalSession(sessionId, cst.getTimeOut());
            } else if (request != null && request.isLocalSession()) {
                request.request.rewind();
                int timeout = request.request.getInt();
                request.request.rewind();
                this.sessionTracker.addSession(request.sessionId, timeout);
            } else {
                LOG.warn("*****>>>>> Got " + txn.getClass() + " " + txn.toString());
            }
        } else if (opCode == -11) {
            this.sessionTracker.removeSession(sessionId);
        }
        return rc;
    }

    public Map<Long, Set<Long>> getSessionExpiryMap() {
        return this.sessionTracker.getSessionExpiryMap();
    }

    void registerServerShutdownHandler(ZooKeeperServerShutdownHandler zkShutdownHandler) {
        this.zkShutdownHandler = zkShutdownHandler;
    }

    static {
        Environment.logEnv("Server environment:", LOG);
        ok = new Exception("No prob");
    }

    static class ChangeRecord {
        long zxid;
        String path;
        StatPersisted stat;
        int childCount;
        List<ACL> acl;

        ChangeRecord(long zxid, String path, StatPersisted stat, int childCount, List<ACL> acl) {
            this.zxid = zxid;
            this.path = path;
            this.stat = stat;
            this.childCount = childCount;
            this.acl = acl;
        }

        ChangeRecord duplicate(long zxid) {
            StatPersisted stat = new StatPersisted();
            if (this.stat != null) {
                DataTree.copyStatPersisted(this.stat, stat);
            }
            return new ChangeRecord(zxid, this.path, stat, this.childCount, this.acl == null ? new ArrayList<ACL>() : new ArrayList<ACL>(this.acl));
        }
    }

    public static class MissingSessionException
    extends IOException {
        private static final long serialVersionUID = 7467414635467261007L;

        public MissingSessionException(String msg) {
            super(msg);
        }
    }

    protected static enum State {
        INITIAL,
        RUNNING,
        SHUTDOWN,
        ERROR;

    }
}

