/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ViewFileSystemOverloadScheme;
import org.apache.hadoop.fs.viewfs.ViewFsTestSetup;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestViewFileSystemOverloadSchemeLocalFileSystem {
    private static final String FILE = "file";
    private static final Log LOG = LogFactory.getLog(TestViewFileSystemOverloadSchemeLocalFileSystem.class);
    private FileSystem fsTarget;
    private Configuration conf;
    private Path targetTestRoot;
    private FileSystemTestHelper fileSystemTestHelper = new FileSystemTestHelper();

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.set(String.format("fs.%s.impl", FILE), ViewFileSystemOverloadScheme.class.getName());
        this.conf.set(String.format("fs.viewfs.overload.scheme.target.%s.impl", FILE), LocalFileSystem.class.getName());
        this.fsTarget = new LocalFileSystem();
        this.fsTarget.initialize(new URI("file:///"), this.conf);
        this.targetTestRoot = this.fileSystemTestHelper.getAbsoluteTestRootPath(this.fsTarget);
        this.fsTarget.delete(this.targetTestRoot, true);
        this.fsTarget.mkdirs(this.targetTestRoot);
    }

    void addMountLinks(String mountTable, String[] sources, String[] targets, Configuration config) throws IOException, URISyntaxException {
        ViewFsTestSetup.addMountLinksToConf(mountTable, sources, targets, config);
    }

    @Test
    public void testLocalTargetLinkWriteSimple() throws IOException, URISyntaxException {
        LOG.info((Object)"Starting testLocalTargetLinkWriteSimple");
        String testString = "Hello Local!...";
        Path lfsRoot = new Path("/lfsRoot");
        this.addMountLinks(null, new String[]{lfsRoot.toString()}, new String[]{this.targetTestRoot + "/local"}, this.conf);
        try (FileSystem lViewFs = FileSystem.get((URI)URI.create("file:///"), (Configuration)this.conf);){
            Path testPath = new Path(lfsRoot, "test.txt");
            try (FSDataOutputStream fsDos = lViewFs.create(testPath);){
                fsDos.writeUTF("Hello Local!...");
            }
            try (FSDataInputStream lViewIs = lViewFs.open(testPath);){
                Assert.assertEquals((Object)"Hello Local!...", (Object)lViewIs.readUTF());
            }
        }
    }

    @Test
    public void testLocalFsCreateAndDelete() throws Exception {
        LOG.info((Object)"Starting testLocalFsCreateAndDelete");
        this.addMountLinks("mt", new String[]{"/lfsroot"}, new String[]{this.targetTestRoot + "/wd2"}, this.conf);
        URI mountURI = URI.create("file://mt/");
        try (FileSystem lViewFS = FileSystem.get((URI)mountURI, (Configuration)this.conf);){
            Path testPath = new Path(mountURI.toString() + "/lfsroot/test");
            lViewFS.createNewFile(testPath);
            Assert.assertTrue((boolean)lViewFS.exists(testPath));
            lViewFS.delete(testPath, true);
            Assert.assertFalse((boolean)lViewFS.exists(testPath));
        }
    }

    @Test
    public void testLocalFsLinkSlashMerge() throws Exception {
        LOG.info((Object)"Starting testLocalFsLinkSlashMerge");
        this.addMountLinks("mt", new String[]{"linkMergeSlash"}, new String[]{this.targetTestRoot + "/wd2"}, this.conf);
        URI mountURI = URI.create("file://mt/");
        try (FileSystem lViewFS = FileSystem.get((URI)mountURI, (Configuration)this.conf);){
            Path fileOnRoot = new Path(mountURI.toString() + "/NewFile");
            lViewFS.createNewFile(fileOnRoot);
            Assert.assertTrue((boolean)lViewFS.exists(fileOnRoot));
        }
    }

    @Test(expected=IOException.class)
    public void testLocalFsLinkSlashMergeWithOtherMountLinks() throws Exception {
        LOG.info((Object)"Starting testLocalFsLinkSlashMergeWithOtherMountLinks");
        this.addMountLinks("mt", new String[]{"/lfsroot", "linkMergeSlash"}, new String[]{this.targetTestRoot + "/wd2", this.targetTestRoot + "/wd2"}, this.conf);
        URI mountURI = URI.create("file://mt/");
        FileSystem.get((URI)mountURI, (Configuration)this.conf);
        Assert.fail((String)"A merge slash cannot be configured with other mount links.");
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.fsTarget) {
            this.fsTarget.delete(this.fileSystemTestHelper.getTestRootPath(this.fsTarget), true);
            this.fsTarget.close();
        }
    }

    public Path getTestRoot() {
        return this.targetTestRoot;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

