/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.ApplicationId;

public class TargetApplications {
    private ApplicationId currentAppId;
    private Map<ApplicationId, Set<String>> allApps;

    public TargetApplications(ApplicationId currentApplicationId, Set<ApplicationId> allApplicationIds) {
        this.currentAppId = currentApplicationId;
        this.allApps = new HashMap<ApplicationId, Set<String>>();
        if (allApplicationIds != null) {
            allApplicationIds.forEach(appId -> this.allApps.put((ApplicationId)appId, (Set<String>)ImmutableSet.of()));
        }
    }

    public TargetApplications(ApplicationId currentApplicationId, Map<ApplicationId, Set<String>> allApplicationIds) {
        this.currentAppId = currentApplicationId;
        this.allApps = allApplicationIds;
    }

    public ApplicationId getCurrentApplicationId() {
        return this.currentAppId;
    }

    public Set<ApplicationId> getAllApplicationIds() {
        return this.allApps == null ? ImmutableSet.of() : this.allApps.keySet();
    }

    public Set<ApplicationId> getOtherApplicationIds() {
        if (this.getAllApplicationIds() == null || this.getAllApplicationIds().isEmpty()) {
            return ImmutableSet.of();
        }
        return this.getAllApplicationIds().stream().filter(appId -> !appId.equals((Object)this.getCurrentApplicationId())).collect(Collectors.toSet());
    }

    public Set<ApplicationId> getApplicationIdsByTag(String applicationTag) {
        HashSet<ApplicationId> result = new HashSet<ApplicationId>();
        if (Strings.isNullOrEmpty((String)applicationTag) || this.allApps == null) {
            return result;
        }
        for (Map.Entry<ApplicationId, Set<String>> app : this.allApps.entrySet()) {
            if (app.getValue() == null || !app.getValue().contains(applicationTag)) continue;
            result.add(app.getKey());
        }
        return result;
    }
}

