/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.nativetask.Command;
import org.apache.hadoop.mapred.nativetask.CommandDispatcher;
import org.apache.hadoop.mapred.nativetask.DataChannel;
import org.apache.hadoop.mapred.nativetask.DataReceiver;
import org.apache.hadoop.mapred.nativetask.INativeHandler;
import org.apache.hadoop.mapred.nativetask.NativeRuntime;
import org.apache.hadoop.mapred.nativetask.buffer.BufferType;
import org.apache.hadoop.mapred.nativetask.buffer.InputBuffer;
import org.apache.hadoop.mapred.nativetask.buffer.OutputBuffer;
import org.apache.hadoop.mapred.nativetask.util.ConfigUtil;
import org.apache.hadoop.mapred.nativetask.util.ReadWriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NativeBatchProcessor
implements INativeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NativeBatchProcessor.class);
    private final String nativeHandlerName;
    private long nativeHandlerAddr;
    private boolean isInputFinished = false;
    private ByteBuffer rawOutputBuffer;
    private ByteBuffer rawInputBuffer;
    private InputBuffer in;
    private OutputBuffer out;
    private CommandDispatcher commandDispatcher;
    private DataReceiver dataReceiver;

    public static INativeHandler create(String nativeHandlerName, Configuration conf, DataChannel channel) throws IOException {
        int bufferSize = conf.getInt("native.processor.buffer.kb", 1024) * 1024;
        LOG.info("NativeHandler: direct buffer size: " + bufferSize);
        OutputBuffer out = null;
        InputBuffer in = null;
        switch (channel) {
            case IN: {
                in = new InputBuffer(BufferType.DIRECT_BUFFER, bufferSize);
                break;
            }
            case OUT: {
                out = new OutputBuffer(BufferType.DIRECT_BUFFER, bufferSize);
                break;
            }
            case INOUT: {
                in = new InputBuffer(BufferType.DIRECT_BUFFER, bufferSize);
                out = new OutputBuffer(BufferType.DIRECT_BUFFER, bufferSize);
                break;
            }
        }
        NativeBatchProcessor handler = new NativeBatchProcessor(nativeHandlerName, in, out);
        handler.init(conf);
        return handler;
    }

    protected NativeBatchProcessor(String nativeHandlerName, InputBuffer input, OutputBuffer output) throws IOException {
        this.nativeHandlerName = nativeHandlerName;
        if (null != input) {
            this.in = input;
            this.rawInputBuffer = input.getByteBuffer();
        }
        if (null != output) {
            this.out = output;
            this.rawOutputBuffer = output.getByteBuffer();
        }
    }

    @Override
    public void setCommandDispatcher(CommandDispatcher handler) {
        this.commandDispatcher = handler;
    }

    @Override
    public void init(Configuration conf) throws IOException {
        this.nativeHandlerAddr = NativeRuntime.createNativeObject(this.nativeHandlerName);
        if (this.nativeHandlerAddr == 0L) {
            throw new RuntimeException("Native object create failed, class: " + this.nativeHandlerName);
        }
        this.setupHandler(this.nativeHandlerAddr, ConfigUtil.toBytes(conf));
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.nativeHandlerAddr != 0L) {
            NativeRuntime.releaseNativeObject(this.nativeHandlerAddr);
            this.nativeHandlerAddr = 0L;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.in});
        this.in = null;
    }

    @Override
    public long getNativeHandler() {
        return this.nativeHandlerAddr;
    }

    @Override
    public ReadWriteBuffer call(Command command, ReadWriteBuffer parameter) throws IOException {
        byte[] bytes = this.nativeCommand(this.nativeHandlerAddr, command.id(), null == parameter ? null : parameter.getBuff());
        ReadWriteBuffer result = new ReadWriteBuffer(bytes);
        result.setWritePoint(bytes.length);
        return result;
    }

    @Override
    public void sendData() throws IOException {
        this.nativeProcessInput(this.nativeHandlerAddr, this.rawOutputBuffer.position());
        this.rawOutputBuffer.position(0);
    }

    @Override
    public void finishSendData() throws IOException {
        if (null == this.rawOutputBuffer || this.isInputFinished) {
            return;
        }
        this.sendData();
        this.nativeFinish(this.nativeHandlerAddr);
        this.isInputFinished = true;
    }

    private byte[] sendCommandToJava(int command, byte[] data) throws IOException {
        try {
            Command cmd = new Command(command);
            ReadWriteBuffer param = null;
            if (null != data) {
                param = new ReadWriteBuffer();
                param.reset(data);
                param.setWritePoint(data.length);
            }
            if (null != this.commandDispatcher) {
                ReadWriteBuffer result = null;
                result = this.commandDispatcher.onCall(cmd, param);
                if (null != result) {
                    return result.getBuff();
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    private void flushOutput(int length) throws IOException {
        if (null != this.rawInputBuffer) {
            this.rawInputBuffer.position(0);
            this.rawInputBuffer.limit(length);
            if (null != this.dataReceiver) {
                try {
                    this.dataReceiver.receiveData();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }
    }

    private static native void InitIDs();

    private native void setupHandler(long var1, byte[][] var3);

    private native void nativeProcessInput(long var1, int var3);

    private native void nativeFinish(long var1);

    private native byte[] nativeCommand(long var1, int var3, byte[] var4);

    private native void nativeLoadData(long var1);

    protected void finishOutput() {
    }

    @Override
    public InputBuffer getInputBuffer() {
        return this.in;
    }

    @Override
    public OutputBuffer getOutputBuffer() {
        return this.out;
    }

    @Override
    public void loadData() throws IOException {
        this.nativeLoadData(this.nativeHandlerAddr);
    }

    @Override
    public void setDataReceiver(DataReceiver handler) {
        this.dataReceiver = handler;
    }

    @Override
    public String name() {
        return this.nativeHandlerName;
    }

    static {
        if (NativeRuntime.isNativeLibraryLoaded()) {
            NativeBatchProcessor.InitIDs();
        }
    }
}

