/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.PermissionNotMatchException;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.UsersACLsManager;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;

public class SecureIOUtils {
    private static final boolean skipSecurity;
    private static final FileSystem rawFilesystem;

    public static RandomAccessFile openForRandomRead(File f, String mode, String expectedOwner, String expectedGroup) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return new RandomAccessFile(f, mode);
        }
        return SecureIOUtils.forceSecureOpenForRandomRead(f, mode, expectedOwner, expectedGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected static RandomAccessFile forceSecureOpenForRandomRead(File f, String mode, String expectedOwner, String expectedGroup) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(f, mode);
        boolean success = false;
        try {
            NativeIO.POSIX.Stat stat = NativeIO.POSIX.getFstat(raf.getFD());
            SecureIOUtils.checkStat(f, stat.getOwner(), stat.getGroup(), expectedOwner, expectedGroup);
            success = true;
            RandomAccessFile randomAccessFile = raf;
            return randomAccessFile;
        }
        finally {
            if (!success) {
                raf.close();
            }
        }
    }

    public static FSDataInputStream openFSDataInputStream(File file, String expectedOwner, String expectedGroup) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return rawFilesystem.open(new Path(file.getAbsolutePath()));
        }
        return SecureIOUtils.forceSecureOpenFSDataInputStream(file, expectedOwner, expectedGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected static FSDataInputStream forceSecureOpenFSDataInputStream(File file, String expectedOwner, String expectedGroup) throws IOException {
        FSDataInputStream in = rawFilesystem.open(new Path(file.getAbsolutePath()));
        boolean success = false;
        try {
            NativeIO.POSIX.Stat stat = NativeIO.POSIX.getFstat(in.getFileDescriptor());
            SecureIOUtils.checkStat(file, stat.getOwner(), stat.getGroup(), expectedOwner, expectedGroup);
            success = true;
            FSDataInputStream fSDataInputStream = in;
            return fSDataInputStream;
        }
        finally {
            if (!success) {
                in.close();
            }
        }
    }

    public static FileInputStream openForRead(File f, String expectedOwner, String expectedGroup) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return new FileInputStream(f);
        }
        return SecureIOUtils.forceSecureOpenForRead(f, expectedOwner, expectedGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected static FileInputStream forceSecureOpenForRead(File f, String expectedOwner, String expectedGroup) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        boolean success = false;
        try {
            NativeIO.POSIX.Stat stat = NativeIO.POSIX.getFstat(fis.getFD());
            SecureIOUtils.checkStat(f, stat.getOwner(), stat.getGroup(), expectedOwner, expectedGroup);
            success = true;
            FileInputStream fileInputStream = fis;
            return fileInputStream;
        }
        finally {
            if (!success) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileOutputStream insecureCreateForWrite(File f, int permissions) throws IOException {
        if (f.exists()) {
            throw new AlreadyExistsException("File " + f + " already exists");
        }
        FileOutputStream fos = new FileOutputStream(f);
        boolean success = false;
        try {
            rawFilesystem.setPermission(new Path(f.getAbsolutePath()), new FsPermission((short)permissions));
            success = true;
            FileOutputStream fileOutputStream = fos;
            return fileOutputStream;
        }
        finally {
            if (!success) {
                fos.close();
            }
        }
    }

    public static FileOutputStream createForWrite(File f, int permissions) throws IOException {
        if (skipSecurity) {
            return SecureIOUtils.insecureCreateForWrite(f, permissions);
        }
        return NativeIO.getCreateForWriteFileOutputStream(f, permissions);
    }

    private static void checkStat(File f, String owner, String group, String expectedOwner, String expectedGroup) throws IOException {
        boolean success = true;
        if (expectedOwner != null && !expectedOwner.equals(owner)) {
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser(expectedOwner);
            if (Path.WINDOWS) {
                String adminsGroupString = "Administrators";
                success = owner.equals("Administrators") && ugi.getGroups().contains("Administrators");
            } else if (!SecureIOUtils.checkIfUserYarnAdmin(expectedOwner, ugi.getGroupNames()) && !SecureIOUtils.checkIfUsersACLMapping(expectedOwner, owner)) {
                success = false;
            }
        }
        if (!success) {
            throw new PermissionNotMatchException("Owner '" + owner + "' for path " + f + " did not match expected owner '" + expectedOwner + "'");
        }
    }

    private static boolean checkIfUserYarnAdmin(String user, String[] expectedGroups) {
        Configuration conf = new Configuration();
        if (conf.getBoolean("yarn.acl.enable", false)) {
            AccessControlList accessControlList = new AccessControlList(conf.get("yarn.admin.acl"));
            if (accessControlList.isAllAllowed() || accessControlList.getUsers().contains(user)) {
                return true;
            }
            for (String expectedGroup : expectedGroups) {
                if (!accessControlList.getGroups().contains(expectedGroup)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkIfUsersACLMapping(String user, String owner) {
        Configuration conf = new Configuration();
        UsersACLsManager usersAclsManager = new UsersACLsManager(conf);
        return usersAclsManager.isUsersACLEnable() && usersAclsManager.checkUserAccess(user, owner);
    }

    static {
        boolean shouldBeSecure = UserGroupInformation.isSecurityEnabled();
        boolean canBeSecure = NativeIO.isAvailable();
        if (!canBeSecure && shouldBeSecure) {
            throw new RuntimeException("Secure IO is not possible without native code extensions.");
        }
        try {
            rawFilesystem = FileSystem.getLocal(new Configuration()).getRaw();
        }
        catch (IOException ie) {
            throw new RuntimeException("Couldn't obtain an instance of RawLocalFileSystem.");
        }
        skipSecurity = !canBeSecure;
    }

    public static class AlreadyExistsException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public AlreadyExistsException(String msg) {
            super(msg);
        }

        public AlreadyExistsException(Throwable cause) {
            super(cause);
        }
    }
}

