/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import org.ojalgo.access.IndexMapper;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.series.TreeSeries;
import org.ojalgo.series.primitive.ExplicitTimeSeries;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;

public final class CalendarDateSeries<N extends Number>
extends TreeSeries<CalendarDate, N, CalendarDateSeries<N>>
implements BasicSeries.NaturallySequenced<CalendarDate, N> {
    private final CalendarDateUnit myResolution;
    private final IndexMapper<CalendarDate> myMapper;

    public CalendarDateSeries() {
        this(CalendarDateUnit.MILLIS);
    }

    public CalendarDateSeries(CalendarDateUnit resolution) {
        this.myResolution = resolution;
        this.myMapper = new IndexMapper<CalendarDate>(){

            @Override
            public long toIndex(CalendarDate key) {
                return key.toTimeInMillis(CalendarDateSeries.this.myResolution);
            }

            @Override
            public CalendarDate toKey(long index) {
                return new CalendarDate(index);
            }
        };
    }

    private CalendarDateSeries(Map<? extends CalendarDate, ? extends N> map) {
        super(map);
        this.myResolution = null;
        this.myMapper = null;
    }

    private CalendarDateSeries(SortedMap<CalendarDate, ? extends N> sortedMap) {
        super(sortedMap);
        this.myResolution = null;
        this.myMapper = null;
    }

    CalendarDateSeries(SortedMap<CalendarDate, ? extends N> sortedMap, CalendarDateUnit resolution, IndexMapper<CalendarDate> mapper) {
        super(sortedMap);
        this.myResolution = resolution;
        this.myMapper = mapper;
    }

    @Override
    public double doubleValue(long key) {
        return this.doubleValue(CalendarDate.make(key, this.myResolution));
    }

    @Override
    public N get(CalendarDate key) {
        return (N)((Number)this.get((Object)key.filter(this.myResolution)));
    }

    @Override
    public N get(long key) {
        return this.get(CalendarDate.make(key, this.myResolution));
    }

    public long getAverageStepSize() {
        return (((CalendarDate)this.lastKey()).millis - ((CalendarDate)this.firstKey()).millis) / (long)(this.size() - 1);
    }

    public long[] getPrimitiveKeys() {
        long[] retVal = new long[this.size()];
        int i = 0;
        for (CalendarDate tmpKey : this.keySet()) {
            retVal[i] = tmpKey.millis;
            ++i;
        }
        return retVal;
    }

    public ExplicitTimeSeries getPrimitiveTimeSeries() {
        return new ExplicitTimeSeries(this.getPrimitiveKeys(), this.asPrimitive());
    }

    public CalendarDateUnit getResolution() {
        return this.myResolution;
    }

    public CalendarDateSeries<N> headMap(CalendarDate newToKey) {
        SortedMap tmpMap = super.headMap(newToKey);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution(), this.myMapper);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    public CalendarDateSeries<N> headMap(CalendarDate newToKey, boolean newInclusive) {
        NavigableMap tmpMap = super.headMap(newToKey, newInclusive);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution(), this.myMapper);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    @Override
    public IndexMapper<CalendarDate> mapper() {
        return this.myMapper;
    }

    @Override
    public CalendarDate nextKey() {
        return ((CalendarDate)this.lastKey()).step(1, this.myResolution);
    }

    @Override
    public N put(Calendar key, N value) {
        return (N)((Number)super.put(CalendarDate.make(key, this.myResolution), value));
    }

    @Override
    public double put(CalendarDate key, double value) {
        Double tmpValue = value;
        Number tmpOldValue = super.put(key.filter(this.myResolution), tmpValue);
        if (tmpOldValue != null) {
            return tmpOldValue.doubleValue();
        }
        return Double.NaN;
    }

    @Override
    public N put(CalendarDate key, N value) {
        return (N)((Number)super.put(key.filter(this.myResolution), value));
    }

    @Override
    public N put(Date key, N value) {
        return (N)((Number)super.put(CalendarDate.make(key, this.myResolution), value));
    }

    @Override
    public double put(long key, double value) {
        return this.put(CalendarDate.make(key, this.myResolution), value);
    }

    @Override
    public N put(long key, N value) {
        return (N)((Number)super.put(CalendarDate.make(key, this.myResolution), value));
    }

    @Override
    public void putAll(Map<? extends CalendarDate, ? extends N> data) {
        for (Map.Entry<CalendarDate, N> tmpEntry : data.entrySet()) {
            this.put(tmpEntry.getKey(), (N)((Number)tmpEntry.getValue()));
        }
    }

    public CalendarDateSeries<N> resample(CalendarDate firstKey, CalendarDate lastKey, CalendarDateUnit resolution) {
        CalendarDateSeries<N> retVal = new CalendarDateSeries<N>(resolution);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        CalendarDateSeries<N> tmpSubMap = this.subMap(firstKey, true, lastKey, true);
        retVal.putAll(tmpSubMap);
        return retVal;
    }

    public CalendarDateSeries<N> resample(CalendarDateUnit resolution) {
        CalendarDateSeries<N> retVal = new CalendarDateSeries<N>(resolution);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        retVal.putAll(this);
        return retVal;
    }

    @Override
    public CalendarDate step(CalendarDate key) {
        return key.step(1, this.myResolution);
    }

    public CalendarDateSeries<N> subMap(CalendarDate fromKey, boolean inclusiveFromKey, CalendarDate toKey, boolean inclusiveToKey) {
        NavigableMap tmpMap = super.subMap(fromKey, inclusiveFromKey, toKey, inclusiveToKey);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution(), this.myMapper);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    public CalendarDateSeries<N> subMap(CalendarDate fromKey, CalendarDate keyLimit) {
        SortedMap tmpMap = super.subMap(fromKey, keyLimit);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution(), this.myMapper);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    public CalendarDateSeries<N> tailMap(CalendarDate fromKey) {
        SortedMap tmpMap = super.tailMap(fromKey);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution(), this.myMapper);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    public CalendarDateSeries<N> tailMap(CalendarDate fromKey, boolean inclusive) {
        NavigableMap tmpMap = super.tailMap(fromKey, inclusive);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution(), this.myMapper);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    @Override
    public String toString() {
        StringBuilder retVal = this.toStringFirstPart();
        retVal.append(this.myResolution);
        retVal.append('\u00a0');
        this.appendLastPartToString(retVal);
        return retVal.toString();
    }
}

