/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ua.DSTU4145NamedCurves;
import org.bouncycastle.asn1.ua.DSTU4145Params;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DSTU4145Parameters {
    private final byte[] dke;
    private final ECDomainParameters domainParameters;

    public DSTU4145Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this(aSN1ObjectIdentifier, DSTU4145Params.getDefaultDKE());
    }

    public DSTU4145Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) {
        this(DSTU4145Parameters.getDomainParameters(aSN1ObjectIdentifier), byArray);
    }

    public DSTU4145Parameters(ECDomainParameters eCDomainParameters) {
        this(eCDomainParameters, DSTU4145Params.getDefaultDKE());
    }

    public DSTU4145Parameters(ECDomainParameters eCDomainParameters, byte[] byArray) {
        this.domainParameters = eCDomainParameters;
        this.dke = Arrays.clone(byArray);
    }

    public byte[] getDKE() {
        return Arrays.clone(this.dke);
    }

    public ECDomainParameters getDomainParameters() {
        return this.domainParameters;
    }

    private static ECDomainParameters getDomainParameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        ECDomainParameters eCDomainParameters = DSTU4145NamedCurves.getByOID(aSN1ObjectIdentifier);
        return new NamedECDomainParameters(aSN1ObjectIdentifier, eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DSTU4145Parameters) {
            return this.domainParameters.equals(((DSTU4145Parameters)object).domainParameters) && Arrays.areEqual(this.dke, ((DSTU4145Parameters)object).dke);
        }
        return false;
    }

    public int hashCode() {
        return this.domainParameters.hashCode() + 37 * Arrays.hashCode(this.dke);
    }
}

