/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class CertificateVerify {
    private final int algorithm;
    private final byte[] signature;

    public CertificateVerify(int algorithm, byte[] signature) {
        if (!TlsUtils.isValidUint16(algorithm)) {
            throw new IllegalArgumentException("'algorithm'");
        }
        if (signature == null) {
            throw new NullPointerException("'signature' cannot be null");
        }
        this.algorithm = algorithm;
        this.signature = signature;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint16(this.algorithm, output);
        TlsUtils.writeOpaque16(this.signature, output);
    }

    public static CertificateVerify parse(TlsContext context, InputStream input) throws IOException {
        if (!TlsUtils.isTLSv13(context)) {
            throw new IllegalStateException();
        }
        int algorithm = TlsUtils.readUint16(input);
        byte[] signature = TlsUtils.readOpaque16(input);
        return new CertificateVerify(algorithm, signature);
    }
}

