/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.BlockAliasMap;
import org.apache.hadoop.hdfs.server.namenode.BlockResolver;
import org.apache.hadoop.hdfs.server.namenode.FSTreeWalk;
import org.apache.hadoop.hdfs.server.namenode.ImageWriter;
import org.apache.hadoop.hdfs.server.namenode.TreePath;
import org.apache.hadoop.hdfs.server.namenode.UGIResolver;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class FileSystemImage
implements Tool {
    private Configuration conf;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        FileSystem.setDefaultUri((Configuration)conf, (String)new File(".").toURI().toString());
    }

    protected void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("fs2img [OPTIONS] URI", new Options());
        formatter.setSyntaxPrefix("");
        formatter.printHelp("Options", FileSystemImage.options());
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
    }

    static Options options() {
        Options options = new Options();
        options.addOption("o", "outdir", true, "Output directory");
        options.addOption("u", "ugiclass", true, "UGI resolver class");
        options.addOption("b", "blockclass", true, "Block output class");
        options.addOption("i", "blockidclass", true, "Block resolver class");
        options.addOption("c", "cachedirs", true, "Max active dirents");
        options.addOption("cid", "clusterID", true, "Cluster ID");
        options.addOption("bpid", "blockPoolID", true, "Block Pool ID");
        options.addOption("h", "help", false, "Print usage");
        return options;
    }

    public int run(String[] argv) throws Exception {
        CommandLine cmd;
        Options options = FileSystemImage.options();
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, argv);
        }
        catch (ParseException e) {
            System.out.println("Error parsing command-line options: " + e.getMessage());
            this.printUsage();
            return -1;
        }
        if (cmd.hasOption("h")) {
            this.printUsage();
            return -1;
        }
        ImageWriter.Options opts = (ImageWriter.Options)ReflectionUtils.newInstance(ImageWriter.Options.class, (Configuration)this.getConf());
        block25: for (Option o : cmd.getOptions()) {
            switch (o.getOpt()) {
                case "o": {
                    opts.output(o.getValue());
                    continue block25;
                }
                case "u": {
                    opts.ugi(Class.forName(o.getValue()).asSubclass(UGIResolver.class));
                    continue block25;
                }
                case "b": {
                    opts.blocks(Class.forName(o.getValue()).asSubclass(BlockAliasMap.class));
                    continue block25;
                }
                case "i": {
                    opts.blockIds(Class.forName(o.getValue()).asSubclass(BlockResolver.class));
                    continue block25;
                }
                case "c": {
                    opts.cache(Integer.parseInt(o.getValue()));
                    continue block25;
                }
                case "cid": {
                    opts.clusterID(o.getValue());
                    continue block25;
                }
                case "bpid": {
                    opts.blockPoolID(o.getValue());
                    continue block25;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown option: " + o.getOpt());
                }
            }
        }
        String[] rem = cmd.getArgs();
        if (rem.length != 1) {
            this.printUsage();
            return -1;
        }
        try (ImageWriter w = new ImageWriter(opts);){
            for (TreePath e : new FSTreeWalk(new Path(rem[0]), this.getConf())) {
                w.accept(e);
            }
        }
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        int ret = ToolRunner.run((Tool)new FileSystemImage(), (String[])argv);
        System.exit(ret);
    }
}

