/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.derived.histogram;

import java.util.Objects;
import java.util.Spliterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Striped<T> {
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final ThreadLocal<Integer> threadHash = ThreadLocal.withInitial(() -> 0);
    private final AtomicInteger stripeGuard = new AtomicInteger();
    private final Supplier<T> constructor;
    private final Cell<T> base;
    private volatile Cell<T>[] cells;

    static final int advanceProbe(int probe) {
        probe ^= probe << 13;
        probe ^= probe >>> 17;
        probe ^= probe << 5;
        threadHash.set(probe);
        return probe;
    }

    public Striped(Supplier<T> constructor) {
        this.constructor = constructor;
        this.base = new Cell<T>(constructor.get());
    }

    protected final Stream<T> stream() {
        Cell<T>[] cs = this.cells;
        if (cs == null) {
            return Stream.of(this.base).map(cell -> cell.entity);
        }
        return Stream.concat(Stream.of(this.base), StreamSupport.stream(new CellSpliterator<T>(this.cells), false)).map(cell -> cell.entity);
    }

    protected final void process(Consumer<T> process) {
        Cell<T>[] cs = this.cells;
        if (cs != null || !this.base.process(process)) {
            Cell<T> cell = null;
            boolean contended = false;
            int hash = threadHash.get();
            if (cs == null || (cell = cs[hash & cs.length - 1]) == null || (contended = !cell.process(process))) {
                this.processWithContention(hash, process, contended);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processWithContention(int hash, Consumer<T> process, boolean contended) {
        if (hash == 0) {
            hash = ThreadLocalRandom.current().nextInt();
            Striped.threadHash.set(hash);
            contended = false;
        }
        collide = false;
        while (true) lbl-1000:
        // 8 sources

        {
            cs = this.cells;
            if (this.cells != null) {
                n = cs.length;
                cell = cs[n - 1 & hash];
                if (cell == null) {
                    if (this.stripeGuard.get() == 0) {
                        r = new Cell<T>(this.constructor.get());
                        r.process(process);
                        if (this.stripeGuard.compareAndSet(0, 1)) {
                            try {
                                rereadCells = this.cells;
                                if (this.cells == null || (m = rereadCells.length) <= 0 || rereadCells[j = rereadCells.length - 1 & hash] != null) ** GOTO lbl-1000
                                rereadCells[j] = r;
                                return;
                            }
                            finally {
                                this.stripeGuard.set(0);
                            }
                            continue;
                        }
                    }
                    collide = false;
                } else if (contended) {
                    contended = false;
                } else {
                    if (cell.process(process)) {
                        return;
                    }
                    if (n >= Striped.NCPU || this.cells != cs) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.stripeGuard.compareAndSet(0, 1)) {
                        try {
                            if (this.cells == cs) {
                                rs = new Cell[cs.length << 1];
                                for (i = 0; i < cs.length; ++i) {
                                    rs[i] = cs[i];
                                }
                                this.cells = rs;
                            }
                        }
                        finally {
                            this.stripeGuard.set(0);
                        }
                        collide = false;
                        continue;
                    }
                }
                hash = Striped.advanceProbe(hash);
                continue;
            }
            if (this.stripeGuard.get() == 0 && this.cells == null && this.stripeGuard.compareAndSet(0, 1)) {
                try {
                    if (this.cells != null) ** GOTO lbl-1000
                    newCells = new Cell[2];
                    cell = new Cell<T>(this.constructor.get());
                    cell.process(process);
                    newCells[hash & 1] = cell;
                    this.cells = newCells;
                    return;
                }
                finally {
                    this.stripeGuard.set(0);
                }
                continue;
            }
            if (this.base.process(process)) break;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append(":").append(System.lineSeparator()).append("\tBase: ").append(this.base).append(System.lineSeparator());
        for (Cell<T> cell : this.cells) {
            if (cell == null) continue;
            builder = builder.append("\tCell: ").append(cell).append(System.lineSeparator());
        }
        return builder.toString();
    }

    static final class CellSpliterator<T>
    implements Spliterator<Cell<T>> {
        private final Cell<T>[] array;
        private int index;
        private final int limit;

        public CellSpliterator(Cell<T>[] array) {
            this(array, 0, array.length);
        }

        private CellSpliterator(Cell<T>[] array, int origin, int fence) {
            this.array = array;
            this.index = origin;
            this.limit = fence;
        }

        @Override
        public Spliterator<Cell<T>> trySplit() {
            int midpoint = this.index + this.limit >>> 1;
            if (this.index >= midpoint) {
                return null;
            }
            int splitIndex = this.index;
            this.index = midpoint;
            return new CellSpliterator<T>(this.array, splitIndex, midpoint);
        }

        @Override
        public void forEachRemaining(Consumer<? super Cell<T>> action) {
            Objects.requireNonNull(action);
            for (int i = this.index; i < this.limit; ++i) {
                Cell<T> cell = this.array[i];
                if (cell == null) continue;
                CellSpliterator.visitCell(cell, action);
            }
            this.index = this.limit;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Cell<T>> action) {
            Objects.requireNonNull(action);
            while (this.index >= 0 && this.index < this.limit) {
                Cell<T> cell;
                if ((cell = this.array[this.index++]) == null) continue;
                CellSpliterator.visitCell(cell, action);
                return true;
            }
            return false;
        }

        private static <T> void visitCell(Cell<T> cell, Consumer<? super Cell<T>> action) {
            while (!Cell.GUARD_UPDATER.compareAndSet(cell, 0, 1)) {
            }
            try {
                action.accept(cell);
            }
            finally {
                Cell.GUARD_UPDATER.set(cell, 0);
            }
        }

        @Override
        public long estimateSize() {
            return this.limit - this.index;
        }

        @Override
        public int characteristics() {
            return 16448;
        }
    }

    static final class Cell<T> {
        static final AtomicIntegerFieldUpdater<Cell> GUARD_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Cell.class, "guard");
        final T entity;
        volatile int guard;

        Cell(T value) {
            this.entity = Objects.requireNonNull(value);
        }

        final boolean process(Consumer<T> process) {
            if (GUARD_UPDATER.compareAndSet(this, 0, 1)) {
                try {
                    process.accept(this.entity);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    GUARD_UPDATER.set(this, 0);
                }
            }
            return false;
        }

        public String toString() {
            while (!GUARD_UPDATER.compareAndSet(this, 0, 1)) {
            }
            try {
                String string = this.entity.toString();
                return string;
            }
            finally {
                GUARD_UPDATER.set(this, 0);
            }
        }
    }
}

