/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.tls.crypto.TlsDecodeResult;
import org.bouncycastle.tls.crypto.TlsEncodeResult;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Tls13NullCipher
implements TlsCipher {
    private final TlsCryptoParameters cryptoParams;
    private final TlsHMAC readHMAC;
    private final TlsHMAC writeHMAC;
    private final byte[] readNonce;
    private final byte[] writeNonce;

    public Tls13NullCipher(TlsCryptoParameters tlsCryptoParameters, TlsHMAC tlsHMAC, TlsHMAC tlsHMAC2) throws IOException {
        SecurityParameters securityParameters = tlsCryptoParameters.getSecurityParametersHandshake();
        if (!TlsImplUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            throw new TlsFatalAlert(80);
        }
        this.cryptoParams = tlsCryptoParameters;
        this.readHMAC = tlsHMAC;
        this.writeHMAC = tlsHMAC2;
        this.readNonce = new byte[tlsHMAC.getMacLength()];
        this.writeNonce = new byte[tlsHMAC2.getMacLength()];
        boolean bl = tlsCryptoParameters.isServer();
        this.rekeyHmac(securityParameters, tlsHMAC, this.readNonce, !bl);
        this.rekeyHmac(securityParameters, tlsHMAC2, this.writeNonce, bl);
    }

    @Override
    public int getCiphertextDecodeLimit(int n) {
        return n + 1 + this.readHMAC.getMacLength();
    }

    @Override
    public int getCiphertextEncodeLimit(int n) {
        return n + 1 + this.writeHMAC.getMacLength();
    }

    @Override
    public int getPlaintextDecodeLimit(int n) {
        return n - this.readHMAC.getMacLength() - 1;
    }

    @Override
    public int getPlaintextEncodeLimit(int n) {
        return n - this.writeHMAC.getMacLength() - 1;
    }

    @Override
    public TlsEncodeResult encodePlaintext(long l, short s, ProtocolVersion protocolVersion, int n, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.writeHMAC.getMacLength();
        this.writeHMAC.reset();
        byte[] byArray2 = Tls13NullCipher.createRecordNonce(this.writeNonce, l);
        this.writeHMAC.update(byArray2, 0, byArray2.length);
        int n5 = n3 + 1;
        int n6 = n5 + n4;
        byte[] byArray3 = new byte[n + n6];
        int n7 = n;
        short s2 = 23;
        byte[] byArray4 = Tls13NullCipher.getAdditionalData(l, s2, protocolVersion, n6);
        try {
            System.arraycopy(byArray, n2, byArray3, n7, n3);
            byArray3[n7 + n3] = (byte)s;
            this.writeHMAC.update(byArray4, 0, byArray4.length);
            this.writeHMAC.update(byArray3, n7, n5);
            this.writeHMAC.calculateMAC(byArray3, n7 + n5);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        if ((n7 += n5 + n4) != byArray3.length) {
            throw new TlsFatalAlert(80);
        }
        return new TlsEncodeResult(byArray3, 0, byArray3.length, s2);
    }

    @Override
    public TlsDecodeResult decodeCiphertext(long l, short s, ProtocolVersion protocolVersion, byte[] byArray, int n, int n2) throws IOException {
        byte by;
        int n3 = this.readHMAC.getMacLength();
        int n4 = n2 - n3;
        if (n4 < 1) {
            throw new TlsFatalAlert(50);
        }
        this.readHMAC.reset();
        byte[] byArray2 = Tls13NullCipher.createRecordNonce(this.readNonce, l);
        this.readHMAC.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = Tls13NullCipher.getAdditionalData(l, s, protocolVersion, n2);
        try {
            this.readHMAC.update(byArray3, 0, byArray3.length);
            this.readHMAC.update(byArray, n, n4);
            byte[] byArray4 = this.readHMAC.calculateMAC();
            if (!Arrays.constantTimeAreEqual((int)n3, (byte[])byArray4, (int)0, (byte[])byArray, (int)(n + n4))) {
                throw new TlsFatalAlert(20);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(20, (Throwable)runtimeException);
        }
        short s2 = s;
        int n5 = n4;
        do {
            if (--n5 >= 0) continue;
            throw new TlsFatalAlert(10);
        } while (0 == (by = byArray[n + n5]));
        s2 = (short)(by & 0xFF);
        return new TlsDecodeResult(byArray, n, n5, s2);
    }

    @Override
    public void rekeyDecoder() throws IOException {
        this.rekeyHmac(this.cryptoParams.getSecurityParametersConnection(), this.readHMAC, this.readNonce, !this.cryptoParams.isServer());
    }

    @Override
    public void rekeyEncoder() throws IOException {
        this.rekeyHmac(this.cryptoParams.getSecurityParametersConnection(), this.writeHMAC, this.writeNonce, this.cryptoParams.isServer());
    }

    @Override
    public boolean usesOpaqueRecordTypeDecode() {
        return true;
    }

    @Override
    public boolean usesOpaqueRecordTypeEncode() {
        return true;
    }

    private void rekeyHmac(SecurityParameters securityParameters, TlsHMAC tlsHMAC, byte[] byArray, boolean bl) throws IOException {
        TlsSecret tlsSecret;
        TlsSecret tlsSecret2 = tlsSecret = bl ? securityParameters.getTrafficSecretServer() : securityParameters.getTrafficSecretClient();
        if (null == tlsSecret) {
            throw new TlsFatalAlert(80);
        }
        this.setupHmac(tlsHMAC, byArray, tlsSecret, securityParameters.getPRFCryptoHashAlgorithm());
    }

    private void setupHmac(TlsHMAC tlsHMAC, byte[] byArray, TlsSecret tlsSecret, int n) throws IOException {
        int n2 = tlsHMAC.getMacLength();
        byte[] byArray2 = Tls13NullCipher.hkdfExpandLabel(tlsSecret, n, "key", n2).extract();
        byte[] byArray3 = Tls13NullCipher.hkdfExpandLabel(tlsSecret, n, "iv", n2).extract();
        tlsHMAC.setKey(byArray2, 0, n2);
        System.arraycopy(byArray3, 0, byArray, 0, n2);
    }

    private static byte[] createRecordNonce(byte[] byArray, long l) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        TlsUtils.writeUint64(l, byArray2, n - 8);
        Tls13NullCipher.xorTo(n, byArray, byArray2);
        return byArray2;
    }

    private static byte[] getAdditionalData(long l, short s, ProtocolVersion protocolVersion, int n) throws IOException {
        byte[] byArray = new byte[5];
        TlsUtils.writeUint8(s, byArray, 0);
        TlsUtils.writeVersion(protocolVersion, byArray, 1);
        TlsUtils.writeUint16(n, byArray, 3);
        return byArray;
    }

    private static TlsSecret hkdfExpandLabel(TlsSecret tlsSecret, int n, String string, int n2) throws IOException {
        return TlsCryptoUtils.hkdfExpandLabel(tlsSecret, n, string, TlsUtils.EMPTY_BYTES, n2);
    }

    private static void xorTo(int n, byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            byArray2[n2] = (byte)(byArray2[n2] ^ byArray[i]);
        }
    }
}

