/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.component.instance;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalizationState;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.service.ServiceScheduler;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.ComponentState;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.api.records.LocalizationStatus;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.component.Component;
import org.apache.hadoop.yarn.service.component.ComponentEvent;
import org.apache.hadoop.yarn.service.component.ComponentEventType;
import org.apache.hadoop.yarn.service.component.ComponentRestartPolicy;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEvent;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEventType;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceId;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceState;
import org.apache.hadoop.yarn.service.monitor.probe.DefaultProbe;
import org.apache.hadoop.yarn.service.monitor.probe.ProbeStatus;
import org.apache.hadoop.yarn.service.provider.ProviderService;
import org.apache.hadoop.yarn.service.registry.YarnRegistryViewForProviders;
import org.apache.hadoop.yarn.service.timelineservice.ServiceTimelinePublisher;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.BoundedAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentInstance
implements EventHandler<ComponentInstanceEvent>,
Comparable<ComponentInstance> {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentInstance.class);
    private static final String FAILED_BEFORE_LAUNCH_DIAG = "failed before launch";
    private static final String UPGRADE_FAILED = "upgrade failed";
    private StateMachine<ComponentInstanceState, ComponentInstanceEventType, ComponentInstanceEvent> stateMachine;
    private Component component;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private ComponentInstanceId compInstanceId = null;
    private Path compInstanceDir;
    private Container container;
    private YarnRegistryViewForProviders yarnRegistryOperations;
    private FileSystem fs;
    private boolean timelineServiceEnabled = false;
    private ServiceTimelinePublisher serviceTimelinePublisher;
    private ServiceScheduler scheduler;
    private BoundedAppender diagnostics = new BoundedAppender(65536);
    private volatile ScheduledFuture containerStatusFuture;
    private volatile ContainerStatus status;
    private long containerStartedTime = 0L;
    private org.apache.hadoop.yarn.service.api.records.Container containerSpec;
    private String serviceVersion;
    private AtomicBoolean upgradeInProgress = new AtomicBoolean(false);
    private boolean pendingCancelUpgrade = false;
    private ProviderService.ResolvedLaunchParams resolvedParams;
    private ScheduledFuture lclizationRetrieverFuture;
    private static final StateMachineFactory<ComponentInstance, ComponentInstanceState, ComponentInstanceEventType, ComponentInstanceEvent> stateMachineFactory = new StateMachineFactory((Enum)ComponentInstanceState.INIT).addTransition((Enum)ComponentInstanceState.INIT, (Enum)ComponentInstanceState.STARTED, (Enum)ComponentInstanceEventType.START, (SingleArcTransition)new ContainerStartedTransition()).addTransition((Enum)ComponentInstanceState.INIT, (Enum)ComponentInstanceState.INIT, (Enum)ComponentInstanceEventType.STOP, (SingleArcTransition)new ContainerStoppedTransition(true)).addTransition((Enum)ComponentInstanceState.STARTED, (Enum)ComponentInstanceState.INIT, (Enum)ComponentInstanceEventType.STOP, (SingleArcTransition)new ContainerStoppedTransition()).addTransition((Enum)ComponentInstanceState.STARTED, (Enum)ComponentInstanceState.READY, (Enum)ComponentInstanceEventType.BECOME_READY, (SingleArcTransition)new ContainerBecomeReadyTransition(false)).addTransition((Enum)ComponentInstanceState.READY, (Enum)ComponentInstanceState.STARTED, (Enum)ComponentInstanceEventType.BECOME_NOT_READY, (SingleArcTransition)new ContainerBecomeNotReadyTransition()).addTransition((Enum)ComponentInstanceState.READY, (Enum)ComponentInstanceState.INIT, (Enum)ComponentInstanceEventType.STOP, (SingleArcTransition)new ContainerStoppedTransition()).addTransition((Enum)ComponentInstanceState.READY, (Enum)ComponentInstanceState.UPGRADING, (Enum)ComponentInstanceEventType.UPGRADE, (SingleArcTransition)new UpgradeTransition()).addTransition((Enum)ComponentInstanceState.READY, EnumSet.of(ComponentInstanceState.READY, ComponentInstanceState.CANCEL_UPGRADING), (Enum)ComponentInstanceEventType.CANCEL_UPGRADE, (MultipleArcTransition)new CancelUpgradeTransition()).addTransition((Enum)ComponentInstanceState.UPGRADING, EnumSet.of(ComponentInstanceState.READY, ComponentInstanceState.CANCEL_UPGRADING), (Enum)ComponentInstanceEventType.CANCEL_UPGRADE, (MultipleArcTransition)new CancelUpgradeTransition()).addTransition((Enum)ComponentInstanceState.UPGRADING, EnumSet.of(ComponentInstanceState.REINITIALIZED), (Enum)ComponentInstanceEventType.START, (MultipleArcTransition)new StartedAfterUpgradeTransition()).addTransition((Enum)ComponentInstanceState.UPGRADING, (Enum)ComponentInstanceState.UPGRADING, (Enum)ComponentInstanceEventType.STOP, (SingleArcTransition)new StoppedAfterUpgradeTransition()).addTransition((Enum)ComponentInstanceState.CANCEL_UPGRADING, EnumSet.of(ComponentInstanceState.CANCEL_UPGRADING, ComponentInstanceState.REINITIALIZED), (Enum)ComponentInstanceEventType.START, (MultipleArcTransition)new StartedAfterUpgradeTransition()).addTransition((Enum)ComponentInstanceState.CANCEL_UPGRADING, EnumSet.of(ComponentInstanceState.CANCEL_UPGRADING, ComponentInstanceState.INIT), (Enum)ComponentInstanceEventType.STOP, (MultipleArcTransition)new StoppedAfterCancelUpgradeTransition()).addTransition((Enum)ComponentInstanceState.REINITIALIZED, (Enum)ComponentInstanceState.CANCEL_UPGRADING, (Enum)ComponentInstanceEventType.CANCEL_UPGRADE, (SingleArcTransition)new CancelledAfterReinitTransition()).addTransition((Enum)ComponentInstanceState.REINITIALIZED, (Enum)ComponentInstanceState.READY, (Enum)ComponentInstanceEventType.BECOME_READY, (SingleArcTransition)new ContainerBecomeReadyTransition(true)).addTransition((Enum)ComponentInstanceState.REINITIALIZED, (Enum)ComponentInstanceState.REINITIALIZED, (Enum)ComponentInstanceEventType.STOP, (SingleArcTransition)new StoppedAfterUpgradeTransition()).installTopology();

    public ComponentInstance(Component component, ComponentInstanceId compInstanceId) {
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.component = component;
        this.compInstanceId = compInstanceId;
        this.scheduler = component.getScheduler();
        this.yarnRegistryOperations = component.getScheduler().getYarnRegistryOperations();
        this.serviceTimelinePublisher = component.getScheduler().getServiceTimelinePublisher();
        if (YarnConfiguration.timelineServiceV2Enabled((Configuration)component.getScheduler().getConfig())) {
            this.timelineServiceEnabled = true;
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.fs = this.scheduler.getContext().fs.getFileSystem();
    }

    private void postContainerReady() {
        if (this.timelineServiceEnabled) {
            this.serviceTimelinePublisher.componentInstanceBecomeReady(this.containerSpec);
        }
        try {
            List statusesFromNM = this.scheduler.getNmClient().getClient().getLocalizationStatuses(this.container.getId(), this.container.getNodeId());
            if (statusesFromNM != null && !statusesFromNM.isEmpty()) {
                this.updateLocalizationStatuses(statusesFromNM);
            }
        }
        catch (IOException | YarnException e) {
            LOG.warn("{} failure getting localization statuses", (Object)this.container.getId(), (Object)e);
        }
    }

    @VisibleForTesting
    static void handleComponentInstanceRelaunch(ComponentInstance compInstance, ComponentInstanceEvent event, boolean failureBeforeLaunch, String containerDiag) {
        ContainerState containerState;
        Component comp = compInstance.getComponent();
        boolean hasContainerFailed = failureBeforeLaunch || ComponentInstance.hasContainerFailed(event.getStatus());
        ComponentRestartPolicy restartPolicy = comp.getRestartPolicyHandler();
        ContainerState containerState2 = containerState = hasContainerFailed ? ContainerState.FAILED : ContainerState.SUCCEEDED;
        if (compInstance.getContainerSpec() != null) {
            compInstance.getContainerSpec().setState(containerState);
        }
        if (restartPolicy.shouldRelaunchInstance(compInstance, event.getStatus())) {
            comp.requestContainers(1L);
            comp.reInsertPendingInstance(compInstance);
            StringBuilder builder = new StringBuilder();
            builder.append(compInstance.getCompInstanceId()).append(": ").append(event.getContainerId()).append(" completed. Reinsert back to pending list and requested ").append("a new container.").append(System.lineSeparator()).append(" exitStatus=").append(failureBeforeLaunch || event.getStatus() == null ? null : Integer.valueOf(event.getStatus().getExitStatus())).append(", diagnostics=").append(failureBeforeLaunch ? FAILED_BEFORE_LAUNCH_DIAG : (event.getStatus() != null ? event.getStatus().getDiagnostics() : UPGRADE_FAILED));
            if (event.getStatus() != null && event.getStatus().getExitStatus() != 0) {
                LOG.error(builder.toString());
            } else {
                LOG.info(builder.toString());
            }
            if (compInstance.timelineServiceEnabled) {
                LOG.info("Publishing component instance status {} {} ", (Object)event.getContainerId(), (Object)containerState);
                int exitStatus = failureBeforeLaunch || event.getStatus() == null ? -1000 : event.getStatus().getExitStatus();
                compInstance.serviceTimelinePublisher.componentInstanceFinished(event.getContainerId(), exitStatus, containerState, containerDiag);
            }
        } else {
            if (hasContainerFailed) {
                comp.markAsFailed(compInstance);
            } else {
                comp.markAsSucceeded(compInstance);
            }
            if (compInstance.timelineServiceEnabled) {
                int exitStatus = failureBeforeLaunch || event.getStatus() == null ? -1000 : event.getStatus().getExitStatus();
                compInstance.serviceTimelinePublisher.componentInstanceFinished(event.getContainerId(), exitStatus, containerState, containerDiag);
            }
            LOG.info(compInstance.getCompInstanceId() + (!hasContainerFailed ? " succeeded" : " failed") + " without retry, exitStatus=" + event.getStatus());
            comp.getScheduler().terminateServiceIfNeeded(comp);
        }
    }

    public static boolean hasContainerFailed(ContainerStatus containerStatus) {
        return containerStatus == null || containerStatus.getExitStatus() != 0;
    }

    public static boolean isFinalState(ContainerState state) {
        return ContainerState.FAILED.equals((Object)state) || ContainerState.STOPPED.equals((Object)state) || ContainerState.SUCCEEDED.equals((Object)state);
    }

    private void cancelUpgrade() {
        LOG.info("{} cancelling upgrade", (Object)this.container.getId());
        this.setContainerState(ContainerState.UPGRADING);
        Component.UpgradeStatus cancelStatus = this.component.getCancelUpgradeStatus();
        this.reInitHelper(cancelStatus);
    }

    private void reInitHelper(Component.UpgradeStatus upgradeStatus) {
        this.cancelContainerStatusRetriever();
        this.cancelLclRetriever();
        this.setContainerStatus(this.container.getId(), null);
        this.scheduler.executorService.submit(() -> this.cleanupRegistry(this.container.getId()));
        Future<ProviderService.ResolvedLaunchParams> launchParamsFuture = this.scheduler.getContainerLaunchService().reInitCompInstance(this.scheduler.getApp(), this, this.container, this.component.createLaunchContext(upgradeStatus.getTargetSpec(), upgradeStatus.getTargetVersion()));
        this.updateResolvedLaunchParams(launchParamsFuture);
    }

    private void initializeStatusRetriever(ComponentInstanceEvent event, long initialDelay) {
        boolean cancelOnSuccess = true;
        if (this.getCompSpec().getArtifact() != null && this.getCompSpec().getArtifact().getType() == Artifact.TypeEnum.DOCKER) {
            cancelOnSuccess = false;
        }
        LOG.info("{} retrieve status after {}", (Object)this.compInstanceId, (Object)initialDelay);
        this.containerStatusFuture = this.scheduler.executorService.scheduleAtFixedRate(new ContainerStatusRetriever(this.scheduler, event.getContainerId(), this, cancelOnSuccess), initialDelay, 1L, TimeUnit.SECONDS);
    }

    public ComponentInstanceState getState() {
        this.readLock.lock();
        try {
            ComponentInstanceState componentInstanceState = (ComponentInstanceState)this.stateMachine.getCurrentState();
            return componentInstanceState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getServiceVersion() {
        this.readLock.lock();
        try {
            String string = this.serviceVersion;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public ContainerState getContainerState() {
        this.readLock.lock();
        try {
            ContainerState containerState = this.containerSpec.getState();
            return containerState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setContainerState(ContainerState state) {
        this.writeLock.lock();
        try {
            ContainerState curState = this.containerSpec.getState();
            if (!curState.equals((Object)state)) {
                this.containerSpec.setState(state);
                LOG.info("{} spec state state changed from {} -> {}", new Object[]{this.getCompInstanceId(), curState, state});
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ComponentInstanceEvent event) {
        this.writeLock.lock();
        try {
            ComponentInstanceState oldState = this.getState();
            try {
                this.stateMachine.doTransition((Enum)((ComponentInstanceEventType)event.getType()), (Object)event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.error(this.getCompInstanceId() + ": Invalid event " + event.getType() + " at " + (Object)((Object)oldState), (Throwable)e);
            }
            if (oldState != this.getState()) {
                LOG.info(this.getCompInstanceId() + " Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState()) + " on " + event.getType() + " event");
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setContainer(Container container) {
        this.container = container;
        this.compInstanceId.setContainerId(container.getId());
    }

    public String getCompInstanceName() {
        return this.compInstanceId.getCompInstanceName();
    }

    @VisibleForTesting
    void updateLocalizationStatuses(List<org.apache.hadoop.yarn.api.records.LocalizationStatus> statuses) {
        HashMap<String, String> resourcesCpy = new HashMap<String, String>();
        this.readLock.lock();
        try {
            if (this.resolvedParams == null || this.resolvedParams.didLaunchFail() || this.resolvedParams.getResolvedRsrcPaths() == null || this.resolvedParams.getResolvedRsrcPaths().isEmpty()) {
                this.cancelLclRetriever();
                return;
            }
            resourcesCpy.putAll(this.resolvedParams.getResolvedRsrcPaths());
        }
        finally {
            this.readLock.unlock();
        }
        boolean allCompleted = true;
        HashMap fromNM = new HashMap();
        statuses.forEach(statusFromNM -> {
            LocalizationStatus lstatus = new LocalizationStatus().destFile(statusFromNM.getResourceKey()).diagnostics(statusFromNM.getDiagnostics()).state(statusFromNM.getLocalizationState());
            fromNM.put(statusFromNM.getResourceKey(), lstatus);
        });
        for (String resourceKey : resourcesCpy.keySet()) {
            LocalizationStatus lstatus = (LocalizationStatus)fromNM.get(resourceKey);
            if (lstatus != null && !lstatus.getState().equals((Object)LocalizationState.PENDING)) continue;
            allCompleted = false;
            break;
        }
        ArrayList<LocalizationStatus> statusList = new ArrayList<LocalizationStatus>();
        statusList.addAll(fromNM.values());
        this.containerSpec.setLocalizationStatuses(statusList);
        if (allCompleted) {
            this.cancelLclRetriever();
        }
    }

    public void updateResolvedLaunchParams(Future<ProviderService.ResolvedLaunchParams> future) {
        this.writeLock.lock();
        try {
            this.resolvedParams = future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("{} updating resolved params", (Object)this.getCompInstanceId(), (Object)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ContainerStatus getContainerStatus() {
        this.readLock.lock();
        try {
            ContainerStatus containerStatus = this.status;
            return containerStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContainerStatus(ContainerId containerId, ContainerStatus latestStatus) {
        this.writeLock.lock();
        try {
            this.status = latestStatus;
            org.apache.hadoop.yarn.service.api.records.Container containerRec = this.getCompSpec().getContainer(containerId.toString());
            if (containerRec != null) {
                if (latestStatus != null) {
                    containerRec.setIp(StringUtils.join((CharSequence)",", (Iterable)latestStatus.getIPs()));
                    containerRec.setHostname(latestStatus.getHost());
                } else {
                    containerRec.setIp(null);
                    containerRec.setHostname(null);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void updateContainerStatus(ContainerStatus status) {
        org.apache.hadoop.yarn.service.api.records.Container containerRec = this.getCompSpec().getContainer(status.getContainerId().toString());
        boolean doRegistryUpdate = true;
        if (containerRec != null) {
            String existingIP = containerRec.getIp();
            String newIP = StringUtils.join((CharSequence)",", (Iterable)status.getIPs());
            if (existingIP != null && newIP.equals(existingIP)) {
                doRegistryUpdate = false;
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map ports = null;
            ports = (Map)mapper.readValue(status.getExposedPorts(), (TypeReference)new TypeReference<Map<String, List<Map<String, String>>>>(){});
            this.container.setExposedPorts(ports);
        }
        catch (IOException e) {
            LOG.warn("Unable to process container ports mapping: {}", (Throwable)e);
        }
        this.setContainerStatus(status.getContainerId(), status);
        if (containerRec != null && this.timelineServiceEnabled && doRegistryUpdate) {
            this.serviceTimelinePublisher.componentInstanceIPHostUpdated(containerRec);
        }
        if (doRegistryUpdate) {
            this.cleanupRegistry(status.getContainerId());
            LOG.info(this.getCompInstanceId() + " new IP = " + status.getIPs() + ", host = " + status.getHost() + ", updating registry");
            this.updateServiceRecord(this.yarnRegistryOperations, status);
        }
    }

    public String getCompName() {
        return this.compInstanceId.getCompName();
    }

    public void setCompInstanceDir(Path dir) {
        this.compInstanceDir = dir;
    }

    public Component getComponent() {
        return this.component;
    }

    public Container getContainer() {
        return this.container;
    }

    public ComponentInstanceId getCompInstanceId() {
        return this.compInstanceId;
    }

    public NodeId getNodeId() {
        return this.container.getNodeId();
    }

    private org.apache.hadoop.yarn.service.api.records.Component getCompSpec() {
        return this.component.getComponentSpec();
    }

    public ProbeStatus ping() {
        if (this.component.getProbe() == null) {
            ProbeStatus status = new ProbeStatus();
            status.setSuccess(true);
            return status;
        }
        return this.component.getProbe().ping(this);
    }

    private void updateServiceRecord(YarnRegistryViewForProviders yarnRegistry, ContainerStatus status) {
        ServiceRecord record = new ServiceRecord();
        String containerId = status.getContainerId().toString();
        record.set("yarn:id", (Object)containerId);
        record.description = this.getCompInstanceName();
        record.set("yarn:persistence", (Object)"container");
        record.set("yarn:ip", status.getIPs().get(0));
        record.set("yarn:hostname", (Object)status.getHost());
        record.set("yarn:component", (Object)this.component.getName());
        try {
            yarnRegistry.putComponent(RegistryPathUtils.encodeYarnID((String)containerId), record);
        }
        catch (IOException e) {
            LOG.error("Failed to update service record in registry: " + containerId + "");
        }
    }

    public void destroy() {
        LOG.info(this.getCompInstanceId() + ": Flexed down by user, destroying.");
        this.diagnostics.append((CharSequence)(this.getCompInstanceId() + ": Flexed down by user"));
        if (this.getState() == ComponentInstanceState.STARTED) {
            this.component.decRunningContainers();
        }
        if (this.getState() == ComponentInstanceState.READY) {
            this.component.decContainersReady(true);
            this.component.decRunningContainers();
        }
        this.getCompSpec().removeContainer(this.containerSpec);
        if (this.container == null) {
            LOG.info(this.getCompInstanceId() + " no container is assigned when destroying");
            return;
        }
        ContainerId containerId = this.container.getId();
        this.scheduler.removeLiveCompInstance(containerId);
        this.component.getScheduler().getAmRMClient().releaseAssignedContainer(containerId);
        if (this.timelineServiceEnabled) {
            this.serviceTimelinePublisher.componentInstanceFinished(containerId, -105, ContainerState.STOPPED, this.diagnostics.toString());
        }
        this.cancelContainerStatusRetriever();
        this.scheduler.executorService.submit(() -> this.cleanupRegistryAndCompHdfsDir(containerId));
        this.cancelLclRetriever();
    }

    private void cleanupRegistry(ContainerId containerId) {
        String cid = RegistryPathUtils.encodeYarnID((String)containerId.toString());
        try {
            this.yarnRegistryOperations.deleteComponent(this.getCompInstanceId(), cid);
        }
        catch (IOException e) {
            LOG.error(this.getCompInstanceId() + ": Failed to delete registry", (Throwable)e);
        }
    }

    public void cleanupRegistryAndCompHdfsDir(ContainerId containerId) {
        this.cleanupRegistry(containerId);
        try {
            if (this.compInstanceDir != null && this.fs.exists(this.compInstanceDir)) {
                boolean deleted = this.fs.delete(this.compInstanceDir, true);
                if (!deleted) {
                    LOG.error(this.getCompInstanceId() + ": Failed to delete component instance dir: " + this.compInstanceDir);
                } else {
                    LOG.info(this.getCompInstanceId() + ": Deleted component instance dir: " + this.compInstanceDir);
                }
            }
        }
        catch (IOException e) {
            LOG.warn(this.getCompInstanceId() + ": Failed to delete directory", (Throwable)e);
        }
    }

    private void cancelContainerStatusRetriever() {
        if (this.containerStatusFuture != null && !this.containerStatusFuture.isDone()) {
            this.containerStatusFuture.cancel(true);
        }
    }

    private void initializeLocalizationStatusRetriever(ContainerId containerId) {
        LOG.info("{} retrieve localization statuses", (Object)this.compInstanceId);
        this.lclizationRetrieverFuture = this.scheduler.executorService.scheduleAtFixedRate(new LocalizationStatusRetriever(this.scheduler, containerId, this), 0L, 1L, TimeUnit.SECONDS);
    }

    private void cancelLclRetriever() {
        if (this.lclizationRetrieverFuture != null && !this.lclizationRetrieverFuture.isDone()) {
            LOG.info("{} cancelling localization retriever", (Object)this.compInstanceId);
            this.lclizationRetrieverFuture.cancel(true);
        }
    }

    @VisibleForTesting
    boolean isLclRetrieverActive() {
        return this.lclizationRetrieverFuture != null && !this.lclizationRetrieverFuture.isCancelled() && !this.lclizationRetrieverFuture.isDone();
    }

    public String getHostname() {
        return this.getCompInstanceName() + this.getComponent().getHostnameSuffix();
    }

    @Override
    public int compareTo(ComponentInstance to) {
        return this.getCompInstanceId().compareTo(to.getCompInstanceId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentInstance instance = (ComponentInstance)o;
        if (this.containerStartedTime != instance.containerStartedTime) {
            return false;
        }
        return this.compInstanceId.equals(instance.compInstanceId);
    }

    public int hashCode() {
        int result = this.compInstanceId.hashCode();
        result = 31 * result + (int)(this.containerStartedTime ^ this.containerStartedTime >>> 32);
        return result;
    }

    public org.apache.hadoop.yarn.service.api.records.Container getContainerSpec() {
        this.readLock.lock();
        try {
            org.apache.hadoop.yarn.service.api.records.Container container = this.containerSpec;
            return container;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static class LocalizationStatusRetriever
    implements Runnable {
        private ContainerId containerId;
        private NodeId nodeId;
        private NMClient nmClient;
        private ComponentInstance instance;

        LocalizationStatusRetriever(ServiceScheduler scheduler, ContainerId containerId, ComponentInstance instance) {
            this.nmClient = scheduler.getNmClient().getClient();
            this.containerId = containerId;
            this.instance = instance;
            this.nodeId = instance.getNodeId();
        }

        @Override
        public void run() {
            List statusesFromNM = null;
            try {
                statusesFromNM = this.nmClient.getLocalizationStatuses(this.containerId, this.nodeId);
            }
            catch (IOException | YarnException e) {
                LOG.error("{} Failed to get localization statuses for {} {} ", new Object[]{this.instance.compInstanceId, this.nodeId, this.containerId, e});
            }
            if (statusesFromNM != null && !statusesFromNM.isEmpty()) {
                this.instance.updateLocalizationStatuses(statusesFromNM);
            }
        }
    }

    private static class ContainerStatusRetriever
    implements Runnable {
        private ContainerId containerId;
        private NodeId nodeId;
        private NMClient nmClient;
        private ComponentInstance instance;
        private boolean cancelOnSuccess;

        ContainerStatusRetriever(ServiceScheduler scheduler, ContainerId containerId, ComponentInstance instance, boolean cancelOnSuccess) {
            this.containerId = containerId;
            this.nodeId = instance.getNodeId();
            this.nmClient = scheduler.getNmClient().getClient();
            this.instance = instance;
            this.cancelOnSuccess = cancelOnSuccess;
        }

        @Override
        public void run() {
            ContainerStatus status = null;
            try {
                status = this.nmClient.getContainerStatus(this.containerId, this.nodeId);
            }
            catch (Exception e) {
                if (e instanceof YarnException) {
                    throw new YarnRuntimeException(this.instance.compInstanceId + " Failed to get container status on " + this.nodeId + " , cancelling.", (Throwable)e);
                }
                LOG.error(this.instance.compInstanceId + " Failed to get container status on " + this.nodeId + ", will try again", (Throwable)e);
                return;
            }
            if (ServiceUtils.isEmpty(status.getIPs()) || ServiceUtils.isUnset(status.getHost())) {
                return;
            }
            this.instance.updateContainerStatus(status);
            if (this.cancelOnSuccess) {
                LOG.info(this.instance.compInstanceId + " IP = " + status.getIPs() + ", host = " + status.getHost() + ", cancel container status retriever");
                this.instance.containerStatusFuture.cancel(false);
            }
        }
    }

    private static class BaseTransition
    implements SingleArcTransition<ComponentInstance, ComponentInstanceEvent> {
        private BaseTransition() {
        }

        public void transition(ComponentInstance compInstance, ComponentInstanceEvent event) {
        }
    }

    private static class CancelUpgradeTransition
    implements MultipleArcTransition<ComponentInstance, ComponentInstanceEvent, ComponentInstanceState> {
        private CancelUpgradeTransition() {
        }

        public ComponentInstanceState transition(ComponentInstance instance, ComponentInstanceEvent event) {
            if (instance.upgradeInProgress.compareAndSet(false, true)) {
                Component.UpgradeStatus cancelStatus = instance.component.getCancelUpgradeStatus();
                if (instance.getServiceVersion().equals(cancelStatus.getTargetVersion())) {
                    LOG.info("{} nothing to cancel", (Object)event.getContainerId());
                    cancelStatus.decContainersThatNeedUpgrade();
                    instance.setContainerState(ContainerState.READY);
                    ComponentEvent checkState = new ComponentEvent(instance.component.getName(), ComponentEventType.CHECK_STABLE);
                    instance.scheduler.getDispatcher().getEventHandler().handle((Event)checkState);
                    return ComponentInstanceState.READY;
                }
                instance.component.decContainersReady(false);
                instance.cancelUpgrade();
            } else {
                LOG.info("{} pending cancellation", (Object)event.getContainerId());
                instance.pendingCancelUpgrade = true;
            }
            return ComponentInstanceState.CANCEL_UPGRADING;
        }
    }

    private static class CancelledAfterReinitTransition
    extends BaseTransition {
        private CancelledAfterReinitTransition() {
        }

        @Override
        public void transition(ComponentInstance instance, ComponentInstanceEvent event) {
            if (instance.upgradeInProgress.compareAndSet(false, true)) {
                instance.cancelUpgrade();
            } else {
                LOG.info("{} pending cancellation", (Object)event.getContainerId());
                instance.pendingCancelUpgrade = true;
            }
        }
    }

    private static class UpgradeTransition
    extends BaseTransition {
        private UpgradeTransition() {
        }

        @Override
        public void transition(ComponentInstance instance, ComponentInstanceEvent event) {
            if (!instance.component.getCancelUpgradeStatus().isCompleted()) {
                return;
            }
            instance.upgradeInProgress.set(true);
            instance.setContainerState(ContainerState.UPGRADING);
            instance.component.decContainersReady(false);
            Component.UpgradeStatus upgradeStatus = instance.component.getUpgradeStatus();
            instance.reInitHelper(upgradeStatus);
        }
    }

    private static class StoppedAfterCancelUpgradeTransition
    implements MultipleArcTransition<ComponentInstance, ComponentInstanceEvent, ComponentInstanceState> {
        private ContainerStoppedTransition stoppedTransition = new ContainerStoppedTransition();

        private StoppedAfterCancelUpgradeTransition() {
        }

        public ComponentInstanceState transition(ComponentInstance instance, ComponentInstanceEvent event) {
            if (instance.pendingCancelUpgrade) {
                LOG.info("{} received stopped but cancellation pending", (Object)event.getContainerId());
                instance.upgradeInProgress.set(true);
                instance.cancelUpgrade();
                instance.pendingCancelUpgrade = false;
                return instance.getState();
            }
            instance.component.getCancelUpgradeStatus().decContainersThatNeedUpgrade();
            instance.upgradeInProgress.set(false);
            this.stoppedTransition.transition(instance, event);
            return ComponentInstanceState.INIT;
        }
    }

    private static class StoppedAfterUpgradeTransition
    extends BaseTransition {
        private StoppedAfterUpgradeTransition() {
        }

        @Override
        public void transition(ComponentInstance instance, ComponentInstanceEvent event) {
            instance.component.getUpgradeStatus().decContainersThatNeedUpgrade();
            instance.component.decRunningContainers();
            ServiceScheduler scheduler = instance.component.getScheduler();
            scheduler.getAmRMClient().releaseAssignedContainer(event.getContainerId());
            ((ComponentInstance)instance).scheduler.executorService.submit(() -> instance.cleanupRegistry(event.getContainerId()));
            scheduler.removeLiveCompInstance(event.getContainerId());
            instance.component.getUpgradeStatus().containerFailedUpgrade();
            instance.setContainerState(ContainerState.FAILED_UPGRADE);
            instance.upgradeInProgress.set(false);
        }
    }

    private static class ContainerStoppedTransition
    extends BaseTransition {
        boolean failedBeforeLaunching = false;

        public ContainerStoppedTransition(boolean failedBeforeLaunching) {
            this.failedBeforeLaunching = failedBeforeLaunching;
        }

        public ContainerStoppedTransition() {
            this(false);
        }

        @Override
        public void transition(ComponentInstance compInstance, ComponentInstanceEvent event) {
            Component comp = compInstance.component;
            ContainerStatus status = event.getStatus();
            String containerDiag = compInstance.getCompInstanceId() + ": " + (this.failedBeforeLaunching ? ComponentInstance.FAILED_BEFORE_LAUNCH_DIAG : (status != null ? status.getDiagnostics() : ComponentInstance.UPGRADE_FAILED));
            compInstance.diagnostics.append((CharSequence)(containerDiag + System.lineSeparator()));
            compInstance.cancelContainerStatusRetriever();
            compInstance.cancelLclRetriever();
            if (compInstance.getState().equals((Object)ComponentInstanceState.READY)) {
                compInstance.component.decContainersReady(true);
            }
            compInstance.component.decRunningContainers();
            boolean shouldFailService = false;
            ServiceScheduler scheduler = comp.getScheduler();
            scheduler.getAmRMClient().releaseAssignedContainer(event.getContainerId());
            if (!comp.isHealthThresholdMonitorEnabled() && comp.currentContainerFailure.get() > comp.maxContainerFailurePerComp) {
                String exitDiag = MessageFormat.format("[COMPONENT {0}]: Failed {1} times, exceeded the limit - {2}. Shutting down now... " + System.lineSeparator(), comp.getName(), comp.currentContainerFailure.get(), comp.maxContainerFailurePerComp);
                compInstance.diagnostics.append((CharSequence)exitDiag);
                scheduler.getDiagnostics().append((CharSequence)containerDiag);
                scheduler.getDiagnostics().append((CharSequence)exitDiag);
                LOG.warn(exitDiag);
                compInstance.getContainerSpec().setState(ContainerState.FAILED);
                comp.getComponentSpec().setState(ComponentState.FAILED);
                comp.getScheduler().getApp().setState(ServiceState.FAILED);
                if (compInstance.timelineServiceEnabled) {
                    compInstance.scheduler.getServiceTimelinePublisher().componentInstanceFinished(compInstance.getContainer().getId(), this.failedBeforeLaunching || status == null ? -1 : status.getExitStatus(), ContainerState.FAILED, containerDiag);
                    for (ContainerId containerId : scheduler.getLiveInstances().keySet()) {
                        if (compInstance.container.getId().equals((Object)containerId) || ComponentInstance.isFinalState(compInstance.getContainerSpec().getState())) continue;
                        compInstance.getContainerSpec().setState(ContainerState.STOPPED);
                        compInstance.scheduler.getServiceTimelinePublisher().componentInstanceFinished(containerId, -107, ContainerState.STOPPED, scheduler.getDiagnostics().toString());
                    }
                    compInstance.scheduler.getServiceTimelinePublisher().componentFinished(comp.getComponentSpec(), ComponentState.FAILED, scheduler.getSystemClock().getTime());
                    compInstance.scheduler.getServiceTimelinePublisher().serviceAttemptUnregistered(comp.getContext(), FinalApplicationStatus.FAILED, scheduler.getDiagnostics().toString());
                }
                shouldFailService = true;
            }
            if (!this.failedBeforeLaunching) {
                ((ComponentInstance)compInstance).scheduler.executorService.submit(() -> compInstance.cleanupRegistry(event.getContainerId()));
            }
            scheduler.removeLiveCompInstance(event.getContainerId());
            ComponentInstance.handleComponentInstanceRelaunch(compInstance, event, this.failedBeforeLaunching, containerDiag);
            if (shouldFailService) {
                scheduler.getTerminationHandler().terminate(-1);
            }
        }
    }

    private static class ContainerBecomeNotReadyTransition
    extends BaseTransition {
        private ContainerBecomeNotReadyTransition() {
        }

        @Override
        public void transition(ComponentInstance compInstance, ComponentInstanceEvent event) {
            compInstance.setContainerState(ContainerState.RUNNING_BUT_UNREADY);
            compInstance.component.decContainersReady(true);
        }
    }

    private static class StartedAfterUpgradeTransition
    implements MultipleArcTransition<ComponentInstance, ComponentInstanceEvent, ComponentInstanceState> {
        private StartedAfterUpgradeTransition() {
        }

        public ComponentInstanceState transition(ComponentInstance instance, ComponentInstanceEvent event) {
            if (instance.pendingCancelUpgrade) {
                LOG.info("{} received started but cancellation pending", (Object)event.getContainerId());
                instance.upgradeInProgress.set(true);
                instance.cancelUpgrade();
                instance.pendingCancelUpgrade = false;
                return instance.getState();
            }
            instance.upgradeInProgress.set(false);
            instance.setContainerState(ContainerState.RUNNING_BUT_UNREADY);
            if (instance.component.getProbe() != null && instance.component.getProbe() instanceof DefaultProbe) {
                instance.initializeStatusRetriever(event, 30L);
            } else {
                instance.initializeStatusRetriever(event, 0L);
            }
            instance.initializeLocalizationStatusRetriever(event.getContainerId());
            Component.UpgradeStatus status = instance.getState().equals((Object)ComponentInstanceState.UPGRADING) ? instance.component.getUpgradeStatus() : instance.component.getCancelUpgradeStatus();
            status.decContainersThatNeedUpgrade();
            instance.serviceVersion = status.getTargetVersion();
            return ComponentInstanceState.REINITIALIZED;
        }
    }

    private static class ContainerBecomeReadyTransition
    extends BaseTransition {
        private final boolean isReinitialized;

        ContainerBecomeReadyTransition(boolean isReinitialized) {
            this.isReinitialized = isReinitialized;
        }

        @Override
        public void transition(ComponentInstance compInstance, ComponentInstanceEvent event) {
            compInstance.setContainerState(ContainerState.READY);
            if (!this.isReinitialized) {
                compInstance.component.incContainersReady(true);
            } else {
                compInstance.component.incContainersReady(false);
                ComponentEvent checkState = new ComponentEvent(compInstance.component.getName(), ComponentEventType.CHECK_STABLE);
                compInstance.scheduler.getDispatcher().getEventHandler().handle((Event)checkState);
            }
            compInstance.postContainerReady();
        }
    }

    private static class ContainerStartedTransition
    extends BaseTransition {
        private ContainerStartedTransition() {
        }

        @Override
        public void transition(ComponentInstance compInstance, ComponentInstanceEvent event) {
            compInstance.initializeStatusRetriever(event, 0L);
            compInstance.initializeLocalizationStatusRetriever(event.getContainerId());
            long containerStartTime = System.currentTimeMillis();
            try {
                ContainerTokenIdentifier containerTokenIdentifier = BuilderUtils.newContainerTokenIdentifier((Token)compInstance.getContainer().getContainerToken());
                containerStartTime = containerTokenIdentifier.getCreationTime();
            }
            catch (Exception e) {
                LOG.info("Could not get container creation time, using current time");
            }
            org.apache.hadoop.yarn.service.api.records.Container container = new org.apache.hadoop.yarn.service.api.records.Container();
            container.setId(event.getContainerId().toString());
            container.setLaunchTime(new Date(containerStartTime));
            container.setState(ContainerState.RUNNING_BUT_UNREADY);
            container.setBareHost(compInstance.getNodeId().getHost());
            container.setComponentInstanceName(compInstance.getCompInstanceName());
            if (compInstance.containerSpec != null) {
                compInstance.getCompSpec().removeContainer(compInstance.containerSpec);
            }
            compInstance.containerSpec = container;
            compInstance.getCompSpec().addContainer(container);
            compInstance.containerStartedTime = containerStartTime;
            compInstance.component.incRunningContainers();
            compInstance.serviceVersion = compInstance.scheduler.getApp().getVersion();
            if (compInstance.timelineServiceEnabled) {
                compInstance.serviceTimelinePublisher.componentInstanceStarted(container, compInstance);
            }
        }
    }
}

