/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell.find;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.find.BaseExpression;
import org.apache.hadoop.fs.shell.find.Expression;
import org.apache.hadoop.fs.shell.find.Find;
import org.apache.hadoop.fs.shell.find.FindOptions;
import org.apache.hadoop.fs.shell.find.MockFileSystem;
import org.apache.hadoop.fs.shell.find.Result;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestFind {
    @Rule
    public Timeout timeout = new Timeout(10000L, TimeUnit.MILLISECONDS);
    private static FileSystem mockFs;
    private static Configuration conf;
    private PathData item1 = null;
    private PathData item1a = null;
    private PathData item1aa = null;
    private PathData item1b = null;
    private PathData item2 = null;
    private PathData item3 = null;
    private PathData item4 = null;
    private PathData item5 = null;
    private PathData item5a = null;
    private PathData item5a1b = null;
    private PathData item5b = null;
    private PathData item5b5 = null;
    private PathData item5c = null;
    private PathData item5ca = null;
    private PathData item5d = null;
    private PathData item5d5c = null;
    private PathData item5e = null;
    private PathData item5e5ca = null;

    @Before
    public void setup() throws IOException {
        mockFs = MockFileSystem.setup();
        conf = mockFs.getConf();
    }

    @Test
    public void processOptionsFollowLink() throws IOException {
        Find find = new Find();
        String args = "-L path";
        find.processOptions(this.getArgs(args));
        Assert.assertTrue((boolean)find.getOptions().isFollowLink());
        Assert.assertFalse((boolean)find.getOptions().isFollowArgLink());
    }

    @Test
    public void processOptionsFollowArgLink() throws IOException {
        Find find = new Find();
        String args = "-H path";
        find.processOptions(this.getArgs(args));
        Assert.assertFalse((boolean)find.getOptions().isFollowLink());
        Assert.assertTrue((boolean)find.getOptions().isFollowArgLink());
    }

    @Test
    public void processOptionsFollowLinkFollowArgLink() throws IOException {
        Find find = new Find();
        String args = "-L -H path";
        find.processOptions(this.getArgs(args));
        Assert.assertTrue((boolean)find.getOptions().isFollowLink());
        Assert.assertFalse((boolean)find.getOptions().isFollowArgLink());
    }

    @Test
    public void processOptionsExpression() throws IOException {
        Find find = new Find();
        find.setConf(conf);
        String paths = "path1 path2 path3";
        String args = "-L -H " + paths + " -print -name test";
        LinkedList<String> argsList = this.getArgs(args);
        find.processOptions(argsList);
        LinkedList<String> pathList = this.getArgs(paths);
        Assert.assertEquals(pathList, argsList);
    }

    @Test
    public void processOptionsNoExpression() throws IOException {
        Find find = new Find();
        find.setConf(conf);
        String args = "path";
        String expected = "Print(;)";
        find.processOptions(this.getArgs(args));
        Expression expression = find.getRootExpression();
        Assert.assertEquals((Object)expected, (Object)expression.toString());
    }

    @Test
    public void processOptionsUnknown() throws IOException {
        Find find = new Find();
        find.setConf(conf);
        String args = "path -unknown";
        try {
            find.processOptions(this.getArgs(args));
            Assert.fail((String)"Unknown expression not caught");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void processOptionsKnownUnknown() throws IOException {
        Find find = new Find();
        find.setConf(conf);
        String args = "path -print -unknown -print";
        try {
            find.processOptions(this.getArgs(args));
            Assert.fail((String)"Unknown expression not caught");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void processOptionsNoPath() throws IOException {
        Find find = new Find();
        find.setConf(conf);
        String args = "-print";
        LinkedList<String> argsList = this.getArgs(args);
        find.processOptions(argsList);
        Assert.assertEquals(Collections.singletonList("."), argsList);
    }

    @Test
    public void processOptionsName() throws IOException {
        Find find = new Find();
        find.setConf(conf);
        String args = "path -name namemask";
        String expected = "And(;Name(namemask;),Print(;))";
        find.processOptions(this.getArgs(args));
        Expression expression = find.getRootExpression();
        Assert.assertEquals((Object)expected, (Object)expression.toString());
    }

    @Test
    public void processOptionsIname() throws IOException {
        Find find = new Find();
        find.setConf(conf);
        String args = "path -iname namemask";
        String expected = "And(;Iname-Name(namemask;),Print(;))";
        find.processOptions(this.getArgs(args));
        Expression expression = find.getRootExpression();
        Assert.assertEquals((Object)expected, (Object)expression.toString());
    }

    @Test
    public void processOptionsPrint() throws IOException {
        Find find = new Find();
        find.setConf(conf);
        String args = "path -print";
        String expected = "Print(;)";
        find.processOptions(this.getArgs(args));
        Expression expression = find.getRootExpression();
        Assert.assertEquals((Object)expected, (Object)expression.toString());
    }

    @Test
    public void processOptionsPrint0() throws IOException {
        Find find = new Find();
        find.setConf(conf);
        String args = "path -print0";
        String expected = "Print0-Print(;)";
        find.processOptions(this.getArgs(args));
        Expression expression = find.getRootExpression();
        Assert.assertEquals((Object)expected, (Object)expression.toString());
    }

    @Test
    public void processOptionsNoop() throws IOException {
        Find find = new Find();
        find.setConf(conf);
        String args = "path -name one -name two -print";
        String expected = "And(;And(;Name(one;),Name(two;)),Print(;))";
        find.processOptions(this.getArgs(args));
        Expression expression = find.getRootExpression();
        Assert.assertEquals((Object)expected, (Object)expression.toString());
    }

    @Test
    public void processOptionsA() throws IOException {
        Find find = new Find();
        find.setConf(conf);
        String args = "path -name one -a -name two -a -print";
        String expected = "And(;And(;Name(one;),Name(two;)),Print(;))";
        find.processOptions(this.getArgs(args));
        Expression expression = find.getRootExpression();
        Assert.assertEquals((Object)expected, (Object)expression.toString());
    }

    @Test
    public void processOptionsAnd() throws IOException {
        Find find = new Find();
        find.setConf(conf);
        String args = "path -name one -and -name two -and -print";
        String expected = "And(;And(;Name(one;),Name(two;)),Print(;))";
        find.processOptions(this.getArgs(args));
        Expression expression = find.getRootExpression();
        Assert.assertEquals((Object)expected, (Object)expression.toString());
    }

    @Test
    public void processArguments() throws IOException {
        LinkedList<PathData> items = this.createDirectories();
        Find find = new Find();
        find.setConf(conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setOut(out);
        PrintStream err = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setErr(err);
        Expression expr = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)expr.apply((PathData)Mockito.any(), Mockito.anyInt())).thenReturn((Object)Result.PASS);
        FileStatusChecker fsCheck = (FileStatusChecker)Mockito.mock(FileStatusChecker.class);
        TestExpression test = new TestExpression(expr, fsCheck);
        find.setRootExpression((Expression)test);
        find.processArguments(items);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{expr});
        ((Expression)inOrder.verify((Object)expr)).setOptions(find.getOptions());
        ((Expression)inOrder.verify((Object)expr)).prepare();
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1aa, 2);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item2, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item3, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item4, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5c, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5ca, 2);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5d, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5e, 1);
        ((Expression)inOrder.verify((Object)expr)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expr});
        InOrder inOrderFsCheck = Mockito.inOrder((Object[])new Object[]{fsCheck});
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1aa.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item2.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item3.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item4.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5c.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5ca.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5d.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5e.stat);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{fsCheck});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{err});
    }

    @Test
    public void processArgumentsDepthFirst() throws IOException {
        LinkedList<PathData> items = this.createDirectories();
        Find find = new Find();
        find.getOptions().setDepthFirst(true);
        find.setConf(conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setOut(out);
        PrintStream err = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setErr(err);
        Expression expr = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)expr.apply((PathData)Mockito.any(), Mockito.anyInt())).thenReturn((Object)Result.PASS);
        FileStatusChecker fsCheck = (FileStatusChecker)Mockito.mock(FileStatusChecker.class);
        TestExpression test = new TestExpression(expr, fsCheck);
        find.setRootExpression((Expression)test);
        find.processArguments(items);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{expr});
        ((Expression)inOrder.verify((Object)expr)).setOptions(find.getOptions());
        ((Expression)inOrder.verify((Object)expr)).prepare();
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1aa, 2);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item2, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item3, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item4, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5ca, 2);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5c, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5d, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5e, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5, 0);
        ((Expression)inOrder.verify((Object)expr)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expr});
        InOrder inOrderFsCheck = Mockito.inOrder((Object[])new Object[]{fsCheck});
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1aa.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item2.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item3.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item4.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5ca.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5c.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5d.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5e.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5.stat);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{fsCheck});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{err});
    }

    @Test
    public void processArgumentsOptionFollowArg() throws IOException {
        LinkedList<PathData> items = this.createDirectories();
        Find find = new Find();
        find.getOptions().setFollowArgLink(true);
        find.setConf(conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setOut(out);
        PrintStream err = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setErr(err);
        Expression expr = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)expr.apply((PathData)Mockito.any(), Mockito.anyInt())).thenReturn((Object)Result.PASS);
        FileStatusChecker fsCheck = (FileStatusChecker)Mockito.mock(FileStatusChecker.class);
        TestExpression test = new TestExpression(expr, fsCheck);
        find.setRootExpression((Expression)test);
        find.processArguments(items);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{expr});
        ((Expression)inOrder.verify((Object)expr)).setOptions(find.getOptions());
        ((Expression)inOrder.verify((Object)expr)).prepare();
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1aa, 2);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item2, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item3, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item4, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5c, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5ca, 2);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5d, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5e, 1);
        ((Expression)inOrder.verify((Object)expr)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expr});
        InOrder inOrderFsCheck = Mockito.inOrder((Object[])new Object[]{fsCheck});
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1aa.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item2.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck, Mockito.times((int)2))).check(this.item3.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5c.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5ca.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5d.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5e.stat);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{fsCheck});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{err});
    }

    @Test
    public void processArgumentsOptionFollow() throws IOException {
        LinkedList<PathData> items = this.createDirectories();
        Find find = new Find();
        find.getOptions().setFollowLink(true);
        find.setConf(conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setOut(out);
        PrintStream err = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setErr(err);
        Expression expr = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)expr.apply((PathData)Mockito.any(), Mockito.anyInt())).thenReturn((Object)Result.PASS);
        FileStatusChecker fsCheck = (FileStatusChecker)Mockito.mock(FileStatusChecker.class);
        TestExpression test = new TestExpression(expr, fsCheck);
        find.setRootExpression((Expression)test);
        find.processArguments(items);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{expr});
        ((Expression)inOrder.verify((Object)expr)).setOptions(find.getOptions());
        ((Expression)inOrder.verify((Object)expr)).prepare();
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1aa, 2);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item2, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item3, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item4, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5c, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5ca, 2);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5d, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5e, 1);
        ((Expression)inOrder.verify((Object)expr)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expr});
        InOrder inOrderFsCheck = Mockito.inOrder((Object[])new Object[]{fsCheck});
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1aa.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item2.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck, Mockito.times((int)2))).check(this.item3.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5c.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5ca.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5c.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck, Mockito.times((int)1))).check(this.item5ca.stat);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{fsCheck});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{err});
    }

    @Test
    public void processArgumentsMinDepth() throws IOException {
        LinkedList<PathData> items = this.createDirectories();
        Find find = new Find();
        find.getOptions().setMinDepth(1);
        find.setConf(conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setOut(out);
        PrintStream err = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setErr(err);
        Expression expr = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)expr.apply((PathData)Mockito.any(), Mockito.anyInt())).thenReturn((Object)Result.PASS);
        FileStatusChecker fsCheck = (FileStatusChecker)Mockito.mock(FileStatusChecker.class);
        TestExpression test = new TestExpression(expr, fsCheck);
        find.setRootExpression((Expression)test);
        find.processArguments(items);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{expr});
        ((Expression)inOrder.verify((Object)expr)).setOptions(find.getOptions());
        ((Expression)inOrder.verify((Object)expr)).prepare();
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1aa, 2);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5c, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5ca, 2);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5d, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5e, 1);
        ((Expression)inOrder.verify((Object)expr)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expr});
        InOrder inOrderFsCheck = Mockito.inOrder((Object[])new Object[]{fsCheck});
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1aa.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5c.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5ca.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5d.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5e.stat);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{fsCheck});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{err});
    }

    @Test
    public void processArgumentsMaxDepth() throws IOException {
        LinkedList<PathData> items = this.createDirectories();
        Find find = new Find();
        find.getOptions().setMaxDepth(1);
        find.setConf(conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setOut(out);
        PrintStream err = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setErr(err);
        Expression expr = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)expr.apply((PathData)Mockito.any(), Mockito.anyInt())).thenReturn((Object)Result.PASS);
        FileStatusChecker fsCheck = (FileStatusChecker)Mockito.mock(FileStatusChecker.class);
        TestExpression test = new TestExpression(expr, fsCheck);
        find.setRootExpression((Expression)test);
        find.processArguments(items);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{expr});
        ((Expression)inOrder.verify((Object)expr)).setOptions(find.getOptions());
        ((Expression)inOrder.verify((Object)expr)).prepare();
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item2, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item3, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item4, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5c, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5d, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5e, 1);
        ((Expression)inOrder.verify((Object)expr)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expr});
        InOrder inOrderFsCheck = Mockito.inOrder((Object[])new Object[]{fsCheck});
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item2.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item3.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item4.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5c.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5d.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5e.stat);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{fsCheck});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{err});
    }

    @Test
    public void processArgumentsDepthFirstMinDepth() throws IOException {
        LinkedList<PathData> items = this.createDirectories();
        Find find = new Find();
        find.getOptions().setDepthFirst(true);
        find.getOptions().setMinDepth(1);
        find.setConf(conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setOut(out);
        PrintStream err = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setErr(err);
        Expression expr = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)expr.apply((PathData)Mockito.any(), Mockito.anyInt())).thenReturn((Object)Result.PASS);
        FileStatusChecker fsCheck = (FileStatusChecker)Mockito.mock(FileStatusChecker.class);
        TestExpression test = new TestExpression(expr, fsCheck);
        find.setRootExpression((Expression)test);
        find.processArguments(items);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{expr});
        ((Expression)inOrder.verify((Object)expr)).setOptions(find.getOptions());
        ((Expression)inOrder.verify((Object)expr)).prepare();
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1aa, 2);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5ca, 2);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5c, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5d, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5e, 1);
        ((Expression)inOrder.verify((Object)expr)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expr});
        InOrder inOrderFsCheck = Mockito.inOrder((Object[])new Object[]{fsCheck});
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1aa.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5ca.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5c.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5d.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5e.stat);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{fsCheck});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{err});
    }

    @Test
    public void processArgumentsDepthFirstMaxDepth() throws IOException {
        LinkedList<PathData> items = this.createDirectories();
        Find find = new Find();
        find.getOptions().setDepthFirst(true);
        find.getOptions().setMaxDepth(1);
        find.setConf(conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setOut(out);
        PrintStream err = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setErr(err);
        Expression expr = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)expr.apply((PathData)Mockito.any(), Mockito.anyInt())).thenReturn((Object)Result.PASS);
        FileStatusChecker fsCheck = (FileStatusChecker)Mockito.mock(FileStatusChecker.class);
        TestExpression test = new TestExpression(expr, fsCheck);
        find.setRootExpression((Expression)test);
        find.processArguments(items);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{expr});
        ((Expression)inOrder.verify((Object)expr)).setOptions(find.getOptions());
        ((Expression)inOrder.verify((Object)expr)).prepare();
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item2, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item3, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item4, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5c, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5d, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5e, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5, 0);
        ((Expression)inOrder.verify((Object)expr)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expr});
        InOrder inOrderFsCheck = Mockito.inOrder((Object[])new Object[]{fsCheck});
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item2.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item3.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item4.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5c.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5d.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5e.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5.stat);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{fsCheck});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{err});
    }

    @Test
    public void processArgumentsNoDescend() throws IOException {
        LinkedList<PathData> items = this.createDirectories();
        Find find = new Find();
        find.setConf(conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setOut(out);
        PrintStream err = (PrintStream)Mockito.mock(PrintStream.class);
        find.getOptions().setErr(err);
        Expression expr = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)expr.apply((PathData)Mockito.any(), Mockito.anyInt())).thenReturn((Object)Result.PASS);
        Mockito.when((Object)expr.apply((PathData)Mockito.eq((Object)this.item1a), Mockito.anyInt())).thenReturn((Object)Result.STOP);
        FileStatusChecker fsCheck = (FileStatusChecker)Mockito.mock(FileStatusChecker.class);
        TestExpression test = new TestExpression(expr, fsCheck);
        find.setRootExpression((Expression)test);
        find.processArguments(items);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{expr});
        ((Expression)inOrder.verify((Object)expr)).setOptions(find.getOptions());
        ((Expression)inOrder.verify((Object)expr)).prepare();
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item1b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item2, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item3, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item4, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5, 0);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5a, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5b, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5c, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5ca, 2);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5d, 1);
        ((Expression)inOrder.verify((Object)expr)).apply(this.item5e, 1);
        ((Expression)inOrder.verify((Object)expr)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expr});
        InOrder inOrderFsCheck = Mockito.inOrder((Object[])new Object[]{fsCheck});
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item1b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item2.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item3.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item4.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5a.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5b.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5c.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5ca.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5d.stat);
        ((FileStatusChecker)inOrderFsCheck.verify((Object)fsCheck)).check(this.item5e.stat);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{fsCheck});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{err});
    }

    private LinkedList<PathData> createDirectories() throws IOException {
        this.item1 = this.createPathData("item1");
        this.item1a = this.createPathData("item1/item1a");
        this.item1aa = this.createPathData("item1/item1a/item1aa");
        this.item1b = this.createPathData("item1/item1b");
        this.item2 = this.createPathData("item2");
        this.item3 = this.createPathData("item3");
        this.item4 = this.createPathData("item4");
        this.item5 = this.createPathData("item5");
        this.item5a = this.createPathData("item5/item5a");
        this.item5a1b = this.createPathData("item5/item1/item1b");
        this.item5b = this.createPathData("item5/item5b");
        this.item5b5 = this.createPathData("item5/item5");
        this.item5c = this.createPathData("item5/item5c");
        this.item5ca = this.createPathData("item5/item5c/item5ca");
        this.item5d = this.createPathData("item5/item5d");
        this.item5d5c = this.createPathData("item5/item5/item5c");
        this.item5e = this.createPathData("item5/item5e");
        this.item5e5ca = this.createPathData("item5/item5/item5c/item5ca");
        LinkedList<PathData> args = new LinkedList<PathData>();
        Mockito.when((Object)this.item1.stat.isDirectory()).thenReturn((Object)true);
        Mockito.when((Object)this.item1a.stat.isDirectory()).thenReturn((Object)true);
        Mockito.when((Object)this.item1aa.stat.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)this.item1b.stat.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)this.item2.stat.isDirectory()).thenReturn((Object)true);
        Mockito.when((Object)this.item3.stat.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)this.item4.stat.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)this.item5.stat.isDirectory()).thenReturn((Object)true);
        Mockito.when((Object)this.item5a.stat.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)this.item5a1b.stat.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)this.item5b.stat.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)this.item5c.stat.isDirectory()).thenReturn((Object)true);
        Mockito.when((Object)this.item5ca.stat.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)this.item5d.stat.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)this.item5d5c.stat.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)this.item5e.stat.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)this.item5e5ca.stat.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)mockFs.listStatus((Path)Mockito.eq((Object)this.item1.path))).thenReturn((Object)new FileStatus[]{this.item1a.stat, this.item1b.stat});
        Mockito.when((Object)mockFs.listStatus((Path)Mockito.eq((Object)this.item1a.path))).thenReturn((Object)new FileStatus[]{this.item1aa.stat});
        Mockito.when((Object)mockFs.listStatus((Path)Mockito.eq((Object)this.item2.path))).thenReturn((Object)new FileStatus[0]);
        Mockito.when((Object)mockFs.listStatus((Path)Mockito.eq((Object)this.item5.path))).thenReturn((Object)new FileStatus[]{this.item5a.stat, this.item5b.stat, this.item5c.stat, this.item5d.stat, this.item5e.stat});
        Mockito.when((Object)mockFs.listStatus((Path)Mockito.eq((Object)this.item5c.path))).thenReturn((Object)new FileStatus[]{this.item5ca.stat});
        Mockito.when((Object)mockFs.listStatusIterator((Path)Mockito.any(Path.class))).thenAnswer((Answer)new Answer<RemoteIterator<FileStatus>>(){

            public RemoteIterator<FileStatus> answer(InvocationOnMock invocation) throws Throwable {
                final Path p = (Path)invocation.getArguments()[0];
                final FileStatus[] stats = mockFs.listStatus(p);
                return new RemoteIterator<FileStatus>(){
                    private int i = 0;

                    public boolean hasNext() throws IOException {
                        return this.i < stats.length;
                    }

                    public FileStatus next() throws IOException {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException("No more entry in " + p);
                        }
                        return stats[this.i++];
                    }
                };
            }
        });
        Mockito.when((Object)this.item1.stat.isSymlink()).thenReturn((Object)false);
        Mockito.when((Object)this.item1a.stat.isSymlink()).thenReturn((Object)false);
        Mockito.when((Object)this.item1aa.stat.isSymlink()).thenReturn((Object)false);
        Mockito.when((Object)this.item1b.stat.isSymlink()).thenReturn((Object)false);
        Mockito.when((Object)this.item2.stat.isSymlink()).thenReturn((Object)false);
        Mockito.when((Object)this.item3.stat.isSymlink()).thenReturn((Object)false);
        Mockito.when((Object)this.item4.stat.isSymlink()).thenReturn((Object)true);
        Mockito.when((Object)this.item5.stat.isSymlink()).thenReturn((Object)false);
        Mockito.when((Object)this.item5a.stat.isSymlink()).thenReturn((Object)true);
        Mockito.when((Object)this.item5b.stat.isSymlink()).thenReturn((Object)true);
        Mockito.when((Object)this.item5d.stat.isSymlink()).thenReturn((Object)true);
        Mockito.when((Object)this.item5e.stat.isSymlink()).thenReturn((Object)true);
        Mockito.when((Object)this.item4.stat.getSymlink()).thenReturn((Object)this.item3.path);
        Mockito.when((Object)this.item5a.stat.getSymlink()).thenReturn((Object)this.item1b.path);
        Mockito.when((Object)this.item5b.stat.getSymlink()).thenReturn((Object)this.item5.path);
        Mockito.when((Object)this.item5d.stat.getSymlink()).thenReturn((Object)this.item5c.path);
        Mockito.when((Object)this.item5e.stat.getSymlink()).thenReturn((Object)this.item5ca.path);
        args.add(this.item1);
        args.add(this.item2);
        args.add(this.item3);
        args.add(this.item4);
        args.add(this.item5);
        return args;
    }

    private PathData createPathData(String name) throws IOException {
        Path path = new Path(name);
        FileStatus fstat = (FileStatus)Mockito.mock(FileStatus.class);
        Mockito.when((Object)fstat.getPath()).thenReturn((Object)path);
        Mockito.when((Object)fstat.toString()).thenReturn((Object)("fileStatus:" + name));
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)path))).thenReturn((Object)fstat);
        PathData item = new PathData(path.toString(), conf);
        return item;
    }

    private LinkedList<String> getArgs(String cmd) {
        return new LinkedList<String>(Arrays.asList(cmd.split(" ")));
    }

    private class TestExpression
    extends BaseExpression
    implements Expression {
        private Expression expr;
        private FileStatusChecker checker;

        public TestExpression(Expression expr, FileStatusChecker checker) {
            this.expr = expr;
            this.checker = checker;
        }

        public Result apply(PathData item, int depth) throws IOException {
            FileStatus fileStatus = this.getFileStatus(item, depth);
            this.checker.check(fileStatus);
            return this.expr.apply(item, depth);
        }

        public void setOptions(FindOptions options) throws IOException {
            super.setOptions(options);
            this.expr.setOptions(options);
        }

        public void prepare() throws IOException {
            this.expr.prepare();
        }

        public void finish() throws IOException {
            this.expr.finish();
        }
    }

    private static interface FileStatusChecker {
        public void check(FileStatus var1);
    }
}

