/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.FileSystemException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.nfs.nfs3.RpcProgramNfs3;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.nfs.NfsFileType;
import org.apache.hadoop.nfs.NfsTime;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.response.WccAttr;
import org.apache.hadoop.nfs.nfs3.response.WccData;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.security.IdMappingServiceProvider;

public class Nfs3Utils {
    public static final String INODEID_PATH_PREFIX = "/.reserved/.inodes/";
    public static final String READ_RPC_START = "READ_RPC_CALL_START____";
    public static final String READ_RPC_END = "READ_RPC_CALL_END______";
    public static final String WRITE_RPC_START = "WRITE_RPC_CALL_START____";
    public static final String WRITE_RPC_END = "WRITE_RPC_CALL_END______";

    public static String getFileIdPath(FileHandle handle) {
        return Nfs3Utils.getFileIdPath(handle.getFileId());
    }

    public static String getFileIdPath(long fileId) {
        return INODEID_PATH_PREFIX + fileId;
    }

    public static HdfsFileStatus getFileStatus(DFSClient client, String fileIdPath) throws IOException {
        return client.getFileLinkInfo(fileIdPath);
    }

    public static Nfs3FileAttributes getNfs3FileAttrFromFileStatus(HdfsFileStatus fs, IdMappingServiceProvider iug) {
        NfsFileType fileType = fs.isDirectory() ? NfsFileType.NFSDIR : NfsFileType.NFSREG;
        fileType = fs.isSymlink() ? NfsFileType.NFSLNK : fileType;
        int nlink = fileType == NfsFileType.NFSDIR ? fs.getChildrenNum() + 2 : 1;
        long size = fileType == NfsFileType.NFSDIR ? Nfs3Utils.getDirSize(fs.getChildrenNum()) : fs.getLen();
        return new Nfs3FileAttributes(fileType, nlink, fs.getPermission().toShort(), iug.getUidAllowingUnknown(fs.getOwner()), iug.getGidAllowingUnknown(fs.getGroup()), size, 0L, fs.getFileId(), fs.getModificationTime(), fs.getAccessTime(), new Nfs3FileAttributes.Specdata3());
    }

    public static Nfs3FileAttributes getFileAttr(DFSClient client, String fileIdPath, IdMappingServiceProvider iug) throws IOException {
        HdfsFileStatus fs = Nfs3Utils.getFileStatus(client, fileIdPath);
        return fs == null ? null : Nfs3Utils.getNfs3FileAttrFromFileStatus(fs, iug);
    }

    public static long getDirSize(int childNum) {
        return (childNum + 2) * 32;
    }

    public static WccAttr getWccAttr(DFSClient client, String fileIdPath) throws IOException {
        HdfsFileStatus fstat = Nfs3Utils.getFileStatus(client, fileIdPath);
        if (fstat == null) {
            return null;
        }
        long size = fstat.isDirectory() ? Nfs3Utils.getDirSize(fstat.getChildrenNum()) : fstat.getLen();
        return new WccAttr(size, new NfsTime(fstat.getModificationTime()), new NfsTime(fstat.getModificationTime()));
    }

    public static WccAttr getWccAttr(Nfs3FileAttributes attr) {
        return attr == null ? new WccAttr() : new WccAttr(attr.getSize(), attr.getMtime(), attr.getCtime());
    }

    public static WccData createWccData(WccAttr preOpAttr, DFSClient dfsClient, String fileIdPath, IdMappingServiceProvider iug) throws IOException {
        Nfs3FileAttributes postOpDirAttr = Nfs3Utils.getFileAttr(dfsClient, fileIdPath, iug);
        return new WccData(preOpAttr, postOpDirAttr);
    }

    public static void writeChannel(Channel channel, XDR out, int xid) {
        if (channel == null) {
            RpcProgramNfs3.LOG.info("Null channel should only happen in tests. Do nothing.");
            return;
        }
        if (RpcProgramNfs3.LOG.isDebugEnabled()) {
            RpcProgramNfs3.LOG.debug(WRITE_RPC_END + xid);
        }
        ByteBuf outBuf = XDR.writeMessageTcp((XDR)out, (boolean)true);
        channel.writeAndFlush((Object)outBuf);
    }

    public static void writeChannelCommit(Channel channel, XDR out, int xid) {
        if (RpcProgramNfs3.LOG.isDebugEnabled()) {
            RpcProgramNfs3.LOG.debug("Commit done:" + xid);
        }
        ByteBuf outBuf = XDR.writeMessageTcp((XDR)out, (boolean)true);
        channel.writeAndFlush((Object)outBuf);
    }

    private static boolean isSet(int access, int bits) {
        return (access & bits) == bits;
    }

    public static int getAccessRights(int mode, int type) {
        int rtn = 0;
        if (Nfs3Utils.isSet(mode, 4)) {
            rtn |= 1;
            if (type == NfsFileType.NFSDIR.toValue()) {
                rtn |= 2;
            }
        }
        if (Nfs3Utils.isSet(mode, 2)) {
            rtn |= 4;
            rtn |= 8;
            rtn |= 0x10;
        }
        if (Nfs3Utils.isSet(mode, 1)) {
            rtn = type == NfsFileType.NFSREG.toValue() ? (rtn |= 0x20) : (rtn |= 2);
        }
        return rtn;
    }

    public static int getAccessRightsForUserGroup(int uid, int gid, int[] auxGids, Nfs3FileAttributes attr) {
        int mode = attr.getMode();
        if (uid == attr.getUid()) {
            return Nfs3Utils.getAccessRights(mode >> 6, attr.getType());
        }
        if (gid == attr.getGid()) {
            return Nfs3Utils.getAccessRights(mode >> 3, attr.getType());
        }
        if (auxGids != null) {
            for (int auxGid : auxGids) {
                if (attr.getGid() != auxGid) continue;
                return Nfs3Utils.getAccessRights(mode >> 3, attr.getType());
            }
        }
        return Nfs3Utils.getAccessRights(mode, attr.getType());
    }

    public static long bytesToLong(byte[] data) {
        long n = 0xFFL & (long)data[0];
        for (int i = 1; i < 8; ++i) {
            n = n << 8 | 0xFFL & (long)data[i];
        }
        return n;
    }

    public static byte[] longToByte(long v) {
        byte[] data = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return data;
    }

    public static long getElapsedTime(long startTimeNano) {
        return System.nanoTime() - startTimeNano;
    }

    public static int getNamenodeId(Configuration conf) {
        URI filesystemURI = FileSystem.getDefaultUri((Configuration)conf);
        return Nfs3Utils.getNamenodeId(conf, filesystemURI);
    }

    public static int getNamenodeId(Configuration conf, URI namenodeURI) {
        InetSocketAddress address = DFSUtilClient.getNNAddressCheckLogical((Configuration)conf, (URI)namenodeURI);
        return address.hashCode();
    }

    public static URI getResolvedURI(FileSystem fs, String exportPath) throws IOException {
        URI fsURI = fs.getUri();
        String scheme = fs.getScheme();
        if (scheme.equalsIgnoreCase("viewfs")) {
            ViewFileSystem.MountPoint[] mountPoints;
            ViewFileSystem viewFs = (ViewFileSystem)fs;
            for (ViewFileSystem.MountPoint mount : mountPoints = viewFs.getMountPoints()) {
                String mountedPath = mount.getMountedOnPath().toString();
                if (!exportPath.startsWith(mountedPath)) continue;
                String subpath = exportPath.substring(mountedPath.length());
                fsURI = mount.getTargetFileSystemURIs()[0].resolve(subpath);
                break;
            }
        } else if (scheme.equalsIgnoreCase("hdfs")) {
            fsURI = fsURI.resolve(exportPath);
        }
        if (!fsURI.getScheme().equalsIgnoreCase("hdfs")) {
            throw new FileSystemException("Only HDFS is supported as underlyingFileSystem, fs scheme:" + scheme + " uri to be added" + fsURI);
        }
        return fsURI;
    }
}

