/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.tools.rumen.JobTraceReader;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedTask;
import org.apache.hadoop.tools.rumen.LoggedTaskAttempt;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.client.util.YarnClientUtils;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.utils.SchedulerUtils;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SLSUtils {
    private static final String LABEL_FORMAT_ERR_MSG = "Input format for adding node-labels is not correct, it should be labelName1[(exclusive=true/false)],labelName2[] ..";

    public static String[] getRackHostName(String hostname) {
        NodeBase node = new NodeBase(hostname);
        return new String[]{node.getNetworkLocation().substring(1), node.getName()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<SLSRunner.NodeDetails> parseNodesFromRumenTrace(String jobTrace) throws IOException {
        HashSet<SLSRunner.NodeDetails> nodeSet = new HashSet<SLSRunner.NodeDetails>();
        File fin = new File(jobTrace);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        try (JobTraceReader reader = new JobTraceReader(new Path(fin.getAbsolutePath()), conf);){
            LoggedJob job;
            while ((job = (LoggedJob)reader.getNext()) != null) {
                LoggedTaskAttempt taskAttempt;
                for (LoggedTask mapTask : job.getMapTasks()) {
                    if (mapTask.getAttempts().size() == 0) continue;
                    taskAttempt = (LoggedTaskAttempt)mapTask.getAttempts().get(mapTask.getAttempts().size() - 1);
                    nodeSet.add(new SLSRunner.NodeDetails(taskAttempt.getHostName().getValue()));
                }
                for (LoggedTask reduceTask : job.getReduceTasks()) {
                    if (reduceTask.getAttempts().size() == 0) continue;
                    taskAttempt = (LoggedTaskAttempt)reduceTask.getAttempts().get(reduceTask.getAttempts().size() - 1);
                    nodeSet.add(new SLSRunner.NodeDetails(taskAttempt.getHostName().getValue()));
                }
            }
        }
        return nodeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<SLSRunner.NodeDetails> parseNodesFromSLSTrace(String jobTrace) throws IOException {
        HashSet<SLSRunner.NodeDetails> nodeSet = new HashSet<SLSRunner.NodeDetails>();
        JsonFactory jsonF = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper();
        try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(jobTrace), StandardCharsets.UTF_8);){
            MappingIterator i = mapper.readValues(jsonF.createParser((Reader)input), Map.class);
            while (i.hasNext()) {
                SLSUtils.addNodes(nodeSet, (Map)i.next());
            }
        }
        return nodeSet;
    }

    private static void addNodes(Set<SLSRunner.NodeDetails> nodeSet, Map jsonEntry) {
        if (jsonEntry.containsKey("num.nodes")) {
            int numNodes = Integer.parseInt(jsonEntry.get("num.nodes").toString());
            int numRacks = 1;
            if (jsonEntry.containsKey("num.racks")) {
                numRacks = Integer.parseInt(jsonEntry.get("num.racks").toString());
            }
            nodeSet.addAll(SLSUtils.generateNodes(numNodes, numRacks));
        }
        if (jsonEntry.containsKey("job.tasks")) {
            List tasks = (List)jsonEntry.get("job.tasks");
            for (Object o : tasks) {
                Map jsonTask = (Map)o;
                String hostname = (String)jsonTask.get("container.host");
                if (hostname == null) continue;
                nodeSet.add(new SLSRunner.NodeDetails(hostname));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<SLSRunner.NodeDetails> parseNodesFromNodeFile(String nodeFile, Resource nmDefaultResource) throws IOException {
        HashSet<SLSRunner.NodeDetails> nodeSet = new HashSet<SLSRunner.NodeDetails>();
        JsonFactory jsonF = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper();
        try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(nodeFile), StandardCharsets.UTF_8);){
            MappingIterator i = mapper.readValues(jsonF.createParser((Reader)input), Map.class);
            while (i.hasNext()) {
                Map jsonE = (Map)i.next();
                String rack = "/" + jsonE.get("rack");
                List tasks = (List)jsonE.get("nodes");
                for (Object o : tasks) {
                    ResourceInformation[] infors;
                    Map jsonNode = (Map)o;
                    SLSRunner.NodeDetails nodeDetails = new SLSRunner.NodeDetails(rack + "/" + jsonNode.get("node"));
                    Resource nodeResource = Resources.clone((Resource)nmDefaultResource);
                    for (ResourceInformation info : infors = ResourceUtils.getResourceTypesArray()) {
                        if (jsonNode.get(info.getName()) == null) continue;
                        nodeResource.setResourceValue(info.getName(), (long)Integer.parseInt(jsonNode.get(info.getName()).toString()));
                    }
                    nodeDetails.setNodeResource(nodeResource);
                    if (jsonNode.get("labels") != null) {
                        HashSet<NodeLabel> nodeLabels = new HashSet<NodeLabel>(YarnClientUtils.buildNodeLabelsFromStr((String)jsonNode.get("labels").toString()));
                        nodeDetails.setLabels(nodeLabels);
                    }
                    nodeSet.add(nodeDetails);
                }
            }
        }
        return nodeSet;
    }

    public static Set<SLSRunner.NodeDetails> generateNodes(int numNodes, int numRacks) {
        HashSet<SLSRunner.NodeDetails> nodeSet = new HashSet<SLSRunner.NodeDetails>();
        if (numRacks < 1) {
            numRacks = 1;
        }
        if (numRacks > numNodes) {
            numRacks = numNodes;
        }
        for (int i = 0; i < numNodes; ++i) {
            nodeSet.add(new SLSRunner.NodeDetails("/rack" + i % numRacks + "/node" + i));
        }
        return nodeSet;
    }

    public static void generateNodeTableMapping(Set<SLSRunner.NodeDetails> nodeDetails, String filePath) throws IOException {
        ArrayList<String> entries = new ArrayList<String>();
        for (SLSRunner.NodeDetails nodeDetail : nodeDetails) {
            if (!nodeDetail.getHostname().contains("/")) continue;
            String hostname = nodeDetail.getHostname();
            int lIndex = hostname.lastIndexOf("/");
            String node = hostname.substring(lIndex + 1);
            String rack = hostname.substring(0, lIndex);
            entries.add(node + " " + rack);
        }
        Files.write(Paths.get(filePath, new String[0]), entries, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
    }

    public static Set<String> generateSlsRunnerConfiguration(int nmMemory, int nmVCores, int amMemory, int amVCores, int slsRunnerPoolSize) {
        HashSet<String> slsProperties = new HashSet<String>();
        slsProperties.add(SchedulerUtils.generateProperty("yarn.sls.nm.memory.mb", String.valueOf(nmMemory)));
        slsProperties.add(SchedulerUtils.generateProperty("yarn.sls.nm.vcores", String.valueOf(nmVCores)));
        slsProperties.add(SchedulerUtils.generateProperty("yarn.sls.container.memory.mb", String.valueOf(amMemory)));
        slsProperties.add(SchedulerUtils.generateProperty("yarn.sls.container.vcores", String.valueOf(amVCores)));
        slsProperties.add(SchedulerUtils.generateProperty("yarn.sls.runner.pool.size", String.valueOf(slsRunnerPoolSize)));
        return slsProperties;
    }
}

