/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.services.AbfsListResult;
import org.apache.hadoop.fs.azurebfs.services.ListingSupport;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsListStatusRemoteIterator
implements RemoteIterator<FileStatus> {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsListStatusRemoteIterator.class);
    private static final boolean FETCH_ALL_FALSE = false;
    private static final int MAX_QUEUE_SIZE = 10;
    private static final long POLL_WAIT_TIME_IN_MS = 250L;
    private final Path path;
    private final ListingSupport listingSupport;
    private final ArrayBlockingQueue<AbfsListResult> listResultQueue;
    private final TracingContext tracingContext;
    private volatile boolean isAsyncInProgress = false;
    private boolean isIterationComplete = false;
    private String continuation;
    private Iterator<FileStatus> currIterator;

    public AbfsListStatusRemoteIterator(Path path, ListingSupport listingSupport, TracingContext tracingContext) throws IOException {
        this.path = path;
        this.listingSupport = listingSupport;
        this.tracingContext = tracingContext;
        this.listResultQueue = new ArrayBlockingQueue(10);
        this.currIterator = Collections.emptyIterator();
        this.addNextBatchIteratorToQueue();
        this.fetchBatchesAsync();
    }

    public boolean hasNext() throws IOException {
        if (this.currIterator.hasNext()) {
            return true;
        }
        this.currIterator = this.getNextIterator();
        return this.currIterator.hasNext();
    }

    public FileStatus next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currIterator.next();
    }

    private Iterator<FileStatus> getNextIterator() throws IOException {
        this.fetchBatchesAsync();
        try {
            AbfsListResult listResult = null;
            while (!(listResult != null || this.isIterationComplete && this.listResultQueue.isEmpty())) {
                listResult = this.listResultQueue.poll(250L, TimeUnit.MILLISECONDS);
            }
            if (listResult == null) {
                return Collections.emptyIterator();
            }
            if (listResult.isFailedListing()) {
                throw listResult.getListingException();
            }
            return listResult.getFileStatusIterator();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Thread got interrupted: {}", (Throwable)e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchBatchesAsync() {
        if (this.isAsyncInProgress || this.isIterationComplete) {
            return;
        }
        AbfsListStatusRemoteIterator abfsListStatusRemoteIterator = this;
        synchronized (abfsListStatusRemoteIterator) {
            if (this.isAsyncInProgress || this.isIterationComplete) {
                return;
            }
            this.isAsyncInProgress = true;
        }
        CompletableFuture.runAsync(() -> this.asyncOp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncOp() {
        try {
            while (!this.isIterationComplete && this.listResultQueue.size() <= 10) {
                this.addNextBatchIteratorToQueue();
            }
        }
        catch (IOException ioe) {
            LOG.error("Fetching filestatuses failed", (Throwable)ioe);
            try {
                this.listResultQueue.put(new AbfsListResult(ioe));
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                LOG.error("Thread got interrupted: {}", (Throwable)interruptedException);
            }
        }
        finally {
            AbfsListStatusRemoteIterator abfsListStatusRemoteIterator = this;
            synchronized (abfsListStatusRemoteIterator) {
                this.isAsyncInProgress = false;
            }
        }
    }

    private synchronized void addNextBatchIteratorToQueue() throws IOException {
        ArrayList<FileStatus> fileStatuses = new ArrayList<FileStatus>();
        try {
            try {
                this.continuation = this.listingSupport.listStatus(this.path, null, fileStatuses, false, this.continuation, this.tracingContext);
            }
            catch (AbfsRestOperationException ex) {
                AzureBlobFileSystem.checkException(this.path, ex, new AzureServiceErrorCode[0]);
            }
            if (!fileStatuses.isEmpty()) {
                this.listResultQueue.put(new AbfsListResult(fileStatuses.iterator()));
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.error("Thread interrupted", (Throwable)ie);
        }
        if (this.continuation == null || this.continuation.isEmpty()) {
            this.isIterationComplete = true;
        }
    }
}

