/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.YarnAppUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMapRTicketGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMapRTicketGenerator.class);

    public void generateToken(ApplicationSubmissionContext appCtx, String username, Configuration conf) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        ApplicationId appId = appCtx.getApplicationId();
        try {
            this.generateMapRLoginTicket(appId, username, conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeToken(ApplicationId appId, Configuration conf) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        try {
            FileSystem fs = FileSystem.get(conf);
            Path path = YarnAppUtil.getRMSystemDir(appId.toString(), fs, conf);
            fs.delete(path, true);
            if (LOG.isDebugEnabled()) {
                LOG.error("Removed system ticket dir from MFS: " + path);
            }
            Path appStagingDir = YarnAppUtil.getRMStagingDir(appId.toString(), fs, conf);
            fs.delete(appStagingDir, true);
            if (LOG.isDebugEnabled()) {
                LOG.error("Removed staging ticket dir from MFS: " + path);
            }
        }
        catch (IOException e) {
            throw new YarnRuntimeException(e);
        }
    }

    public abstract void generateMapRLoginTicket(ApplicationId var1, String var2, Configuration var3) throws IOException;
}

