/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.IndexRecord;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputCollector;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapred.Merger;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.SkipBadRecords;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.SpillRecord;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CryptoUtils;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormatCounter;
import org.apache.hadoop.mapreduce.lib.map.WrappedMapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormatCounter;
import org.apache.hadoop.mapreduce.security.IntermediateEncryptedStream;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.maprfs.AbstractMapRFileSystem;
import org.apache.hadoop.util.IndexedSortable;
import org.apache.hadoop.util.IndexedSorter;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.QuickSort;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
public class MapTask
extends Task {
    public static final int MAP_OUTPUT_INDEX_RECORD_LENGTH = 24;
    private static final FsPermission SHUFFLE_OUTPUT_PERM = new FsPermission(416);
    private JobSplit.TaskSplitIndex splitMetaInfo = new JobSplit.TaskSplitIndex();
    public static final int APPROX_HEADER_LENGTH = 150;
    private static final String JOB_ID_CONF = "mapreduce.job.id";
    private static final String MOUNT_PATH_CONF = "mapr.mapred.localvolume.mount.path";
    private static final String DEFAULT_MOUNT_PATH = "/var/mapr/local/node1/mapred";
    private static final Logger LOG = LoggerFactory.getLogger((String)MapTask.class.getName());
    private Progress mapPhase;
    private Progress sortPhase;

    public MapTask() {
        this.setPhase(TaskStatus.Phase.MAP);
        this.getProgress().setStatus("map");
    }

    public MapTask(String jobFile, TaskAttemptID taskId, int partition, JobSplit.TaskSplitIndex splitIndex, int numSlotsRequired) {
        super(jobFile, taskId, partition, numSlotsRequired);
        this.setPhase(TaskStatus.Phase.MAP);
        this.getProgress().setStatus("map");
        this.splitMetaInfo = splitIndex;
    }

    @Override
    public boolean isMapTask() {
        return true;
    }

    @Override
    public void localizeConfiguration(JobConf conf) throws IOException {
        super.localizeConfiguration(conf);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        if (this.isMapOrReduce()) {
            if (this.splitMetaInfo != null) {
                this.splitMetaInfo.write(out);
            } else {
                new JobSplit.TaskSplitIndex().write(out);
            }
            this.splitMetaInfo = null;
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        if (this.isMapOrReduce()) {
            this.splitMetaInfo.readFields(in);
        }
    }

    @Override
    public void run(JobConf job, TaskUmbilicalProtocol umbilical) throws IOException, ClassNotFoundException, InterruptedException {
        this.umbilical = umbilical;
        if (this.isMapTask()) {
            Path outDir = org.apache.hadoop.mapred.FileOutputFormat.getOutputPath(this.conf);
            FileSystem fileSystem = outDir != null ? FileSystem.get(outDir.toUri(), this.conf) : FileSystem.get(this.conf);
            if (fileSystem instanceof AbstractMapRFileSystem && outDir != null && fileSystem.exists(outDir)) {
                AbstractMapRFileSystem mapRFileSystem = (AbstractMapRFileSystem)fileSystem;
                String relativeMountPath = this.conf.get(MOUNT_PATH_CONF, DEFAULT_MOUNT_PATH);
                String jobId = job.get(JOB_ID_CONF);
                Path shuffleDir = new Path("maprfs:" + relativeMountPath + "/nodeManager/output/" + jobId);
                mapRFileSystem.copyAce(outDir, shuffleDir);
            }
            if (this.conf.getNumReduceTasks() == 0) {
                this.mapPhase = this.getProgress().addPhase("map", 1.0f);
            } else {
                this.mapPhase = this.getProgress().addPhase("map", 0.667f);
                this.sortPhase = this.getProgress().addPhase("sort", 0.333f);
            }
        }
        Task.TaskReporter reporter = this.startReporter(umbilical);
        boolean useNewApi = job.getUseNewMapper();
        this.initialize(job, this.getJobID(), reporter, useNewApi);
        if (this.jobCleanup) {
            this.runJobCleanupTask(umbilical, reporter);
            return;
        }
        if (this.jobSetup) {
            this.runJobSetupTask(umbilical, reporter);
            return;
        }
        if (this.taskCleanup) {
            this.runTaskCleanupTask(umbilical, reporter);
            return;
        }
        if (useNewApi) {
            this.runNewMapper(job, this.splitMetaInfo, umbilical, reporter);
        } else {
            this.runOldMapper(job, this.splitMetaInfo, umbilical, reporter);
        }
        this.done(umbilical, reporter);
    }

    public Progress getSortPhase() {
        return this.sortPhase;
    }

    private <T> T getSplitDetails(Path file, long offset) throws IOException {
        Class<?> cls;
        FileSystem fs = file.getFileSystem(this.conf);
        FSDataInputStream inFile = fs.open(file);
        inFile.seek(offset);
        String className = StringInterner.weakIntern(Text.readString(inFile));
        try {
            cls = this.conf.getClassByName(className);
        }
        catch (ClassNotFoundException ce) {
            IOException wrap = new IOException("Split class " + className + " not found");
            wrap.initCause(ce);
            throw wrap;
        }
        SerializationFactory factory = new SerializationFactory(this.conf);
        Deserializer<?> deserializer = factory.getDeserializer(cls);
        deserializer.open(inFile);
        T split = deserializer.deserialize(null);
        long pos = inFile.getPos();
        ((Counters.Counter)this.getCounters().findCounter(TaskCounter.SPLIT_RAW_BYTES)).increment(pos - offset);
        inFile.close();
        return split;
    }

    private <KEY, VALUE> MapOutputCollector<KEY, VALUE> createSortingCollector(JobConf job, Task.TaskReporter reporter) throws IOException, ClassNotFoundException {
        MapOutputCollector.Context context = new MapOutputCollector.Context(this, job, reporter);
        Class<?>[] collectorClasses = job.getClasses("mapreduce.job.map.output.collector.class", MapOutputBuffer.class);
        int remainingCollectors = collectorClasses.length;
        Throwable lastException = null;
        for (Class<?> clazz : collectorClasses) {
            try {
                if (!MapOutputCollector.class.isAssignableFrom(clazz)) {
                    throw new IOException("Invalid output collector class: " + clazz.getName() + " (does not implement MapOutputCollector)");
                }
                Class<MapOutputCollector> subclazz = clazz.asSubclass(MapOutputCollector.class);
                LOG.debug("Trying map output collector class: " + subclazz.getName());
                MapOutputCollector collector = ReflectionUtils.newInstance(subclazz, job);
                collector.init(context);
                LOG.info("Map output collector class = " + collector.getClass().getName());
                return collector;
            }
            catch (Exception e) {
                String msg = "Unable to initialize MapOutputCollector " + clazz.getName();
                if (--remainingCollectors > 0) {
                    msg = msg + " (" + remainingCollectors + " more collector(s) to try)";
                }
                lastException = e;
                LOG.warn(msg, (Throwable)e);
            }
        }
        if (lastException != null) {
            throw new IOException("Initialization of all the collectors failed. Error in last collector was:" + lastException.toString(), lastException);
        }
        throw new IOException("Initialization of all the collectors failed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <INKEY, INVALUE, OUTKEY, OUTVALUE> void runOldMapper(JobConf job, JobSplit.TaskSplitIndex splitIndex, TaskUmbilicalProtocol umbilical, Task.TaskReporter reporter) throws IOException, InterruptedException, ClassNotFoundException {
        org.apache.hadoop.mapred.InputSplit inputSplit = (org.apache.hadoop.mapred.InputSplit)this.getSplitDetails(new Path(splitIndex.getSplitLocation()), splitIndex.getStartOffset());
        this.updateJobWithSplit(job, inputSplit);
        reporter.setInputSplit(inputSplit);
        TrackedRecordReader in = this.isSkipping() ? new SkippingRecordReader(umbilical, reporter, job) : new TrackedRecordReader(reporter, job);
        job.setBoolean("mapreduce.job.skiprecords", this.isSkipping());
        int numReduceTasks = this.conf.getNumReduceTasks();
        LOG.info("numReduceTasks: " + numReduceTasks);
        MapOutputCollector collector = null;
        if (numReduceTasks > 0) {
            collector = this.createSortingCollector(job, reporter);
        } else {
            collector = new DirectMapOutputCollector();
            MapOutputCollector.Context context = new MapOutputCollector.Context(this, job, reporter);
            collector.init(context);
        }
        MapRunnable runner = ReflectionUtils.newInstance(job.getMapRunnerClass(), job);
        try {
            runner.run(in, new OldOutputCollector(collector, this.conf), reporter);
            this.mapPhase.complete();
            if (numReduceTasks > 0) {
                this.setPhase(TaskStatus.Phase.SORT);
            }
            this.statusUpdate(umbilical);
            collector.flush();
            in.close();
            in = null;
            collector.close();
            collector = null;
        }
        finally {
            this.closeQuietly(in);
            this.closeQuietly(collector);
        }
    }

    private void updateJobWithSplit(JobConf job, org.apache.hadoop.mapred.InputSplit inputSplit) {
        if (inputSplit instanceof FileSplit) {
            FileSplit fileSplit = (FileSplit)inputSplit;
            job.set("mapreduce.map.input.file", fileSplit.getPath().toString());
            job.setLong("mapreduce.map.input.start", fileSplit.getStart());
            if (LOG.isInfoEnabled()) {
                LOG.info("Processing Split: File = " + fileSplit.getPath().toString() + ", Start Offset = " + fileSplit.getStart() + ", Length = " + fileSplit.getLength());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <INKEY, INVALUE, OUTKEY, OUTVALUE> void runNewMapper(JobConf job, JobSplit.TaskSplitIndex splitIndex, TaskUmbilicalProtocol umbilical, Task.TaskReporter reporter) throws IOException, ClassNotFoundException, InterruptedException {
        TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl(job, this.getTaskID(), reporter);
        Mapper<?, ?, ?, ?> mapper = ReflectionUtils.newInstance(taskContext.getMapperClass(), job);
        InputFormat<?, ?> inputFormat = ReflectionUtils.newInstance(taskContext.getInputFormatClass(), job);
        InputSplit split = null;
        split = (InputSplit)this.getSplitDetails(new Path(splitIndex.getSplitLocation()), splitIndex.getStartOffset());
        LOG.info("Processing split: " + split);
        NewTrackingRecordReader input = new NewTrackingRecordReader(split, inputFormat, reporter, taskContext);
        job.setBoolean("mapreduce.job.skiprecords", this.isSkipping());
        RecordWriter output = null;
        output = job.getNumReduceTasks() == 0 ? new NewDirectOutputCollector(taskContext, job, umbilical, reporter) : new NewOutputCollector(taskContext, job, umbilical, reporter);
        MapContextImpl mapContext = new MapContextImpl(job, this.getTaskID(), input, output, this.committer, reporter, split);
        Mapper.Context mapperContext = new WrappedMapper().getMapContext(mapContext);
        try {
            ((RecordReader)input).initialize(split, mapperContext);
            mapper.run(mapperContext);
            this.mapPhase.complete();
            this.setPhase(TaskStatus.Phase.SORT);
            this.statusUpdate(umbilical);
            ((RecordReader)input).close();
            input = null;
            output.close(mapperContext);
            output = null;
        }
        finally {
            this.closeQuietly(input);
            this.closeQuietly(output, mapperContext);
        }
    }

    private <INKEY, INVALUE, OUTKEY, OUTVALUE> void closeQuietly(org.apache.hadoop.mapred.RecordReader<INKEY, INVALUE> c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException ie) {
                LOG.info("Ignoring exception during close for " + c, (Throwable)ie);
            }
        }
    }

    private <OUTKEY, OUTVALUE> void closeQuietly(MapOutputCollector<OUTKEY, OUTVALUE> c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception ie) {
                LOG.info("Ignoring exception during close for " + c, (Throwable)ie);
            }
        }
    }

    private <INKEY, INVALUE, OUTKEY, OUTVALUE> void closeQuietly(RecordReader<INKEY, INVALUE> c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception ie) {
                LOG.info("Ignoring exception during close for " + c, (Throwable)ie);
            }
        }
    }

    private <INKEY, INVALUE, OUTKEY, OUTVALUE> void closeQuietly(RecordWriter<OUTKEY, OUTVALUE> c, Mapper.Context mapperContext) {
        if (c != null) {
            try {
                c.close(mapperContext);
            }
            catch (Exception ie) {
                LOG.info("Ignoring exception during close for " + c, (Throwable)ie);
            }
        }
    }

    public static class MapBufferTooSmallException
    extends IOException {
        public MapBufferTooSmallException(String s) {
            super(s);
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"MapReduce"})
    @InterfaceStability.Unstable
    public static class MapOutputBuffer<K, V>
    implements MapOutputCollector<K, V>,
    IndexedSortable {
        private int partitions;
        private JobConf job;
        private Task.TaskReporter reporter;
        private Class<K> keyClass;
        private Class<V> valClass;
        private RawComparator<K> comparator;
        private SerializationFactory serializationFactory;
        private Serializer<K> keySerializer;
        private Serializer<V> valSerializer;
        private Task.CombinerRunner<K, V> combinerRunner;
        private Task.CombineOutputCollector<K, V> combineCollector;
        private CompressionCodec codec;
        private IntBuffer kvmeta;
        int kvstart;
        int kvend;
        int kvindex;
        int equator;
        int bufstart;
        int bufend;
        int bufmark;
        int bufindex;
        int bufvoid;
        byte[] kvbuffer;
        private final byte[] b0 = new byte[0];
        private static final int VALSTART = 0;
        private static final int KEYSTART = 1;
        private static final int PARTITION = 2;
        private static final int VALLEN = 3;
        private static final int NMETA = 4;
        private static final int METASIZE = 16;
        private int maxRec;
        private int softLimit;
        boolean spillInProgress;
        int bufferRemaining;
        volatile Throwable sortSpillException = null;
        int numSpills = 0;
        private int minSpillsForCombine;
        private IndexedSorter sorter;
        final ReentrantLock spillLock = new ReentrantLock();
        final Condition spillDone = this.spillLock.newCondition();
        final Condition spillReady = this.spillLock.newCondition();
        final BlockingBuffer bb = new BlockingBuffer();
        volatile boolean spillThreadRunning = false;
        final SpillThread spillThread = new SpillThread();
        private FileSystem rfs;
        private Counters.Counter mapOutputByteCounter;
        private Counters.Counter mapOutputRecordCounter;
        private Counters.Counter fileOutputByteCounter;
        final ArrayList<SpillRecord> indexCacheList = new ArrayList();
        private int totalIndexCacheMemory;
        private int indexCacheMemoryLimit;
        private static final int INDEX_CACHE_MEMORY_LIMIT_DEFAULT = 0x100000;
        private MapTask mapTask;
        private MapOutputFile mapOutputFile;
        private Progress sortPhase;
        private Counters.Counter spilledRecordsCounter;
        final byte[] META_BUFFER_TMP = new byte[16];

        @Override
        public void init(MapOutputCollector.Context context) throws IOException, ClassNotFoundException {
            this.job = context.getJobConf();
            this.reporter = context.getReporter();
            this.mapTask = context.getMapTask();
            this.mapOutputFile = this.mapTask.getMapOutputFile();
            this.sortPhase = this.mapTask.getSortPhase();
            this.spilledRecordsCounter = this.reporter.getCounter((Enum)TaskCounter.SPILLED_RECORDS);
            this.partitions = this.job.getNumReduceTasks();
            this.rfs = FileSystem.getLocal(this.job).getRaw();
            float spillper = this.job.getFloat("mapreduce.map.sort.spill.percent", 0.8f);
            int sortmb = this.job.getInt("mapreduce.task.io.sort.mb", 100);
            this.indexCacheMemoryLimit = this.job.getInt("mapreduce.task.index.cache.limit.bytes", 0x100000);
            if (spillper > 1.0f || spillper <= 0.0f) {
                throw new IOException("Invalid \"mapreduce.map.sort.spill.percent\": " + spillper);
            }
            if ((sortmb & 0x7FF) != sortmb) {
                throw new IOException("Invalid \"mapreduce.task.io.sort.mb\": " + sortmb);
            }
            this.sorter = ReflectionUtils.newInstance(this.job.getClass("map.sort.class", QuickSort.class, IndexedSorter.class), this.job);
            int maxMemUsage = sortmb << 20;
            maxMemUsage -= maxMemUsage % 16;
            this.kvbuffer = new byte[maxMemUsage];
            this.bufvoid = this.kvbuffer.length;
            this.kvmeta = ByteBuffer.wrap(this.kvbuffer).order(ByteOrder.nativeOrder()).asIntBuffer();
            this.setEquator(0);
            this.bufend = this.bufindex = this.equator;
            this.bufstart = this.bufindex;
            this.kvstart = this.kvend = this.kvindex;
            this.maxRec = this.kvmeta.capacity() / 4;
            this.bufferRemaining = this.softLimit = (int)((float)this.kvbuffer.length * spillper);
            LOG.info("mapreduce.task.io.sort.mb: " + sortmb);
            LOG.info("soft limit at " + this.softLimit);
            LOG.info("bufstart = " + this.bufstart + "; bufvoid = " + this.bufvoid);
            LOG.info("kvstart = " + this.kvstart + "; length = " + this.maxRec);
            this.comparator = this.job.getOutputKeyComparator();
            this.keyClass = this.job.getMapOutputKeyClass();
            this.valClass = this.job.getMapOutputValueClass();
            this.serializationFactory = new SerializationFactory(this.job);
            this.keySerializer = this.serializationFactory.getSerializer(this.keyClass);
            this.keySerializer.open(this.bb);
            this.valSerializer = this.serializationFactory.getSerializer(this.valClass);
            this.valSerializer.open(this.bb);
            this.mapOutputByteCounter = this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_BYTES);
            this.mapOutputRecordCounter = this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_RECORDS);
            this.fileOutputByteCounter = this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_MATERIALIZED_BYTES);
            if (this.job.getCompressMapOutput()) {
                Class<? extends CompressionCodec> codecClass = this.job.getMapOutputCompressorClass(DefaultCodec.class);
                this.codec = ReflectionUtils.newInstance(codecClass, this.job);
            } else {
                this.codec = null;
            }
            Counter combineInputCounter = this.reporter.getCounter((Enum)TaskCounter.COMBINE_INPUT_RECORDS);
            this.combinerRunner = Task.CombinerRunner.create(this.job, this.getTaskID(), (Counters.Counter)combineInputCounter, this.reporter, null);
            if (this.combinerRunner != null) {
                Counter combineOutputCounter = this.reporter.getCounter((Enum)TaskCounter.COMBINE_OUTPUT_RECORDS);
                this.combineCollector = new Task.CombineOutputCollector((Counters.Counter)combineOutputCounter, this.reporter, this.job);
            } else {
                this.combineCollector = null;
            }
            this.spillInProgress = false;
            this.minSpillsForCombine = this.job.getInt("mapreduce.map.combine.minspills", 3);
            this.spillThread.setDaemon(true);
            this.spillThread.setName("SpillThread");
            this.spillLock.lock();
            try {
                this.spillThread.start();
                while (!this.spillThreadRunning) {
                    this.spillDone.await();
                }
            }
            catch (InterruptedException e) {
                throw new IOException("Spill thread failed to initialize", e);
            }
            finally {
                this.spillLock.unlock();
            }
            if (this.sortSpillException != null) {
                throw new IOException("Spill thread failed to initialize", this.sortSpillException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void collect(K key, V value, int partition) throws IOException {
            this.reporter.progress();
            if (key.getClass() != this.keyClass) {
                throw new IOException("Type mismatch in key from map: expected " + this.keyClass.getName() + ", received " + key.getClass().getName());
            }
            if (value.getClass() != this.valClass) {
                throw new IOException("Type mismatch in value from map: expected " + this.valClass.getName() + ", received " + value.getClass().getName());
            }
            if (partition < 0 || partition >= this.partitions) {
                throw new IOException("Illegal partition for " + key + " (" + partition + ")");
            }
            this.checkSpillException();
            this.bufferRemaining -= 16;
            if (this.bufferRemaining <= 0) {
                this.spillLock.lock();
                try {
                    if (!this.spillInProgress) {
                        boolean bufsoftlimit;
                        int kvbidx = 4 * this.kvindex;
                        int kvbend = 4 * this.kvend;
                        int bUsed = this.distanceTo(kvbidx, this.bufindex);
                        boolean bl = bufsoftlimit = bUsed >= this.softLimit;
                        if ((kvbend + 16) % this.kvbuffer.length != this.equator - this.equator % 16) {
                            this.resetSpill();
                            this.bufferRemaining = Math.min(this.distanceTo(this.bufindex, kvbidx) - 32, this.softLimit - bUsed) - 16;
                        } else if (bufsoftlimit && this.kvindex != this.kvend) {
                            this.startSpill();
                            int avgRec = (int)(this.mapOutputByteCounter.getCounter() / this.mapOutputRecordCounter.getCounter());
                            int distkvi = this.distanceTo(this.bufindex, kvbidx);
                            int newPos = (this.bufindex + Math.max(31, Math.min(distkvi / 2, distkvi / (16 + avgRec) * 16))) % this.kvbuffer.length;
                            this.setEquator(newPos);
                            this.bufmark = this.bufindex = newPos;
                            int serBound = 4 * this.kvend;
                            this.bufferRemaining = Math.min(this.distanceTo(this.bufend, newPos), Math.min(this.distanceTo(newPos, serBound), this.softLimit)) - 32;
                        }
                    }
                }
                finally {
                    this.spillLock.unlock();
                }
            }
            try {
                int keystart = this.bufindex;
                this.keySerializer.serialize(key);
                if (this.bufindex < keystart) {
                    this.bb.shiftBufferedKey();
                    keystart = 0;
                }
                int valstart = this.bufindex;
                this.valSerializer.serialize(value);
                this.bb.write(this.b0, 0, 0);
                int valend = this.bb.markRecord();
                this.mapOutputRecordCounter.increment(1L);
                this.mapOutputByteCounter.increment(this.distanceTo(keystart, valend, this.bufvoid));
                this.kvmeta.put(this.kvindex + 2, partition);
                this.kvmeta.put(this.kvindex + 1, keystart);
                this.kvmeta.put(this.kvindex + 0, valstart);
                this.kvmeta.put(this.kvindex + 3, this.distanceTo(valstart, valend));
                this.kvindex = (this.kvindex - 4 + this.kvmeta.capacity()) % this.kvmeta.capacity();
            }
            catch (MapBufferTooSmallException e) {
                LOG.info("Record too large for in-memory buffer: " + e.getMessage());
                this.spillSingleRecord(key, value, partition);
                this.mapOutputRecordCounter.increment(1L);
                return;
            }
        }

        private TaskAttemptID getTaskID() {
            return this.mapTask.getTaskID();
        }

        private void setEquator(int pos) {
            this.equator = pos;
            int aligned = pos - pos % 16;
            this.kvindex = (int)(((long)aligned - 16L + (long)this.kvbuffer.length) % (long)this.kvbuffer.length) / 4;
            LOG.info("(EQUATOR) " + pos + " kvi " + this.kvindex + "(" + this.kvindex * 4 + ")");
        }

        private void resetSpill() {
            int e;
            this.bufstart = this.bufend = (e = this.equator);
            int aligned = e - e % 16;
            this.kvstart = this.kvend = (int)(((long)aligned - 16L + (long)this.kvbuffer.length) % (long)this.kvbuffer.length) / 4;
            LOG.info("(RESET) equator " + e + " kv " + this.kvstart + "(" + this.kvstart * 4 + ") kvi " + this.kvindex + "(" + this.kvindex * 4 + ")");
        }

        final int distanceTo(int i, int j) {
            return this.distanceTo(i, j, this.kvbuffer.length);
        }

        int distanceTo(int i, int j, int mod) {
            return i <= j ? j - i : mod - i + j;
        }

        int offsetFor(int metapos) {
            return metapos * 4;
        }

        @Override
        public int compare(int mi, int mj) {
            int kvjp;
            int kvi = this.offsetFor(mi % this.maxRec);
            int kvj = this.offsetFor(mj % this.maxRec);
            int kvip = this.kvmeta.get(kvi + 2);
            if (kvip != (kvjp = this.kvmeta.get(kvj + 2))) {
                return kvip - kvjp;
            }
            return this.comparator.compare(this.kvbuffer, this.kvmeta.get(kvi + 1), this.kvmeta.get(kvi + 0) - this.kvmeta.get(kvi + 1), this.kvbuffer, this.kvmeta.get(kvj + 1), this.kvmeta.get(kvj + 0) - this.kvmeta.get(kvj + 1));
        }

        @Override
        public void swap(int mi, int mj) {
            int iOff = mi % this.maxRec * 16;
            int jOff = mj % this.maxRec * 16;
            System.arraycopy(this.kvbuffer, iOff, this.META_BUFFER_TMP, 0, 16);
            System.arraycopy(this.kvbuffer, jOff, this.kvbuffer, iOff, 16);
            System.arraycopy(this.META_BUFFER_TMP, 0, this.kvbuffer, jOff, 16);
        }

        @Override
        public void flush() throws IOException, ClassNotFoundException, InterruptedException {
            LOG.info("Starting flush of map output");
            if (this.kvbuffer == null) {
                LOG.info("kvbuffer is null. Skipping flush.");
                return;
            }
            this.spillLock.lock();
            try {
                while (this.spillInProgress) {
                    this.reporter.progress();
                    this.spillDone.await();
                }
                this.checkSpillException();
                int kvbend = 4 * this.kvend;
                if ((kvbend + 16) % this.kvbuffer.length != this.equator - this.equator % 16) {
                    this.resetSpill();
                }
                if (this.kvindex != this.kvend) {
                    this.kvend = (this.kvindex + 4) % this.kvmeta.capacity();
                    this.bufend = this.bufmark;
                    LOG.info("Spilling map output");
                    LOG.info("bufstart = " + this.bufstart + "; bufend = " + this.bufmark + "; bufvoid = " + this.bufvoid);
                    LOG.info("kvstart = " + this.kvstart + "(" + this.kvstart * 4 + "); kvend = " + this.kvend + "(" + this.kvend * 4 + "); length = " + (this.distanceTo(this.kvend, this.kvstart, this.kvmeta.capacity()) + 1) + "/" + this.maxRec);
                    this.sortAndSpill();
                }
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while waiting for the writer", e);
            }
            finally {
                this.spillLock.unlock();
            }
            assert (!this.spillLock.isHeldByCurrentThread());
            try {
                this.spillThread.interrupt();
                this.spillThread.join();
            }
            catch (InterruptedException e) {
                throw new IOException("Spill failed", e);
            }
            this.kvbuffer = null;
            this.mergeParts();
            Path outputPath = this.mapOutputFile.getOutputFile();
            this.fileOutputByteCounter.increment(this.rfs.getFileStatus(outputPath).getLen());
            if (!SHUFFLE_OUTPUT_PERM.equals(SHUFFLE_OUTPUT_PERM.applyUMask(FsPermission.getUMask(this.job)))) {
                Path indexPath = this.mapOutputFile.getOutputIndexFile();
                this.rfs.setPermission(outputPath, SHUFFLE_OUTPUT_PERM);
                this.rfs.setPermission(indexPath, SHUFFLE_OUTPUT_PERM);
            }
        }

        @Override
        public void close() {
        }

        private void checkSpillException() throws IOException {
            Throwable lspillException = this.sortSpillException;
            if (lspillException != null) {
                if (lspillException instanceof Error) {
                    String logMsg = "Task " + this.getTaskID() + " failed : " + StringUtils.stringifyException(lspillException);
                    this.mapTask.reportFatalError(this.getTaskID(), lspillException, logMsg, false);
                }
                throw new IOException("Spill failed", lspillException);
            }
        }

        private void startSpill() {
            assert (!this.spillInProgress);
            this.kvend = (this.kvindex + 4) % this.kvmeta.capacity();
            this.bufend = this.bufmark;
            this.spillInProgress = true;
            LOG.info("Spilling map output");
            LOG.info("bufstart = " + this.bufstart + "; bufend = " + this.bufmark + "; bufvoid = " + this.bufvoid);
            LOG.info("kvstart = " + this.kvstart + "(" + this.kvstart * 4 + "); kvend = " + this.kvend + "(" + this.kvend * 4 + "); length = " + (this.distanceTo(this.kvend, this.kvstart, this.kvmeta.capacity()) + 1) + "/" + this.maxRec);
            this.spillReady.signal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sortAndSpill() throws IOException, ClassNotFoundException, InterruptedException {
            long size = this.distanceTo(this.bufstart, this.bufend, this.bufvoid) + this.partitions * 150;
            FSDataOutputStream out = null;
            FSDataOutputStream partitionOut = null;
            try {
                SpillRecord spillRec = new SpillRecord(this.partitions);
                Path filename = this.mapOutputFile.getSpillFileForWrite(this.numSpills, size);
                out = this.rfs.create(filename);
                int mstart = this.kvend / 4;
                int mend = 1 + (this.kvstart >= this.kvend ? this.kvstart : this.kvmeta.capacity() + this.kvstart) / 4;
                this.sorter.sort(this, mstart, mend, this.reporter);
                int spindex = mstart;
                IndexRecord rec = new IndexRecord();
                InMemValBytes value = new InMemValBytes();
                for (int i = 0; i < this.partitions; ++i) {
                    IFile.Writer<K, V> writer = null;
                    try {
                        long segmentStart = out.getPos();
                        partitionOut = IntermediateEncryptedStream.wrapIfNecessary((Configuration)this.job, out, false, filename);
                        writer = new IFile.Writer<K, V>(this.job, partitionOut, this.keyClass, this.valClass, this.codec, this.spilledRecordsCounter);
                        if (this.combinerRunner == null) {
                            DataInputBuffer key = new DataInputBuffer();
                            while (spindex < mend && this.kvmeta.get(this.offsetFor(spindex % this.maxRec) + 2) == i) {
                                int kvoff = this.offsetFor(spindex % this.maxRec);
                                int keystart = this.kvmeta.get(kvoff + 1);
                                int valstart = this.kvmeta.get(kvoff + 0);
                                key.reset(this.kvbuffer, keystart, valstart - keystart);
                                this.getVBytesForOffset(kvoff, value);
                                writer.append(key, value);
                                ++spindex;
                            }
                        } else {
                            int spstart = spindex;
                            while (spindex < mend && this.kvmeta.get(this.offsetFor(spindex % this.maxRec) + 2) == i) {
                                ++spindex;
                            }
                            if (spstart != spindex) {
                                this.combineCollector.setWriter(writer);
                                MRResultIterator kvIter = new MRResultIterator(spstart, spindex);
                                this.combinerRunner.combine(kvIter, this.combineCollector);
                            }
                        }
                        writer.close();
                        if (partitionOut != out) {
                            partitionOut.close();
                            partitionOut = null;
                        }
                        rec.startOffset = segmentStart;
                        rec.rawLength = writer.getRawLength() + (long)CryptoUtils.cryptoPadding(this.job);
                        rec.partLength = writer.getCompressedLength() + (long)CryptoUtils.cryptoPadding(this.job);
                        spillRec.putIndex(rec, i);
                        writer = null;
                        continue;
                    }
                    finally {
                        if (null != writer) {
                            writer.close();
                        }
                    }
                }
                if (this.totalIndexCacheMemory >= this.indexCacheMemoryLimit) {
                    Path indexFilename = this.mapOutputFile.getSpillIndexFileForWrite(this.numSpills, this.partitions * 24);
                    IntermediateEncryptedStream.addSpillIndexFile(indexFilename, this.job);
                    spillRec.writeToFile(indexFilename, this.job);
                } else {
                    this.indexCacheList.add(spillRec);
                    this.totalIndexCacheMemory += spillRec.size() * 24;
                }
                LOG.info("Finished spill " + this.numSpills);
                ++this.numSpills;
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (partitionOut != null) {
                    partitionOut.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void spillSingleRecord(K key, V value, int partition) throws IOException {
            long size = this.kvbuffer.length + this.partitions * 150;
            FSDataOutputStream out = null;
            FSDataOutputStream partitionOut = null;
            try {
                SpillRecord spillRec = new SpillRecord(this.partitions);
                Path filename = this.mapOutputFile.getSpillFileForWrite(this.numSpills, size);
                out = this.rfs.create(filename);
                IndexRecord rec = new IndexRecord();
                for (int i = 0; i < this.partitions; ++i) {
                    IFile.Writer<K, V> writer = null;
                    try {
                        long segmentStart = out.getPos();
                        partitionOut = IntermediateEncryptedStream.wrapIfNecessary((Configuration)this.job, out, false, filename);
                        writer = new IFile.Writer<K, V>(this.job, partitionOut, this.keyClass, this.valClass, this.codec, this.spilledRecordsCounter);
                        if (i == partition) {
                            long recordStart = out.getPos();
                            writer.append(key, value);
                            this.mapOutputByteCounter.increment(out.getPos() - recordStart);
                        }
                        writer.close();
                        if (partitionOut != out) {
                            partitionOut.close();
                            partitionOut = null;
                        }
                        rec.startOffset = segmentStart;
                        rec.rawLength = writer.getRawLength() + (long)CryptoUtils.cryptoPadding(this.job);
                        rec.partLength = writer.getCompressedLength() + (long)CryptoUtils.cryptoPadding(this.job);
                        spillRec.putIndex(rec, i);
                        writer = null;
                        continue;
                    }
                    catch (IOException e) {
                        if (null != writer) {
                            writer.close();
                        }
                        throw e;
                    }
                }
                if (this.totalIndexCacheMemory >= this.indexCacheMemoryLimit) {
                    Path indexFilename = this.mapOutputFile.getSpillIndexFileForWrite(this.numSpills, this.partitions * 24);
                    IntermediateEncryptedStream.addSpillIndexFile(indexFilename, this.job);
                    spillRec.writeToFile(indexFilename, this.job);
                } else {
                    this.indexCacheList.add(spillRec);
                    this.totalIndexCacheMemory += spillRec.size() * 24;
                }
                ++this.numSpills;
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (partitionOut != null) {
                    partitionOut.close();
                }
            }
        }

        private void getVBytesForOffset(int kvoff, InMemValBytes vbytes) {
            int vallen = this.kvmeta.get(kvoff + 3);
            assert (vallen >= 0);
            vbytes.reset(this.kvbuffer, this.kvmeta.get(kvoff + 0), vallen);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mergeParts() throws IOException, InterruptedException, ClassNotFoundException {
            int i;
            long finalOutFileSize = 0L;
            long finalIndexFileSize = 0L;
            Path[] filename = new Path[this.numSpills];
            TaskAttemptID mapId = this.getTaskID();
            for (i = 0; i < this.numSpills; ++i) {
                filename[i] = this.mapOutputFile.getSpillFile(i);
                finalOutFileSize += this.rfs.getFileStatus(filename[i]).getLen();
            }
            if (this.numSpills == 1) {
                Path indexFileOutput = this.mapOutputFile.getOutputIndexFileForWriteInVolume(filename[0]);
                this.sameVolRename(filename[0], this.mapOutputFile.getOutputFileForWriteInVolume(filename[0]));
                if (this.indexCacheList.size() == 0) {
                    Path indexFilePath = this.mapOutputFile.getSpillIndexFile(0);
                    IntermediateEncryptedStream.validateSpillIndexFile(indexFilePath, this.job);
                    this.sameVolRename(indexFilePath, indexFileOutput);
                } else {
                    this.indexCacheList.get(0).writeToFile(indexFileOutput, this.job);
                }
                IntermediateEncryptedStream.addSpillIndexFile(indexFileOutput, this.job);
                this.sortPhase.complete();
                return;
            }
            for (i = this.indexCacheList.size(); i < this.numSpills; ++i) {
                Path indexFileName = this.mapOutputFile.getSpillIndexFile(i);
                IntermediateEncryptedStream.validateSpillIndexFile(indexFileName, this.job);
                this.indexCacheList.add(new SpillRecord(indexFileName, this.job));
            }
            finalIndexFileSize = this.partitions * 24;
            Path finalOutputFile = this.mapOutputFile.getOutputFileForWrite(finalOutFileSize += (long)(this.partitions * 150));
            Path finalIndexFile = this.mapOutputFile.getOutputIndexFileForWrite(finalIndexFileSize);
            IntermediateEncryptedStream.addSpillIndexFile(finalIndexFile, this.job);
            FSDataOutputStream finalOut = this.rfs.create(finalOutputFile, true, 4096);
            FSDataOutputStream finalPartitionOut = null;
            if (this.numSpills == 0) {
                IndexRecord rec = new IndexRecord();
                SpillRecord sr = new SpillRecord(this.partitions);
                try {
                    for (int i2 = 0; i2 < this.partitions; ++i2) {
                        long segmentStart = finalOut.getPos();
                        finalPartitionOut = IntermediateEncryptedStream.wrapIfNecessary((Configuration)this.job, finalOut, false, finalOutputFile);
                        IFile.Writer<K, V> writer = new IFile.Writer<K, V>(this.job, finalPartitionOut, this.keyClass, this.valClass, this.codec, null);
                        writer.close();
                        if (finalPartitionOut != finalOut) {
                            finalPartitionOut.close();
                            finalPartitionOut = null;
                        }
                        rec.startOffset = segmentStart;
                        rec.rawLength = writer.getRawLength() + (long)CryptoUtils.cryptoPadding(this.job);
                        rec.partLength = writer.getCompressedLength() + (long)CryptoUtils.cryptoPadding(this.job);
                        sr.putIndex(rec, i2);
                    }
                    sr.writeToFile(finalIndexFile, this.job);
                }
                finally {
                    finalOut.close();
                    if (finalPartitionOut != null) {
                        finalPartitionOut.close();
                    }
                }
                this.sortPhase.complete();
                return;
            }
            this.sortPhase.addPhases(this.partitions);
            IndexRecord rec = new IndexRecord();
            SpillRecord spillRec = new SpillRecord(this.partitions);
            for (int parts = 0; parts < this.partitions; ++parts) {
                ArrayList segmentList = new ArrayList(this.numSpills);
                for (int i3 = 0; i3 < this.numSpills; ++i3) {
                    IndexRecord indexRecord = this.indexCacheList.get(i3).getIndex(parts);
                    Merger.Segment s = new Merger.Segment((Configuration)this.job, this.rfs, filename[i3], indexRecord.startOffset, indexRecord.partLength, this.codec, true);
                    segmentList.add(i3, s);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("MapId=" + mapId + " Reducer=" + parts + "Spill =" + i3 + "(" + indexRecord.startOffset + "," + indexRecord.rawLength + ", " + indexRecord.partLength + ")");
                }
                int mergeFactor = this.job.getInt("mapreduce.task.io.sort.factor", 10);
                boolean sortSegments = segmentList.size() > mergeFactor;
                RawKeyValueIterator kvIter = Merger.merge((Configuration)this.job, this.rfs, this.keyClass, this.valClass, this.codec, segmentList, mergeFactor, new Path(mapId.toString()), this.job.getOutputKeyComparator(), this.reporter, sortSegments, null, this.spilledRecordsCounter, this.sortPhase.phase(), TaskType.MAP);
                long segmentStart = finalOut.getPos();
                finalPartitionOut = IntermediateEncryptedStream.wrapIfNecessary((Configuration)this.job, finalOut, false, finalOutputFile);
                IFile.Writer<K, V> writer = new IFile.Writer<K, V>(this.job, finalPartitionOut, this.keyClass, this.valClass, this.codec, this.spilledRecordsCounter);
                if (this.combinerRunner == null || this.numSpills < this.minSpillsForCombine) {
                    Merger.writeFile(kvIter, writer, this.reporter, this.job);
                } else {
                    this.combineCollector.setWriter(writer);
                    this.combinerRunner.combine(kvIter, this.combineCollector);
                }
                writer.close();
                if (finalPartitionOut != finalOut) {
                    finalPartitionOut.close();
                    finalPartitionOut = null;
                }
                this.sortPhase.startNextPhase();
                rec.startOffset = segmentStart;
                rec.rawLength = writer.getRawLength() + (long)CryptoUtils.cryptoPadding(this.job);
                rec.partLength = writer.getCompressedLength() + (long)CryptoUtils.cryptoPadding(this.job);
                spillRec.putIndex(rec, parts);
            }
            spillRec.writeToFile(finalIndexFile, this.job);
            finalOut.close();
            if (finalPartitionOut != null) {
                finalPartitionOut.close();
            }
            for (int i4 = 0; i4 < this.numSpills; ++i4) {
                this.rfs.delete(filename[i4], true);
            }
        }

        private void sameVolRename(Path srcPath, Path dstPath) throws IOException {
            RawLocalFileSystem rfs = (RawLocalFileSystem)this.rfs;
            File src = rfs.pathToFile(srcPath);
            File dst = rfs.pathToFile(dstPath);
            if (!dst.getParentFile().exists() && !dst.getParentFile().mkdirs()) {
                throw new IOException("Unable to rename " + src + " to " + dst + ": couldn't create parent directory");
            }
            if (!src.renameTo(dst)) {
                throw new IOException("Unable to rename " + src + " to " + dst);
            }
        }

        protected class MRResultIterator
        implements RawKeyValueIterator {
            private final DataInputBuffer keybuf = new DataInputBuffer();
            private final InMemValBytes vbytes = new InMemValBytes();
            private final int end;
            private int current;

            public MRResultIterator(int start, int end) {
                this.end = end;
                this.current = start - 1;
            }

            @Override
            public boolean next() throws IOException {
                return ++this.current < this.end;
            }

            @Override
            public DataInputBuffer getKey() throws IOException {
                int kvoff = MapOutputBuffer.this.offsetFor(this.current % MapOutputBuffer.this.maxRec);
                this.keybuf.reset(MapOutputBuffer.this.kvbuffer, MapOutputBuffer.this.kvmeta.get(kvoff + 1), MapOutputBuffer.this.kvmeta.get(kvoff + 0) - MapOutputBuffer.this.kvmeta.get(kvoff + 1));
                return this.keybuf;
            }

            @Override
            public DataInputBuffer getValue() throws IOException {
                MapOutputBuffer.this.getVBytesForOffset(MapOutputBuffer.this.offsetFor(this.current % MapOutputBuffer.this.maxRec), this.vbytes);
                return this.vbytes;
            }

            @Override
            public Progress getProgress() {
                return null;
            }

            @Override
            public void close() {
            }
        }

        protected class InMemValBytes
        extends DataInputBuffer {
            private byte[] buffer;
            private int start;
            private int length;

            protected InMemValBytes() {
            }

            @Override
            public void reset(byte[] buffer, int start, int length) {
                this.buffer = buffer;
                this.start = start;
                this.length = length;
                if (start + length > MapOutputBuffer.this.bufvoid) {
                    this.buffer = new byte[this.length];
                    int taillen = MapOutputBuffer.this.bufvoid - start;
                    System.arraycopy(buffer, start, this.buffer, 0, taillen);
                    System.arraycopy(buffer, 0, this.buffer, taillen, length - taillen);
                    this.start = 0;
                }
                super.reset(this.buffer, this.start, this.length);
            }
        }

        protected class SpillThread
        extends Thread {
            protected SpillThread() {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                MapOutputBuffer.this.spillLock.lock();
                MapOutputBuffer.this.spillThreadRunning = true;
                try {
                    try {}
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        MapOutputBuffer.this.spillLock.unlock();
                        MapOutputBuffer.this.spillThreadRunning = false;
                        return;
                    }
                }
                catch (Throwable throwable) {
                    MapOutputBuffer.this.spillLock.unlock();
                    MapOutputBuffer.this.spillThreadRunning = false;
                    throw throwable;
                }
                while (true) {
                    MapOutputBuffer.this.spillDone.signal();
                    while (!MapOutputBuffer.this.spillInProgress) {
                        MapOutputBuffer.this.spillReady.await();
                    }
                    try {
                        MapOutputBuffer.this.spillLock.unlock();
                        MapOutputBuffer.this.sortAndSpill();
                        continue;
                    }
                    catch (Throwable t) {
                        MapOutputBuffer.this.sortSpillException = t;
                        continue;
                    }
                    finally {
                        MapOutputBuffer.this.spillLock.lock();
                        if (MapOutputBuffer.this.bufend < MapOutputBuffer.this.bufstart) {
                            MapOutputBuffer.this.bufvoid = MapOutputBuffer.this.kvbuffer.length;
                        }
                        MapOutputBuffer.this.kvstart = MapOutputBuffer.this.kvend;
                        MapOutputBuffer.this.bufstart = MapOutputBuffer.this.bufend;
                        MapOutputBuffer.this.spillInProgress = false;
                        continue;
                    }
                    break;
                }
            }
        }

        public class Buffer
        extends OutputStream {
            private final byte[] scratch = new byte[1];

            @Override
            public void write(int v) throws IOException {
                this.scratch[0] = (byte)v;
                this.write(this.scratch, 0, 1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                MapOutputBuffer.this.bufferRemaining -= len;
                if (MapOutputBuffer.this.bufferRemaining <= 0) {
                    boolean blockwrite = false;
                    MapOutputBuffer.this.spillLock.lock();
                    try {
                        do {
                            MapOutputBuffer.this.checkSpillException();
                            int kvbidx = 4 * MapOutputBuffer.this.kvindex;
                            int kvbend = 4 * MapOutputBuffer.this.kvend;
                            int distkvi = MapOutputBuffer.this.distanceTo(MapOutputBuffer.this.bufindex, kvbidx);
                            int distkve = MapOutputBuffer.this.distanceTo(MapOutputBuffer.this.bufindex, kvbend);
                            boolean bl = distkvi <= distkve ? distkvi <= len + 32 : (blockwrite = distkve <= len || MapOutputBuffer.this.distanceTo(MapOutputBuffer.this.bufend, kvbidx) < 32);
                            if (!MapOutputBuffer.this.spillInProgress && blockwrite) {
                                if ((kvbend + 16) % MapOutputBuffer.this.kvbuffer.length != MapOutputBuffer.this.equator - MapOutputBuffer.this.equator % 16) {
                                    MapOutputBuffer.this.resetSpill();
                                    MapOutputBuffer.this.bufferRemaining = Math.min(distkvi - 32, MapOutputBuffer.this.softLimit - MapOutputBuffer.this.distanceTo(kvbidx, MapOutputBuffer.this.bufindex)) - len;
                                    continue;
                                }
                                if (MapOutputBuffer.this.kvindex != MapOutputBuffer.this.kvend) {
                                    MapOutputBuffer.this.startSpill();
                                    MapOutputBuffer.this.setEquator(MapOutputBuffer.this.bufmark);
                                } else {
                                    int size = MapOutputBuffer.this.distanceTo(MapOutputBuffer.this.bufstart, MapOutputBuffer.this.bufindex) + len;
                                    MapOutputBuffer.this.setEquator(0);
                                    MapOutputBuffer.this.bufend = MapOutputBuffer.this.bufindex = MapOutputBuffer.this.equator;
                                    MapOutputBuffer.this.bufstart = MapOutputBuffer.this.bufindex;
                                    MapOutputBuffer.this.kvstart = MapOutputBuffer.this.kvend = MapOutputBuffer.this.kvindex;
                                    MapOutputBuffer.this.bufvoid = MapOutputBuffer.this.kvbuffer.length;
                                    throw new MapBufferTooSmallException(size + " bytes");
                                }
                            }
                            if (!blockwrite) continue;
                            try {
                                while (MapOutputBuffer.this.spillInProgress) {
                                    MapOutputBuffer.this.reporter.progress();
                                    MapOutputBuffer.this.spillDone.await();
                                }
                            }
                            catch (InterruptedException e) {
                                throw new IOException("Buffer interrupted while waiting for the writer", e);
                            }
                        } while (blockwrite);
                    }
                    finally {
                        MapOutputBuffer.this.spillLock.unlock();
                    }
                }
                if (MapOutputBuffer.this.bufindex + len > MapOutputBuffer.this.bufvoid) {
                    int gaplen = MapOutputBuffer.this.bufvoid - MapOutputBuffer.this.bufindex;
                    System.arraycopy(b, off, MapOutputBuffer.this.kvbuffer, MapOutputBuffer.this.bufindex, gaplen);
                    len -= gaplen;
                    off += gaplen;
                    MapOutputBuffer.this.bufindex = 0;
                }
                System.arraycopy(b, off, MapOutputBuffer.this.kvbuffer, MapOutputBuffer.this.bufindex, len);
                MapOutputBuffer.this.bufindex += len;
            }
        }

        protected class BlockingBuffer
        extends DataOutputStream {
            public BlockingBuffer() {
                super(new Buffer());
            }

            public int markRecord() {
                MapOutputBuffer.this.bufmark = MapOutputBuffer.this.bufindex;
                return MapOutputBuffer.this.bufindex;
            }

            protected void shiftBufferedKey() throws IOException {
                int headbytelen = MapOutputBuffer.this.bufvoid - MapOutputBuffer.this.bufmark;
                MapOutputBuffer.this.bufvoid = MapOutputBuffer.this.bufmark;
                int kvbidx = 4 * MapOutputBuffer.this.kvindex;
                int kvbend = 4 * MapOutputBuffer.this.kvend;
                int avail = Math.min(MapOutputBuffer.this.distanceTo(0, kvbidx), MapOutputBuffer.this.distanceTo(0, kvbend));
                if (MapOutputBuffer.this.bufindex + headbytelen < avail) {
                    System.arraycopy(MapOutputBuffer.this.kvbuffer, 0, MapOutputBuffer.this.kvbuffer, headbytelen, MapOutputBuffer.this.bufindex);
                    System.arraycopy(MapOutputBuffer.this.kvbuffer, MapOutputBuffer.this.bufvoid, MapOutputBuffer.this.kvbuffer, 0, headbytelen);
                    MapOutputBuffer.this.bufindex += headbytelen;
                    MapOutputBuffer.this.bufferRemaining -= MapOutputBuffer.this.kvbuffer.length - MapOutputBuffer.this.bufvoid;
                } else {
                    byte[] keytmp = new byte[MapOutputBuffer.this.bufindex];
                    System.arraycopy(MapOutputBuffer.this.kvbuffer, 0, keytmp, 0, MapOutputBuffer.this.bufindex);
                    MapOutputBuffer.this.bufindex = 0;
                    this.out.write(MapOutputBuffer.this.kvbuffer, MapOutputBuffer.this.bufmark, headbytelen);
                    this.out.write(keytmp);
                }
            }
        }
    }

    class DirectMapOutputCollector<K, V>
    implements MapOutputCollector<K, V> {
        private org.apache.hadoop.mapred.RecordWriter<K, V> out = null;
        private Task.TaskReporter reporter = null;
        private Counters.Counter mapOutputRecordCounter;
        private Counters.Counter fileOutputByteCounter;
        private List<FileSystem.Statistics> fsStats;

        @Override
        public void init(MapOutputCollector.Context context) throws IOException, ClassNotFoundException {
            this.reporter = context.getReporter();
            JobConf job = context.getJobConf();
            String finalName = Task.getOutputName(MapTask.this.getPartition());
            FileSystem fs = FileSystem.get(job);
            OutputFormat outputFormat = job.getOutputFormat();
            this.mapOutputRecordCounter = this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_RECORDS);
            this.fileOutputByteCounter = this.reporter.getCounter((Enum)FileOutputFormatCounter.BYTES_WRITTEN);
            List<FileSystem.Statistics> matchedStats = null;
            if (outputFormat instanceof org.apache.hadoop.mapred.FileOutputFormat) {
                matchedStats = Task.getFsStatistics(org.apache.hadoop.mapred.FileOutputFormat.getOutputPath(job), job);
            }
            this.fsStats = matchedStats;
            long bytesOutPrev = this.getOutputBytes(this.fsStats);
            this.out = job.getOutputFormat().getRecordWriter(fs, job, finalName, this.reporter);
            long bytesOutCurr = this.getOutputBytes(this.fsStats);
            this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
        }

        @Override
        public void close() throws IOException {
            if (this.out != null) {
                long bytesOutPrev = this.getOutputBytes(this.fsStats);
                this.out.close(this.reporter);
                long bytesOutCurr = this.getOutputBytes(this.fsStats);
                this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
            }
        }

        @Override
        public void flush() throws IOException, InterruptedException, ClassNotFoundException {
        }

        @Override
        public void collect(K key, V value, int partition) throws IOException {
            this.reporter.progress();
            long bytesOutPrev = this.getOutputBytes(this.fsStats);
            this.out.write(key, value);
            long bytesOutCurr = this.getOutputBytes(this.fsStats);
            this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
            this.mapOutputRecordCounter.increment(1L);
        }

        private long getOutputBytes(List<FileSystem.Statistics> stats) {
            if (stats == null) {
                return 0L;
            }
            long bytesWritten = 0L;
            for (FileSystem.Statistics stat : stats) {
                bytesWritten += stat.getBytesWritten();
            }
            return bytesWritten;
        }
    }

    private class NewOutputCollector<K, V>
    extends RecordWriter<K, V> {
        private final MapOutputCollector<K, V> collector;
        private final org.apache.hadoop.mapreduce.Partitioner<K, V> partitioner;
        private final int partitions;

        NewOutputCollector(JobContext jobContext, JobConf job, TaskUmbilicalProtocol umbilical, Task.TaskReporter reporter) throws IOException, ClassNotFoundException {
            this.collector = MapTask.this.createSortingCollector(job, reporter);
            this.partitions = jobContext.getNumReduceTasks();
            this.partitioner = this.partitions > 1 ? ReflectionUtils.newInstance(jobContext.getPartitionerClass(), job) : new org.apache.hadoop.mapreduce.Partitioner<K, V>(){

                @Override
                public int getPartition(K key, V value, int numPartitions) {
                    return NewOutputCollector.this.partitions - 1;
                }
            };
        }

        @Override
        public void write(K key, V value) throws IOException, InterruptedException {
            this.collector.collect(key, value, this.partitioner.getPartition(key, value, this.partitions));
        }

        @Override
        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            try {
                this.collector.flush();
            }
            catch (ClassNotFoundException cnf) {
                throw new IOException("can't find class ", cnf);
            }
            this.collector.close();
        }
    }

    private class NewDirectOutputCollector<K, V>
    extends RecordWriter<K, V> {
        private final RecordWriter out;
        private final Task.TaskReporter reporter;
        private final Counters.Counter mapOutputRecordCounter;
        private final Counters.Counter fileOutputByteCounter;
        private final List<FileSystem.Statistics> fsStats;

        NewDirectOutputCollector(MRJobConfig jobContext, JobConf job, TaskUmbilicalProtocol umbilical, Task.TaskReporter reporter) throws IOException, ClassNotFoundException, InterruptedException {
            this.reporter = reporter;
            this.mapOutputRecordCounter = reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_RECORDS);
            this.fileOutputByteCounter = reporter.getCounter((Enum)FileOutputFormatCounter.BYTES_WRITTEN);
            List<FileSystem.Statistics> matchedStats = null;
            if (MapTask.this.outputFormat instanceof FileOutputFormat) {
                matchedStats = Task.getFsStatistics(FileOutputFormat.getOutputPath(MapTask.this.taskContext), MapTask.this.taskContext.getConfiguration());
            }
            this.fsStats = matchedStats;
            long bytesOutPrev = this.getOutputBytes(this.fsStats);
            this.out = MapTask.this.outputFormat.getRecordWriter(MapTask.this.taskContext);
            long bytesOutCurr = this.getOutputBytes(this.fsStats);
            this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
        }

        @Override
        public void write(K key, V value) throws IOException, InterruptedException {
            this.reporter.progress();
            long bytesOutPrev = this.getOutputBytes(this.fsStats);
            this.out.write(key, value);
            long bytesOutCurr = this.getOutputBytes(this.fsStats);
            this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
            this.mapOutputRecordCounter.increment(1L);
        }

        @Override
        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.reporter.progress();
            if (this.out != null) {
                long bytesOutPrev = this.getOutputBytes(this.fsStats);
                this.out.close(context);
                long bytesOutCurr = this.getOutputBytes(this.fsStats);
                this.fileOutputByteCounter.increment(bytesOutCurr - bytesOutPrev);
            }
        }

        private long getOutputBytes(List<FileSystem.Statistics> stats) {
            if (stats == null) {
                return 0L;
            }
            long bytesWritten = 0L;
            for (FileSystem.Statistics stat : stats) {
                bytesWritten += stat.getBytesWritten();
            }
            return bytesWritten;
        }
    }

    private static class OldOutputCollector<K, V>
    implements OutputCollector<K, V> {
        private final Partitioner<K, V> partitioner;
        private final MapOutputCollector<K, V> collector;
        private final int numPartitions;

        OldOutputCollector(MapOutputCollector<K, V> collector, JobConf conf) {
            this.numPartitions = conf.getNumReduceTasks();
            this.partitioner = this.numPartitions > 1 ? ReflectionUtils.newInstance(conf.getPartitionerClass(), conf) : new Partitioner<K, V>(){

                @Override
                public void configure(JobConf job) {
                }

                @Override
                public int getPartition(K key, V value, int numPartitions) {
                    return numPartitions - 1;
                }
            };
            this.collector = collector;
        }

        @Override
        public void collect(K key, V value) throws IOException {
            try {
                this.collector.collect(key, value, this.partitioner.getPartition(key, value, this.numPartitions));
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new IOException("interrupt exception", ie);
            }
        }
    }

    static class NewTrackingRecordReader<K, V>
    extends RecordReader<K, V> {
        private final RecordReader<K, V> real;
        private final Counter inputRecordCounter;
        private final Counter fileInputByteCounter;
        private final Task.TaskReporter reporter;
        private final List<FileSystem.Statistics> fsStats;

        NewTrackingRecordReader(InputSplit split, InputFormat<K, V> inputFormat, Task.TaskReporter reporter, TaskAttemptContext taskContext) throws InterruptedException, IOException {
            this.reporter = reporter;
            this.inputRecordCounter = reporter.getCounter((Enum)TaskCounter.MAP_INPUT_RECORDS);
            this.fileInputByteCounter = reporter.getCounter((Enum)FileInputFormatCounter.BYTES_READ);
            List<FileSystem.Statistics> matchedStats = null;
            if (split instanceof org.apache.hadoop.mapreduce.lib.input.FileSplit) {
                matchedStats = Task.getFsStatistics(((org.apache.hadoop.mapreduce.lib.input.FileSplit)split).getPath(), taskContext.getConfiguration());
            }
            this.fsStats = matchedStats;
            long bytesInPrev = this.getInputBytes(this.fsStats);
            this.real = inputFormat.createRecordReader(split, taskContext);
            long bytesInCurr = this.getInputBytes(this.fsStats);
            this.fileInputByteCounter.increment(bytesInCurr - bytesInPrev);
        }

        @Override
        public void close() throws IOException {
            long bytesInPrev = this.getInputBytes(this.fsStats);
            this.real.close();
            long bytesInCurr = this.getInputBytes(this.fsStats);
            this.fileInputByteCounter.increment(bytesInCurr - bytesInPrev);
        }

        @Override
        public K getCurrentKey() throws IOException, InterruptedException {
            return this.real.getCurrentKey();
        }

        @Override
        public V getCurrentValue() throws IOException, InterruptedException {
            return this.real.getCurrentValue();
        }

        @Override
        public float getProgress() throws IOException, InterruptedException {
            return this.real.getProgress();
        }

        @Override
        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            long bytesInPrev = this.getInputBytes(this.fsStats);
            this.real.initialize(split, context);
            long bytesInCurr = this.getInputBytes(this.fsStats);
            this.fileInputByteCounter.increment(bytesInCurr - bytesInPrev);
        }

        @Override
        public boolean nextKeyValue() throws IOException, InterruptedException {
            long bytesInPrev = this.getInputBytes(this.fsStats);
            boolean result = this.real.nextKeyValue();
            long bytesInCurr = this.getInputBytes(this.fsStats);
            if (result) {
                this.inputRecordCounter.increment(1L);
            }
            this.fileInputByteCounter.increment(bytesInCurr - bytesInPrev);
            this.reporter.setProgress(this.getProgress());
            return result;
        }

        private long getInputBytes(List<FileSystem.Statistics> stats) {
            if (stats == null) {
                return 0L;
            }
            long bytesRead = 0L;
            for (FileSystem.Statistics stat : stats) {
                bytesRead += stat.getBytesRead();
            }
            return bytesRead;
        }
    }

    class SkippingRecordReader<K, V>
    extends TrackedRecordReader<K, V> {
        private SortedRanges.SkipRangeIterator skipIt;
        private SequenceFile.Writer skipWriter;
        private boolean toWriteSkipRecs;
        private TaskUmbilicalProtocol umbilical;
        private Counters.Counter skipRecCounter;
        private long recIndex;

        SkippingRecordReader(TaskUmbilicalProtocol umbilical, Task.TaskReporter reporter, JobConf job) throws IOException {
            super(reporter, job);
            this.recIndex = -1L;
            this.umbilical = umbilical;
            this.skipRecCounter = reporter.getCounter((Enum)TaskCounter.MAP_SKIPPED_RECORDS);
            this.toWriteSkipRecs = MapTask.this.toWriteSkipRecs() && SkipBadRecords.getSkipOutputPath(MapTask.this.conf) != null;
            this.skipIt = MapTask.this.getSkipRanges().skipRangeIterator();
        }

        @Override
        public synchronized boolean next(K key, V value) throws IOException {
            if (!this.skipIt.hasNext()) {
                LOG.warn("Further records got skipped.");
                return false;
            }
            boolean ret = this.moveToNext(key, value);
            long nextRecIndex = this.skipIt.next();
            long skip = 0L;
            while (this.recIndex < nextRecIndex && ret) {
                if (this.toWriteSkipRecs) {
                    this.writeSkippedRec(key, value);
                }
                ret = this.moveToNext(key, value);
                ++skip;
            }
            if (skip > 0L && this.skipIt.skippedAllRanges() && this.skipWriter != null) {
                this.skipWriter.close();
            }
            this.skipRecCounter.increment(skip);
            MapTask.this.reportNextRecordRange(this.umbilical, this.recIndex);
            if (ret) {
                this.incrCounters();
            }
            return ret;
        }

        @Override
        protected synchronized boolean moveToNext(K key, V value) throws IOException {
            ++this.recIndex;
            return super.moveToNext(key, value);
        }

        private void writeSkippedRec(K key, V value) throws IOException {
            if (this.skipWriter == null) {
                Path skipDir = SkipBadRecords.getSkipOutputPath(MapTask.this.conf);
                Path skipFile = new Path(skipDir, MapTask.this.getTaskID().toString());
                this.skipWriter = SequenceFile.createWriter(skipFile.getFileSystem(MapTask.this.conf), (Configuration)MapTask.this.conf, skipFile, this.createKey().getClass(), this.createValue().getClass(), SequenceFile.CompressionType.BLOCK, this.getTaskReporter());
            }
            this.skipWriter.append(key, value);
        }
    }

    class TrackedRecordReader<K, V>
    implements org.apache.hadoop.mapred.RecordReader<K, V> {
        private org.apache.hadoop.mapred.RecordReader<K, V> rawIn;
        private Counters.Counter fileInputByteCounter;
        private Counters.Counter inputRecordCounter;
        private Task.TaskReporter reporter;
        private long bytesInPrev = -1L;
        private long bytesInCurr = -1L;
        private final List<FileSystem.Statistics> fsStats;

        TrackedRecordReader(Task.TaskReporter reporter, JobConf job) throws IOException {
            this.inputRecordCounter = reporter.getCounter((Enum)TaskCounter.MAP_INPUT_RECORDS);
            this.fileInputByteCounter = reporter.getCounter((Enum)FileInputFormatCounter.BYTES_READ);
            this.reporter = reporter;
            List<FileSystem.Statistics> matchedStats = null;
            if (this.reporter.getInputSplit() instanceof FileSplit) {
                matchedStats = Task.getFsStatistics(((FileSplit)this.reporter.getInputSplit()).getPath(), job);
            }
            this.fsStats = matchedStats;
            this.bytesInPrev = this.getInputBytes(this.fsStats);
            this.rawIn = job.getInputFormat().getRecordReader(reporter.getInputSplit(), job, reporter);
            this.bytesInCurr = this.getInputBytes(this.fsStats);
            this.fileInputByteCounter.increment(this.bytesInCurr - this.bytesInPrev);
        }

        @Override
        public K createKey() {
            return this.rawIn.createKey();
        }

        @Override
        public V createValue() {
            return this.rawIn.createValue();
        }

        @Override
        public synchronized boolean next(K key, V value) throws IOException {
            boolean ret = this.moveToNext(key, value);
            if (ret) {
                this.incrCounters();
            }
            return ret;
        }

        protected void incrCounters() {
            this.inputRecordCounter.increment(1L);
        }

        protected synchronized boolean moveToNext(K key, V value) throws IOException {
            this.bytesInPrev = this.getInputBytes(this.fsStats);
            boolean ret = this.rawIn.next(key, value);
            this.bytesInCurr = this.getInputBytes(this.fsStats);
            this.fileInputByteCounter.increment(this.bytesInCurr - this.bytesInPrev);
            this.reporter.setProgress(this.getProgress());
            return ret;
        }

        @Override
        public long getPos() throws IOException {
            return this.rawIn.getPos();
        }

        @Override
        public void close() throws IOException {
            this.bytesInPrev = this.getInputBytes(this.fsStats);
            this.rawIn.close();
            this.bytesInCurr = this.getInputBytes(this.fsStats);
            this.fileInputByteCounter.increment(this.bytesInCurr - this.bytesInPrev);
        }

        @Override
        public float getProgress() throws IOException {
            return this.rawIn.getProgress();
        }

        Task.TaskReporter getTaskReporter() {
            return this.reporter;
        }

        private long getInputBytes(List<FileSystem.Statistics> stats) {
            if (stats == null) {
                return 0L;
            }
            long bytesRead = 0L;
            for (FileSystem.Statistics stat : stats) {
                bytesRead += stat.getBytesRead();
            }
            return bytesRead;
        }
    }
}

