/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.fs.MultipartUploader;
import org.apache.hadoop.fs.PartHandle;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UploadHandle;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

public abstract class AbstractMultipartUploader
implements MultipartUploader {
    private final Path basePath;

    protected AbstractMultipartUploader(Path basePath) {
        this.basePath = Objects.requireNonNull(basePath, "null path");
    }

    @Override
    public void close() throws IOException {
    }

    protected Path getBasePath() {
        return this.basePath;
    }

    protected void checkPath(Path path) {
        Objects.requireNonNull(path, "null path");
        Preconditions.checkArgument((boolean)path.toString().startsWith(this.basePath.toString()), (String)"Path %s is not under %s", (Object)path, (Object)this.basePath);
    }

    protected void checkUploadId(byte[] uploadId) throws IllegalArgumentException {
        Preconditions.checkArgument((uploadId != null ? 1 : 0) != 0, (Object)"null uploadId");
        Preconditions.checkArgument((uploadId.length > 0 ? 1 : 0) != 0, (Object)"Empty UploadId is not valid");
    }

    protected void checkPartHandles(Map<Integer, PartHandle> partHandles) {
        Preconditions.checkArgument((!partHandles.isEmpty() ? 1 : 0) != 0, (Object)"Empty upload");
        partHandles.keySet().stream().forEach(key -> Preconditions.checkArgument((key > 0 ? 1 : 0) != 0, (String)"Invalid part handle index %s", (Object)key));
    }

    protected void checkPutArguments(Path filePath, InputStream inputStream, int partNumber, UploadHandle uploadId, long lengthInBytes) throws IllegalArgumentException {
        this.checkPath(filePath);
        Preconditions.checkArgument((inputStream != null ? 1 : 0) != 0, (Object)"null inputStream");
        Preconditions.checkArgument((partNumber > 0 ? 1 : 0) != 0, (String)"Invalid part number: %d", (int)partNumber);
        Preconditions.checkArgument((uploadId != null ? 1 : 0) != 0, (Object)"null uploadId");
        Preconditions.checkArgument((lengthInBytes >= 0L ? 1 : 0) != 0, (String)"Invalid part length: %d", (long)lengthInBytes);
    }

    @Override
    public CompletableFuture<Integer> abortUploadsUnderPath(Path path) throws IOException {
        this.checkPath(path);
        CompletableFuture<Integer> f = new CompletableFuture<Integer>();
        f.complete(-1);
        return f;
    }
}

