/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.AuthenticationParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.OutputMACCalculator;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.io.MacOutputStream;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class GuardedMACOperatorFactory<T extends AuthenticationParameters>
implements MACOperatorFactory<T> {
    GuardedMACOperatorFactory() {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
        }
    }

    @Override
    public final OutputMACCalculator<T> createOutputMACCalculator(SymmetricKey symmetricKey, T t) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t.getAlgorithm());
        }
        Mac mac = this.createMAC(symmetricKey, t);
        return new OutputMACCalculator<T>((AuthenticationParameters)t, mac){
            final /* synthetic */ AuthenticationParameters val$parameters;
            final /* synthetic */ Mac val$mac;
            {
                this.val$parameters = authenticationParameters;
                this.val$mac = mac;
            }

            @Override
            public T getParameters() {
                return this.val$parameters;
            }

            @Override
            public int getMACSize() {
                return this.val$mac.getMacSize();
            }

            @Override
            public UpdateOutputStream getMACStream() {
                return new MacOutputStream(this.val$mac);
            }

            @Override
            public byte[] getMAC() {
                byte[] byArray = new byte[this.val$mac.getMacSize()];
                this.getMAC(byArray, 0);
                return byArray;
            }

            @Override
            public int getMAC(byte[] byArray, int n) {
                return this.val$mac.doFinal(byArray, n);
            }

            @Override
            public void reset() {
                this.val$mac.reset();
            }
        };
    }

    protected abstract Mac createMAC(SymmetricKey var1, T var2);

    protected abstract int calculateMACSize(T var1);
}

