/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.annotations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AnnotationIntrospector {
    private final Set<Class<?>> _introspectedClasses = new HashSet();
    private final List<IntrospectableAnnotationHandler> _handlers = new ArrayList<IntrospectableAnnotationHandler>();

    public void registerHandler(IntrospectableAnnotationHandler handler) {
        this._handlers.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void introspect(Class<?> clazz) {
        if (this._handlers == null) {
            return;
        }
        if (clazz == null) {
            return;
        }
        Set<Class<?>> set = this._introspectedClasses;
        synchronized (set) {
            if (this._introspectedClasses.add(clazz)) {
                for (IntrospectableAnnotationHandler handler : this._handlers) {
                    try {
                        handler.handle(clazz);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public static interface IntrospectableAnnotationHandler {
        public void handle(Class<?> var1);
    }

    public static abstract class AbstractIntrospectableAnnotationHandler
    implements IntrospectableAnnotationHandler {
        private boolean _introspectAncestors;

        public abstract void doHandle(Class<?> var1);

        public AbstractIntrospectableAnnotationHandler(boolean introspectAncestors) {
            this._introspectAncestors = introspectAncestors;
        }

        @Override
        public void handle(Class<?> clazz) {
            for (Class<?> c = clazz; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
                this.doHandle(c);
                if (!this._introspectAncestors) break;
            }
        }
    }
}

