/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.SettableFuture;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.security.AccessRequest;
import org.apache.hadoop.yarn.security.ConfiguredYarnAuthorizer;
import org.apache.hadoop.yarn.security.ExternalTokenManager;
import org.apache.hadoop.yarn.security.ExternalTokenManagerFactory;
import org.apache.hadoop.yarn.security.Permission;
import org.apache.hadoop.yarn.security.PrivilegedEntity;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.federation.FederationStateStoreService;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRecoverEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMAppManager
implements EventHandler<RMAppManagerEvent>,
Recoverable {
    private static final Logger LOG = LoggerFactory.getLogger(RMAppManager.class);
    private int maxCompletedAppsInMemory;
    private int maxCompletedAppsInStateStore;
    protected int completedAppsInStateStore = 0;
    private LinkedList<ApplicationId> completedApps = new LinkedList();
    private final RMContext rmContext;
    private final ApplicationMasterService masterService;
    private final YarnScheduler scheduler;
    private final ApplicationACLsManager applicationACLsManager;
    private Configuration conf;
    private ExternalTokenManager extTokenMgr = ExternalTokenManagerFactory.get();
    private YarnAuthorizationProvider authorizer;
    private boolean timelineServiceV2Enabled;
    private boolean nodeLabelsEnabled;
    private Set<String> exclusiveEnforcedPartitions;
    private String amDefaultNodeLabel;
    private FederationStateStoreService federationStateStoreService;
    private static final String USER_ID_PREFIX = "userid=";

    public RMAppManager(RMContext context, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationACLsManager applicationACLsManager, Configuration conf) {
        this.rmContext = context;
        this.scheduler = scheduler;
        this.masterService = masterService;
        this.applicationACLsManager = applicationACLsManager;
        this.conf = conf;
        this.maxCompletedAppsInMemory = conf.getInt("yarn.resourcemanager.max-completed-applications", 1000);
        this.maxCompletedAppsInStateStore = conf.getInt("yarn.resourcemanager.state-store.max-completed-applications", this.maxCompletedAppsInMemory);
        if (this.maxCompletedAppsInStateStore > this.maxCompletedAppsInMemory) {
            this.maxCompletedAppsInStateStore = this.maxCompletedAppsInMemory;
        }
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)conf);
        this.timelineServiceV2Enabled = YarnConfiguration.timelineServiceV2Enabled((Configuration)conf);
        this.nodeLabelsEnabled = YarnConfiguration.areNodeLabelsEnabled((Configuration)this.rmContext.getYarnConfiguration());
        this.exclusiveEnforcedPartitions = YarnConfiguration.getExclusiveEnforcedPartitions((Configuration)this.rmContext.getYarnConfiguration());
        this.amDefaultNodeLabel = conf.get("yarn.resourcemanager.node-labels.am.default-node-label-expression", null);
    }

    @VisibleForTesting
    public void logApplicationSummary(ApplicationId appId) {
        ApplicationSummary.logAppSummary((RMApp)this.rmContext.getRMApps().get(appId));
    }

    private static <V> V getChecked(Future<V> future) throws YarnException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new YarnException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new YarnException((Throwable)e);
        }
    }

    protected synchronized int getCompletedAppsListSize() {
        return this.completedApps.size();
    }

    protected synchronized void finishApplication(ApplicationId applicationId) {
        if (applicationId == null) {
            LOG.error("RMAppManager received completed appId of null, skipping");
        } else {
            if (UserGroupInformation.isSecurityEnabled()) {
                this.rmContext.getDelegationTokenRenewer().applicationFinished(applicationId);
            }
            if (this.extTokenMgr != null) {
                this.extTokenMgr.removeToken(applicationId, this.conf);
            }
            this.completedApps.add(applicationId);
            ++this.completedAppsInStateStore;
            this.writeAuditLog(applicationId);
        }
    }

    protected void writeAuditLog(ApplicationId appId) {
        RMApp app = (RMApp)this.rmContext.getRMApps().get(appId);
        String operation = "UNKNOWN";
        boolean success = false;
        switch (app.getState()) {
            case FAILED: {
                operation = "Application Finished - Failed";
                break;
            }
            case FINISHED: {
                operation = "Application Finished - Succeeded";
                success = true;
                break;
            }
            case KILLED: {
                operation = "Application Finished - Killed";
                success = true;
                break;
            }
        }
        if (success) {
            RMAuditLogger.logSuccess(app.getUser(), operation, "RMAppManager", app.getApplicationId());
        } else {
            StringBuilder diag = app.getDiagnostics();
            String msg = diag == null ? null : diag.toString();
            RMAuditLogger.logFailure(app.getUser(), operation, msg, "RMAppManager", "App failed with state: " + (Object)((Object)app.getState()), appId);
        }
    }

    protected synchronized void checkAppNumCompletedLimit() {
        ApplicationId removeId;
        while (this.completedAppsInStateStore > this.maxCompletedAppsInStateStore) {
            removeId = this.completedApps.get(this.completedApps.size() - this.completedAppsInStateStore);
            RMApp removeApp = (RMApp)this.rmContext.getRMApps().get(removeId);
            LOG.info("Max number of completed apps kept in state store met: maxCompletedAppsInStateStore = " + this.maxCompletedAppsInStateStore + ", removing app " + removeApp.getApplicationId() + " from state store.");
            this.rmContext.getStateStore().removeApplication(removeApp);
            this.removeApplicationIdFromStateStore(removeId);
            --this.completedAppsInStateStore;
        }
        while (this.completedApps.size() > this.maxCompletedAppsInMemory) {
            removeId = this.completedApps.remove();
            LOG.info("Application should be expired, max number of completed apps kept in memory met: maxCompletedAppsInMemory = " + this.maxCompletedAppsInMemory + ", removing app " + removeId + " from memory: ");
            this.rmContext.getRMApps().remove(removeId);
            this.removeApplicationIdFromStateStore(removeId);
            this.applicationACLsManager.removeApplication(removeId);
        }
    }

    @Deprecated
    @VisibleForTesting
    protected void submitApplication(ApplicationSubmissionContext submissionContext, long submitTime, String user) throws YarnException {
        this.submitApplication(submissionContext, submitTime, UserGroupInformation.createRemoteUser((String)user));
    }

    @VisibleForTesting
    protected void submitApplication(ApplicationSubmissionContext submissionContext, long submitTime, UserGroupInformation userUgi) throws YarnException {
        ApplicationId applicationId = submissionContext.getApplicationId();
        RMAppImpl application = this.createAndPopulateNewRMApp(submissionContext, submitTime, userUgi, false, -1L, null);
        try {
            if (UserGroupInformation.isSecurityEnabled()) {
                this.rmContext.getDelegationTokenRenewer().addApplicationAsync(applicationId, BuilderUtils.parseCredentials((ApplicationSubmissionContext)submissionContext), submissionContext.getCancelTokensWhenComplete(), application.getUser(), BuilderUtils.parseTokensConf((ApplicationSubmissionContext)submissionContext));
            } else {
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.START));
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to parse credentials for " + applicationId, (Throwable)e);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, e.getMessage()));
            throw RPCUtil.getRemoteException((Throwable)e);
        }
    }

    protected void recoverApplication(ApplicationStateData appState, RMStateStore.RMState rmState) throws Exception {
        ApplicationSubmissionContext appContext = appState.getApplicationSubmissionContext();
        ApplicationId appId = appContext.getApplicationId();
        UserGroupInformation userUgi = null;
        if (appState.getRealUser() != null) {
            UserGroupInformation realUserUgi = null;
            realUserUgi = UserGroupInformation.createRemoteUser((String)appState.getRealUser());
            userUgi = UserGroupInformation.createProxyUser((String)appState.getUser(), (UserGroupInformation)realUserUgi);
        } else {
            userUgi = UserGroupInformation.createRemoteUser((String)appState.getUser());
        }
        RMAppImpl application = this.createAndPopulateNewRMApp(appContext, appState.getSubmitTime(), userUgi, true, appState.getStartTime(), appState.getState());
        application.handle(new RMAppRecoverEvent(appId, rmState));
    }

    private RMAppImpl createAndPopulateNewRMApp(ApplicationSubmissionContext submissionContext, long submitTime, UserGroupInformation userUgi, boolean isRecovery, long startTime, RMAppState recoveredFinalState) throws YarnException {
        String user = userUgi.getShortUserName();
        ApplicationPlacementContext placementContext = null;
        if (recoveredFinalState == null) {
            placementContext = this.placeApplication(this.rmContext.getQueuePlacementManager(), submissionContext, user, isRecovery);
        }
        if (!isRecovery) {
            this.copyPlacementQueueToSubmissionContext(placementContext, submissionContext);
            RMServerUtils.validateApplicationTimeouts(submissionContext.getApplicationTimeouts());
        }
        ApplicationId applicationId = submissionContext.getApplicationId();
        List<ResourceRequest> amReqs = this.validateAndCreateResourceRequest(submissionContext, isRecovery);
        if (!isRecovery) {
            Priority appPriority = this.scheduler.checkAndGetApplicationPriority(submissionContext.getPriority(), userUgi, submissionContext.getQueue(), applicationId);
            submissionContext.setPriority(appPriority);
        }
        if (!isRecovery && YarnConfiguration.isAclEnabled((Configuration)this.conf)) {
            String queueName;
            if (this.scheduler instanceof CapacityScheduler) {
                String appName;
                List<Permission> permissions;
                queueName = placementContext == null ? submissionContext.getQueue() : placementContext.getFullQueuePath();
                CapacityScheduler cs = (CapacityScheduler)this.scheduler;
                CSQueue csqueue = cs.getQueue(queueName);
                PrivilegedEntity privilegedEntity = new PrivilegedEntity(csqueue == null ? queueName : csqueue.getQueuePath());
                ConfiguredYarnAuthorizer dynamicAuthorizer = null;
                if (csqueue == null && !(permissions = cs.getCapacitySchedulerQueueManager().getPermissionsForDynamicQueue(new QueuePath(queueName), cs.getConfiguration())).isEmpty()) {
                    dynamicAuthorizer = new ConfiguredYarnAuthorizer();
                    dynamicAuthorizer.setPermission(permissions, userUgi);
                }
                if (!(csqueue == null && dynamicAuthorizer == null || this.checkPermission(RMAppManager.createAccessRequest(privilegedEntity, userUgi, applicationId, appName = submissionContext.getApplicationName(), QueueACL.SUBMIT_APPLICATIONS), (YarnAuthorizationProvider)dynamicAuthorizer) || this.checkPermission(RMAppManager.createAccessRequest(privilegedEntity, userUgi, applicationId, appName, QueueACL.ADMINISTER_QUEUE), (YarnAuthorizationProvider)dynamicAuthorizer))) {
                    throw RPCUtil.getRemoteException((Throwable)new AccessControlException("User " + user + " does not have permission to submit " + applicationId + " to queue " + submissionContext.getQueue()));
                }
            }
            if (this.scheduler instanceof FairScheduler && placementContext != null) {
                queueName = submissionContext.getQueue();
                FSQueue queue = ((FairScheduler)this.scheduler).getQueueManager().getQueue(queueName);
                while (queue == null) {
                    int sepIndex = queueName.lastIndexOf(".");
                    queueName = queueName.substring(0, sepIndex);
                    queue = ((FairScheduler)this.scheduler).getQueueManager().getQueue(queueName);
                }
                if (!queue.hasAccess(QueueACL.SUBMIT_APPLICATIONS, userUgi) && !queue.hasAccess(QueueACL.ADMINISTER_QUEUE, userUgi)) {
                    throw RPCUtil.getRemoteException((Throwable)new AccessControlException("User " + user + " does not have permission to submit " + applicationId + " to queue " + submissionContext.getQueue() + " denied by ACL for queue " + queueName));
                }
            }
        }
        String placementQueueName = submissionContext.getQueue();
        if (placementContext != null && this.scheduler instanceof CapacityScheduler) {
            placementQueueName = placementContext.hasParentQueue() ? placementContext.getParentQueue() + "." + placementContext.getQueue() : placementContext.getQueue();
        }
        placementQueueName = this.getQueuePath(placementQueueName);
        RMAppImpl application = new RMAppImpl(applicationId, this.rmContext, this.conf, submissionContext.getApplicationName(), userUgi, placementQueueName, submissionContext, this.scheduler, this.masterService, submitTime, submissionContext.getApplicationType(), (Set<String>)submissionContext.getApplicationTags(), amReqs, placementContext, startTime);
        if (this.rmContext.getRMApps().putIfAbsent(applicationId, application) != null) {
            String message = "Application with id " + applicationId + " is already present! Cannot add a duplicate!";
            LOG.warn(message);
            throw new YarnException(message);
        }
        if (this.timelineServiceV2Enabled) {
            application.startTimelineCollector();
        }
        this.applicationACLsManager.addApplication(applicationId, submissionContext.getAMContainerSpec().getApplicationACLs());
        return application;
    }

    public String getQueuePath(String queueName) {
        String queuePath = queueName;
        try {
            QueueInfo queueInfo = this.scheduler.getQueueInfo(queueName, false, false);
            if (queueInfo != null && queueInfo.getQueuePath() != null) {
                queuePath = queueInfo.getQueuePath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return queuePath;
    }

    private boolean checkPermission(AccessRequest accessRequest, YarnAuthorizationProvider dynamicAuthorizer) {
        return this.authorizer.checkPermission(accessRequest) || dynamicAuthorizer != null && dynamicAuthorizer.checkPermission(accessRequest);
    }

    private static AccessRequest createAccessRequest(PrivilegedEntity privilegedEntity, UserGroupInformation userUgi, ApplicationId applicationId, String appName, QueueACL submitApplications) {
        return new AccessRequest(privilegedEntity, userUgi, SchedulerUtils.toAccessType(submitApplications), applicationId.toString(), appName, Server.getRemoteAddress(), null);
    }

    private List<ResourceRequest> validateAndCreateResourceRequest(ApplicationSubmissionContext submissionContext, boolean isRecovery) throws InvalidResourceRequestException {
        if (!submissionContext.getUnmanagedAM()) {
            List<ResourceRequest> amReqs = submissionContext.getAMContainerResourceRequests();
            if (amReqs == null || amReqs.isEmpty()) {
                if (submissionContext.getResource() != null) {
                    amReqs = Collections.singletonList(BuilderUtils.newResourceRequest((Priority)RMAppAttemptImpl.AM_CONTAINER_PRIORITY, (String)"*", (Resource)submissionContext.getResource(), (int)1));
                } else {
                    throw new InvalidResourceRequestException("Invalid resource request, no resources requested");
                }
            }
            try {
                ResourceRequest anyReq = null;
                for (ResourceRequest amReq : amReqs) {
                    if (!amReq.getResourceName().equals("*")) continue;
                    if (anyReq == null) {
                        anyReq = amReq;
                        continue;
                    }
                    throw new InvalidResourceRequestException("Invalid resource request, only one resource request with * is allowed");
                }
                if (anyReq == null) {
                    throw new InvalidResourceRequestException("Invalid resource request, no resource request specified with *");
                }
                SchedulerUtils.enforcePartitionExclusivity(anyReq, this.exclusiveEnforcedPartitions, submissionContext.getNodeLabelExpression());
                for (ResourceRequest amReq : amReqs) {
                    amReq.setCapability(anyReq.getCapability());
                    amReq.setExecutionTypeRequest(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED));
                    amReq.setNumContainers(1);
                    amReq.setPriority(RMAppAttemptImpl.AM_CONTAINER_PRIORITY);
                }
                if (StringUtils.isEmpty((String)anyReq.getNodeLabelExpression())) {
                    if (StringUtils.isNotEmpty((String)this.amDefaultNodeLabel)) {
                        anyReq.setNodeLabelExpression(this.amDefaultNodeLabel);
                    } else {
                        anyReq.setNodeLabelExpression(submissionContext.getNodeLabelExpression());
                    }
                }
                if (!amReqs.get(0).equals((Object)anyReq)) {
                    amReqs.remove(anyReq);
                    amReqs.add(0, anyReq);
                }
                String queue = submissionContext.getQueue();
                Resource maxAllocation = this.scheduler.getMaximumResourceCapability(queue);
                for (ResourceRequest amReq : amReqs) {
                    SchedulerUtils.normalizeAndValidateRequest(amReq, maxAllocation, queue, isRecovery, this.rmContext, null, this.nodeLabelsEnabled);
                    amReq.setCapability(this.scheduler.getNormalizedResource(amReq.getCapability(), maxAllocation));
                }
                return amReqs;
            }
            catch (InvalidResourceRequestException e) {
                LOG.warn("RM app submission failed in validating AM resource request for application " + submissionContext.getApplicationId(), (Throwable)e);
                throw e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover(RMStateStore.RMState state) throws Exception {
        RMStateStore store = this.rmContext.getStateStore();
        assert (store != null);
        Map<ApplicationId, ApplicationStateData> appStates = state.getApplicationState();
        LOG.info("Recovering " + appStates.size() + " applications");
        int count = 0;
        try {
            for (ApplicationStateData appState : appStates.values()) {
                this.recoverApplication(appState, state);
                ++count;
            }
        }
        finally {
            LOG.info("Successfully recovered " + count + " out of " + appStates.size() + " applications");
        }
    }

    public void handle(RMAppManagerEvent event) {
        ApplicationId applicationId = event.getApplicationId();
        LOG.debug("RMAppManager processing event for {} of type {}", (Object)applicationId, (Object)event.getType());
        switch ((RMAppManagerEventType)event.getType()) {
            case APP_COMPLETED: {
                this.finishApplication(applicationId);
                this.logApplicationSummary(applicationId);
                this.checkAppNumCompletedLimit();
                break;
            }
            case APP_MOVE: {
                try {
                    this.moveApplicationAcrossQueue(applicationId, event.getTargetQueueForMove());
                }
                catch (YarnException e) {
                    LOG.warn("Move Application has failed: " + e.getMessage());
                }
                break;
            }
            default: {
                LOG.error("Invalid eventtype " + event.getType() + ". Ignoring!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ApplicationTimeoutType, String> updateApplicationTimeout(RMApp app, Map<ApplicationTimeoutType, String> newTimeoutInISO8601Format) throws YarnException {
        ApplicationId applicationId;
        ApplicationId applicationId2 = applicationId = app.getApplicationId();
        synchronized (applicationId2) {
            long queueMaxLifetimeInSec;
            if (app.isAppInCompletedStates()) {
                return newTimeoutInISO8601Format;
            }
            Map<ApplicationTimeoutType, Long> newExpireTime = RMServerUtils.validateISO8601AndConvertToLocalTimeEpoch(newTimeoutInISO8601Format);
            Long updatedlifetimeInMillis = newExpireTime.get(ApplicationTimeoutType.LIFETIME);
            if (updatedlifetimeInMillis != null && (queueMaxLifetimeInSec = this.scheduler.getMaximumApplicationLifetime(app.getQueue())) > 0L && updatedlifetimeInMillis > app.getSubmitTime() + queueMaxLifetimeInSec * 1000L) {
                updatedlifetimeInMillis = app.getSubmitTime() + queueMaxLifetimeInSec * 1000L;
                newExpireTime.put(ApplicationTimeoutType.LIFETIME, updatedlifetimeInMillis);
                newTimeoutInISO8601Format.put(ApplicationTimeoutType.LIFETIME, Times.formatISO8601((long)updatedlifetimeInMillis));
            }
            SettableFuture future = SettableFuture.create();
            Map<ApplicationTimeoutType, Long> currentExpireTimeouts = app.getApplicationTimeouts();
            currentExpireTimeouts.putAll(newExpireTime);
            ApplicationStateData appState = ApplicationStateData.newInstance(app.getSubmitTime(), app.getStartTime(), app.getApplicationSubmissionContext(), app.getUser(), app.getCallerContext());
            appState.setApplicationTimeouts(currentExpireTimeouts);
            appState.setLaunchTime(app.getLaunchTime());
            this.rmContext.getStateStore().updateApplicationStateSynchronously(appState, false, (SettableFuture<Object>)future);
            RMAppManager.getChecked(future);
            ((RMAppImpl)app).updateApplicationTimeout(newExpireTime);
            return newTimeoutInISO8601Format;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateApplicationPriority(UserGroupInformation callerUGI, ApplicationId applicationId, Priority newAppPriority) throws YarnException {
        RMApp app = (RMApp)this.rmContext.getRMApps().get(applicationId);
        ApplicationId applicationId2 = applicationId;
        synchronized (applicationId2) {
            if (app == null || app.isAppInCompletedStates()) {
                return;
            }
            SettableFuture future = SettableFuture.create();
            Priority appPriority = this.rmContext.getScheduler().updateApplicationPriority(newAppPriority, applicationId, (SettableFuture<Object>)future, callerUGI);
            if (app.getApplicationPriority().equals((Object)appPriority)) {
                return;
            }
            RMAppManager.getChecked(future);
            ((RMAppImpl)app).setApplicationPriority(appPriority);
        }
        this.rmContext.getSystemMetricsPublisher().appUpdated(app, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveApplicationAcrossQueue(ApplicationId applicationId, String targetQueue) throws YarnException {
        RMApp app = (RMApp)this.rmContext.getRMApps().get(applicationId);
        ApplicationId applicationId2 = applicationId;
        synchronized (applicationId2) {
            if (app == null || app.isAppInCompletedStates()) {
                return;
            }
            String sourceQueue = app.getQueue();
            this.rmContext.getScheduler().preValidateMoveApplication(applicationId, targetQueue);
            this.updateAppDataToStateStore(targetQueue, app, false);
            String queue = "";
            try {
                queue = this.rmContext.getScheduler().moveApplication(applicationId, targetQueue);
            }
            catch (YarnException e) {
                this.updateAppDataToStateStore(sourceQueue, app, true);
                throw e;
            }
            if (queue != null && !queue.isEmpty()) {
                app.setQueue(queue);
            }
        }
        this.rmContext.getSystemMetricsPublisher().appUpdated(app, System.currentTimeMillis());
    }

    private void updateAppDataToStateStore(String queue, RMApp app, boolean toSuppressException) throws YarnException {
        SettableFuture future = SettableFuture.create();
        app.getApplicationSubmissionContext().setQueue(queue);
        ApplicationStateData appState = ApplicationStateData.newInstance(app.getSubmitTime(), app.getStartTime(), app.getApplicationSubmissionContext(), app.getUser(), app.getCallerContext());
        appState.setApplicationTimeouts(app.getApplicationTimeouts());
        appState.setLaunchTime(app.getLaunchTime());
        this.rmContext.getStateStore().updateApplicationStateSynchronously(appState, false, (SettableFuture<Object>)future);
        try {
            RMAppManager.getChecked(future);
        }
        catch (YarnException ex) {
            if (!toSuppressException) {
                throw ex;
            }
            LOG.error("Statestore update failed for move application '" + app.getApplicationId() + "' to queue '" + queue + "' with below exception:" + ex.getMessage());
        }
    }

    @VisibleForTesting
    ApplicationPlacementContext placeApplication(PlacementManager placementManager, ApplicationSubmissionContext context, String user, boolean isRecovery) throws YarnException {
        ApplicationPlacementContext placementContext = null;
        if (placementManager != null) {
            try {
                String usernameUsedForPlacement = this.getUserNameForPlacement(user, context, placementManager);
                placementContext = placementManager.placeApplication(context, usernameUsedForPlacement, isRecovery);
            }
            catch (YarnException e) {
                if (isRecovery) {
                    LOG.warn("Application placement failed for user " + user + " and application " + context.getApplicationId() + ", skipping placement on recovery of rm", (Throwable)e);
                    return placementContext;
                }
                throw e;
            }
        }
        if (placementContext == null && context.getQueue() == null || context.getQueue().isEmpty()) {
            String msg = "Failed to place application " + context.getApplicationId() + " in a queue and submit context queue is null or empty";
            LOG.error(msg);
            throw new YarnException(msg);
        }
        return placementContext;
    }

    @VisibleForTesting
    protected String getUserNameForPlacement(String user, ApplicationSubmissionContext context, PlacementManager placementManager) throws YarnException {
        boolean applicationTagBasedPlacementEnabled = this.conf.getBoolean("yarn.resourcemanager.application-tag-based-placement.enable", false);
        String usernameUsedForPlacement = user;
        if (!applicationTagBasedPlacementEnabled) {
            return usernameUsedForPlacement;
        }
        if (!this.isWhitelistedUser(user, this.conf)) {
            LOG.warn("User '{}' is not allowed to do placement based on application tag", (Object)user);
            return usernameUsedForPlacement;
        }
        LOG.debug("Application tag based placement is enabled, checking for 'userid' among the application tags");
        Set applicationTags = context.getApplicationTags();
        String userNameFromAppTag = this.getUserNameFromApplicationTag(applicationTags);
        if (userNameFromAppTag != null) {
            LOG.debug("Found 'userid' '{}' in application tag", (Object)userNameFromAppTag);
            UserGroupInformation callerUGI = UserGroupInformation.createRemoteUser((String)user);
            ApplicationPlacementContext appPlacementContext = placementManager.placeApplication(context, userNameFromAppTag);
            if (appPlacementContext == null) {
                LOG.warn("No rule was found for user '{}'", (Object)userNameFromAppTag);
                return usernameUsedForPlacement;
            }
            String queue = appPlacementContext.getQueue();
            String parent = appPlacementContext.getParentQueue();
            if (this.scheduler instanceof CapacityScheduler && parent != null) {
                queue = parent + "." + queue;
            }
            if (callerUGI != null && this.scheduler.checkAccess(callerUGI, QueueACL.SUBMIT_APPLICATIONS, queue)) {
                usernameUsedForPlacement = userNameFromAppTag;
            } else {
                LOG.warn("Proxy user '{}' from application tag does not have access to  queue '{}'. The placement is done for user '{}'", new Object[]{userNameFromAppTag, queue, user});
            }
        } else {
            LOG.warn("'userid' was not found in application tags");
        }
        return usernameUsedForPlacement;
    }

    private boolean isWhitelistedUser(String user, Configuration config) {
        String[] userWhitelist = config.getStrings("yarn.resourcemanager.application-tag-based-placement.username.whitelist");
        if (userWhitelist == null || userWhitelist.length == 0) {
            return false;
        }
        for (String s : userWhitelist) {
            if (!s.equals(user)) continue;
            return true;
        }
        return false;
    }

    private String getUserNameFromApplicationTag(Set<String> applicationTags) {
        for (String tag : applicationTags) {
            if (!tag.startsWith(USER_ID_PREFIX)) continue;
            String[] userIdTag = tag.split("=");
            if (userIdTag.length == 2) {
                return userIdTag[1];
            }
            LOG.warn("Found wrongly qualified username in tag");
        }
        return null;
    }

    private void copyPlacementQueueToSubmissionContext(ApplicationPlacementContext placementContext, ApplicationSubmissionContext context) {
        if (placementContext != null && !org.apache.hadoop.util.StringUtils.equalsIgnoreCase((String)context.getQueue(), (String)placementContext.getQueue())) {
            LOG.info("Placed application with ID " + context.getApplicationId() + " in queue: " + placementContext.getQueue() + ", original submission queue was: " + context.getQueue());
            context.setQueue(placementContext.getFullQueuePath());
        }
    }

    @VisibleForTesting
    public void setFederationStateStoreService(FederationStateStoreService stateStoreService) {
        this.federationStateStoreService = stateStoreService;
    }

    private void removeApplicationIdFromStateStore(ApplicationId appId) {
        if (HAUtil.isFederationEnabled((Configuration)this.conf) && this.federationStateStoreService != null) {
            try {
                boolean cleanUpResult = this.federationStateStoreService.cleanUpFinishApplicationsWithRetries(appId, true);
                if (cleanUpResult) {
                    LOG.info("applicationId = {} remove from state store success.", (Object)appId);
                } else {
                    LOG.warn("applicationId = {} remove from state store failed.", (Object)appId);
                }
            }
            catch (Exception e) {
                LOG.error("applicationId = {} remove from state store error.", (Object)appId, (Object)e);
            }
        }
    }

    @VisibleForTesting
    public void checkAppNumCompletedLimit4Test() {
        this.checkAppNumCompletedLimit();
    }

    @VisibleForTesting
    public void finishApplication4Test(ApplicationId applicationId) {
        this.finishApplication(applicationId);
    }

    static class ApplicationSummary {
        static final Logger LOG = LoggerFactory.getLogger(ApplicationSummary.class);
        static final char EQUALS = '=';
        static final char[] charsToEscape = new char[]{',', '=', '\\'};

        ApplicationSummary() {
        }

        public static SummaryBuilder createAppSummary(RMApp app) {
            String trackingUrl = "N/A";
            String host = "N/A";
            RMAppAttempt attempt = app.getCurrentAppAttempt();
            if (attempt != null) {
                String amHost;
                NodeId nodeId;
                trackingUrl = attempt.getTrackingUrl();
                Container masterContainer = attempt.getMasterContainer();
                if (masterContainer != null && (nodeId = masterContainer.getNodeId()) != null && (amHost = nodeId.getHost()) != null) {
                    host = amHost;
                }
            }
            RMAppMetrics metrics = app.getRMAppMetrics();
            SummaryBuilder summary = new SummaryBuilder().add("appId", app.getApplicationId()).add("name", app.getName()).add("user", app.getUser()).add("queue", app.getQueue()).add("state", app.getState()).add("trackingUrl", trackingUrl).add("appMasterHost", host).add("submitTime", app.getSubmitTime()).add("startTime", app.getStartTime()).add("launchTime", app.getLaunchTime()).add("finishTime", app.getFinishTime()).add("finalStatus", app.getFinalApplicationStatus()).add("memorySeconds", metrics.getMemorySeconds()).add("vcoreSeconds", metrics.getVcoreSeconds()).add("preemptedMemorySeconds", metrics.getPreemptedMemorySeconds()).add("preemptedVcoreSeconds", metrics.getPreemptedVcoreSeconds()).add("preemptedAMContainers", metrics.getNumAMContainersPreempted()).add("preemptedNonAMContainers", metrics.getNumNonAMContainersPreempted()).add("preemptedResources", metrics.getResourcePreempted()).add("applicationType", app.getApplicationType()).add("resourceSeconds", StringHelper.getResourceSecondsString(metrics.getResourceSecondsMap())).add("preemptedResourceSeconds", StringHelper.getResourceSecondsString(metrics.getPreemptedResourceSecondsMap())).add("applicationTags", StringHelper.CSV_JOINER.join((Iterable)(app.getApplicationTags() != null ? new TreeSet<String>(app.getApplicationTags()) : Collections.emptySet()))).add("applicationNodeLabel", app.getApplicationSubmissionContext().getNodeLabelExpression() == null ? "" : app.getApplicationSubmissionContext().getNodeLabelExpression()).add("diagnostics", app.getDiagnostics()).add("totalAllocatedContainers", metrics.getTotalAllocatedContainers());
            return summary;
        }

        public static void logAppSummary(RMApp app) {
            if (app != null) {
                LOG.info(ApplicationSummary.createAppSummary(app).toString());
            }
        }

        static class SummaryBuilder {
            final StringBuilder buffer = new StringBuilder();

            SummaryBuilder() {
            }

            SummaryBuilder add(String key, long value) {
                return this._add(key, Long.toString(value));
            }

            <T> SummaryBuilder add(String key, T value) {
                String escapedString = org.apache.hadoop.util.StringUtils.escapeString((String)String.valueOf(value), (char)'\\', (char[])charsToEscape).replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
                return this._add(key, escapedString);
            }

            SummaryBuilder add(SummaryBuilder summary) {
                if (this.buffer.length() > 0) {
                    this.buffer.append(',');
                }
                this.buffer.append((CharSequence)summary.buffer);
                return this;
            }

            SummaryBuilder _add(String key, String value) {
                if (this.buffer.length() > 0) {
                    this.buffer.append(',');
                }
                this.buffer.append(key).append('=').append(value);
                return this;
            }

            public String toString() {
                return this.buffer.toString();
            }
        }
    }
}

