/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.log;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.util.concurrent.Callable;
import javax.net.ssl.SSLException;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.log.LogLevel;
import org.apache.hadoop.minikdc.KerberosSecurityTestcase;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class TestLogLevel
extends KerberosSecurityTestcase {
    private static final File BASEDIR = GenericTestUtils.getRandomizedTestDir();
    private static String keystoresDir;
    private static String sslConfDir;
    private static Configuration conf;
    private static Configuration sslConf;
    private final String logName = TestLogLevel.class.getName();
    private String clientPrincipal;
    private String serverPrincipal;
    private final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger((String)this.logName);
    private static final String PRINCIPAL = "loglevel.principal";
    private static final String KEYTAB = "loglevel.keytab";
    private static final String PREFIX = "hadoop.http.authentication.";

    @BeforeClass
    public static void setUp() throws Exception {
        Logger logger = LoggerFactory.getLogger(KerberosAuthenticator.class);
        GenericTestUtils.setLogLevel(logger, Level.DEBUG);
        FileUtil.fullyDelete((File)BASEDIR);
        if (!BASEDIR.mkdirs()) {
            throw new Exception("unable to create the base directory for testing");
        }
        conf = new Configuration();
        TestLogLevel.setupSSL(BASEDIR);
    }

    private static void setupSSL(File base) throws Exception {
        keystoresDir = base.getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestLogLevel.class);
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfDir, conf, false);
        sslConf = KeyStoreTestUtil.getSslConfig();
    }

    @Before
    public void setupKerberos() throws Exception {
        File keytabFile = new File(KerberosTestUtils.getKeytabFile());
        this.clientPrincipal = KerberosTestUtils.getClientPrincipal();
        this.serverPrincipal = KerberosTestUtils.getServerPrincipal();
        this.clientPrincipal = this.clientPrincipal.substring(0, this.clientPrincipal.lastIndexOf("@"));
        this.serverPrincipal = this.serverPrincipal.substring(0, this.serverPrincipal.lastIndexOf("@"));
        this.getKdc().createPrincipal(keytabFile, new String[]{this.clientPrincipal, this.serverPrincipal});
    }

    @AfterClass
    public static void tearDown() throws Exception {
        KeyStoreTestUtil.cleanupSSLConfig(keystoresDir, sslConfDir);
        FileUtil.fullyDelete((File)BASEDIR);
    }

    @Test(timeout=120000L)
    public void testCommandOptions() throws Exception {
        String className = ((Object)((Object)this)).getClass().getName();
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-foo"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[0]));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-getlevel"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-setlevel"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080"}));
        Assert.assertTrue((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080", className}));
        Assert.assertTrue((boolean)this.validateCommand(new String[]{"-setlevel", "foo.bar:8080", className, "DEBUG"}));
        Assert.assertTrue((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080", className, "-protocol", "http"}));
        Assert.assertTrue((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080", className, "-protocol", "https"}));
        Assert.assertTrue((boolean)this.validateCommand(new String[]{"-setlevel", "foo.bar:8080", className, "DEBUG", "-protocol", "http"}));
        Assert.assertTrue((boolean)this.validateCommand(new String[]{"-setlevel", "foo.bar:8080", className, "DEBUG", "-protocol", "https"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080", className, "-protocol", "https", "blah"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-setlevel", "foo.bar:8080", className, "DEBUG", "-protocol", "https", "blah"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080", className, "-protocol", "https", "-protocol", "https"}));
        Assert.assertFalse((boolean)this.validateCommand(new String[]{"-getlevel", "foo.bar:8080", className, "-setlevel", "foo.bar:8080", className}));
    }

    private boolean validateCommand(String[] args) throws Exception {
        LogLevel.CLI cli = new LogLevel.CLI(sslConf);
        try {
            cli.parseArguments(args);
        }
        catch (HadoopIllegalArgumentException e) {
            return false;
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    private HttpServer2 createServer(String protocol, boolean isSpnego) throws Exception {
        HttpServer2.Builder builder = new HttpServer2.Builder().setName("..").addEndpoint(new URI(protocol + "://localhost:0")).setFindPort(true).setConf(conf);
        if (isSpnego) {
            builder.setSecurityEnabled(true).setUsernameConfKey(PRINCIPAL).setKeytabConfKey(KEYTAB).setACL(new AccessControlList(this.clientPrincipal));
        }
        if (protocol.equals("https")) {
            builder = builder.keyPassword(sslConf.get("ssl.server.keystore.keypassword")).keyStore(sslConf.get("ssl.server.keystore.location"), sslConf.get("ssl.server.keystore.password"), sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), sslConf.get("ssl.server.truststore.password"), sslConf.get("ssl.server.truststore.type", "jks"));
        }
        HttpServer2 server = builder.build();
        if (isSpnego) {
            server.addInternalServlet("logLevel", "/logLevel", LogLevel.Servlet.class, true);
        }
        server.start();
        return server;
    }

    private void testDynamicLogLevel(String bindProtocol, String connectProtocol, boolean isSpnego) throws Exception {
        this.testDynamicLogLevel(bindProtocol, connectProtocol, isSpnego, Level.DEBUG.toString());
    }

    private void testDynamicLogLevel(String bindProtocol, final String connectProtocol, boolean isSpnego, final String newLevel) throws Exception {
        if (!LogLevel.isValidProtocol((String)bindProtocol)) {
            throw new Exception("Invalid server protocol " + bindProtocol);
        }
        if (!LogLevel.isValidProtocol((String)connectProtocol)) {
            throw new Exception("Invalid client protocol " + connectProtocol);
        }
        Level oldLevel = this.log.getEffectiveLevel();
        Assert.assertNotEquals((String)"Get default Log Level which shouldn't be ERROR.", (Object)Level.ERROR, (Object)oldLevel);
        if (isSpnego) {
            conf.set(PRINCIPAL, KerberosTestUtils.getServerPrincipal());
            conf.set(KEYTAB, KerberosTestUtils.getKeytabFile());
            conf.set("hadoop.security.authentication", "kerberos");
            conf.set("hadoop.http.authentication.type", "kerberos");
            conf.set("hadoop.http.authentication.kerberos.keytab", KerberosTestUtils.getKeytabFile());
            conf.set("hadoop.http.authentication.kerberos.principal", KerberosTestUtils.getServerPrincipal());
            conf.set("hadoop.http.filter.initializers", AuthenticationFilterInitializer.class.getName());
            conf.setBoolean("hadoop.security.authorization", true);
            UserGroupInformation.setConfiguration((Configuration)conf);
        }
        HttpServer2 server = this.createServer(bindProtocol, isSpnego);
        final String authority = NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0));
        KerberosTestUtils.doAsClient((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestLogLevel.this.getLevel(connectProtocol, authority);
                TestLogLevel.this.setLevel(connectProtocol, authority, newLevel);
                return null;
            }
        });
        server.stop();
        GenericTestUtils.setLogLevel(this.log, oldLevel);
    }

    private void getLevel(String protocol, String authority) throws Exception {
        String[] getLevelArgs = new String[]{"-getlevel", authority, this.logName, "-protocol", protocol};
        LogLevel.CLI cli = new LogLevel.CLI(sslConf);
        cli.run(getLevelArgs);
    }

    private void setLevel(String protocol, String authority, String newLevel) throws Exception {
        String[] setLevelArgs = new String[]{"-setlevel", authority, this.logName, newLevel, "-protocol", protocol};
        LogLevel.CLI cli = new LogLevel.CLI(sslConf);
        cli.run(setLevelArgs);
        Assert.assertEquals((String)"new level not equal to expected: ", (Object)newLevel.toUpperCase(), (Object)this.log.getEffectiveLevel().toString());
    }

    @Test(timeout=60000L)
    public void testInfoLogLevel() throws Exception {
        this.testDynamicLogLevel("http", "http", false, "Info");
    }

    @Test(timeout=60000L)
    public void testErrorLogLevel() throws Exception {
        this.testDynamicLogLevel("http", "http", false, "Error");
    }

    @Test(timeout=60000L)
    public void testLogLevelByHttp() throws Exception {
        this.testDynamicLogLevel("http", "http", false);
        try {
            this.testDynamicLogLevel("http", "https", false);
            Assert.fail((String)"A HTTPS Client should not have succeeded in connecting to a HTTP server");
        }
        catch (SSLException e) {
            GenericTestUtils.assertExceptionContains("Error while authenticating with endpoint", e);
            GenericTestUtils.assertExceptionContains("recognized SSL message", e.getCause());
        }
    }

    @Test(timeout=60000L)
    public void testLogLevelByHttpWithSpnego() throws Exception {
        this.testDynamicLogLevel("http", "http", true);
        try {
            this.testDynamicLogLevel("http", "https", true);
            Assert.fail((String)"A HTTPS Client should not have succeeded in connecting to a HTTP server");
        }
        catch (SSLException e) {
            GenericTestUtils.assertExceptionContains("Error while authenticating with endpoint", e);
            GenericTestUtils.assertExceptionContains("recognized SSL message", e.getCause());
        }
    }

    @Test(timeout=60000L)
    public void testLogLevelByHttps() throws Exception {
        this.testDynamicLogLevel("https", "https", false);
        try {
            this.testDynamicLogLevel("https", "http", false);
            Assert.fail((String)"A HTTP Client should not have succeeded in connecting to a HTTPS server");
        }
        catch (SocketException e) {
            GenericTestUtils.assertExceptionContains("Error while authenticating with endpoint", e);
            GenericTestUtils.assertExceptionContains("Unexpected end of file from server", e.getCause());
        }
    }

    @Test(timeout=60000L)
    public void testLogLevelByHttpsWithSpnego() throws Exception {
        this.testDynamicLogLevel("https", "https", true);
        try {
            this.testDynamicLogLevel("https", "http", true);
            Assert.fail((String)"A HTTP Client should not have succeeded in connecting to a HTTPS server");
        }
        catch (SocketException e) {
            GenericTestUtils.assertExceptionContains("Error while authenticating with endpoint", e);
            GenericTestUtils.assertExceptionContains("Unexpected end of file from server", e.getCause());
        }
    }
}

