/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth.delegation;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationTokenIOException;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.hadoop.util.Time;

public abstract class AbstractS3ATokenIdentifier
extends DelegationTokenIdentifier {
    protected static final int MAX_TEXT_LENGTH = 8192;
    private URI uri;
    private EncryptionSecrets encryptionSecrets = new EncryptionSecrets();
    private long created = System.currentTimeMillis();
    private String origin = "";
    private String uuid = UUID.randomUUID().toString();

    protected AbstractS3ATokenIdentifier(Text kind, URI uri, Text owner, Text renewer, String origin, EncryptionSecrets encryptionSecrets) {
        this(kind, owner, renewer != null ? renewer : new Text(), new Text(), uri);
        this.origin = Objects.requireNonNull(origin);
        this.encryptionSecrets = Objects.requireNonNull(encryptionSecrets);
    }

    protected AbstractS3ATokenIdentifier(Text kind, Text owner, Text renewer, Text realUser, URI uri) {
        super(kind, owner, renewer, realUser);
        this.uri = Objects.requireNonNull(uri);
        this.initializeIssueDate();
    }

    protected AbstractS3ATokenIdentifier(Text kind, Token<AbstractS3ATokenIdentifier> token) throws IOException {
        super(kind);
        ByteArrayInputStream bais = new ByteArrayInputStream(token.getIdentifier());
        this.readFields(new DataInputStream(bais));
    }

    protected AbstractS3ATokenIdentifier(Text kind) {
        super(kind);
        this.initializeIssueDate();
    }

    private void initializeIssueDate() {
        this.setIssueDate(Time.now());
    }

    public String getBucket() {
        return this.uri.getHost();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public long getCreated() {
        return this.created;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.uri.toString());
        Text.writeString((DataOutput)out, (String)this.origin);
        Text.writeString((DataOutput)out, (String)this.uuid);
        this.encryptionSecrets.write(out);
        out.writeLong(this.created);
    }

    public void readFields(DataInput in) throws DelegationTokenIOException, IOException {
        super.readFields(in);
        this.uri = URI.create(Text.readString((DataInput)in, (int)8192));
        this.origin = Text.readString((DataInput)in, (int)8192);
        this.uuid = Text.readString((DataInput)in, (int)8192);
        this.encryptionSecrets.readFields(in);
        this.created = in.readLong();
    }

    public void validate() throws IOException {
        if (this.uri == null) {
            throw new DelegationTokenIOException("No URI in " + (Object)((Object)this));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("S3ATokenIdentifier{");
        sb.append(this.getKind());
        sb.append("; uri=").append(this.uri);
        sb.append("; timestamp=").append(this.created);
        sb.append("; renewer=").append(this.getRenewer());
        sb.append("; encryption=").append(this.encryptionSecrets.toString());
        sb.append("; ").append(this.uuid);
        sb.append("; ").append(this.origin);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractS3ATokenIdentifier that = (AbstractS3ATokenIdentifier)((Object)o);
        return Objects.equals(this.uuid, that.uuid) && Objects.equals(this.uri, that.uri);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.uri);
    }

    public long getExpiryTime() {
        return 0L;
    }

    public String getUuid() {
        return this.uuid;
    }

    public EncryptionSecrets getEncryptionSecrets() {
        return this.encryptionSecrets;
    }

    public static String createDefaultOriginMessage() {
        return String.format("Created on %s at time %s.", NetUtils.getHostname(), Instant.now());
    }
}

