/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLContext;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public class ZKFipsLoader {
    public static void loadZKFipsProviders() {
        Security.addProvider((Provider)new BouncyCastleFipsProvider());
        Security.addProvider((Provider)new BouncyCastleJsseProvider("fips:org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCryptoProvider"));
    }

    public static boolean isFipsMode() {
        Provider provider = Security.getProvider("BCJSSE");
        return provider != null && provider.getClass() == BouncyCastleJsseProvider.class && ((BouncyCastleJsseProvider)provider).isFipsMode();
    }

    public static SSLContext getBCFKSSSLContext(String protocol) throws NoSuchAlgorithmException {
        return SSLContext.getInstance(protocol, Security.getProvider("BCJSSE"));
    }
}

