/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.oncrpc.RpcResponse;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;

public class RpcCallCache {
    private final String program;
    private final Map<ClientRequest, CacheEntry> map;

    public RpcCallCache(String program, final int maxEntries) {
        if (maxEntries <= 0) {
            throw new IllegalArgumentException("Cache size is " + maxEntries + ". Should be > 0");
        }
        this.program = program;
        this.map = new LinkedHashMap<ClientRequest, CacheEntry>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<ClientRequest, CacheEntry> eldest) {
                return RpcCallCache.this.size() > maxEntries;
            }
        };
    }

    public String getProgram() {
        return this.program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callCompleted(InetAddress clientId, int xid, RpcResponse response) {
        CacheEntry e;
        ClientRequest req = new ClientRequest(clientId, xid);
        Map<ClientRequest, CacheEntry> map = this.map;
        synchronized (map) {
            e = this.map.get(req);
        }
        e.response = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry checkOrAddToCache(InetAddress clientId, int xid) {
        CacheEntry e;
        ClientRequest req = new ClientRequest(clientId, xid);
        Map<ClientRequest, CacheEntry> map = this.map;
        synchronized (map) {
            e = this.map.get(req);
            if (e == null) {
                this.map.put(req, new CacheEntry());
            }
        }
        return e;
    }

    public int size() {
        return this.map.size();
    }

    @VisibleForTesting
    public Iterator<Map.Entry<ClientRequest, CacheEntry>> iterator() {
        return this.map.entrySet().iterator();
    }

    public static class ClientRequest {
        protected final InetAddress clientId;
        protected final int xid;

        public InetAddress getClientId() {
            return this.clientId;
        }

        public ClientRequest(InetAddress clientId, int xid) {
            this.clientId = clientId;
            this.xid = xid;
        }

        public int hashCode() {
            return this.xid + this.clientId.hashCode() * 31;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof ClientRequest)) {
                return false;
            }
            ClientRequest other = (ClientRequest)obj;
            return this.clientId.equals(other.clientId) && this.xid == other.xid;
        }
    }

    public static class CacheEntry {
        private RpcResponse response = null;

        public boolean isInProgress() {
            return this.response == null;
        }

        public boolean isCompleted() {
            return this.response != null;
        }

        public RpcResponse getResponse() {
            return this.response;
        }

        public void setResponse(RpcResponse response) {
            this.response = response;
        }
    }
}

