/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.conf.DefaultYarnConfiguration;
import org.apache.hadoop.yarn.security.AbstractMapRTicketGenerator;
import org.apache.hadoop.yarn.security.ExternalTokenManager;
import org.apache.hadoop.yarn.security.MapRTicketUploader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRTicketManager
implements ExternalTokenManager {
    private static final Logger LOG = LoggerFactory.getLogger(MapRTicketManager.class);
    private MapRTicketUploader uploader = new MapRTicketUploader();
    private AbstractMapRTicketGenerator generator;
    private static final String MapRTicketGenerator = "org.apache.hadoop.shaded.com.mapr.security.MapRTicketGenerator";

    public MapRTicketManager() {
        try {
            Class<?> klass = Thread.currentThread().getContextClassLoader().loadClass(MapRTicketGenerator);
            this.generator = (AbstractMapRTicketGenerator)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException err) {
            LOG.error("Could not find MapRTicketGenerator class at classpath");
            err.printStackTrace();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Could not instantiate MapRTicketGenerator");
            e.printStackTrace();
        }
    }

    @Override
    public void uploadTokenToDistributedCache(ApplicationId appId) {
        this.uploader.uploadToken(appId, DefaultYarnConfiguration.get());
    }

    @Override
    public void generateToken(ApplicationSubmissionContext appCtx, String username, Configuration conf) {
        this.generator.generateToken(appCtx, username, conf);
    }

    @Override
    public void removeToken(ApplicationId appId, Configuration conf) {
        this.generator.removeToken(appId, conf);
    }
}

