/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.security.ssl.FileMonitoringTimerTask;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.ReloadingX509TrustManager;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestReloadingX509TrustManager {
    private static final String BASEDIR = GenericTestUtils.getTempPath(TestReloadingX509TrustManager.class.getSimpleName());
    private X509Certificate cert1;
    private X509Certificate cert2;
    private final GenericTestUtils.LogCapturer reloaderLog = GenericTestUtils.LogCapturer.captureLogs(FileMonitoringTimerTask.LOG);

    @BeforeClass
    public static void setUp() throws Exception {
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
    }

    @Test(expected=IOException.class)
    public void testLoadMissingTrustStore() throws Exception {
        String truststoreLocation = BASEDIR + "/testmissing.jks";
        ReloadingX509TrustManager tm = new ReloadingX509TrustManager("jks", truststoreLocation, "password");
    }

    @Test(expected=IOException.class)
    public void testLoadCorruptTrustStore() throws Exception {
        String truststoreLocation = BASEDIR + "/testcorrupt.jks";
        FileOutputStream os = new FileOutputStream(truststoreLocation);
        ((OutputStream)os).write(1);
        ((OutputStream)os).close();
        ReloadingX509TrustManager tm = new ReloadingX509TrustManager("jks", truststoreLocation, "password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testReload() throws Exception {
        KeyPair kp = KeyStoreTestUtil.generateKeyPair("RSA");
        this.cert1 = KeyStoreTestUtil.generateCertificate("CN=Cert1", kp, 30, "SHA256WithRSA");
        this.cert2 = KeyStoreTestUtil.generateCertificate("CN=Cert2", kp, 30, "SHA256WithRSA");
        String truststoreLocation = BASEDIR + "/testreload.jks";
        KeyStoreTestUtil.createTrustStore(truststoreLocation, "password", "cert1", this.cert1);
        long reloadInterval = 10L;
        Timer fileMonitoringTimer = new Timer("SSL Certificates Store Monitor", true);
        final ReloadingX509TrustManager tm = new ReloadingX509TrustManager("jks", truststoreLocation, "password");
        try {
            fileMonitoringTimer.schedule((TimerTask)new FileMonitoringTimerTask(Paths.get(truststoreLocation, new String[0]), arg_0 -> ((ReloadingX509TrustManager)tm).loadFrom(arg_0), null), reloadInterval, reloadInterval);
            Assert.assertEquals((long)1L, (long)tm.getAcceptedIssuers().length);
            Thread.sleep(reloadInterval + 1000L);
            HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
            certs.put("cert1", this.cert1);
            certs.put("cert2", this.cert2);
            KeyStoreTestUtil.createTrustStore(truststoreLocation, "password", certs);
            GenericTestUtils.waitFor(new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return tm.getAcceptedIssuers().length == 2;
                }
            }, (int)reloadInterval, 100000L);
        }
        finally {
            fileMonitoringTimer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testReloadMissingTrustStore() throws Exception {
        KeyPair kp = KeyStoreTestUtil.generateKeyPair("RSA");
        this.cert1 = KeyStoreTestUtil.generateCertificate("CN=Cert1", kp, 30, "SHA256WithRSA");
        this.cert2 = KeyStoreTestUtil.generateCertificate("CN=Cert2", kp, 30, "SHA256WithRSA");
        String truststoreLocation = BASEDIR + "/testmissing.jks";
        KeyStoreTestUtil.createTrustStore(truststoreLocation, "password", "cert1", this.cert1);
        long reloadInterval = 10L;
        Timer fileMonitoringTimer = new Timer("SSL Certificates Store Monitor", true);
        ReloadingX509TrustManager tm = new ReloadingX509TrustManager("jks", truststoreLocation, "password");
        try {
            fileMonitoringTimer.schedule((TimerTask)new FileMonitoringTimerTask(Paths.get(truststoreLocation, new String[0]), arg_0 -> ((ReloadingX509TrustManager)tm).loadFrom(arg_0), null), reloadInterval, reloadInterval);
            Assert.assertEquals((long)1L, (long)tm.getAcceptedIssuers().length);
            X509Certificate cert = tm.getAcceptedIssuers()[0];
            Assert.assertFalse((boolean)this.reloaderLog.getOutput().contains("Could not process file change : "));
            Thread.sleep(reloadInterval + 1000L);
            new File(truststoreLocation).delete();
            Thread.sleep(reloadInterval + 1000L);
            this.waitForFailedReloadAtLeastOnce((int)reloadInterval);
            Assert.assertEquals((long)1L, (long)tm.getAcceptedIssuers().length);
            Assert.assertEquals((Object)cert, (Object)tm.getAcceptedIssuers()[0]);
        }
        finally {
            this.reloaderLog.stopCapturing();
            fileMonitoringTimer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testReloadCorruptTrustStore() throws Exception {
        KeyPair kp = KeyStoreTestUtil.generateKeyPair("RSA");
        this.cert1 = KeyStoreTestUtil.generateCertificate("CN=Cert1", kp, 30, "SHA256WithRSA");
        this.cert2 = KeyStoreTestUtil.generateCertificate("CN=Cert2", kp, 30, "SHA256WithRSA");
        String truststoreLocation = BASEDIR + "/testcorrupt.jks";
        KeyStoreTestUtil.createTrustStore(truststoreLocation, "password", "cert1", this.cert1);
        long reloadInterval = 10L;
        Timer fileMonitoringTimer = new Timer("SSL Certificates Store Monitor", true);
        ReloadingX509TrustManager tm = new ReloadingX509TrustManager("jks", truststoreLocation, "password");
        try {
            fileMonitoringTimer.schedule((TimerTask)new FileMonitoringTimerTask(Paths.get(truststoreLocation, new String[0]), arg_0 -> ((ReloadingX509TrustManager)tm).loadFrom(arg_0), null), reloadInterval, reloadInterval);
            Assert.assertEquals((long)1L, (long)tm.getAcceptedIssuers().length);
            X509Certificate cert = tm.getAcceptedIssuers()[0];
            Thread.sleep(reloadInterval + 1000L);
            Assert.assertFalse((boolean)this.reloaderLog.getOutput().contains("Could not process file change : "));
            FileOutputStream os = new FileOutputStream(truststoreLocation);
            ((OutputStream)os).write(1);
            ((OutputStream)os).close();
            this.waitForFailedReloadAtLeastOnce((int)reloadInterval);
            Assert.assertEquals((long)1L, (long)tm.getAcceptedIssuers().length);
            Assert.assertEquals((Object)cert, (Object)tm.getAcceptedIssuers()[0]);
        }
        finally {
            this.reloaderLog.stopCapturing();
            fileMonitoringTimer.cancel();
        }
    }

    private void waitForFailedReloadAtLeastOnce(int reloadInterval) throws InterruptedException, TimeoutException {
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return TestReloadingX509TrustManager.this.reloaderLog.getOutput().contains("Could not process file change : ");
            }
        }, reloadInterval, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoPassword() throws Exception {
        KeyPair kp = KeyStoreTestUtil.generateKeyPair("RSA");
        this.cert1 = KeyStoreTestUtil.generateCertificate("CN=Cert1", kp, 30, "SHA256WithRSA");
        this.cert2 = KeyStoreTestUtil.generateCertificate("CN=Cert2", kp, 30, "SHA256WithRSA");
        String truststoreLocation = BASEDIR + "/testreload.jks";
        KeyStoreTestUtil.createTrustStore(truststoreLocation, "password", "cert1", this.cert1);
        Timer fileMonitoringTimer = new Timer("SSL Certificates Store Monitor", true);
        ReloadingX509TrustManager tm = new ReloadingX509TrustManager("jks", truststoreLocation, null);
        try {
            fileMonitoringTimer.schedule((TimerTask)new FileMonitoringTimerTask(Paths.get(truststoreLocation, new String[0]), arg_0 -> ((ReloadingX509TrustManager)tm).loadFrom(arg_0), null), 10L, 10L);
            Assert.assertEquals((long)1L, (long)tm.getAcceptedIssuers().length);
        }
        finally {
            fileMonitoringTimer.cancel();
        }
    }
}

