/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.DTLSProtocol;
import org.bouncycastle.tls.DTLSRecordLayer;
import org.bouncycastle.tls.DTLSReliableHandshake;
import org.bouncycastle.tls.DTLSRequest;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HeartbeatExtension;
import org.bouncycastle.tls.KeyExchangeAlgorithm;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.NullOutputStream;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerHello;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsHeartbeat;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerContextImpl;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;

public class DTLSServerProtocol
extends DTLSProtocol {
    protected boolean verifyRequests = true;

    public boolean getVerifyRequests() {
        return this.verifyRequests;
    }

    public void setVerifyRequests(boolean verifyRequests) {
        this.verifyRequests = verifyRequests;
    }

    public DTLSTransport accept(TlsServer server, DatagramTransport transport) throws IOException {
        return this.accept(server, transport, null);
    }

    public DTLSTransport accept(TlsServer server, DatagramTransport transport, DTLSRequest request) throws IOException {
        if (server == null) {
            throw new IllegalArgumentException("'server' cannot be null");
        }
        if (transport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        TlsServerContextImpl serverContext = new TlsServerContextImpl(server.getCrypto());
        ServerHandshakeState state = new ServerHandshakeState();
        state.server = server;
        state.serverContext = serverContext;
        server.init(serverContext);
        serverContext.handshakeBeginning(server);
        SecurityParameters securityParameters = serverContext.getSecurityParametersHandshake();
        securityParameters.extendedPadding = server.shouldUseExtendedPadding();
        DTLSRecordLayer recordLayer = new DTLSRecordLayer(serverContext, server, transport);
        server.notifyCloseHandle(recordLayer);
        try {
            DTLSTransport dTLSTransport = this.serverHandshake(state, recordLayer, request);
            return dTLSTransport;
        }
        catch (TlsFatalAlert fatalAlert) {
            this.abortServerHandshake(state, recordLayer, fatalAlert.getAlertDescription());
            throw fatalAlert;
        }
        catch (IOException e) {
            this.abortServerHandshake(state, recordLayer, (short)80);
            throw e;
        }
        catch (RuntimeException e) {
            this.abortServerHandshake(state, recordLayer, (short)80);
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        finally {
            securityParameters.clear();
        }
    }

    protected void abortServerHandshake(ServerHandshakeState state, DTLSRecordLayer recordLayer, short alertDescription) {
        recordLayer.fail(alertDescription);
        this.invalidateSession(state);
    }

    protected DTLSTransport serverHandshake(ServerHandshakeState state, DTLSRecordLayer recordLayer, DTLSRequest request) throws IOException {
        byte[] serverKeyExchange;
        CertificateStatus certificateStatus;
        TlsServer server = state.server;
        TlsServerContextImpl serverContext = state.serverContext;
        SecurityParameters securityParameters = serverContext.getSecurityParametersHandshake();
        DTLSReliableHandshake handshake = new DTLSReliableHandshake(serverContext, recordLayer, server.getHandshakeTimeoutMillis(), server.getHandshakeResendTimeMillis(), request);
        DTLSReliableHandshake.Message clientMessage = null;
        if (null == request) {
            clientMessage = handshake.receiveMessage();
            if (clientMessage.getType() != 1) {
                throw new TlsFatalAlert(10);
            }
            this.processClientHello(state, clientMessage.getBody());
            clientMessage = null;
        } else {
            this.processClientHello(state, request.getClientHello());
            request = null;
        }
        byte[] serverHelloBody = this.generateServerHello(state, recordLayer);
        ProtocolVersion recordLayerVersion = serverContext.getServerVersion();
        recordLayer.setReadVersion(recordLayerVersion);
        recordLayer.setWriteVersion(recordLayerVersion);
        handshake.sendMessage((short)2, serverHelloBody);
        handshake.getHandshakeHash().notifyPRFDetermined();
        if (securityParameters.isResumedSession()) {
            securityParameters.masterSecret = state.sessionMasterSecret;
            recordLayer.initPendingEpoch(TlsUtils.initCipher(serverContext));
            securityParameters.localVerifyData = TlsUtils.calculateVerifyData(serverContext, handshake.getHandshakeHash(), true);
            handshake.sendMessage((short)20, securityParameters.getLocalVerifyData());
            securityParameters.peerVerifyData = TlsUtils.calculateVerifyData(serverContext, handshake.getHandshakeHash(), false);
            this.processFinished(handshake.receiveMessageBody((short)20), securityParameters.getPeerVerifyData());
            handshake.finish();
            if (securityParameters.isExtendedMasterSecret()) {
                securityParameters.tlsUnique = securityParameters.getLocalVerifyData();
            }
            securityParameters.localCertificate = state.sessionParameters.getLocalCertificate();
            securityParameters.peerCertificate = state.sessionParameters.getPeerCertificate();
            securityParameters.pskIdentity = state.sessionParameters.getPSKIdentity();
            securityParameters.srpIdentity = state.sessionParameters.getSRPIdentity();
            serverContext.handshakeComplete(server, state.tlsSession);
            recordLayer.initHeartbeat(state.heartbeat, 1 == state.heartbeatPolicy);
            return new DTLSTransport(recordLayer);
        }
        Vector serverSupplementalData = server.getServerSupplementalData();
        if (serverSupplementalData != null) {
            byte[] supplementalDataBody = DTLSServerProtocol.generateSupplementalData(serverSupplementalData);
            handshake.sendMessage((short)23, supplementalDataBody);
        }
        state.keyExchange = TlsUtils.initKeyExchangeServer(serverContext, server);
        state.serverCredentials = null;
        if (!KeyExchangeAlgorithm.isAnonymous(securityParameters.getKeyExchangeAlgorithm())) {
            state.serverCredentials = TlsUtils.establishServerCredentials(server);
        }
        Certificate serverCertificate = null;
        ByteArrayOutputStream endPointHash = new ByteArrayOutputStream();
        if (state.serverCredentials == null) {
            state.keyExchange.skipServerCredentials();
        } else {
            state.keyExchange.processServerCredentials(state.serverCredentials);
            serverCertificate = state.serverCredentials.getCertificate();
            DTLSServerProtocol.sendCertificateMessage(serverContext, handshake, serverCertificate, endPointHash);
        }
        securityParameters.tlsServerEndPoint = endPointHash.toByteArray();
        if (serverCertificate == null || serverCertificate.isEmpty()) {
            securityParameters.statusRequestVersion = 0;
        }
        if (securityParameters.getStatusRequestVersion() > 0 && (certificateStatus = server.getCertificateStatus()) != null) {
            byte[] certificateStatusBody = this.generateCertificateStatus(state, certificateStatus);
            handshake.sendMessage((short)22, certificateStatusBody);
        }
        if ((serverKeyExchange = state.keyExchange.generateServerKeyExchange()) != null) {
            handshake.sendMessage((short)12, serverKeyExchange);
        }
        if (state.serverCredentials != null) {
            state.certificateRequest = server.getCertificateRequest();
            if (null == state.certificateRequest) {
                if (!state.keyExchange.requiresCertificateVerify()) {
                    throw new TlsFatalAlert(80);
                }
            } else {
                if (TlsUtils.isTLSv12(serverContext) != (state.certificateRequest.getSupportedSignatureAlgorithms() != null)) {
                    throw new TlsFatalAlert(80);
                }
                state.certificateRequest = TlsUtils.validateCertificateRequest(state.certificateRequest, state.keyExchange);
                TlsUtils.establishServerSigAlgs(securityParameters, state.certificateRequest);
                if (ProtocolVersion.DTLSv12.equals(securityParameters.getNegotiatedVersion())) {
                    TlsUtils.trackHashAlgorithms(handshake.getHandshakeHash(), securityParameters.getServerSigAlgs());
                    if (serverContext.getCrypto().hasAnyStreamVerifiers(securityParameters.getServerSigAlgs())) {
                        handshake.getHandshakeHash().forceBuffering();
                    }
                } else if (serverContext.getCrypto().hasAnyStreamVerifiersLegacy(state.certificateRequest.getCertificateTypes())) {
                    handshake.getHandshakeHash().forceBuffering();
                }
            }
        }
        handshake.getHandshakeHash().sealHashAlgorithms();
        if (null != state.certificateRequest) {
            byte[] certificateRequestBody = this.generateCertificateRequest(state, state.certificateRequest);
            handshake.sendMessage((short)13, certificateRequestBody);
        }
        handshake.sendMessage((short)14, TlsUtils.EMPTY_BYTES);
        clientMessage = handshake.receiveMessage();
        if (clientMessage.getType() == 23) {
            this.processClientSupplementalData(state, clientMessage.getBody());
            clientMessage = handshake.receiveMessage();
        } else {
            server.processClientSupplementalData(null);
        }
        if (state.certificateRequest == null) {
            state.keyExchange.skipClientCredentials();
        } else if (clientMessage.getType() == 11) {
            this.processClientCertificate(state, clientMessage.getBody());
            clientMessage = handshake.receiveMessage();
        } else {
            if (TlsUtils.isTLSv12(serverContext)) {
                throw new TlsFatalAlert(10);
            }
            this.notifyClientCertificate(state, Certificate.EMPTY_CHAIN);
        }
        if (clientMessage.getType() != 16) {
            throw new TlsFatalAlert(10);
        }
        this.processClientKeyExchange(state, clientMessage.getBody());
        securityParameters.sessionHash = TlsUtils.getCurrentPRFHash(handshake.getHandshakeHash());
        TlsProtocol.establishMasterSecret(serverContext, state.keyExchange);
        recordLayer.initPendingEpoch(TlsUtils.initCipher(serverContext));
        if (this.expectCertificateVerifyMessage(state)) {
            clientMessage = handshake.receiveMessageDelayedDigest((short)15);
            byte[] certificateVerifyBody = clientMessage.getBody();
            this.processCertificateVerify(state, certificateVerifyBody, handshake.getHandshakeHash());
            handshake.prepareToFinish();
            handshake.updateHandshakeMessagesDigest(clientMessage);
        } else {
            handshake.prepareToFinish();
        }
        clientMessage = null;
        securityParameters.peerVerifyData = TlsUtils.calculateVerifyData(serverContext, handshake.getHandshakeHash(), false);
        this.processFinished(handshake.receiveMessageBody((short)20), securityParameters.getPeerVerifyData());
        if (state.expectSessionTicket) {
            NewSessionTicket newSessionTicket = server.getNewSessionTicket();
            byte[] newSessionTicketBody = this.generateNewSessionTicket(state, newSessionTicket);
            handshake.sendMessage((short)4, newSessionTicketBody);
        }
        securityParameters.localVerifyData = TlsUtils.calculateVerifyData(serverContext, handshake.getHandshakeHash(), true);
        handshake.sendMessage((short)20, securityParameters.getLocalVerifyData());
        handshake.finish();
        state.sessionMasterSecret = securityParameters.getMasterSecret();
        state.sessionParameters = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setExtendedMasterSecret(securityParameters.isExtendedMasterSecret()).setLocalCertificate(securityParameters.getLocalCertificate()).setMasterSecret(serverContext.getCrypto().adoptSecret(state.sessionMasterSecret)).setNegotiatedVersion(securityParameters.getNegotiatedVersion()).setPeerCertificate(securityParameters.getPeerCertificate()).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(state.serverExtensions).build();
        state.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), state.sessionParameters);
        securityParameters.tlsUnique = securityParameters.getPeerVerifyData();
        serverContext.handshakeComplete(server, state.tlsSession);
        recordLayer.initHeartbeat(state.heartbeat, 1 == state.heartbeatPolicy);
        return new DTLSTransport(recordLayer);
    }

    protected byte[] generateCertificateRequest(ServerHandshakeState state, CertificateRequest certificateRequest) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        certificateRequest.encode(state.serverContext, buf);
        return buf.toByteArray();
    }

    protected byte[] generateCertificateStatus(ServerHandshakeState state, CertificateStatus certificateStatus) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        certificateStatus.encode(buf);
        return buf.toByteArray();
    }

    protected byte[] generateNewSessionTicket(ServerHandshakeState state, NewSessionTicket newSessionTicket) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        newSessionTicket.encode(buf);
        return buf.toByteArray();
    }

    protected byte[] generateServerHello(ServerHandshakeState state, DTLSRecordLayer recordLayer) throws IOException {
        byte[] serverConnectionID;
        TlsServer server = state.server;
        TlsServerContextImpl serverContext = state.serverContext;
        SecurityParameters securityParameters = serverContext.getSecurityParametersHandshake();
        ProtocolVersion serverVersion = server.getServerVersion();
        if (!ProtocolVersion.contains(serverContext.getClientSupportedVersions(), serverVersion)) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.negotiatedVersion = serverVersion;
        boolean useGMTUnixTime = server.shouldUseGMTUnixTime();
        securityParameters.serverRandom = TlsProtocol.createRandomBlock(useGMTUnixTime, serverContext);
        if (!serverVersion.equals(ProtocolVersion.getLatestDTLS(server.getProtocolVersions()))) {
            TlsUtils.writeDowngradeMarker(serverVersion, securityParameters.getServerRandom());
        }
        Hashtable clientHelloExtensions = state.clientHello.getExtensions();
        TlsSession sessionToResume = server.getSessionToResume(state.clientHello.getSessionID());
        boolean resumedSession = this.establishSession(state, sessionToResume);
        if (resumedSession && !serverVersion.equals(state.sessionParameters.getNegotiatedVersion())) {
            resumedSession = false;
        }
        boolean negotiateEMS = false;
        if (TlsUtils.isExtendedMasterSecretOptional(serverVersion) && server.shouldUseExtendedMasterSecret()) {
            if (TlsExtensionsUtils.hasExtendedMasterSecretExtension(clientHelloExtensions)) {
                negotiateEMS = true;
            } else {
                if (server.requiresExtendedMasterSecret()) {
                    throw new TlsFatalAlert(40, "Extended Master Secret extension is required");
                }
                if (resumedSession) {
                    if (state.sessionParameters.isExtendedMasterSecret()) {
                        throw new TlsFatalAlert(40, "Extended Master Secret extension is required for EMS session resumption");
                    }
                    if (!server.allowLegacyResumption()) {
                        throw new TlsFatalAlert(40, "Extended Master Secret extension is required for legacy session resumption");
                    }
                }
            }
        }
        if (resumedSession && negotiateEMS != state.sessionParameters.isExtendedMasterSecret()) {
            resumedSession = false;
        }
        securityParameters.extendedMasterSecret = negotiateEMS;
        if (!resumedSession) {
            this.cancelSession(state);
            byte[] newSessionID = server.getNewSessionID();
            if (null == newSessionID) {
                newSessionID = TlsUtils.EMPTY_BYTES;
            }
            state.tlsSession = TlsUtils.importSession(newSessionID, null);
        }
        securityParameters.resumedSession = resumedSession;
        securityParameters.sessionID = state.tlsSession.getSessionID();
        server.notifySession(state.tlsSession);
        TlsUtils.negotiatedVersionDTLSServer(serverContext);
        int cipherSuite = DTLSServerProtocol.validateSelectedCipherSuite(server.getSelectedCipherSuite(), (short)80);
        if (!TlsUtils.isValidCipherSuiteSelection(state.clientHello.getCipherSuites(), cipherSuite) || !TlsUtils.isValidVersionForCipherSuite(cipherSuite, securityParameters.getNegotiatedVersion())) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.negotiatedCipherSuite(securityParameters, cipherSuite);
        Hashtable sessionServerExtensions = resumedSession ? state.sessionParameters.readServerExtensions() : server.getServerExtensions();
        state.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(sessionServerExtensions);
        server.getServerExtensionsForConnection(state.serverExtensions);
        if (securityParameters.isSecureRenegotiation()) {
            boolean noRenegExt;
            byte[] serverRenegExtData = TlsUtils.getExtensionData(state.serverExtensions, TlsProtocol.EXT_RenegotiationInfo);
            boolean bl = noRenegExt = null == serverRenegExtData;
            if (noRenegExt) {
                state.serverExtensions.put(TlsProtocol.EXT_RenegotiationInfo, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (securityParameters.isExtendedMasterSecret()) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(state.serverExtensions);
        } else {
            state.serverExtensions.remove(TlsExtensionsUtils.EXT_extended_master_secret);
        }
        if (null != state.heartbeat || 1 == state.heartbeatPolicy) {
            TlsExtensionsUtils.addHeartbeatExtension(state.serverExtensions, new HeartbeatExtension(state.heartbeatPolicy));
        }
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(state.serverExtensions);
        securityParameters.applicationProtocolSet = true;
        if (ProtocolVersion.DTLSv12.equals(securityParameters.getNegotiatedVersion()) && (serverConnectionID = TlsExtensionsUtils.getConnectionIDExtension(state.serverExtensions)) != null) {
            byte[] clientConnectionID = TlsExtensionsUtils.getConnectionIDExtension(clientHelloExtensions);
            if (clientConnectionID == null) {
                throw new TlsFatalAlert(80);
            }
            securityParameters.connectionIDLocal = clientConnectionID;
            securityParameters.connectionIDPeer = serverConnectionID;
        }
        if (!state.serverExtensions.isEmpty()) {
            securityParameters.encryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(state.serverExtensions);
            securityParameters.maxFragmentLength = TlsUtils.processMaxFragmentLengthExtension(resumedSession ? null : clientHelloExtensions, state.serverExtensions, (short)80);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(state.serverExtensions);
            if (!resumedSession) {
                if (TlsUtils.hasExpectedEmptyExtensionData(state.serverExtensions, TlsExtensionsUtils.EXT_status_request_v2, (short)80)) {
                    securityParameters.statusRequestVersion = 2;
                } else if (TlsUtils.hasExpectedEmptyExtensionData(state.serverExtensions, TlsExtensionsUtils.EXT_status_request, (short)80)) {
                    securityParameters.statusRequestVersion = 1;
                }
                securityParameters.clientCertificateType = TlsUtils.processClientCertificateTypeExtension(clientHelloExtensions, state.serverExtensions, (short)80);
                securityParameters.serverCertificateType = TlsUtils.processServerCertificateTypeExtension(clientHelloExtensions, state.serverExtensions, (short)80);
                state.expectSessionTicket = TlsUtils.hasExpectedEmptyExtensionData(state.serverExtensions, TlsProtocol.EXT_SessionTicket, (short)80);
            }
        }
        ServerHello serverHello = new ServerHello(serverVersion, securityParameters.getServerRandom(), securityParameters.getSessionID(), securityParameters.getCipherSuite(), state.serverExtensions);
        state.clientHello = null;
        DTLSServerProtocol.applyMaxFragmentLengthExtension(recordLayer, securityParameters.getMaxFragmentLength());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        serverHello.encode(serverContext, buf);
        return buf.toByteArray();
    }

    protected void cancelSession(ServerHandshakeState state) {
        if (state.sessionMasterSecret != null) {
            state.sessionMasterSecret.destroy();
            state.sessionMasterSecret = null;
        }
        if (state.sessionParameters != null) {
            state.sessionParameters.clear();
            state.sessionParameters = null;
        }
        state.tlsSession = null;
    }

    protected boolean establishSession(ServerHandshakeState state, TlsSession sessionToResume) {
        state.tlsSession = null;
        state.sessionParameters = null;
        state.sessionMasterSecret = null;
        if (null == sessionToResume || !sessionToResume.isResumable()) {
            return false;
        }
        SessionParameters sessionParameters = sessionToResume.exportSessionParameters();
        if (null == sessionParameters) {
            return false;
        }
        ProtocolVersion sessionVersion = sessionParameters.getNegotiatedVersion();
        if (null == sessionVersion || !sessionVersion.isDTLS()) {
            return false;
        }
        boolean isEMS = sessionParameters.isExtendedMasterSecret();
        if (!TlsUtils.isExtendedMasterSecretOptional(sessionVersion) && !isEMS) {
            return false;
        }
        TlsCrypto crypto = state.serverContext.getCrypto();
        TlsSecret sessionMasterSecret = TlsUtils.getSessionMasterSecret(crypto, sessionParameters.getMasterSecret());
        if (null == sessionMasterSecret) {
            return false;
        }
        state.tlsSession = sessionToResume;
        state.sessionParameters = sessionParameters;
        state.sessionMasterSecret = sessionMasterSecret;
        return true;
    }

    protected void invalidateSession(ServerHandshakeState state) {
        if (state.tlsSession != null) {
            state.tlsSession.invalidate();
        }
        this.cancelSession(state);
    }

    protected void notifyClientCertificate(ServerHandshakeState state, Certificate clientCertificate) throws IOException {
        if (null == state.certificateRequest) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.processClientCertificate(state.serverContext, clientCertificate, state.keyExchange, state.server);
    }

    protected void processClientCertificate(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        Certificate.ParseOptions options = new Certificate.ParseOptions().setCertificateType(state.serverContext.getSecurityParametersHandshake().getClientCertificateType()).setMaxChainLength(state.server.getMaxCertificateChainLength());
        Certificate clientCertificate = Certificate.parse(options, state.serverContext, buf, null);
        TlsProtocol.assertEmpty(buf);
        this.notifyClientCertificate(state, clientCertificate);
    }

    protected void processCertificateVerify(ServerHandshakeState state, byte[] body, TlsHandshakeHash handshakeHash) throws IOException {
        if (state.certificateRequest == null) {
            throw new IllegalStateException();
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        TlsServerContextImpl serverContext = state.serverContext;
        DigitallySigned certificateVerify = DigitallySigned.parse(serverContext, buf);
        TlsProtocol.assertEmpty(buf);
        TlsUtils.verifyCertificateVerifyClient(serverContext, state.certificateRequest, certificateVerify, handshakeHash);
    }

    protected void processClientHello(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        ClientHello clientHello = ClientHello.parse(buf, NullOutputStream.INSTANCE);
        this.processClientHello(state, clientHello);
    }

    protected void processClientHello(ServerHandshakeState state, ClientHello clientHello) throws IOException {
        state.clientHello = clientHello;
        ProtocolVersion legacy_version = clientHello.getVersion();
        int[] offeredCipherSuites = clientHello.getCipherSuites();
        Hashtable clientHelloExtensions = clientHello.getExtensions();
        TlsServer server = state.server;
        TlsServerContextImpl serverContext = state.serverContext;
        SecurityParameters securityParameters = serverContext.getSecurityParametersHandshake();
        if (!legacy_version.isDTLS()) {
            throw new TlsFatalAlert(47);
        }
        serverContext.setRSAPreMasterSecretVersion(legacy_version);
        serverContext.setClientSupportedVersions(TlsExtensionsUtils.getSupportedVersionsExtensionClient(clientHelloExtensions));
        ProtocolVersion client_version = legacy_version;
        if (null == serverContext.getClientSupportedVersions()) {
            if (client_version.isLaterVersionOf(ProtocolVersion.DTLSv12)) {
                client_version = ProtocolVersion.DTLSv12;
            }
            serverContext.setClientSupportedVersions(client_version.downTo(ProtocolVersion.DTLSv10));
        } else {
            client_version = ProtocolVersion.getLatestDTLS(serverContext.getClientSupportedVersions());
        }
        if (!ProtocolVersion.SERVER_EARLIEST_SUPPORTED_DTLS.isEqualOrEarlierVersionOf(client_version)) {
            throw new TlsFatalAlert(70);
        }
        serverContext.setClientVersion(client_version);
        server.notifyClientVersion(serverContext.getClientVersion());
        securityParameters.clientRandom = clientHello.getRandom();
        server.notifyFallback(Arrays.contains((int[])offeredCipherSuites, (int)22016));
        server.notifyOfferedCipherSuites(offeredCipherSuites);
        byte[] clientRenegExtData = TlsUtils.getExtensionData(clientHelloExtensions, TlsProtocol.EXT_RenegotiationInfo);
        if (Arrays.contains((int[])offeredCipherSuites, (int)255)) {
            securityParameters.secureRenegotiation = true;
        }
        if (clientRenegExtData != null) {
            securityParameters.secureRenegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])clientRenegExtData, (byte[])TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        server.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        if (clientHelloExtensions != null) {
            TlsExtensionsUtils.getPaddingExtension(clientHelloExtensions);
            securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(clientHelloExtensions);
            if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(client_version)) {
                TlsUtils.establishClientSigAlgs(securityParameters, clientHelloExtensions);
            }
            securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(clientHelloExtensions);
            HeartbeatExtension heartbeatExtension = TlsExtensionsUtils.getHeartbeatExtension(clientHelloExtensions);
            if (null != heartbeatExtension) {
                if (1 == heartbeatExtension.getMode()) {
                    state.heartbeat = server.getHeartbeat();
                }
                state.heartbeatPolicy = server.getHeartbeatPolicy();
            }
            server.processClientExtensions(clientHelloExtensions);
        }
    }

    protected void processClientKeyExchange(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        state.keyExchange.processClientKeyExchange(buf);
        TlsProtocol.assertEmpty(buf);
    }

    protected void processClientSupplementalData(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        Vector clientSupplementalData = TlsProtocol.readSupplementalDataMessage(buf);
        state.server.processClientSupplementalData(clientSupplementalData);
    }

    protected boolean expectCertificateVerifyMessage(ServerHandshakeState state) {
        if (null == state.certificateRequest) {
            return false;
        }
        Certificate clientCertificate = state.serverContext.getSecurityParametersHandshake().getPeerCertificate();
        return null != clientCertificate && !clientCertificate.isEmpty() && (null == state.keyExchange || state.keyExchange.requiresCertificateVerify());
    }

    protected static class ServerHandshakeState {
        TlsServer server = null;
        TlsServerContextImpl serverContext = null;
        TlsSession tlsSession = null;
        SessionParameters sessionParameters = null;
        TlsSecret sessionMasterSecret = null;
        SessionParameters.Builder sessionParametersBuilder = null;
        ClientHello clientHello = null;
        Hashtable serverExtensions = null;
        boolean expectSessionTicket = false;
        TlsKeyExchange keyExchange = null;
        TlsCredentials serverCredentials = null;
        CertificateRequest certificateRequest = null;
        TlsHeartbeat heartbeat = null;
        short heartbeatPolicy = (short)2;

        protected ServerHandshakeState() {
        }
    }
}

