/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.maprfs.AbstractMapRFileSystem;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpContext;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.GlobbedCopyListing;
import org.apache.hadoop.tools.mapred.DeletedDirTracker;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyCommitter
extends FileOutputCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(CopyCommitter.class);
    private final TaskAttemptContext taskAttemptContext;
    private boolean syncFolder = false;
    private boolean overwrite = false;
    private boolean targetPathExists = true;
    private boolean ignoreFailures = false;
    private boolean skipCrc = false;
    private int blocksPerChunk = 0;

    public CopyCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        this.blocksPerChunk = context.getConfiguration().getInt(DistCpOptionSwitch.BLOCKS_PER_CHUNK.getConfigLabel(), 0);
        LOG.debug("blocks per chunk {}", (Object)this.blocksPerChunk);
        this.skipCrc = context.getConfiguration().getBoolean(DistCpOptionSwitch.SKIP_CRC.getConfigLabel(), false);
        LOG.debug("skip CRC is {}", (Object)this.skipCrc);
        this.taskAttemptContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitJob(JobContext jobContext) throws IOException {
        Configuration conf = jobContext.getConfiguration();
        this.syncFolder = conf.getBoolean("distcp.sync.folders", false);
        this.overwrite = conf.getBoolean("distcp.copy.overwrite", false);
        this.targetPathExists = conf.getBoolean("distcp.target.path.exists", true);
        this.ignoreFailures = conf.getBoolean(DistCpOptionSwitch.IGNORE_FAILURES.getConfigLabel(), false);
        Path targetRoot = new Path(conf.get("distcp.target.work.path"));
        FileSystem targetFS = targetRoot.getFileSystem(conf);
        if (!(targetFS instanceof AbstractMapRFileSystem)) {
            if (this.blocksPerChunk > 0) {
                this.concatFileChunks(conf);
            }
        } else {
            this.renameSpitFiles(conf, jobContext);
        }
        super.commitJob(jobContext);
        this.cleanupTempFiles(jobContext);
        try {
            if (conf.getBoolean("distcp.delete.missing.source", false)) {
                this.deleteMissing(conf);
            } else if (conf.getBoolean("distcp.atomic.copy", false)) {
                this.commitData(conf);
            } else if (conf.get("distcp.track.missing.source") != null) {
                this.trackMissing(conf);
            }
            String attributes = conf.get("distcp.preserve.status");
            boolean preserveRawXattrs = conf.getBoolean("distcp.preserve.rawxattrs", false);
            if (attributes != null && !attributes.isEmpty() || preserveRawXattrs) {
                this.preserveFileAttributesForDirectories(conf);
            }
            this.taskAttemptContext.setStatus("Commit Successful");
        }
        finally {
            this.cleanup(conf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameSpitFiles(Configuration conf, JobContext jobContext) throws IOException {
        Path targetRoot = new Path(conf.get("distcp.target.work.path"));
        String spath = conf.get("distcp.listing.file.path");
        Path sourceListing = new Path(spath);
        FileSystem fs = targetRoot.getFileSystem(conf);
        SequenceFile.Reader sourceReader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)sourceListing)});
        try {
            CopyListingFileStatus srcFileStatus = new CopyListingFileStatus();
            Text srcRelPath = new Text();
            while (sourceReader.next((Writable)srcRelPath, (Writable)srcFileStatus)) {
                Path tmpTargetFile;
                LOG.info(srcFileStatus.getPath().toString());
                if (srcFileStatus.isDirectory() || !srcFileStatus.isSplit()) continue;
                if (fs.exists(targetRoot) && fs.isDirectory(targetRoot)) {
                    tmpTargetFile = new Path(targetRoot.toString() + "/.distcp.tmp." + srcFileStatus.getPath().getName() + "." + jobContext.getJobID().toString());
                    Path targetFile = new Path(targetRoot.toString() + "/" + srcFileStatus.getPath().getName());
                    this.renameTmpTarget(fs, tmpTargetFile, targetFile);
                    continue;
                }
                tmpTargetFile = new Path(targetRoot.getParent() + "/.distcp.tmp." + targetRoot.getName() + "." + jobContext.getJobID().toString());
                this.renameTmpTarget(fs, tmpTargetFile, targetRoot);
            }
        }
        finally {
            IOUtils.closeStream((Closeable)sourceReader);
        }
    }

    private void renameTmpTarget(FileSystem fs, Path tmpTargetFile, Path targetFile) throws IOException {
        if (fs.exists(tmpTargetFile) && !fs.rename(tmpTargetFile, targetFile)) {
            throw new IOException("Failed to promote tmp-file:" + tmpTargetFile + " to: " + targetFile);
        }
    }

    public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
        try {
            super.abortJob(jobContext, state);
        }
        finally {
            this.cleanupTempFiles(jobContext);
            this.cleanup(jobContext.getConfiguration());
        }
    }

    private void cleanupTempFiles(JobContext context) {
        try {
            Configuration conf = context.getConfiguration();
            Path targetWorkPath = new Path(conf.get("distcp.target.work.path"));
            FileSystem targetFS = targetWorkPath.getFileSystem(conf);
            String jobId = context.getJobID().toString();
            this.deleteAttemptTempFiles(targetWorkPath, targetFS, jobId);
            this.deleteAttemptTempFiles(targetWorkPath.getParent(), targetFS, jobId);
        }
        catch (Throwable t) {
            LOG.warn("Unable to cleanup temp files", t);
        }
    }

    private void deleteAttemptTempFiles(Path targetWorkPath, FileSystem targetFS, String jobId) throws IOException {
        if (targetWorkPath == null) {
            return;
        }
        FileStatus[] tempFiles = targetFS.globStatus(new Path(targetWorkPath, ".distcp.tmp." + jobId.replaceAll("job", "attempt") + "*"));
        if (tempFiles != null && tempFiles.length > 0) {
            for (FileStatus file : tempFiles) {
                LOG.info("Cleaning up " + file.getPath());
                targetFS.delete(file.getPath(), false);
            }
        }
    }

    private void cleanup(Configuration conf) {
        Path metaFolder = new Path(conf.get("distcp.meta.folder"));
        try {
            FileSystem fs = metaFolder.getFileSystem(conf);
            LOG.info("Cleaning up temporary work folder: " + metaFolder);
            fs.delete(metaFolder, true);
        }
        catch (IOException ignore) {
            LOG.error("Exception encountered ", (Throwable)ignore);
        }
    }

    private boolean isFileNotFoundException(IOException e) {
        if (e instanceof FileNotFoundException) {
            return true;
        }
        if (e instanceof RemoteException) {
            return ((RemoteException)e).unwrapRemoteException() instanceof FileNotFoundException;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concatFileChunks(Configuration conf) throws IOException {
        LOG.info("concat file chunks ...");
        String spath = conf.get("distcp.listing.file.path");
        if (spath == null || spath.isEmpty()) {
            return;
        }
        Path sourceListing = new Path(spath);
        SequenceFile.Reader sourceReader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)sourceListing)});
        Path targetRoot = new Path(conf.get("distcp.target.work.path"));
        try {
            CopyListingFileStatus srcFileStatus = new CopyListingFileStatus();
            Text srcRelPath = new Text();
            CopyListingFileStatus lastFileStatus = null;
            LinkedList<Path> allChunkPaths = new LinkedList<Path>();
            while (sourceReader.next((Writable)srcRelPath, (Writable)srcFileStatus)) {
                if (srcFileStatus.isDirectory()) continue;
                Path targetFile = new Path(targetRoot.toString() + "/" + srcRelPath);
                Path targetFileChunkPath = DistCpUtils.getSplitChunkPath(targetFile, srcFileStatus);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  add " + targetFileChunkPath + " to concat.");
                }
                allChunkPaths.add(targetFileChunkPath);
                if (srcFileStatus.getChunkOffset() + srcFileStatus.getChunkLength() == srcFileStatus.getLen()) {
                    block13: {
                        try {
                            this.concatFileChunks(conf, srcFileStatus.getPath(), targetFile, allChunkPaths, srcFileStatus);
                        }
                        catch (IOException e) {
                            if (this.isFileNotFoundException(e)) break block13;
                            String emsg = "Failed to concat chunk files for " + targetFile;
                            if (!this.ignoreFailures) {
                                throw new IOException(emsg, e);
                            }
                            LOG.warn(emsg, (Throwable)e);
                        }
                    }
                    allChunkPaths.clear();
                    lastFileStatus = null;
                    continue;
                }
                if (lastFileStatus == null) {
                    lastFileStatus = new CopyListingFileStatus(srcFileStatus);
                    continue;
                }
                if (!srcFileStatus.getPath().equals((Object)lastFileStatus.getPath()) || srcFileStatus.getChunkOffset() != lastFileStatus.getChunkOffset() + lastFileStatus.getChunkLength()) {
                    String emsg = "Inconsistent sequence file: current chunk file " + srcFileStatus + " doesnt match prior entry " + lastFileStatus;
                    if (!this.ignoreFailures) {
                        throw new IOException(emsg);
                    }
                    LOG.warn(emsg + ", skipping concat this set.");
                    continue;
                }
                lastFileStatus.setChunkOffset(srcFileStatus.getChunkOffset());
                lastFileStatus.setChunkLength(srcFileStatus.getChunkLength());
            }
        }
        finally {
            IOUtils.closeStream((Closeable)sourceReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preserveFileAttributesForDirectories(Configuration conf) throws IOException {
        String attrSymbols = conf.get("distcp.preserve.status");
        boolean syncOrOverwrite = this.syncFolder || this.overwrite;
        LOG.info("About to preserve attributes: " + attrSymbols);
        EnumSet<DistCpOptions.FileAttribute> attributes = DistCpUtils.unpackAttributes(attrSymbols);
        boolean preserveRawXattrs = conf.getBoolean("distcp.preserve.rawxattrs", false);
        Path sourceListing = new Path(conf.get("distcp.listing.file.path"));
        FileSystem clusterFS = sourceListing.getFileSystem(conf);
        SequenceFile.Reader sourceReader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)sourceListing)});
        long totalLen = clusterFS.getFileStatus(sourceListing).getLen();
        Path targetRoot = new Path(conf.get("distcp.target.final.path"));
        long preservedEntries = 0L;
        try {
            CopyListingFileStatus srcFileStatus = new CopyListingFileStatus();
            Text srcRelPath = new Text();
            while (sourceReader.next((Writable)srcRelPath, (Writable)srcFileStatus)) {
                Path targetFile;
                if (!srcFileStatus.isDirectory() || targetRoot.equals((Object)(targetFile = new Path(targetRoot.toString() + "/" + srcRelPath))) && syncOrOverwrite) continue;
                FileSystem targetFS = targetFile.getFileSystem(conf);
                DistCpUtils.preserve(targetFS, targetFile, srcFileStatus, attributes, preserveRawXattrs);
                this.taskAttemptContext.progress();
                this.taskAttemptContext.setStatus("Preserving status on directory entries. [" + sourceReader.getPosition() * 100L / totalLen + "%]");
            }
        }
        finally {
            IOUtils.closeStream((Closeable)sourceReader);
        }
        LOG.info("Preserved status on " + preservedEntries + " dir entries on target");
    }

    private void trackMissing(Configuration conf) throws IOException {
        Path trackDir = new Path(conf.get("distcp.track.missing.source"));
        Path sourceListing = new Path(conf.get("distcp.listing.file.path"));
        LOG.info("Tracking file changes to directory {}", (Object)trackDir);
        Path sourceSortedListing = new Path(trackDir, "source_sorted.seq");
        LOG.info("Source listing {}", (Object)sourceSortedListing);
        DistCpUtils.sortListing(conf, sourceListing, sourceSortedListing);
        Path targetListing = new Path(trackDir, "target_listing.seq");
        Path sortedTargetListing = new Path(trackDir, "target_sorted.seq");
        this.listTargetFiles(conf, targetListing, sortedTargetListing);
        LOG.info("Target listing {}", (Object)sortedTargetListing);
        targetListing.getFileSystem(conf).delete(targetListing, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMissing(Configuration conf) throws IOException {
        LOG.info("-delete option is enabled. About to remove entries from target that are missing in source");
        long listingStart = System.currentTimeMillis();
        Path sourceListing = new Path(conf.get("distcp.listing.file.path"));
        FileSystem clusterFS = sourceListing.getFileSystem(conf);
        Path sortedSourceListing = DistCpUtils.sortListing(conf, sourceListing);
        long sourceListingCompleted = System.currentTimeMillis();
        LOG.info("Source listing completed in {}", (Object)this.formatDuration(sourceListingCompleted - listingStart));
        Path targetListing = new Path(sourceListing.getParent(), "targetListing.seq");
        Path sortedTargetListing = new Path(targetListing.toString() + "_sorted");
        Path targetFinalPath = this.listTargetFiles(conf, targetListing, sortedTargetListing);
        long totalLen = clusterFS.getFileStatus(sortedTargetListing).getLen();
        SequenceFile.Reader sourceReader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)sortedSourceListing)});
        SequenceFile.Reader targetReader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)sortedTargetListing)});
        long deletionStart = System.currentTimeMillis();
        LOG.info("Destination listing completed in {}", (Object)this.formatDuration(deletionStart - sourceListingCompleted));
        long deletedEntries = 0L;
        long filesDeleted = 0L;
        long missingDeletes = 0L;
        long failedDeletes = 0L;
        long skippedDeletes = 0L;
        long deletedDirectories = 0L;
        DeletedDirTracker tracker = new DeletedDirTracker(1000);
        try {
            CopyListingFileStatus srcFileStatus = new CopyListingFileStatus();
            Text srcRelPath = new Text();
            CopyListingFileStatus trgtFileStatus = new CopyListingFileStatus();
            Text trgtRelPath = new Text();
            FileSystem targetFS = targetFinalPath.getFileSystem(conf);
            boolean srcAvailable = sourceReader.next((Writable)srcRelPath, (Writable)srcFileStatus);
            while (targetReader.next((Writable)trgtRelPath, (Writable)trgtFileStatus)) {
                boolean showProgress;
                block13: {
                    while (srcAvailable && trgtRelPath.compareTo((BinaryComparable)srcRelPath) > 0) {
                        srcAvailable = sourceReader.next((Writable)srcRelPath, (Writable)srcFileStatus);
                    }
                    Path targetEntry = trgtFileStatus.getPath();
                    LOG.debug("Comparing {} and {}", (Object)srcFileStatus.getPath(), (Object)targetEntry);
                    if (srcAvailable && trgtRelPath.equals((Object)srcRelPath)) continue;
                    if (tracker.shouldDelete(trgtFileStatus)) {
                        showProgress = true;
                        try {
                            if (targetFS.delete(targetEntry, true)) {
                                LOG.info("Deleted " + targetEntry + " - missing at source");
                                ++deletedEntries;
                                if (trgtFileStatus.isDirectory()) {
                                    ++deletedDirectories;
                                } else {
                                    ++filesDeleted;
                                }
                                break block13;
                            }
                            LOG.info("delete({}) returned false ({})", (Object)targetEntry, (Object)trgtFileStatus);
                            ++missingDeletes;
                        }
                        catch (IOException e) {
                            if (!this.ignoreFailures) {
                                throw e;
                            }
                            LOG.info("Failed to delete {}, ignoring exception {}", (Object)targetEntry, (Object)e.toString());
                            LOG.debug("Failed to delete {}", (Object)targetEntry, (Object)e);
                            ++failedDeletes;
                        }
                    } else {
                        LOG.debug("Skipping deletion of {}", (Object)targetEntry);
                        ++skippedDeletes;
                        showProgress = false;
                    }
                }
                if (!showProgress) continue;
                this.taskAttemptContext.progress();
                this.taskAttemptContext.setStatus("Deleting removed files from target. [" + targetReader.getPosition() * 100L / totalLen + "%]");
            }
            LOG.info("Completed deletion of files from {}", (Object)targetFS);
        }
        finally {
            IOUtils.closeStream((Closeable)sourceReader);
            IOUtils.closeStream((Closeable)targetReader);
        }
        long deletionEnd = System.currentTimeMillis();
        long deletedFileCount = deletedEntries - deletedDirectories;
        LOG.info("Deleted from target: files: {} directories: {}; skipped deletions {}; deletions already missing {}; failed deletes {}", new Object[]{deletedFileCount, deletedDirectories, skippedDeletes, missingDeletes, failedDeletes});
        LOG.info("Number of tracked deleted directories {}", (Object)tracker.size());
        LOG.info("Duration of deletions: {}", (Object)this.formatDuration(deletionEnd - deletionStart));
        LOG.info("Total duration of deletion operation: {}", (Object)this.formatDuration(deletionEnd - listingStart));
    }

    private String formatDuration(long duration) {
        long seconds = duration > 0L ? duration / 1000L : 0L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        return String.format("%d:%02d:%02d.%03d", hours, minutes % 60L, seconds % 60L, duration % 1000L);
    }

    private Path listTargetFiles(Configuration conf, Path targetListing, Path sortedTargetListing) throws IOException {
        GlobbedCopyListing target = new GlobbedCopyListing(new Configuration(conf), null);
        Path targetFinalPath = new Path(conf.get("distcp.target.final.path"));
        ArrayList<Path> targets = new ArrayList<Path>(1);
        targets.add(targetFinalPath);
        int threads = conf.getInt("distcp.liststatus.threads", 1);
        boolean useIterator = conf.getBoolean("distcp.use.iterator", false);
        LOG.info("Scanning destination directory {} with thread count: {}", (Object)targetFinalPath, (Object)threads);
        DistCpOptions options = new DistCpOptions.Builder(targets, targetFinalPath).withOverwrite(this.overwrite).withSyncFolder(this.syncFolder).withNumListstatusThreads(threads).withUseIterator(useIterator).build();
        DistCpContext distCpContext = new DistCpContext(options);
        distCpContext.setTargetPathExists(this.targetPathExists);
        target.buildListing(targetListing, distCpContext);
        DistCpUtils.sortListing(conf, targetListing, sortedTargetListing);
        return targetFinalPath;
    }

    private void commitData(Configuration conf) throws IOException {
        Path workDir = new Path(conf.get("distcp.target.work.path"));
        Path finalDir = new Path(conf.get("distcp.target.final.path"));
        FileSystem targetFS = workDir.getFileSystem(conf);
        LOG.info("Atomic commit enabled. Moving " + workDir + " to " + finalDir);
        if (targetFS.exists(finalDir) && targetFS.exists(workDir)) {
            LOG.error("Pre-existing final-path found at: " + finalDir);
            throw new IOException("Target-path can't be committed to because it exists at " + finalDir + ". Copied data is in temp-dir: " + workDir + ". ");
        }
        boolean result = targetFS.rename(workDir, finalDir);
        if (!result) {
            LOG.warn("Rename failed. Perhaps data already moved. Verifying...");
            boolean bl = result = targetFS.exists(finalDir) && !targetFS.exists(workDir);
        }
        if (!result) {
            LOG.error("Unable to commit data to " + finalDir);
            throw new IOException("Atomic commit failed. Temporary data in " + workDir + ", Unable to move to " + finalDir);
        }
        LOG.info("Data committed successfully to " + finalDir);
        this.taskAttemptContext.setStatus("Data committed successfully to " + finalDir);
    }

    private void concatFileChunks(Configuration conf, Path sourceFile, Path targetFile, LinkedList<Path> allChunkPaths, CopyListingFileStatus srcFileStatus) throws IOException {
        if (allChunkPaths.size() == 1) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("concat " + targetFile + " allChunkSize+ " + allChunkPaths.size());
        }
        FileSystem dstfs = targetFile.getFileSystem(conf);
        FileSystem srcfs = sourceFile.getFileSystem(conf);
        Path firstChunkFile = allChunkPaths.removeFirst();
        Path[] restChunkFiles = new Path[allChunkPaths.size()];
        allChunkPaths.toArray(restChunkFiles);
        if (LOG.isDebugEnabled()) {
            LOG.debug("concat: firstchunk: " + dstfs.getFileStatus(firstChunkFile));
            int i = 0;
            for (Path f : restChunkFiles) {
                LOG.debug("concat: other chunk: " + i + ": " + dstfs.getFileStatus(f));
                ++i;
            }
        }
        dstfs.concat(firstChunkFile, restChunkFiles);
        if (LOG.isDebugEnabled()) {
            LOG.debug("concat: result: " + dstfs.getFileStatus(firstChunkFile));
        }
        CopyCommitter.rename(dstfs, firstChunkFile, targetFile);
        DistCpUtils.compareFileLengthsAndChecksums(srcFileStatus.getLen(), srcfs, sourceFile, null, dstfs, targetFile, this.skipCrc, srcFileStatus.getLen());
    }

    private static void rename(FileSystem destFileSys, Path tmp, Path dst) throws IOException {
        try {
            if (destFileSys.exists(dst)) {
                destFileSys.delete(dst, true);
            }
            destFileSys.rename(tmp, dst);
        }
        catch (IOException ioe) {
            throw new IOException("Fail to rename tmp file (=" + tmp + ") to destination file (=" + dst + ")", ioe);
        }
    }
}

