/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.log4j.Appender;
import org.apache.log4j.AsyncAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsLoggerTask
implements Runnable {
    public static final Logger LOG = LoggerFactory.getLogger(MetricsLoggerTask.class);
    private static ObjectName objectName = null;
    private org.apache.log4j.Logger metricsLog;
    private String nodeName;
    private short maxLogLineLength;

    public MetricsLoggerTask(String metricsLog, String nodeName, short maxLogLineLength) {
        this.metricsLog = org.apache.log4j.Logger.getLogger((String)metricsLog);
        this.nodeName = nodeName;
        this.maxLogLineLength = maxLogLineLength;
    }

    @Override
    public void run() {
        if (!this.metricsLog.isInfoEnabled() || !MetricsLoggerTask.hasAppenders(this.metricsLog) || objectName == null) {
            return;
        }
        this.metricsLog.info((Object)(" >> Begin " + this.nodeName + " metrics dump"));
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        for (ObjectName mbeanName : server.queryNames(objectName, null)) {
            try {
                MBeanInfo mBeanInfo = server.getMBeanInfo(mbeanName);
                String mBeanNameName = MBeans.getMbeanNameName((ObjectName)mbeanName);
                Set<String> attributeNames = MetricsLoggerTask.getFilteredAttributes(mBeanInfo);
                AttributeList attributes = server.getAttributes(mbeanName, attributeNames.toArray(new String[attributeNames.size()]));
                for (Object o : attributes) {
                    Attribute attribute = (Attribute)o;
                    Object value = attribute.getValue();
                    String valueStr = value != null ? value.toString() : "null";
                    this.metricsLog.info((Object)(mBeanNameName + ":" + attribute.getName() + "=" + this.trimLine(valueStr)));
                }
            }
            catch (Exception e) {
                this.metricsLog.error((Object)("Failed to get " + this.nodeName + " metrics for mbean " + mbeanName.toString()), (Throwable)e);
            }
        }
        this.metricsLog.info((Object)(" << End " + this.nodeName + " metrics dump"));
    }

    private String trimLine(String valueStr) {
        if (this.maxLogLineLength <= 0) {
            return valueStr;
        }
        return valueStr.length() < this.maxLogLineLength ? valueStr : valueStr.substring(0, this.maxLogLineLength) + "...";
    }

    private static boolean hasAppenders(org.apache.log4j.Logger logger) {
        return logger.getAllAppenders().hasMoreElements();
    }

    private static Set<String> getFilteredAttributes(MBeanInfo mBeanInfo) {
        HashSet<String> attributeNames = new HashSet<String>();
        for (MBeanAttributeInfo attributeInfo : mBeanInfo.getAttributes()) {
            if (attributeInfo.getType().equals("javax.management.openmbean.TabularData") || attributeInfo.getType().equals("javax.management.openmbean.CompositeData") || attributeInfo.getType().equals("[Ljavax.management.openmbean.CompositeData;")) continue;
            attributeNames.add(attributeInfo.getName());
        }
        return attributeNames;
    }

    public static void makeMetricsLoggerAsync(String metricsLog) {
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)metricsLog);
        logger.setAdditivity(false);
        ArrayList<Appender> appenders = Collections.list(logger.getAllAppenders());
        if (!appenders.isEmpty() && !(appenders.get(0) instanceof AsyncAppender)) {
            AsyncAppender asyncAppender = new AsyncAppender();
            for (Appender appender : appenders) {
                logger.removeAppender(appender);
                asyncAppender.addAppender(appender);
            }
            logger.addAppender((Appender)asyncAppender);
        }
    }

    static {
        try {
            objectName = new ObjectName("Hadoop:*");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

