/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.client;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.qjournal.QJMTestUtil;
import org.apache.hadoop.hdfs.qjournal.client.AsyncLogger;
import org.apache.hadoop.hdfs.qjournal.client.AsyncLoggerSet;
import org.apache.hadoop.hdfs.qjournal.client.DirectExecutorService;
import org.apache.hadoop.hdfs.qjournal.client.IPCLoggerChannel;
import org.apache.hadoop.hdfs.qjournal.client.QuorumException;
import org.apache.hadoop.hdfs.qjournal.client.QuorumJournalManager;
import org.apache.hadoop.hdfs.qjournal.client.TestQuorumJournalManagerUnit;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocolProtos;
import org.apache.hadoop.hdfs.qjournal.server.JournalFaultInjector;
import org.apache.hadoop.hdfs.qjournal.server.JournalNode;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.mockito.stubbing.Stubber;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestQuorumJournalManager {
    private static final Logger LOG = LoggerFactory.getLogger(TestQuorumJournalManager.class);
    private MiniJournalCluster cluster;
    private Configuration conf;
    private QuorumJournalManager qjm;
    private List<AsyncLogger> spies;
    private final List<QuorumJournalManager> toClose = Lists.newLinkedList();
    @Rule
    public TestName name = new TestName();

    @Before
    public void setup() throws Exception {
        this.conf = new Configuration();
        if (!this.name.getMethodName().equals("testSelectThreadCounts")) {
            this.conf.setInt("ipc.client.connect.max.retries", 0);
        }
        this.conf.setInt("ipc.client.connection.maxidletime", 0);
        this.conf.setBoolean("dfs.ha.tail-edits.in-progress", true);
        this.cluster = new MiniJournalCluster.Builder(this.conf).baseDir(GenericTestUtils.getRandomizedTestDir().getAbsolutePath()).build();
        this.cluster.waitActive();
        this.qjm = this.createSpyingQJM();
        this.spies = this.qjm.getLoggerSetForTests().getLoggersForTests();
        this.qjm.format(QJMTestUtil.FAKE_NSINFO, false);
        this.qjm.recoverUnfinalizedSegments();
        Assert.assertEquals((long)1L, (long)this.qjm.getLoggerSetForTests().getEpoch());
    }

    @After
    public void shutdown() throws IOException, InterruptedException, TimeoutException {
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])this.toClose.toArray(new Closeable[0]));
        GenericTestUtils.waitForThreadTermination((String)".*IPC Client.*", (int)100, (int)1000);
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private QuorumJournalManager closeLater(QuorumJournalManager qjm) {
        this.toClose.add(qjm);
        return qjm;
    }

    @Test
    public void testSingleWriter() throws Exception {
        QJMTestUtil.writeSegment(this.cluster, this.qjm, 1L, 3, true);
        this.checkRecovery(this.cluster, 1L, 3L);
        QJMTestUtil.writeSegment(this.cluster, this.qjm, 4L, 1, true);
        this.checkRecovery(this.cluster, 4L, 4L);
    }

    @Test
    public void testFormat() throws Exception {
        QuorumJournalManager qjm = this.closeLater(new QuorumJournalManager(this.conf, this.cluster.getQuorumJournalURI("testFormat-jid"), QJMTestUtil.FAKE_NSINFO));
        Assert.assertFalse((boolean)qjm.hasSomeData());
        qjm.format(QJMTestUtil.FAKE_NSINFO, false);
        Assert.assertTrue((boolean)qjm.hasSomeData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReaderWhileAnotherWrites() throws Exception {
        EditLogInputStream stream;
        QuorumJournalManager readerQjm = this.closeLater(this.createSpyingQJM());
        ArrayList streams = Lists.newArrayList();
        readerQjm.selectInputStreams((Collection)streams, 0L, false);
        Assert.assertEquals((long)0L, (long)streams.size());
        QJMTestUtil.writeSegment(this.cluster, this.qjm, 1L, 3, true);
        readerQjm.selectInputStreams((Collection)streams, 0L, false);
        try {
            Assert.assertEquals((long)1L, (long)streams.size());
            stream = (EditLogInputStream)streams.get(0);
            Assert.assertEquals((long)1L, (long)stream.getFirstTxId());
            Assert.assertEquals((long)3L, (long)stream.getLastTxId());
            QJMTestUtil.verifyEdits(streams, 1, 3);
            Assert.assertNull((Object)stream.readOp());
        }
        finally {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])streams.toArray(new Closeable[0]));
            streams.clear();
        }
        QJMTestUtil.writeSegment(this.cluster, this.qjm, 4L, 3, false);
        readerQjm.selectInputStreams((Collection)streams, 0L, false);
        try {
            Assert.assertEquals((long)1L, (long)streams.size());
            stream = (EditLogInputStream)streams.get(0);
            Assert.assertEquals((long)1L, (long)stream.getFirstTxId());
            Assert.assertEquals((long)3L, (long)stream.getLastTxId());
            QJMTestUtil.verifyEdits(streams, 1, 3);
        }
        finally {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])streams.toArray(new Closeable[0]));
            streams.clear();
        }
        this.qjm.finalizeLogSegment(4L, 6L);
        readerQjm.selectInputStreams((Collection)streams, 0L, false);
        try {
            Assert.assertEquals((long)2L, (long)streams.size());
            Assert.assertEquals((long)4L, (long)((EditLogInputStream)streams.get(1)).getFirstTxId());
            Assert.assertEquals((long)6L, (long)((EditLogInputStream)streams.get(1)).getLastTxId());
            QJMTestUtil.verifyEdits(streams, 1, 6);
        }
        finally {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])streams.toArray(new Closeable[0]));
            streams.clear();
        }
    }

    @Test
    public void testOneJNMissingSegments() throws Exception {
        QJMTestUtil.writeSegment(this.cluster, this.qjm, 1L, 3, true);
        TestQuorumJournalManager.waitForAllPendingCalls(this.qjm.getLoggerSetForTests());
        this.cluster.getJournalNode(0).stopAndJoin(0);
        QJMTestUtil.writeSegment(this.cluster, this.qjm, 4L, 3, true);
        TestQuorumJournalManager.waitForAllPendingCalls(this.qjm.getLoggerSetForTests());
        this.cluster.restartJournalNode(0);
        QJMTestUtil.writeSegment(this.cluster, this.qjm, 7L, 3, true);
        TestQuorumJournalManager.waitForAllPendingCalls(this.qjm.getLoggerSetForTests());
        this.cluster.getJournalNode(1).stopAndJoin(0);
        QuorumJournalManager readerQjm = this.createSpyingQJM();
        ArrayList streams = Lists.newArrayList();
        try {
            readerQjm.selectInputStreams((Collection)streams, 1L, false);
            QJMTestUtil.verifyEdits(streams, 1, 9);
        }
        finally {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])streams.toArray(new Closeable[0]));
            readerQjm.close();
        }
    }

    @Test
    public void testSelectInputStreamsMajorityDown() throws Exception {
        this.cluster.shutdown();
        ArrayList streams = Lists.newArrayList();
        try {
            this.qjm.selectInputStreams((Collection)streams, 0L, false);
            Assert.fail((String)"Did not throw IOE");
        }
        catch (QuorumException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Got too many exceptions", (Throwable)ioe);
            Assert.assertTrue((boolean)streams.isEmpty());
        }
    }

    @Test
    public void testCrashAtBeginningOfSegment() throws Exception {
        QJMTestUtil.writeSegment(this.cluster, this.qjm, 1L, 3, true);
        TestQuorumJournalManager.waitForAllPendingCalls(this.qjm.getLoggerSetForTests());
        EditLogOutputStream stm = this.qjm.startLogSegment(4L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        try {
            TestQuorumJournalManager.waitForAllPendingCalls(this.qjm.getLoggerSetForTests());
        }
        finally {
            stm.abort();
        }
        this.qjm = this.closeLater(new QuorumJournalManager(this.conf, this.cluster.getQuorumJournalURI("test-journal"), QJMTestUtil.FAKE_NSINFO));
        this.qjm.recoverUnfinalizedSegments();
        this.checkRecovery(this.cluster, 1L, 3L);
        QJMTestUtil.writeSegment(this.cluster, this.qjm, 4L, 3, true);
    }

    @Test
    public void testOutOfSyncAtBeginningOfSegment0() throws Exception {
        this.doTestOutOfSyncAtBeginningOfSegment(0);
    }

    @Test
    public void testOutOfSyncAtBeginningOfSegment1() throws Exception {
        this.doTestOutOfSyncAtBeginningOfSegment(1);
    }

    @Test
    public void testOutOfSyncAtBeginningOfSegment2() throws Exception {
        this.doTestOutOfSyncAtBeginningOfSegment(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestOutOfSyncAtBeginningOfSegment(int nodeWithOneTxn) throws Exception {
        int nodeWithEmptySegment = (nodeWithOneTxn + 1) % 3;
        int nodeMissingSegment = (nodeWithOneTxn + 2) % 3;
        QJMTestUtil.writeSegment(this.cluster, this.qjm, 1L, 3, true);
        TestQuorumJournalManager.waitForAllPendingCalls(this.qjm.getLoggerSetForTests());
        this.cluster.getJournalNode(nodeMissingSegment).stopAndJoin(0);
        EditLogOutputStream stm = this.qjm.startLogSegment(4L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        try {
            TestQuorumJournalManager.waitForAllPendingCalls(this.qjm.getLoggerSetForTests());
            this.failLoggerAtTxn(this.spies.get(nodeWithEmptySegment), 4L);
            try {
                QJMTestUtil.writeTxns(stm, 4L, 1);
                Assert.fail((String)"Did not fail even though 2/3 failed");
            }
            catch (QuorumException qe) {
                GenericTestUtils.assertExceptionContains((String)"mock failure", (Throwable)qe);
            }
        }
        finally {
            stm.abort();
        }
        this.cluster.restartJournalNode(nodeMissingSegment);
        GenericTestUtils.assertGlobEquals((File)this.cluster.getCurrentDir(nodeWithEmptySegment, "test-journal"), (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)1L, (long)3L), NNStorage.getInProgressEditsFileName((long)4L)});
        GenericTestUtils.assertGlobEquals((File)this.cluster.getCurrentDir(nodeWithOneTxn, "test-journal"), (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)1L, (long)3L), NNStorage.getInProgressEditsFileName((long)4L)});
        GenericTestUtils.assertGlobEquals((File)this.cluster.getCurrentDir(nodeMissingSegment, "test-journal"), (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)1L, (long)3L)});
        this.cluster.getJournalNode(2).stopAndJoin(0);
        this.qjm = this.createSpyingQJM();
        this.qjm.recoverUnfinalizedSegments();
        if (nodeWithOneTxn == 0 || nodeWithOneTxn == 1) {
            this.checkRecovery(this.cluster, 4L, 4L);
            QJMTestUtil.writeSegment(this.cluster, this.qjm, 5L, 3, true);
        } else {
            this.checkRecovery(this.cluster, 1L, 3L);
            QJMTestUtil.writeSegment(this.cluster, this.qjm, 4L, 3, true);
        }
    }

    @Test
    public void testChangeWritersLogsInSync() throws Exception {
        QJMTestUtil.writeSegment(this.cluster, this.qjm, 1L, 3, false);
        QJMTestUtil.assertExistsInQuorum(this.cluster, NNStorage.getInProgressEditsFileName((long)1L));
        this.qjm = this.closeLater(new QuorumJournalManager(this.conf, this.cluster.getQuorumJournalURI("test-journal"), QJMTestUtil.FAKE_NSINFO));
        this.qjm.recoverUnfinalizedSegments();
        this.checkRecovery(this.cluster, 1L, 3L);
    }

    @Test
    public void testChangeWritersLogsOutOfSync1() throws Exception {
        this.doOutOfSyncTest(0, 5L);
    }

    @Test
    public void testChangeWritersLogsOutOfSync2() throws Exception {
        this.doOutOfSyncTest(1, 5L);
    }

    @Test
    public void testChangeWritersLogsOutOfSync3() throws Exception {
        this.doOutOfSyncTest(2, 4L);
    }

    private void doOutOfSyncTest(int missingOnRecoveryIdx, long expectedRecoveryTxnId) throws Exception {
        this.setupLoggers345();
        QJMTestUtil.assertExistsInQuorum(this.cluster, NNStorage.getInProgressEditsFileName((long)1L));
        this.cluster.getJournalNode(missingOnRecoveryIdx).stopAndJoin(0);
        this.qjm = this.createSpyingQJM();
        this.qjm.recoverUnfinalizedSegments();
        this.checkRecovery(this.cluster, 1L, expectedRecoveryTxnId);
    }

    private void failLoggerAtTxn(AsyncLogger spy, long txid) {
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureThrows(new IOException("mock failure")).when((Object)spy)).sendEdits(Mockito.anyLong(), Mockito.eq((long)txid), Mockito.eq((int)1), (byte[])Mockito.any());
    }

    @Test
    public void testMissFinalizeAndNextStart() throws Exception {
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureThrows(new IOException("injected")).when((Object)this.spies.get(0))).finalizeLogSegment(Mockito.eq((long)1L), Mockito.eq((long)3L));
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureThrows(new IOException("injected")).when((Object)this.spies.get(0))).startLogSegment(Mockito.eq((long)4L), Mockito.eq((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION));
        this.failLoggerAtTxn(this.spies.get(1), 4L);
        QJMTestUtil.writeSegment(this.cluster, this.qjm, 1L, 3, true);
        EditLogOutputStream stm = this.qjm.startLogSegment(4L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        try {
            QJMTestUtil.writeTxns(stm, 4L, 1);
            Assert.fail((String)"Did not fail to write");
        }
        catch (QuorumException qe) {
            GenericTestUtils.assertExceptionContains((String)"Writer out of sync", (Throwable)qe);
        }
        finally {
            stm.abort();
            this.qjm.close();
        }
        this.cluster.getJournalNode(2).stopAndJoin(0);
        this.qjm = this.createSpyingQJM();
        long recovered = QJMTestUtil.recoverAndReturnLastTxn(this.qjm);
        Assert.assertEquals((long)3L, (long)recovered);
    }

    @Test
    public void testRecoverAfterIncompleteRecovery() throws Exception {
        this.setupLoggers345();
        this.cluster.getJournalNode(2).stopAndJoin(0);
        this.qjm = this.createSpyingQJM();
        this.spies = this.qjm.getLoggerSetForTests().getLoggersForTests();
        for (AsyncLogger spy : this.spies) {
            ((AsyncLogger)TestQuorumJournalManagerUnit.futureThrows(new IOException("injected")).when((Object)spy)).finalizeLogSegment(Mockito.eq((long)1L), Mockito.eq((long)4L));
        }
        try {
            this.qjm.recoverUnfinalizedSegments();
            Assert.fail((String)"Should have failed recovery since no finalization occurred");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"injected", (Throwable)ioe);
        }
        this.cluster.getJournalNode(0).stopAndJoin(0);
        this.cluster.restartJournalNode(2);
        this.qjm = this.createSpyingQJM();
        this.spies = this.qjm.getLoggerSetForTests().getLoggersForTests();
        this.qjm.recoverUnfinalizedSegments();
        this.checkRecovery(this.cluster, 1L, 4L);
    }

    private void setupLoggers345() throws Exception {
        EditLogOutputStream stm = this.qjm.startLogSegment(1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        this.failLoggerAtTxn(this.spies.get(0), 4L);
        this.failLoggerAtTxn(this.spies.get(1), 5L);
        QJMTestUtil.writeTxns(stm, 1L, 3);
        QJMTestUtil.writeTxns(stm, 4L, 1);
        try {
            QJMTestUtil.writeTxns(stm, 5L, 1);
            Assert.fail((String)"Did not fail to write when only a minority succeeded");
        }
        catch (QuorumException qe) {
            GenericTestUtils.assertExceptionContains((String)"too many exceptions to achieve quorum size 2/3", (Throwable)qe);
        }
    }

    private void setupEdgeCaseOneJnHasSegmentWithAcceptedRecovery() throws Exception {
        QJMTestUtil.writeSegment(this.cluster, this.qjm, 1L, 100, true);
        this.failLoggerAtTxn(this.spies.get(1), 101L);
        this.failLoggerAtTxn(this.spies.get(2), 101L);
        try {
            QJMTestUtil.writeSegment(this.cluster, this.qjm, 101L, 1, true);
            Assert.fail((String)"Should have failed");
        }
        catch (QuorumException qe) {
            GenericTestUtils.assertExceptionContains((String)"mock failure", (Throwable)qe);
        }
        finally {
            this.qjm.close();
        }
        this.qjm = this.createSpyingQJM();
        this.spies = this.qjm.getLoggerSetForTests().getLoggersForTests();
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureThrows(new IOException("mock failure")).when((Object)this.spies.get(1))).acceptRecovery((QJournalProtocolProtos.SegmentStateProto)Mockito.any(), (URL)Mockito.any());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureThrows(new IOException("mock failure")).when((Object)this.spies.get(2))).acceptRecovery((QJournalProtocolProtos.SegmentStateProto)Mockito.any(), (URL)Mockito.any());
        try {
            this.qjm.recoverUnfinalizedSegments();
            Assert.fail((String)"Should have failed to recover");
        }
        catch (QuorumException qe) {
            GenericTestUtils.assertExceptionContains((String)"mock failure", (Throwable)qe);
        }
        finally {
            this.qjm.close();
        }
        GenericTestUtils.assertGlobEquals((File)this.cluster.getCurrentDir(0, "test-journal"), (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)1L, (long)100L), NNStorage.getInProgressEditsFileName((long)101L)});
        GenericTestUtils.assertGlobEquals((File)this.cluster.getCurrentDir(1, "test-journal"), (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)1L, (long)100L), NNStorage.getInProgressEditsFileName((long)101L) + ".empty"});
        GenericTestUtils.assertGlobEquals((File)this.cluster.getCurrentDir(2, "test-journal"), (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)1L, (long)100L), NNStorage.getInProgressEditsFileName((long)101L) + ".empty"});
        File paxos0 = new File(this.cluster.getCurrentDir(0, "test-journal"), "paxos");
        File paxos1 = new File(this.cluster.getCurrentDir(1, "test-journal"), "paxos");
        File paxos2 = new File(this.cluster.getCurrentDir(2, "test-journal"), "paxos");
        GenericTestUtils.assertGlobEquals((File)paxos0, (String)".*", (String[])new String[]{"101"});
        GenericTestUtils.assertGlobEquals((File)paxos1, (String)".*", (String[])new String[0]);
        GenericTestUtils.assertGlobEquals((File)paxos2, (String)".*", (String[])new String[0]);
    }

    @Test
    public void testNewerVersionOfSegmentWins() throws Exception {
        this.setupEdgeCaseOneJnHasSegmentWithAcceptedRecovery();
        this.cluster.getJournalNode(0).stopAndJoin(0);
        this.qjm = this.createSpyingQJM();
        try {
            Assert.assertEquals((long)100L, (long)QJMTestUtil.recoverAndReturnLastTxn(this.qjm));
            QJMTestUtil.writeSegment(this.cluster, this.qjm, 101L, 50, false);
        }
        finally {
            this.qjm.close();
        }
        this.cluster.restartJournalNode(0);
        this.qjm = this.createSpyingQJM();
        try {
            Assert.assertEquals((long)150L, (long)QJMTestUtil.recoverAndReturnLastTxn(this.qjm));
        }
        finally {
            this.qjm.close();
        }
    }

    @Test
    public void testNewerVersionOfSegmentWins2() throws Exception {
        this.setupEdgeCaseOneJnHasSegmentWithAcceptedRecovery();
        this.cluster.getJournalNode(0).stopAndJoin(0);
        this.qjm = this.createSpyingQJM();
        try {
            Assert.assertEquals((long)100L, (long)QJMTestUtil.recoverAndReturnLastTxn(this.qjm));
            this.cluster.restartJournalNode(0);
            this.cluster.getJournalNode(1).stopAndJoin(0);
            QJMTestUtil.writeSegment(this.cluster, this.qjm, 101L, 50, false);
        }
        finally {
            this.qjm.close();
        }
        this.cluster.restartJournalNode(1);
        this.cluster.getJournalNode(2).stopAndJoin(0);
        this.qjm = this.createSpyingQJM();
        try {
            Assert.assertEquals((long)150L, (long)QJMTestUtil.recoverAndReturnLastTxn(this.qjm));
        }
        finally {
            this.qjm.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testCrashBetweenSyncLogAndPersistPaxosData() throws Exception {
        JournalFaultInjector faultInjector = JournalFaultInjector.instance = (JournalFaultInjector)Mockito.mock(JournalFaultInjector.class);
        this.setupLoggers345();
        this.qjm = this.createSpyingQJM();
        this.spies = this.qjm.getLoggerSetForTests().getLoggersForTests();
        this.cluster.getJournalNode(2).stopAndJoin(0);
        ((AsyncLogger)this.injectIOE().when((Object)this.spies.get(1))).acceptRecovery((QJournalProtocolProtos.SegmentStateProto)Mockito.any(), (URL)Mockito.any());
        this.tryRecoveryExpectingFailure();
        this.cluster.restartJournalNode(2);
        this.qjm = this.createSpyingQJM();
        this.spies = this.qjm.getLoggerSetForTests().getLoggersForTests();
        ((AsyncLogger)this.injectIOE().when((Object)this.spies.get(0))).prepareRecovery(Mockito.eq((long)1L));
        ((JournalFaultInjector)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Injected")}).when((Object)faultInjector)).beforePersistPaxosData();
        this.tryRecoveryExpectingFailure();
        Mockito.reset((Object[])new JournalFaultInjector[]{faultInjector});
        this.cluster.getJournalNode(2).stopAndJoin(0);
        this.qjm = this.createSpyingQJM();
        try {
            long recovered = QJMTestUtil.recoverAndReturnLastTxn(this.qjm);
            Assert.assertTrue((recovered >= 4L ? 1 : 0) != 0);
        }
        finally {
            this.qjm.close();
        }
    }

    private void tryRecoveryExpectingFailure() throws IOException {
        try {
            QJMTestUtil.recoverAndReturnLastTxn(this.qjm);
            Assert.fail((String)"Expected to fail recovery");
        }
        catch (QuorumException qe) {
            GenericTestUtils.assertExceptionContains((String)"Injected", (Throwable)qe);
        }
        finally {
            this.qjm.close();
        }
    }

    private Stubber injectIOE() {
        return TestQuorumJournalManagerUnit.futureThrows(new IOException("Injected"));
    }

    @Test
    public void testPurgeLogs() throws Exception {
        for (int txid = 1; txid <= 5; ++txid) {
            QJMTestUtil.writeSegment(this.cluster, this.qjm, txid, 1, true);
        }
        File curDir = this.cluster.getCurrentDir(0, "test-journal");
        GenericTestUtils.assertGlobEquals((File)curDir, (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)1L, (long)1L), NNStorage.getFinalizedEditsFileName((long)2L, (long)2L), NNStorage.getFinalizedEditsFileName((long)3L, (long)3L), NNStorage.getFinalizedEditsFileName((long)4L, (long)4L), NNStorage.getFinalizedEditsFileName((long)5L, (long)5L)});
        File paxosDir = new File(curDir, "paxos");
        GenericTestUtils.assertExists((File)paxosDir);
        Assert.assertTrue((boolean)new File(paxosDir, "1").createNewFile());
        Assert.assertTrue((boolean)new File(paxosDir, "3").createNewFile());
        GenericTestUtils.assertGlobEquals((File)paxosDir, (String)"\\d+", (String[])new String[]{"1", "3"});
        Assert.assertTrue((boolean)new File(curDir, "edits_inprogress_0000000000000000001.epoch=140").createNewFile());
        Assert.assertTrue((boolean)new File(curDir, "edits_inprogress_0000000000000000002.empty").createNewFile());
        this.qjm.purgeLogsOlderThan(3L);
        TestQuorumJournalManager.waitForAllPendingCalls(this.qjm.getLoggerSetForTests());
        GenericTestUtils.assertGlobEquals((File)curDir, (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)3L, (long)3L), NNStorage.getFinalizedEditsFileName((long)4L, (long)4L), NNStorage.getFinalizedEditsFileName((long)5L, (long)5L)});
        GenericTestUtils.assertGlobEquals((File)paxosDir, (String)"\\d+", (String[])new String[]{"3"});
    }

    @Test
    public void testToString() throws Exception {
        GenericTestUtils.assertMatches((String)this.qjm.toString(), (String)"QJM to \\[127.0.0.1:\\d+, 127.0.0.1:\\d+, 127.0.0.1:\\d+\\]");
    }

    @Test
    public void testSelectInputStreamsNotOnBoundary() throws Exception {
        int txIdsPerSegment = 10;
        for (int txid = 1; txid <= 50; txid += 10) {
            QJMTestUtil.writeSegment(this.cluster, this.qjm, txid, 10, true);
        }
        File curDir = this.cluster.getCurrentDir(0, "test-journal");
        GenericTestUtils.assertGlobEquals((File)curDir, (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)1L, (long)10L), NNStorage.getFinalizedEditsFileName((long)11L, (long)20L), NNStorage.getFinalizedEditsFileName((long)21L, (long)30L), NNStorage.getFinalizedEditsFileName((long)31L, (long)40L), NNStorage.getFinalizedEditsFileName((long)41L, (long)50L)});
        ArrayList<EditLogInputStream> streams = new ArrayList<EditLogInputStream>();
        this.qjm.selectInputStreams(streams, 25L, false);
        QJMTestUtil.verifyEdits(streams, 25, 50);
    }

    @Test
    public void testInProgressRecovery() throws Exception {
        EditLogOutputStream stm = this.qjm.startLogSegment(1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        QJMTestUtil.writeTxns(stm, 1L, 5);
        QJMTestUtil.writeTxns(stm, 6L, 3);
        QuorumJournalManager qjm2 = this.createSpyingQJM();
        qjm2.recoverUnfinalizedSegments();
        this.checkRecovery(this.cluster, 1L, 8L);
        ArrayList<EditLogInputStream> streams = new ArrayList<EditLogInputStream>();
        qjm2.selectInputStreams(streams, 1L, true, true);
        QJMTestUtil.verifyEdits(streams, 1, 8);
    }

    @Test
    public void testSelectViaRpcWithDurableTransactions() throws Exception {
        this.failLoggerAtTxn(this.spies.get(0), 6L);
        this.failLoggerAtTxn(this.spies.get(1), 6L);
        EditLogOutputStream stm = this.qjm.startLogSegment(1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        QJMTestUtil.writeTxns(stm, 1L, 5);
        try {
            QJMTestUtil.writeTxns(stm, 6L, 1);
            Assert.fail((String)"Did not fail to write when only a minority succeeded");
        }
        catch (QuorumException qe) {
            GenericTestUtils.assertExceptionContains((String)"too many exceptions to achieve quorum size 2/3", (Throwable)qe);
        }
        ArrayList<EditLogInputStream> streams = new ArrayList<EditLogInputStream>();
        this.qjm.selectInputStreams(streams, 1L, true, true);
        QJMTestUtil.verifyEdits(streams, 1, 5);
        IOUtils.closeStreams((Closeable[])streams.toArray(new Closeable[0]));
        for (AsyncLogger logger : this.spies) {
            ((AsyncLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).getJournaledEdits(1L, 5000);
        }
    }

    @Test
    public void testSelectViaRpcWithoutDurableTransactions() throws Exception {
        this.setupLoggers345();
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureThrows(new IOException()).when((Object)this.spies.get(1))).getJournaledEdits(1L, 5000);
        ArrayList<EditLogInputStream> streams = new ArrayList<EditLogInputStream>();
        this.qjm.selectInputStreams(streams, 1L, true, false);
        QJMTestUtil.verifyEdits(streams, 1, 5);
        IOUtils.closeStreams((Closeable[])streams.toArray(new Closeable[0]));
        for (AsyncLogger logger : this.spies) {
            ((AsyncLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).getJournaledEdits(1L, 5000);
        }
    }

    @Test
    public void testSelectViaRpcOneDeadJN() throws Exception {
        EditLogOutputStream stm = this.qjm.startLogSegment(1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        QJMTestUtil.writeTxns(stm, 1L, 10);
        this.cluster.getJournalNode(0).stopAndJoin(0);
        ArrayList<EditLogInputStream> streams = new ArrayList<EditLogInputStream>();
        this.qjm.selectInputStreams(streams, 1L, true, false);
        QJMTestUtil.verifyEdits(streams, 1, 10);
        IOUtils.closeStreams((Closeable[])streams.toArray(new Closeable[0]));
    }

    @Test
    public void testSelectViaRpcTwoDeadJNs() throws Exception {
        EditLogOutputStream stm = this.qjm.startLogSegment(1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        QJMTestUtil.writeTxns(stm, 1L, 10);
        this.cluster.getJournalNode(0).stopAndJoin(0);
        this.cluster.getJournalNode(1).stopAndJoin(0);
        try {
            this.qjm.selectInputStreams(new ArrayList(), 1L, true, false);
            Assert.fail((String)"");
        }
        catch (QuorumException qe) {
            GenericTestUtils.assertExceptionContains((String)"too many exceptions to achieve quorum size 2/3", (Throwable)qe);
        }
    }

    @Test
    public void testSelectThreadCounts() throws Exception {
        EditLogOutputStream stm = this.qjm.startLogSegment(1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        QJMTestUtil.writeTxns(stm, 1L, 10);
        JournalNode jn0 = this.cluster.getJournalNode(0);
        String ipcAddr = this.cluster.getJournalNodeIpcAddress(0);
        jn0.stopAndJoin(0);
        for (int i = 0; i < 1000; ++i) {
            this.qjm.selectInputStreams(new ArrayList(), 1L, true, false);
        }
        String expectedName = "Logger channel (from parallel executor) to " + ipcAddr;
        long num = Thread.getAllStackTraces().keySet().stream().filter(t -> t.getName().contains(expectedName)).count();
        Assert.assertTrue((String)("Number of threads are : " + num), (num <= 5L ? 1 : 0) != 0);
    }

    @Test
    public void testSelectViaRpcTwoJNsError() throws Exception {
        EditLogOutputStream stm = this.qjm.startLogSegment(1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        QJMTestUtil.writeTxns(stm, 1L, 10);
        QJMTestUtil.writeTxns(stm, 11L, 1);
        QJMTestUtil.writeTxns(stm, 12L, 1);
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureThrows(new IOException()).when((Object)this.spies.get(0))).getJournaledEdits(1L, 5000);
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureThrows(new IOException()).when((Object)this.spies.get(1))).getJournaledEdits(1L, 5000);
        ArrayList<EditLogInputStream> streams = new ArrayList<EditLogInputStream>();
        this.qjm.selectInputStreams(streams, 1L, true, true);
        QJMTestUtil.verifyEdits(streams, 1, 11);
        IOUtils.closeStreams((Closeable[])streams.toArray(new Closeable[0]));
        for (AsyncLogger logger : this.spies) {
            ((AsyncLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).getEditLogManifest(1L, true);
        }
    }

    @Test
    public void testSelectViaRpcAfterJNRestart() throws Exception {
        EditLogOutputStream stm = this.qjm.startLogSegment(1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        QJMTestUtil.writeTxns(stm, 1L, 10);
        this.qjm.finalizeLogSegment(1L, 10L);
        for (int i = 0; i < this.cluster.getNumNodes(); ++i) {
            this.cluster.restartJournalNode(i);
        }
        this.cluster.waitActive();
        this.qjm = this.createSpyingQJM();
        this.spies = this.qjm.getLoggerSetForTests().getLoggersForTests();
        ArrayList<EditLogInputStream> streams = new ArrayList<EditLogInputStream>();
        this.qjm.selectInputStreams(streams, 1L, true, true);
        QJMTestUtil.verifyEdits(streams, 1, 10);
        IOUtils.closeStreams((Closeable[])streams.toArray(new Closeable[0]));
        for (AsyncLogger logger : this.spies) {
            ((AsyncLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).getEditLogManifest(1L, true);
        }
    }

    private QuorumJournalManager createSpyingQJM() throws IOException, URISyntaxException {
        AsyncLogger.Factory spyFactory = new AsyncLogger.Factory(){

            public AsyncLogger createLogger(Configuration conf, NamespaceInfo nsInfo, String journalId, String nameServiceId, InetSocketAddress addr) {
                IPCLoggerChannel logger = new IPCLoggerChannel(conf, nsInfo, journalId, nameServiceId, addr){

                    protected ExecutorService createSingleThreadExecutor() {
                        return new DirectExecutorService();
                    }
                };
                return (AsyncLogger)Mockito.spy((Object)logger);
            }
        };
        return this.closeLater(new QuorumJournalManager(this.conf, this.cluster.getQuorumJournalURI("test-journal"), QJMTestUtil.FAKE_NSINFO, spyFactory));
    }

    private static void waitForAllPendingCalls(AsyncLoggerSet als) throws InterruptedException {
        for (AsyncLogger l : als.getLoggersForTests()) {
            IPCLoggerChannel ch = (IPCLoggerChannel)l;
            ch.waitForAllPendingCalls();
        }
    }

    private void checkRecovery(MiniJournalCluster cluster, long segmentTxId, long expectedEndTxId) throws IOException {
        int numFinalized = 0;
        for (int i = 0; i < cluster.getNumNodes(); ++i) {
            File logDir = cluster.getCurrentDir(i, "test-journal");
            FileJournalManager.EditLogFile elf = FileJournalManager.getLogFile((File)logDir, (long)segmentTxId);
            if (elf == null || elf.isInProgress()) continue;
            ++numFinalized;
            if (elf.getLastTxId() == expectedEndTxId) continue;
            Assert.fail((String)("File " + elf + " finalized to wrong txid, expected " + expectedEndTxId));
        }
        if (numFinalized < cluster.getQuorumSize()) {
            Assert.fail((String)("Did not find a quorum of finalized logs starting at " + segmentTxId));
        }
    }

    static {
        GenericTestUtils.setLogLevel((Logger)ProtobufRpcEngine2.LOG, (Level)Level.TRACE);
    }
}

