/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import io.netty.channel.DefaultFileRegion;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FadvisedFileRegion
extends DefaultFileRegion {
    private static final Logger LOG = LoggerFactory.getLogger(FadvisedFileRegion.class);
    private final Object closeLock = new Object();
    private final boolean manageOsCache;
    private final int readaheadLength;
    private final ReadaheadPool readaheadPool;
    private final FileDescriptor fd;
    private final String identifier;
    private final long count;
    private final long position;
    private final int shuffleBufferSize;
    private final boolean shuffleTransferToAllowed;
    private final FileChannel fileChannel;
    private volatile ReadaheadPool.ReadaheadRequest readaheadRequest;

    public FadvisedFileRegion(RandomAccessFile file, long position, long count, boolean manageOsCache, int readaheadLength, ReadaheadPool readaheadPool, String identifier, int shuffleBufferSize, boolean shuffleTransferToAllowed) throws IOException {
        super(file.getChannel(), position, count);
        this.manageOsCache = manageOsCache;
        this.readaheadLength = readaheadLength;
        this.readaheadPool = readaheadPool;
        this.fd = file.getFD();
        this.identifier = identifier;
        this.fileChannel = file.getChannel();
        this.count = count;
        this.position = position;
        this.shuffleBufferSize = shuffleBufferSize;
        this.shuffleTransferToAllowed = shuffleTransferToAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferTo(WritableByteChannel target, long position) throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.fd.valid()) {
                if (this.readaheadPool != null && this.readaheadLength > 0) {
                    this.readaheadRequest = this.readaheadPool.readaheadStream(this.identifier, this.fd, this.position() + position, (long)this.readaheadLength, this.position() + this.count(), this.readaheadRequest);
                }
                if (this.shuffleTransferToAllowed) {
                    return super.transferTo(target, position);
                }
                return this.customShuffleTransfer(target, position);
            }
            return 0L;
        }
    }

    @VisibleForTesting
    long customShuffleTransfer(WritableByteChannel target, long position) throws IOException {
        int readSize;
        long actualCount = this.count - position;
        if (actualCount < 0L || position < 0L) {
            throw new IllegalArgumentException("position out of range: " + position + " (expected: 0 - " + (this.count - 1L) + ')');
        }
        if (actualCount == 0L) {
            return 0L;
        }
        long trans = actualCount;
        ByteBuffer byteBuffer = ByteBuffer.allocate(Math.min(this.shuffleBufferSize, trans > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)trans));
        while (trans > 0L && (readSize = this.fileChannel.read(byteBuffer, this.position + position)) > 0) {
            if ((long)readSize < trans) {
                trans -= (long)readSize;
                position += (long)readSize;
                byteBuffer.flip();
            } else {
                byteBuffer.limit((int)trans);
                byteBuffer.position(0);
                position += trans;
                trans = 0L;
            }
            while (byteBuffer.hasRemaining()) {
                target.write(byteBuffer);
            }
            byteBuffer.clear();
        }
        return actualCount - trans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deallocate() {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.readaheadRequest != null) {
                this.readaheadRequest.cancel();
                this.readaheadRequest = null;
            }
            super.deallocate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferSuccessful() {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.fd.valid() && this.manageOsCache && this.count() > 0L) {
                try {
                    NativeIO.POSIX.getCacheManipulator().posixFadviseIfPossible(this.identifier, this.fd, this.position(), this.count(), NativeIO.POSIX.POSIX_FADV_DONTNEED);
                }
                catch (Throwable t) {
                    LOG.warn("Failed to manage OS cache for " + this.identifier + " fd " + this.fd, t);
                }
            }
        }
    }
}

