/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceProcessor;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.client.AMRMClientUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.InvalidApplicationMasterRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.AMSProcessingChain;
import org.apache.hadoop.yarn.server.resourcemanager.DefaultAMSProcessor;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.processor.AbstractPlacementProcessor;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.processor.DisabledPlacementProcessor;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.processor.PlacementConstraintProcessor;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.processor.SchedulerPlacementProcessor;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.authorize.RMPolicyProvider;
import org.apache.hadoop.yarn.server.security.MasterKeyData;
import org.apache.hadoop.yarn.server.utils.YarnServerSecurityUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ApplicationMasterService
extends AbstractService
implements ApplicationMasterProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationMasterService.class);
    private final AMLivelinessMonitor amLivelinessMonitor;
    private YarnScheduler rScheduler;
    protected InetSocketAddress masterServiceAddress;
    protected Server server;
    protected final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final ConcurrentMap<ApplicationAttemptId, AllocateResponseLock> responseMap = new ConcurrentHashMap<ApplicationAttemptId, AllocateResponseLock>();
    private final ConcurrentHashMap<ApplicationAttemptId, Boolean> finishedAttemptCache = new ConcurrentHashMap();
    protected final RMContext rmContext;
    private final AMSProcessingChain amsProcessingChain;
    private boolean timelineServiceV2Enabled;
    private static final List<Container> EMPTY_CONTAINER_LIST = new ArrayList<Container>();
    protected static final Allocation EMPTY_ALLOCATION = new Allocation(EMPTY_CONTAINER_LIST, Resources.createResource((int)0), null, null, null);

    public ApplicationMasterService(RMContext rmContext, YarnScheduler scheduler) {
        this(ApplicationMasterService.class.getName(), rmContext, scheduler);
    }

    public ApplicationMasterService(String name, RMContext rmContext, YarnScheduler scheduler) {
        super(name);
        this.amLivelinessMonitor = rmContext.getAMLivelinessMonitor();
        this.rScheduler = scheduler;
        this.rmContext = rmContext;
        this.amsProcessingChain = new AMSProcessingChain(new DefaultAMSProcessor());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.masterServiceAddress = conf.getSocketAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
        this.initializeProcessingChain(conf);
    }

    private void addPlacementConstraintHandler(Configuration conf) {
        String placementConstraintsHandler = conf.get("yarn.resourcemanager.placement-constraints.handler", "disabled");
        if (placementConstraintsHandler.equals("disabled")) {
            LOG.info("disabled placement handler will be used, all scheduling requests will be rejected.");
            this.amsProcessingChain.addProcessor(new DisabledPlacementProcessor());
        } else if (placementConstraintsHandler.equals("placement-processor")) {
            LOG.info("placement-processor placement handler will be used. Scheduling requests will be handled by the placement constraint processor");
            this.amsProcessingChain.addProcessor(new PlacementConstraintProcessor());
        } else if (placementConstraintsHandler.equals("scheduler")) {
            LOG.info("scheduler placement handler will be used. Scheduling requests will be handled by the main scheduler.");
            this.amsProcessingChain.addProcessor(new SchedulerPlacementProcessor());
        }
    }

    private void initializeProcessingChain(Configuration conf) {
        this.amsProcessingChain.init(this.rmContext, null);
        this.addPlacementConstraintHandler(conf);
        List<ApplicationMasterServiceProcessor> processors = this.getProcessorList(conf);
        if (processors != null) {
            Collections.reverse(processors);
            for (ApplicationMasterServiceProcessor p : processors) {
                if (p instanceof AbstractPlacementProcessor) {
                    LOG.warn("Found PlacementProcessor=" + p.getClass().getCanonicalName() + " defined in " + "yarn.resourcemanager.application-master-service.processors" + ", however PlacementProcessor handler should be configured by using " + "yarn.resourcemanager.placement-constraints.handler" + ", this processor will be ignored.");
                    continue;
                }
                this.amsProcessingChain.addProcessor(p);
            }
        }
    }

    protected List<ApplicationMasterServiceProcessor> getProcessorList(Configuration conf) {
        return conf.getInstances("yarn.resourcemanager.application-master-service.processors", ApplicationMasterServiceProcessor.class);
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        Configuration serverConf = conf;
        serverConf = new Configuration(conf);
        serverConf.set("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.TOKEN.toString());
        this.server = this.getServer(rpc, serverConf, this.masterServiceAddress, this.rmContext.getAMRMTokenSecretManager());
        this.server.addTerseExceptions(new Class[]{ApplicationMasterNotRegisteredException.class});
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            InputStream inputStream = this.rmContext.getConfigurationProvider().getConfigurationInputStream(conf, "hadoop-policy.xml");
            if (inputStream != null) {
                conf.addResource(inputStream);
            }
            this.refreshServiceAcls(conf, RMPolicyProvider.getInstance());
        }
        this.server.start();
        this.masterServiceAddress = conf.updateConnectAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", this.server.getListenerAddress());
        this.timelineServiceV2Enabled = YarnConfiguration.timelineServiceV2Enabled((Configuration)conf);
        super.serviceStart();
    }

    protected Server getServer(YarnRPC rpc, Configuration serverConf, InetSocketAddress addr, AMRMTokenSecretManager secretManager) {
        return rpc.getServer(ApplicationMasterProtocol.class, (Object)this, addr, serverConf, (SecretManager)secretManager, serverConf.getInt("yarn.resourcemanager.scheduler.client.thread-count", 50));
    }

    protected AMSProcessingChain getProcessingChain() {
        return this.amsProcessingChain;
    }

    @InterfaceAudience.Private
    public InetSocketAddress getBindAddress() {
        return this.masterServiceAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        AMRMTokenIdentifier amrmTokenIdentifier = YarnServerSecurityUtils.authorizeRequest();
        ApplicationAttemptId applicationAttemptId = amrmTokenIdentifier.getApplicationAttemptId();
        ApplicationId appID = applicationAttemptId.getApplicationId();
        AllocateResponseLock lock = (AllocateResponseLock)this.responseMap.get(applicationAttemptId);
        if (lock == null) {
            RMAuditLogger.logFailure(((RMApp)this.rmContext.getRMApps().get(appID)).getUser(), "Register App Master", "Application doesn't exist in cache " + applicationAttemptId, "ApplicationMasterService", "Error in registering application master", appID, applicationAttemptId);
            this.throwApplicationDoesNotExistInCacheException(applicationAttemptId);
        }
        AllocateResponseLock allocateResponseLock = lock;
        synchronized (allocateResponseLock) {
            ApplicationSubmissionContext appContext;
            AllocateResponse lastResponse = lock.getAllocateResponse();
            if (!(!this.hasApplicationMasterRegistered(applicationAttemptId) || (appContext = ((RMApp)this.rmContext.getRMApps().get(appID)).getApplicationSubmissionContext()).getUnmanagedAM() && appContext.getKeepContainersAcrossApplicationAttempts())) {
                String message = "Application Master is already registered : " + appID;
                LOG.warn(message);
                RMAuditLogger.logFailure(((RMApp)this.rmContext.getRMApps().get(appID)).getUser(), "Register App Master", "", "ApplicationMasterService", message, appID, applicationAttemptId);
                throw new InvalidApplicationMasterRequestException(message);
            }
            this.amLivelinessMonitor.receivedPing(applicationAttemptId);
            lastResponse.setResponseId(0);
            lock.setAllocateResponse(lastResponse);
            RegisterApplicationMasterResponse response = (RegisterApplicationMasterResponse)this.recordFactory.newRecordInstance(RegisterApplicationMasterResponse.class);
            this.amsProcessingChain.registerApplicationMaster(amrmTokenIdentifier.getApplicationAttemptId(), request, response);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
        ApplicationAttemptId applicationAttemptId = YarnServerSecurityUtils.authorizeRequest().getApplicationAttemptId();
        ApplicationId appId = applicationAttemptId.getApplicationId();
        RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(applicationAttemptId.getApplicationId());
        if (this.timelineServiceV2Enabled) {
            ((RMAppImpl)rmApp).removeCollectorData();
        }
        if (rmApp.isAppFinalStateStored()) {
            LOG.info(rmApp.getApplicationId() + " unregistered successfully. ");
            return FinishApplicationMasterResponse.newInstance((boolean)true);
        }
        AllocateResponseLock lock = (AllocateResponseLock)this.responseMap.get(applicationAttemptId);
        if (lock == null) {
            this.throwApplicationDoesNotExistInCacheException(applicationAttemptId);
        }
        AllocateResponseLock allocateResponseLock = lock;
        synchronized (allocateResponseLock) {
            if (!this.hasApplicationMasterRegistered(applicationAttemptId)) {
                String message = "Application Master is trying to unregister before registering for: " + appId;
                LOG.error(message);
                RMAuditLogger.logFailure(((RMApp)this.rmContext.getRMApps().get(appId)).getUser(), "Unregister App Master", "", "ApplicationMasterService", message, appId, applicationAttemptId);
                throw new ApplicationMasterNotRegisteredException(message);
            }
            FinishApplicationMasterResponse response = FinishApplicationMasterResponse.newInstance((boolean)false);
            if (this.finishedAttemptCache.putIfAbsent(applicationAttemptId, true) == null) {
                this.amsProcessingChain.finishApplicationMaster(applicationAttemptId, request, response);
            }
            this.amLivelinessMonitor.receivedPing(applicationAttemptId);
            return response;
        }
    }

    private void throwApplicationDoesNotExistInCacheException(ApplicationAttemptId appAttemptId) throws InvalidApplicationMasterRequestException {
        String message = "Application doesn't exist in cache " + appAttemptId;
        LOG.error(message);
        throw new InvalidApplicationMasterRequestException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasApplicationMasterRegistered(ApplicationAttemptId appAttemptId) {
        boolean hasApplicationMasterRegistered = false;
        AllocateResponseLock lastResponse = (AllocateResponseLock)this.responseMap.get(appAttemptId);
        if (lastResponse != null) {
            AllocateResponseLock allocateResponseLock = lastResponse;
            synchronized (allocateResponseLock) {
                if (lastResponse.getAllocateResponse() != null && lastResponse.getAllocateResponse().getResponseId() >= 0) {
                    hasApplicationMasterRegistered = true;
                }
            }
        }
        return hasApplicationMasterRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
        AMRMTokenIdentifier amrmTokenIdentifier = YarnServerSecurityUtils.authorizeRequest();
        ApplicationAttemptId appAttemptId = amrmTokenIdentifier.getApplicationAttemptId();
        this.amLivelinessMonitor.receivedPing(appAttemptId);
        AllocateResponseLock lock = (AllocateResponseLock)this.responseMap.get(appAttemptId);
        if (lock == null) {
            String message = "Application attempt " + appAttemptId + " doesn't exist in ApplicationMasterService cache.";
            LOG.error(message);
            throw new ApplicationAttemptNotFoundException(message);
        }
        AllocateResponseLock allocateResponseLock = lock;
        synchronized (allocateResponseLock) {
            AllocateResponse lastResponse = lock.getAllocateResponse();
            if (!this.hasApplicationMasterRegistered(appAttemptId)) {
                String message = "AM is not registered for known application attempt: " + appAttemptId + " or RM had restarted after AM registered.  AM should re-register.";
                throw new ApplicationMasterNotRegisteredException(message);
            }
            if (AMRMClientUtils.getNextResponseId((int)request.getResponseId()) == lastResponse.getResponseId()) {
                return lastResponse;
            }
            if (request.getResponseId() != lastResponse.getResponseId()) {
                throw new InvalidApplicationMasterRequestException(AMRMClientUtils.assembleInvalidResponseIdExceptionMessage((ApplicationAttemptId)appAttemptId, (int)lastResponse.getResponseId(), (int)request.getResponseId()));
            }
            AllocateResponse response = (AllocateResponse)this.recordFactory.newRecordInstance(AllocateResponse.class);
            this.amsProcessingChain.allocate(amrmTokenIdentifier.getApplicationAttemptId(), request, response);
            MasterKeyData nextMasterKey = this.rmContext.getAMRMTokenSecretManager().getNextMasterKeyData();
            if (nextMasterKey != null && nextMasterKey.getMasterKey().getKeyId() != amrmTokenIdentifier.getKeyId()) {
                RMApp app = (RMApp)this.rmContext.getRMApps().get(appAttemptId.getApplicationId());
                RMAppAttempt appAttempt = app.getRMAppAttempt(appAttemptId);
                RMAppAttemptImpl appAttemptImpl = (RMAppAttemptImpl)appAttempt;
                Token<AMRMTokenIdentifier> amrmToken = appAttempt.getAMRMToken();
                if (nextMasterKey.getMasterKey().getKeyId() != appAttemptImpl.getAMRMTokenKeyId()) {
                    LOG.info("The AMRMToken has been rolled-over. Send new AMRMToken back to application: " + appAttemptId.getApplicationId());
                    amrmToken = this.rmContext.getAMRMTokenSecretManager().createAndGetAMRMToken(appAttemptId);
                    appAttemptImpl.setAMRMToken(amrmToken);
                }
                response.setAMRMToken(org.apache.hadoop.yarn.api.records.Token.newInstance((byte[])amrmToken.getIdentifier(), (String)amrmToken.getKind().toString(), (byte[])amrmToken.getPassword(), (String)amrmToken.getService().toString()));
            }
            response.setResponseId(AMRMClientUtils.getNextResponseId((int)lastResponse.getResponseId()));
            lock.setAllocateResponse(response);
            return response;
        }
    }

    public void registerAppAttempt(ApplicationAttemptId attemptId) {
        AllocateResponse response = (AllocateResponse)this.recordFactory.newRecordInstance(AllocateResponse.class);
        response.setResponseId(-1);
        LOG.info("Registering app attempt : " + attemptId);
        this.responseMap.put(attemptId, new AllocateResponseLock(response));
        this.rmContext.getNMTokenSecretManager().registerApplicationAttempt(attemptId);
    }

    @VisibleForTesting
    protected boolean setAttemptLastResponseId(ApplicationAttemptId attemptId, int lastResponseId) {
        AllocateResponseLock lock = (AllocateResponseLock)this.responseMap.get(attemptId);
        if (lock == null || lock.getAllocateResponse() == null) {
            return false;
        }
        lock.getAllocateResponse().setResponseId(lastResponseId);
        return true;
    }

    public void unregisterAttempt(ApplicationAttemptId attemptId) {
        LOG.info("Unregistering app attempt : " + attemptId);
        this.responseMap.remove(attemptId);
        this.finishedAttemptCache.remove(attemptId);
        this.rmContext.getNMTokenSecretManager().unregisterApplicationAttempt(attemptId);
    }

    public void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAclWithLoadedConfiguration(configuration, policyProvider);
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        this.responseMap.clear();
        this.finishedAttemptCache.clear();
        super.serviceStop();
    }

    @VisibleForTesting
    public Server getServer() {
        return this.server;
    }

    public static class AllocateResponseLock {
        private AllocateResponse response;

        public AllocateResponseLock(AllocateResponse response) {
            this.response = response;
        }

        public synchronized AllocateResponse getAllocateResponse() {
            return this.response;
        }

        public synchronized void setAllocateResponse(AllocateResponse response) {
            this.response = response;
        }
    }
}

