/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.containerlaunch;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.Configuration;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.component.ComponentEvent;
import org.apache.hadoop.yarn.service.component.ComponentEventType;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.containerlaunch.AbstractLauncher;
import org.apache.hadoop.yarn.service.provider.ProviderFactory;
import org.apache.hadoop.yarn.service.provider.ProviderService;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerLaunchService
extends AbstractService {
    protected static final Logger LOG = LoggerFactory.getLogger(ContainerLaunchService.class);
    private ExecutorService executorService;
    private SliderFileSystem fs;
    private ServiceContext context;

    public ContainerLaunchService(ServiceContext context) {
        super(ContainerLaunchService.class.getName());
        this.fs = context.fs;
        this.context = context;
    }

    public void serviceInit(org.apache.hadoop.conf.Configuration conf) throws Exception {
        this.executorService = Executors.newCachedThreadPool();
        super.serviceInit(conf);
    }

    protected void serviceStop() throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        super.serviceStop();
    }

    public Future<ProviderService.ResolvedLaunchParams> launchCompInstance(Service service, ComponentInstance instance, Container container, ComponentLaunchContext componentLaunchContext) {
        ContainerLauncher launcher = new ContainerLauncher(service, instance, container, componentLaunchContext, false);
        return this.executorService.submit(launcher);
    }

    public Future<ProviderService.ResolvedLaunchParams> reInitCompInstance(Service service, ComponentInstance instance, Container container, ComponentLaunchContext componentLaunchContext) {
        ContainerLauncher reInitializer = new ContainerLauncher(service, instance, container, componentLaunchContext, true);
        return this.executorService.submit(reInitializer);
    }

    public static class ComponentLaunchContext {
        private final String name;
        private final String serviceVersion;
        private Artifact artifact;
        private Configuration configuration;
        private String launchCommand;
        private boolean runPrivilegedContainer;

        public ComponentLaunchContext(String name, String serviceVersion) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.serviceVersion = (String)Preconditions.checkNotNull((Object)serviceVersion);
        }

        public String getName() {
            return this.name;
        }

        public String getServiceVersion() {
            return this.serviceVersion;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public String getLaunchCommand() {
            return this.launchCommand;
        }

        public boolean isRunPrivilegedContainer() {
            return this.runPrivilegedContainer;
        }

        public ComponentLaunchContext setArtifact(Artifact artifact) {
            this.artifact = artifact;
            return this;
        }

        public ComponentLaunchContext setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public ComponentLaunchContext setLaunchCommand(String launchCommand) {
            this.launchCommand = launchCommand;
            return this;
        }

        public ComponentLaunchContext setRunPrivilegedContainer(boolean runPrivilegedContainer) {
            this.runPrivilegedContainer = runPrivilegedContainer;
            return this;
        }
    }

    private class ContainerLauncher
    implements Callable<ProviderService.ResolvedLaunchParams> {
        public final Container container;
        public final Service service;
        public ComponentInstance instance;
        private final ComponentLaunchContext componentLaunchContext;
        private final boolean reInit;

        ContainerLauncher(Service service, ComponentInstance instance, Container container, ComponentLaunchContext componentLaunchContext, boolean reInit) {
            this.container = container;
            this.service = service;
            this.instance = instance;
            this.componentLaunchContext = componentLaunchContext;
            this.reInit = reInit;
        }

        @Override
        public ProviderService.ResolvedLaunchParams call() {
            ProviderService provider = ProviderFactory.getProviderService(this.componentLaunchContext.getArtifact());
            AbstractLauncher launcher = new AbstractLauncher(ContainerLaunchService.this.context);
            ProviderService.ResolvedLaunchParams resolvedParams = null;
            try {
                resolvedParams = provider.buildContainerLaunchContext(launcher, this.service, this.instance, ContainerLaunchService.this.fs, ContainerLaunchService.this.getConfig(), this.container, this.componentLaunchContext);
                if (!this.reInit) {
                    LOG.info("launching container {}", (Object)this.container.getId());
                    this.instance.getComponent().getScheduler().getNmClient().startContainerAsync(this.container, launcher.completeContainerLaunch());
                } else {
                    LOG.info("reInitializing container {} with version {}", (Object)this.container.getId(), (Object)this.componentLaunchContext.getServiceVersion());
                    this.instance.getComponent().getScheduler().getNmClient().reInitializeContainerAsync(this.container.getId(), launcher.completeContainerLaunch(), true);
                }
            }
            catch (Exception e) {
                LOG.error("{}: Failed to launch container.", (Object)this.instance.getCompInstanceId(), (Object)e);
                ComponentEvent event = new ComponentEvent(this.instance.getCompName(), ComponentEventType.CONTAINER_COMPLETED).setInstance(this.instance).setContainerId(this.container.getId());
                ((ContainerLaunchService)ContainerLaunchService.this).context.scheduler.getDispatcher().getEventHandler().handle((Event)event);
            }
            if (resolvedParams != null) {
                return resolvedParams;
            }
            return ProviderService.FAILED_LAUNCH_PARAMS;
        }
    }
}

